/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.transform.internal;

import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractRegistry;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.transform.ManagedTransformationProvider;
import org.openhab.core.transform.Transformation;
import org.openhab.core.transform.TransformationProvider;
import org.openhab.core.transform.TransformationRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(immediate=true)
public class TransformationRegistryImpl
extends AbstractRegistry<Transformation, String, TransformationProvider>
implements TransformationRegistry {
    private static final Pattern FILENAME_PATTERN = Pattern.compile("(?<filename>.+)(_(?<language>[a-z]{2}))?\\.(?<extension>[^.]*)$");
    private final LocaleProvider localeProvider;

    @Activate
    public TransformationRegistryImpl(@Reference LocaleProvider localeProvider) {
        super(TransformationProvider.class);
        this.localeProvider = localeProvider;
    }

    @Override
    public @Nullable Transformation get(String uid, @Nullable Locale locale) {
        Transformation configuration = null;
        String language = Objects.requireNonNullElse(locale, this.localeProvider.getLocale()).getLanguage();
        Matcher uidMatcher = CONFIG_UID_PATTERN.matcher(uid);
        if (uidMatcher.matches()) {
            if (uidMatcher.group("language") == null) {
                configuration = (Transformation)this.get(uid + ":" + language);
            }
        } else {
            uidMatcher = FILENAME_PATTERN.matcher(uid);
            if (uidMatcher.matches() && uidMatcher.group("language") == null) {
                String localizedUid = uidMatcher.group("filename") + "_" + language + "." + uidMatcher.group("extension");
                configuration = (Transformation)this.get(localizedUid);
            }
        }
        return configuration != null ? configuration : (Transformation)this.get(uid);
    }

    @Override
    public Collection<Transformation> getTransformations(Collection<String> types) {
        return this.getAll().stream().filter(e -> types.contains(e.getType())).toList();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedProvider(ManagedTransformationProvider provider) {
        super.setManagedProvider((ManagedProvider)provider);
    }

    protected void unsetManagedProvider(ManagedTransformationProvider provider) {
        super.unsetManagedProvider((ManagedProvider)provider);
    }

    protected void addProvider(Provider<Transformation> provider) {
        super.addProvider(provider);
    }
}

