<!--- This file is autogenerated. Do not edit manually! -->
# <code>[pixi](../pixi.md) exec</code>

## About
Run a command and install it in a temporary environment

--8<-- "docs/reference/cli/pixi/exec_extender:description"

## Usage
```
pixi exec [OPTIONS] [COMMAND]...
```

## Arguments
- <a id="arg-<COMMAND>" href="#arg-<COMMAND>">`<COMMAND>`</a>
:  The executable to run, followed by any arguments
<br>May be provided more than once.

## Options
- <a id="arg---spec" href="#arg---spec">`--spec (-s) <SPEC>`</a>
:  Matchspecs of package to install. If this is not provided, the package is guessed from the command
<br>May be provided more than once.
- <a id="arg---channel" href="#arg---channel">`--channel (-c) <CHANNEL>`</a>
:  The channels to consider as a name or a url. Multiple channels can be specified by using this field multiple times
<br>May be provided more than once.
- <a id="arg---platform" href="#arg---platform">`--platform (-p) <PLATFORM>`</a>
:  The platform to create the environment for
<br>**default**: `current_platform`
- <a id="arg---force-reinstall" href="#arg---force-reinstall">`--force-reinstall`</a>
:  If specified a new environment is always created even if one already exists
- <a id="arg---list" href="#arg---list">`--list <LIST>`</a>
:  Before executing the command, list packages in the environment Specify `--list=some_regex` to filter the shown packages

## Config Options
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`

## Description
Run a command and install it in a temporary environment.

Remove the temporary environments with `pixi clean cache --exec`.


--8<-- "docs/reference/cli/pixi/exec_extender:example"
