<!--- This file is autogenerated. Do not edit manually! -->
# <code>pixi</code>

--8<-- "docs/reference/cli/pixi_extender:description"

## Usage
```
pixi [OPTIONS] <COMMAND>
```

## Subcommands
| Command | Description |
|---------|-------------|
| [`add`](pixi/add.md) | Adds dependencies to the workspace |
| [`auth`](pixi/auth.md) | Login to prefix.dev or anaconda.org servers to access private channels |
| [`build`](pixi/build.md) | Workspace configuration |
| [`clean`](pixi/clean.md) | Cleanup the environments |
| [`completion`](pixi/completion.md) | Generates a completion script for a shell |
| [`config`](pixi/config.md) | Configuration management |
| [`exec`](pixi/exec.md) | Run a command and install it in a temporary environment |
| [`global`](pixi/global.md) | Subcommand for global package management actions |
| [`info`](pixi/info.md) | Information about the system, workspace and environments for the current machine |
| [`init`](pixi/init.md) | Creates a new workspace |
| [`install`](pixi/install.md) | Install an environment, both updating the lockfile and installing the environment |
| [`list`](pixi/list.md) | List workspace's packages |
| [`lock`](pixi/lock.md) | Solve environment and update the lock file without installing the environments |
| [`reinstall`](pixi/reinstall.md) | Re-install an environment, both updating the lockfile and re-installing the environment |
| [`remove`](pixi/remove.md) | Removes dependencies from the workspace |
| [`run`](pixi/run.md) | Runs task in the pixi environment |
| [`search`](pixi/search.md) | Search a conda package |
| [`self-update`](pixi/self-update.md) | Update pixi to the latest version or a specific version |
| [`shell`](pixi/shell.md) | Start a shell in a pixi environment, run `exit` to leave the shell |
| [`shell-hook`](pixi/shell-hook.md) | Print the pixi environment activation script |
| [`task`](pixi/task.md) | Interact with tasks in the workspace |
| [`tree`](pixi/tree.md) | Show a tree of workspace dependencies |
| [`update`](pixi/update.md) | The `update` command checks if there are newer versions of the dependencies and updates the `pixi.lock` file and environments accordingly |
| [`upgrade`](pixi/upgrade.md) | Checks if there are newer versions of the dependencies and upgrades them in the lockfile and manifest file |
| [`upload`](pixi/upload.md) | Upload a conda package |
| [`workspace`](pixi/workspace.md) | Modify the workspace configuration file through the command line |


## Global Options
- <a id="arg---help" href="#arg---help">`--help (-h)`</a>
:  Display help information
- <a id="arg---verbose" href="#arg---verbose">`--verbose (-v)`</a>
:  Increase logging verbosity (-v for warnings, -vv for info, -vvv for debug, -vvvv for trace)
- <a id="arg---quiet" href="#arg---quiet">`--quiet (-q)`</a>
:  Decrease logging verbosity (quiet mode)
- <a id="arg---color" href="#arg---color">`--color <COLOR>`</a>
:  Whether the log needs to be colored
<br>**env**: `PIXI_COLOR`
<br>**default**: `auto`
<br>**options**: `always`, `never`, `auto`
- <a id="arg---no-progress" href="#arg---no-progress">`--no-progress`</a>
:  Hide all progress bars, always turned on if stderr is not a terminal
<br>**env**: `PIXI_NO_PROGRESS`
<br>**default**: `false`

--8<-- "docs/reference/cli/pixi_extender:example"
