/*
 * Copyright (C) 2023-2025 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#pragma once

#include "shared/source/helpers/definitions/command_encoder_args.h"
#include "shared/source/helpers/extendable_enum.h"

#include <cstddef>
#include <cstdint>
#include <vector>

namespace L0 {
struct CmdListKernelLaunchParamsExt;

struct CommandToPatch {
    enum CommandType {
        FrontEndState,
        PauseOnEnqueueSemaphoreStart,
        PauseOnEnqueueSemaphoreEnd,
        PauseOnEnqueuePipeControlStart,
        PauseOnEnqueuePipeControlEnd,
        ComputeWalker,
        SignalEventPostSyncPipeControl,
        WaitEventSemaphoreWait,
        TimestampEventPostSyncStoreRegMem,
        CbEventTimestampPostSyncSemaphoreWait,
        CbEventTimestampClearStoreDataImm,
        CbWaitEventSemaphoreWait,
        CbWaitEventLoadRegisterImm,
        ComputeWalkerInlineDataScratch,
        ComputeWalkerImplicitArgsScratch,
        NoopSpace,
        Invalid
    };
    void *pDestination = nullptr;
    void *pCommand = nullptr;
    size_t offset = 0;
    CommandType type = Invalid;
    size_t inOrderPatchListIndex = 0;
    size_t patchSize = 0;
    uint64_t baseAddress = 0;
};

using CommandToPatchContainer = std::vector<CommandToPatch>;

struct CmdListKernelLaunchParams {
    void *outWalker = nullptr;
    void *cmdWalkerBuffer = nullptr;
    void *hostPayloadBuffer = nullptr;
    CommandToPatch *outSyncCommand = nullptr;
    CommandToPatchContainer *outListCommands = nullptr;
    CmdListKernelLaunchParamsExt *launchParamsExt = nullptr;
    size_t syncBufferPatchIndex = std::numeric_limits<size_t>::max();
    size_t regionBarrierPatchIndex = std::numeric_limits<size_t>::max();
    uint32_t externalPerThreadScratchSize[2] = {0U, 0U};
    NEO::RequiredPartitionDim requiredPartitionDim = NEO::RequiredPartitionDim::none;
    NEO::RequiredDispatchWalkOrder requiredDispatchWalkOrder = NEO::RequiredDispatchWalkOrder::none;
    uint32_t localRegionSize = NEO::localRegionSizeParamNotSet;
    uint32_t numKernelsInSplitLaunch = 0;
    uint32_t numKernelsExecutedInSplitLaunch = 0;
    uint32_t reserveExtraPayloadSpace = 0;
    bool isIndirect = false;
    bool isPredicate = false;
    bool isCooperative = false;
    bool isKernelSplitOperation = false;
    bool isBuiltInKernel = false;
    bool isDestinationAllocationInSystemMemory = false;
    bool isDestinationAllocationImported = false;
    bool isHostSignalScopeEvent = false;
    bool isExpLaunchKernel = false;
    bool skipInOrderNonWalkerSignaling = false;
    bool pipeControlSignalling = false;
    bool omitAddingKernelArgumentResidency = false;
    bool omitAddingKernelInternalResidency = false;
    bool omitAddingEventResidency = false;
    bool omitAddingWaitEventsResidency = false;
    bool makeKernelCommandView = false;
    bool relaxedOrderingDispatch = false;
};

struct CmdListMemoryCopyParams {
    bool relaxedOrderingDispatch = false;
    bool forceDisableCopyOnlyInOrderSignaling = false;
    bool copyOffloadAllowed = false;
};

struct CopyOffloadMode : ExtendableEnum {
  public:
    constexpr CopyOffloadMode(uint32_t val) : ExtendableEnum(val) {}
};

namespace CopyOffloadModes {
static constexpr CopyOffloadMode disabled = 0;
static constexpr CopyOffloadMode dualStream = 1;
} // namespace CopyOffloadModes

} // namespace L0
