<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

July 24, 2020

Host: Carol Payne

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Troy Sobotka
  * [X] Chin-Ying Li
  * [X] Simran Brucherseifer
  * [X] Grahame Fuller - Autodesk
  * [X] Mario Rokicki - DNEG
  * [X] Joseph Goldstone - ARRI

# **OCIO Documentation Working Group Meeting Notes**

* Documentation TOC:
    - [Google Doc](https://docs.google.com/document/d/1AdCWgo_g7SHoVCakGTizs8j6AljSVfx1u6RKnyxIC2A/edit)
    - Doug: Goal to lock down TOC today so we can start writing. Timeline is 
      short. Can change going forward, but let's agree on a TOC to use as a 
      starting point for writing docs. Next week's meeting we can look at 
      website with some initial writing and discuss feedback of the actual docs 
      (on RTD).
    - Docs landing page (different from main landing page) will have three 
      sections: 
        - Intended audiences
        - Where to find what you need
        - About documentation versions
    - Quick starts page for different types of users (A subpage for each topic 
      in this section instead of calling out roles throughout docs): 
        - Artists
        - Config authors
        - App developers
        - Contributors
    - Simran: Would be good to have links in these quick starts to specific 
      sections that are useful for the audiences.
    - Doug: Looking for volunteers to write first drafts of certain sections. 
      Quick starts is a good area to begin. 
    - Concepts section with overview of "what is OCIO?" and "why use 
      OCIO?". Also architecture and config sections that may need separate 
      pages. These were a big part of the v1 docs.
    - Publications section for Cinematic Color and DigiPro papers.
    - Glossary will be helpful (OpenCue has one too). Disambiguate terms with 
      various meanings (i.e. "look" and "role").
    - Imageworks case study is fairly out of date. Can we get some new case 
      studies from participating studios?
    - **TODO**: Call for entries of studio case studies for OCIO.
    - Carol: Could move case studies to tutorials section.
    - Sean: Good to have mile high view of theoretical infrastructure. How does 
      a config embody a studio? How do you get multiple DCCs talking together 
      and using the same config, etc.
    - Doug: Tutorials sections: 
        - Idea from Troy on building a simple config
        - Baking LUTs
        - Contributing to the project (CLA, DCO), etc.
    - Guides have four main sections:
        - Using OCIO (entry point for more detailed info on using OCIO, good 
          for beginners).
        - Authoring config files (focus on Python API, not hand writing 
          YAML). Start with top-level components, and then cover how those 
          pieces go together). Sean: Can use Sphinx tabs to group Python/YAML 
          together.
        - Integration OCIO into apps (developer section). Can pull over 
          existing pages as starting point and refine over time. 
        - Contributing to OCIO (can pull some from CONTRIBUTING.md).
    - Upgrading to v2 section. Top-level section, will be important for 
      existing users wanting to upgrade. Sean: Include banner at top of page 
      for this topic.
    - Sean: Version features of RTD are a feature of RTD, on top of the chosen 
      theme. Have access to docs from each release.
    - Current v1 site available in RTD, but currently missing API docs due to 
      build. Can put pre-built static site in RB-1.1 branch to get it into RTD 
      (can possibly pull build from gh-pages).
    - Top-level section for installation: pre-built install (package managers) 
      and building from source.
    - Top-level section for license and CLA. Sean: make this an ASWF section. 
      Michael: also include link to aswf-docker for users to use locally. ASWF 
      section has info on CLA and DCO, linked to from contributing page.
    - Simran: Concepts/"what is OCIO?"/"why use OCIO?" could be moved to 
      homepage. Might be redundant with main OCIO homepage. Avoid having 
      content in two places.
    - Carol: Few sentences on homepage (short blurbs to draw you in), later 
      info can be more detailed.
    - Doug: Can have more graphical version on homepage and more textural 
      version on inner doc pages.
  
* Other notes:
    - Michael: Note that LF can't design/maintain our website frontend. Support 
      WordPress only. Can help with graphic design as needed.
