<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

May 4, 2020

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Joseph Goldstone - ARRI
  * [X] Troy Sobotka

# **OCIO TSC Meeting Notes**

* GPU CI update
    - GH Actions is now in place, and LF release engineering is working on 
      setting up needed AWS infrastructure to provision GPU instances. Once 
      this is completed (within ~1-2 weeks) we will work with JF to implement
      into CI. A CI working group goal is for OCIO to have GPU CI up and running
      by the May CI working group meeting in a month.

* OpenColorIO-configs update
    - There was a joint ACES-OCIO meeting last Friday to discuss the way 
      forward for the ACES OCIO config. We will be starting a new ASWF repo to
      house a new config, and further discuss the design within that repo's 
      issues.
    - Doug: Rod Bogart has some action items around licensing of existing code 
      and HP's python scripts. TBD how to move forward with these.
    - Joseph: Did anyone from Canon come to this group? The current IDTs dont 
      match Canon's white paper. It contains a note saying the formula has been 
      revised.
    - Doug: That's more on the ACES side to get that updated. It should be 
      mentioned to Alex and Scott. We're just going to follow what is in their 
      repo.
    - Joseph: I will reach out to them via email.
    - Sean: The tricky part will be what to do with old stuff. Also the 
      particulars of the config. But path forward is clear. It would be 
      worthwhile to investigate a chair to oversee config maintenance and to 
      have a clear owner - whoever has the time and detail.
    - Mark: That person could also own the numbers in the config, which 
      sometimes are debated.
    - Doug: Thomas Mansencal and Michael Parsons are the people that are 
      currently tasked by the Academy as the maintainers of the config, and 
      Thomas has done a great job on the ACES 1.2 config. My impression is 
      that ACES would like OCIO to take a bigger role in the management of the 
      config, similar to a product partner, but hopefully the same people will 
      stay involved.
    - Sean: The owner can ensure the config is up to date, and handle opinions 
      about community configs.
    
* Docs
    - Sean: I've been exploring the docs and have a rough working copy. Able to 
      populate docstrings from C++ headers automatically. pybind11 provides 
      tooling to extract doxygen style comments from headers and exposes a 
      macro to pull them into python bindings at compilation time. Seems 
      designed to document python bindings only - no comments about C++ at all. 
      Will be Interesting to see if both Python and C++ can be documented from 
      the same source.
    - Ideally the documentation will just live in the headers, but will need 
      work to be explicit API docs, instead of lots of explanatory text. This 
      will be needed sooner than the main OCIO v2 release. After the call with 
      ACES it was clear there should be a sense of urgency in getting 
      documentation going.
    - Once general docstrings are in place, we can discuss how to structure 
      docs and website. The current structure is not logical. The bulk of the 
      work will having to describe things beyond API docstrings.
    - Doug: The sooner we have a template the better. The AD team can then help 
      fill it in places. A template within the month would be very helpful.

* Logos
    - LF creative services is helping redesign an OpenEXR logo. For OCIO 
      branding should we do the same, or reach out to the OCIO community for 
      ideas?
    - Carol: Using LF would bring consistency between ASWF projects. Related 
      projects with different designers tend to look ad-hoc. Not bad, but 
      something to consider.
    - Sean: Would be nice to get the O*IO project branding aligned.
    - Doug: If anyone knows designer to work on it, we could get some ideas to 
      give to LF as a starting point. 
    - Sean: I can ask Mario if he has ideas, since he proposed some previously.
    - Patrick: It's a good opportunity to update the logo at the same time as 
      the library.
    - Carol: There could also be packaging and tweaks to work for different 
      uses.
    - Doug: LF can design different flavors of logo like they did previously 
      with OCIO typography.

* Python unit tests
    - Doug: Python unit tests are needed soon. It would be great to get a PR 
      to set guidelines and establish the implementation. This could just be 
      for a small portion of the library, to be followed by other PRs.
    - Mei: I made some changes to two Python test modules, which Michael 
      reviewed in his fork. Can keep working on it to get a good template we 
      can use across project.
    - Patrick: Don't try to write them all; it's more so we can see next steps. 
      When CI moved to GH Actions, the bindings are compiling but not running. 
      Unit tests are needed to make sure it is working.
    - Doug: We also need some new good first issues for the project. There 
      aren't many good first issues there now. Python unit tests could be 
      included.

* Built-in transforms
    - Doug: More built-in transforms will be needed, and could be contributed 
      by the community once the current PR #1006 is merged.
    - Mark: I was hoping to have OpenColorMath in before going too far with 
      those.
    - Doug: It depends on when that would go in. When we get to doing v2 
      configs, we need examples of how to make ACES output transforms. This can 
      be an area for community contributions.
    - Mark: There will still be work to do once library is feature complete. 
      I will take a deeper look then to help refine before a final release 
      later in the year.
 
* Important items for community contribution over the next few months:
    - GPU CI
    - OpenColorIO-Configs
    - Documentation / branding
    - Python unit tests
    - Built-in transforms
