// Code generated by sdkgen. DO NOT EDIT.

// nolint
package opensearch

import (
	"context"

	"google.golang.org/grpc"

	opensearch "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/opensearch/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// ClusterServiceClient is a opensearch.ClusterServiceClient with
// lazy GRPC connection initialization.
type ClusterServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// AddDashboardsNodeGroup implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) AddDashboardsNodeGroup(ctx context.Context, in *opensearch.AddDashboardsNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).AddDashboardsNodeGroup(ctx, in, opts...)
}

// AddOpenSearchNodeGroup implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) AddOpenSearchNodeGroup(ctx context.Context, in *opensearch.AddOpenSearchNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).AddOpenSearchNodeGroup(ctx, in, opts...)
}

// Backup implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) Backup(ctx context.Context, in *opensearch.BackupClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).Backup(ctx, in, opts...)
}

// Create implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) Create(ctx context.Context, in *opensearch.CreateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) Delete(ctx context.Context, in *opensearch.DeleteClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).Delete(ctx, in, opts...)
}

// DeleteBackup implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) DeleteBackup(ctx context.Context, in *opensearch.DeleteBackupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).DeleteBackup(ctx, in, opts...)
}

// DeleteDashboardsNodeGroup implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) DeleteDashboardsNodeGroup(ctx context.Context, in *opensearch.DeleteDashboardsNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).DeleteDashboardsNodeGroup(ctx, in, opts...)
}

// DeleteOpenSearchNodeGroup implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) DeleteOpenSearchNodeGroup(ctx context.Context, in *opensearch.DeleteOpenSearchNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).DeleteOpenSearchNodeGroup(ctx, in, opts...)
}

// Get implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) Get(ctx context.Context, in *opensearch.GetClusterRequest, opts ...grpc.CallOption) (*opensearch.Cluster, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).Get(ctx, in, opts...)
}

// GetAuthSettings implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) GetAuthSettings(ctx context.Context, in *opensearch.GetAuthSettingsRequest, opts ...grpc.CallOption) (*opensearch.AuthSettings, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).GetAuthSettings(ctx, in, opts...)
}

// List implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) List(ctx context.Context, in *opensearch.ListClustersRequest, opts ...grpc.CallOption) (*opensearch.ListClustersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).List(ctx, in, opts...)
}

type ClusterIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ClusterServiceClient
	request *opensearch.ListClustersRequest

	items []*opensearch.Cluster
}

func (c *ClusterServiceClient) ClusterIterator(ctx context.Context, req *opensearch.ListClustersRequest, opts ...grpc.CallOption) *ClusterIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ClusterIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ClusterIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Clusters
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterIterator) Take(size int64) ([]*opensearch.Cluster, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*opensearch.Cluster

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ClusterIterator) TakeAll() ([]*opensearch.Cluster, error) {
	return it.Take(0)
}

func (it *ClusterIterator) Value() *opensearch.Cluster {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterIterator) Error() error {
	return it.err
}

// ListBackups implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) ListBackups(ctx context.Context, in *opensearch.ListClusterBackupsRequest, opts ...grpc.CallOption) (*opensearch.ListClusterBackupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).ListBackups(ctx, in, opts...)
}

type ClusterBackupsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ClusterServiceClient
	request *opensearch.ListClusterBackupsRequest

	items []*opensearch.Backup
}

func (c *ClusterServiceClient) ClusterBackupsIterator(ctx context.Context, req *opensearch.ListClusterBackupsRequest, opts ...grpc.CallOption) *ClusterBackupsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ClusterBackupsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ClusterBackupsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListBackups(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Backups
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterBackupsIterator) Take(size int64) ([]*opensearch.Backup, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*opensearch.Backup

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ClusterBackupsIterator) TakeAll() ([]*opensearch.Backup, error) {
	return it.Take(0)
}

func (it *ClusterBackupsIterator) Value() *opensearch.Backup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterBackupsIterator) Error() error {
	return it.err
}

// ListHosts implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) ListHosts(ctx context.Context, in *opensearch.ListClusterHostsRequest, opts ...grpc.CallOption) (*opensearch.ListClusterHostsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).ListHosts(ctx, in, opts...)
}

type ClusterHostsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ClusterServiceClient
	request *opensearch.ListClusterHostsRequest

	items []*opensearch.Host
}

func (c *ClusterServiceClient) ClusterHostsIterator(ctx context.Context, req *opensearch.ListClusterHostsRequest, opts ...grpc.CallOption) *ClusterHostsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ClusterHostsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ClusterHostsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListHosts(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Hosts
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterHostsIterator) Take(size int64) ([]*opensearch.Host, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*opensearch.Host

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ClusterHostsIterator) TakeAll() ([]*opensearch.Host, error) {
	return it.Take(0)
}

func (it *ClusterHostsIterator) Value() *opensearch.Host {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterHostsIterator) Error() error {
	return it.err
}

// ListLogs implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) ListLogs(ctx context.Context, in *opensearch.ListClusterLogsRequest, opts ...grpc.CallOption) (*opensearch.ListClusterLogsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).ListLogs(ctx, in, opts...)
}

type ClusterLogsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ClusterServiceClient
	request *opensearch.ListClusterLogsRequest

	items []*opensearch.LogRecord
}

func (c *ClusterServiceClient) ClusterLogsIterator(ctx context.Context, req *opensearch.ListClusterLogsRequest, opts ...grpc.CallOption) *ClusterLogsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ClusterLogsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ClusterLogsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListLogs(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Logs
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterLogsIterator) Take(size int64) ([]*opensearch.LogRecord, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*opensearch.LogRecord

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ClusterLogsIterator) TakeAll() ([]*opensearch.LogRecord, error) {
	return it.Take(0)
}

func (it *ClusterLogsIterator) Value() *opensearch.LogRecord {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterLogsIterator) Error() error {
	return it.err
}

// ListOperations implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) ListOperations(ctx context.Context, in *opensearch.ListClusterOperationsRequest, opts ...grpc.CallOption) (*opensearch.ListClusterOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).ListOperations(ctx, in, opts...)
}

type ClusterOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ClusterServiceClient
	request *opensearch.ListClusterOperationsRequest

	items []*operation.Operation
}

func (c *ClusterServiceClient) ClusterOperationsIterator(ctx context.Context, req *opensearch.ListClusterOperationsRequest, opts ...grpc.CallOption) *ClusterOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ClusterOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ClusterOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ClusterOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ClusterOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *ClusterOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ClusterOperationsIterator) Error() error {
	return it.err
}

// Move implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) Move(ctx context.Context, in *opensearch.MoveClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).Move(ctx, in, opts...)
}

// RescheduleMaintenance implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) RescheduleMaintenance(ctx context.Context, in *opensearch.RescheduleMaintenanceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).RescheduleMaintenance(ctx, in, opts...)
}

// Restore implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) Restore(ctx context.Context, in *opensearch.RestoreClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).Restore(ctx, in, opts...)
}

// Start implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) Start(ctx context.Context, in *opensearch.StartClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).Start(ctx, in, opts...)
}

// Stop implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) Stop(ctx context.Context, in *opensearch.StopClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).Stop(ctx, in, opts...)
}

// StreamLogs implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) StreamLogs(ctx context.Context, in *opensearch.StreamClusterLogsRequest, opts ...grpc.CallOption) (opensearch.ClusterService_StreamLogsClient, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).StreamLogs(ctx, in, opts...)
}

// Update implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) Update(ctx context.Context, in *opensearch.UpdateClusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAuthSettings implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) UpdateAuthSettings(ctx context.Context, in *opensearch.UpdateAuthSettingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).UpdateAuthSettings(ctx, in, opts...)
}

// UpdateDashboardsNodeGroup implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) UpdateDashboardsNodeGroup(ctx context.Context, in *opensearch.UpdateDashboardsNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).UpdateDashboardsNodeGroup(ctx, in, opts...)
}

// UpdateOpenSearchNodeGroup implements opensearch.ClusterServiceClient
func (c *ClusterServiceClient) UpdateOpenSearchNodeGroup(ctx context.Context, in *opensearch.UpdateOpenSearchNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return opensearch.NewClusterServiceClient(conn).UpdateOpenSearchNodeGroup(ctx, in, opts...)
}
