// Code generated by sdkgen. DO NOT EDIT.

// nolint
package eventrouter

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	eventrouter "github.com/yandex-cloud/go-genproto/yandex/cloud/serverless/eventrouter/v1"
)

//revive:disable

// ConnectorServiceClient is a eventrouter.ConnectorServiceClient with
// lazy GRPC connection initialization.
type ConnectorServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) Create(ctx context.Context, in *eventrouter.CreateConnectorRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) Delete(ctx context.Context, in *eventrouter.DeleteConnectorRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) Get(ctx context.Context, in *eventrouter.GetConnectorRequest, opts ...grpc.CallOption) (*eventrouter.Connector, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).Get(ctx, in, opts...)
}

// List implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) List(ctx context.Context, in *eventrouter.ListConnectorsRequest, opts ...grpc.CallOption) (*eventrouter.ListConnectorsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).List(ctx, in, opts...)
}

type ConnectorIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ConnectorServiceClient
	request *eventrouter.ListConnectorsRequest

	items []*eventrouter.Connector
}

func (c *ConnectorServiceClient) ConnectorIterator(ctx context.Context, req *eventrouter.ListConnectorsRequest, opts ...grpc.CallOption) *ConnectorIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ConnectorIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ConnectorIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Connectors
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ConnectorIterator) Take(size int64) ([]*eventrouter.Connector, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*eventrouter.Connector

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ConnectorIterator) TakeAll() ([]*eventrouter.Connector, error) {
	return it.Take(0)
}

func (it *ConnectorIterator) Value() *eventrouter.Connector {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ConnectorIterator) Error() error {
	return it.err
}

// ListAccessBindings implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type ConnectorAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ConnectorServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *ConnectorServiceClient) ConnectorAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *ConnectorAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ConnectorAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ConnectorAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ConnectorAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ConnectorAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *ConnectorAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ConnectorAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) ListOperations(ctx context.Context, in *eventrouter.ListConnectorOperationsRequest, opts ...grpc.CallOption) (*eventrouter.ListConnectorOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).ListOperations(ctx, in, opts...)
}

type ConnectorOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ConnectorServiceClient
	request *eventrouter.ListConnectorOperationsRequest

	items []*operation.Operation
}

func (c *ConnectorServiceClient) ConnectorOperationsIterator(ctx context.Context, req *eventrouter.ListConnectorOperationsRequest, opts ...grpc.CallOption) *ConnectorOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ConnectorOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ConnectorOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ConnectorOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ConnectorOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *ConnectorOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ConnectorOperationsIterator) Error() error {
	return it.err
}

// SetAccessBindings implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Start implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) Start(ctx context.Context, in *eventrouter.StartConnectorRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).Start(ctx, in, opts...)
}

// Stop implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) Stop(ctx context.Context, in *eventrouter.StopConnectorRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).Stop(ctx, in, opts...)
}

// Update implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) Update(ctx context.Context, in *eventrouter.UpdateConnectorRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements eventrouter.ConnectorServiceClient
func (c *ConnectorServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return eventrouter.NewConnectorServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
