// Code generated by sdkgen. DO NOT EDIT.

// nolint
package containerregistry

import (
	"context"

	"google.golang.org/grpc"

	containerregistry "github.com/yandex-cloud/go-genproto/yandex/cloud/containerregistry/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// ScannerServiceClient is a containerregistry.ScannerServiceClient with
// lazy GRPC connection initialization.
type ScannerServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements containerregistry.ScannerServiceClient
func (c *ScannerServiceClient) Get(ctx context.Context, in *containerregistry.GetScanResultRequest, opts ...grpc.CallOption) (*containerregistry.ScanResult, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewScannerServiceClient(conn).Get(ctx, in, opts...)
}

// GetLast implements containerregistry.ScannerServiceClient
func (c *ScannerServiceClient) GetLast(ctx context.Context, in *containerregistry.GetLastScanResultRequest, opts ...grpc.CallOption) (*containerregistry.ScanResult, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewScannerServiceClient(conn).GetLast(ctx, in, opts...)
}

// List implements containerregistry.ScannerServiceClient
func (c *ScannerServiceClient) List(ctx context.Context, in *containerregistry.ListScanResultsRequest, opts ...grpc.CallOption) (*containerregistry.ListScanResultsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewScannerServiceClient(conn).List(ctx, in, opts...)
}

type ScannerIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ScannerServiceClient
	request *containerregistry.ListScanResultsRequest

	items []*containerregistry.ScanResult
}

func (c *ScannerServiceClient) ScannerIterator(ctx context.Context, req *containerregistry.ListScanResultsRequest, opts ...grpc.CallOption) *ScannerIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ScannerIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ScannerIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.ScanResults
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ScannerIterator) Take(size int64) ([]*containerregistry.ScanResult, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containerregistry.ScanResult

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ScannerIterator) TakeAll() ([]*containerregistry.ScanResult, error) {
	return it.Take(0)
}

func (it *ScannerIterator) Value() *containerregistry.ScanResult {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ScannerIterator) Error() error {
	return it.err
}

// ListVulnerabilities implements containerregistry.ScannerServiceClient
func (c *ScannerServiceClient) ListVulnerabilities(ctx context.Context, in *containerregistry.ListVulnerabilitiesRequest, opts ...grpc.CallOption) (*containerregistry.ListVulnerabilitiesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewScannerServiceClient(conn).ListVulnerabilities(ctx, in, opts...)
}

type ScannerVulnerabilitiesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ScannerServiceClient
	request *containerregistry.ListVulnerabilitiesRequest

	items []*containerregistry.Vulnerability
}

func (c *ScannerServiceClient) ScannerVulnerabilitiesIterator(ctx context.Context, req *containerregistry.ListVulnerabilitiesRequest, opts ...grpc.CallOption) *ScannerVulnerabilitiesIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ScannerVulnerabilitiesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ScannerVulnerabilitiesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListVulnerabilities(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Vulnerabilities
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ScannerVulnerabilitiesIterator) Take(size int64) ([]*containerregistry.Vulnerability, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containerregistry.Vulnerability

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ScannerVulnerabilitiesIterator) TakeAll() ([]*containerregistry.Vulnerability, error) {
	return it.Take(0)
}

func (it *ScannerVulnerabilitiesIterator) Value() *containerregistry.Vulnerability {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ScannerVulnerabilitiesIterator) Error() error {
	return it.err
}

// Scan implements containerregistry.ScannerServiceClient
func (c *ScannerServiceClient) Scan(ctx context.Context, in *containerregistry.ScanRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewScannerServiceClient(conn).Scan(ctx, in, opts...)
}
