// Code generated by sdkgen. DO NOT EDIT.

// nolint
package cdn

import (
	"context"

	"google.golang.org/grpc"

	cdn "github.com/yandex-cloud/go-genproto/yandex/cloud/cdn/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// OriginGroupServiceClient is a cdn.OriginGroupServiceClient with
// lazy GRPC connection initialization.
type OriginGroupServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements cdn.OriginGroupServiceClient
func (c *OriginGroupServiceClient) Create(ctx context.Context, in *cdn.CreateOriginGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewOriginGroupServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements cdn.OriginGroupServiceClient
func (c *OriginGroupServiceClient) Delete(ctx context.Context, in *cdn.DeleteOriginGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewOriginGroupServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements cdn.OriginGroupServiceClient
func (c *OriginGroupServiceClient) Get(ctx context.Context, in *cdn.GetOriginGroupRequest, opts ...grpc.CallOption) (*cdn.OriginGroup, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewOriginGroupServiceClient(conn).Get(ctx, in, opts...)
}

// List implements cdn.OriginGroupServiceClient
func (c *OriginGroupServiceClient) List(ctx context.Context, in *cdn.ListOriginGroupsRequest, opts ...grpc.CallOption) (*cdn.ListOriginGroupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewOriginGroupServiceClient(conn).List(ctx, in, opts...)
}

type OriginGroupIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *OriginGroupServiceClient
	request *cdn.ListOriginGroupsRequest

	items []*cdn.OriginGroup
}

func (c *OriginGroupServiceClient) OriginGroupIterator(ctx context.Context, req *cdn.ListOriginGroupsRequest, opts ...grpc.CallOption) *OriginGroupIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &OriginGroupIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *OriginGroupIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.OriginGroups
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *OriginGroupIterator) Take(size int64) ([]*cdn.OriginGroup, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*cdn.OriginGroup

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *OriginGroupIterator) TakeAll() ([]*cdn.OriginGroup, error) {
	return it.Take(0)
}

func (it *OriginGroupIterator) Value() *cdn.OriginGroup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *OriginGroupIterator) Error() error {
	return it.err
}

// Update implements cdn.OriginGroupServiceClient
func (c *OriginGroupServiceClient) Update(ctx context.Context, in *cdn.UpdateOriginGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return cdn.NewOriginGroupServiceClient(conn).Update(ctx, in, opts...)
}
