/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class ReaderParameter
extends LongDataParameterHolder {
    private Reader reader;
    private ArrayList<char[]> readArrays = null;
    private long length;
    private boolean noBackslashEscapes;

    public ReaderParameter(Reader reader, long length, boolean noBackslashEscapes) {
        this.reader = reader;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public ReaderParameter(Reader reader, boolean noBackslashEscapes) {
        this(reader, Long.MAX_VALUE, noBackslashEscapes);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.readArrays != null) {
            ParameterWriter.write(os, this.readArrays, this.noBackslashEscapes);
        } else if (this.length == Long.MAX_VALUE) {
            ParameterWriter.write(os, this.reader, this.noBackslashEscapes);
        } else {
            ParameterWriter.write(os, this.reader, this.length, this.noBackslashEscapes);
        }
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        if (this.length == Long.MAX_VALUE) {
            int len;
            this.readArrays = new ArrayList();
            int length = 0;
            char[] buffer = new char[1024];
            while ((len = this.reader.read(buffer)) >= 0) {
                this.readArrays.add(buffer);
                buffer = new char[1024];
                length += len;
            }
            this.reader = null;
            return 2 + length * 2;
        }
        return this.length;
    }

    @Override
    public void writeBinary(PacketOutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            os.sendStream(this.reader);
        } else {
            os.sendStream(this.reader, this.length);
        }
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.BLOB;
    }

    @Override
    public String toString() {
        return "<Buffer> " + this.reader;
    }

    @Override
    public boolean isLongData() {
        return true;
    }
}

