// #############################################################################
// #                     DO NOT MODIFY THIS FILE BY HAND!                      #
// #           Scanner.cs and Parser.cs are generated using Coco/R.            #
// #    Edit BoogiePL.atg and run make in the same directory to regenerate.    #
// #############################################################################

// Exclude from StyleCop analysis
// <auto-generated/>

using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using Microsoft.Boogie;
using Microsoft.BaseTypes;
using Bpl = Microsoft.Boogie;




using System;
using System.Diagnostics.Contracts;
using System.Reflection;

namespace Microsoft.Boogie {



public class Parser {
	public const int _EOF = 0;
	public const int _ident = 1;
	public const int _bvlit = 2;
	public const int _digits = 3;
	public const int _string = 4;
	public const int _decimal = 5;
	public const int _dec_float = 6;
	public const int _float = 7;
	public const int maxT = 125;

	const bool _T = true;
	const bool _x = false;
	const int minErrDist = 2;

	public Scanner/*!*/ scanner;
	public Errors/*!*/  errors;

	public Token/*!*/ t;    // last recognized token
	public Token/*!*/ la;   // lookahead token
	int errDist = minErrDist;

readonly Program/*!*/ Pgm;

readonly Expr/*!*/ dummyExpr;
readonly Cmd/*!*/ dummyCmd;
readonly Block/*!*/ dummyBlock;
readonly Bpl.Type/*!*/ dummyType;
readonly List<Expr>/*!*/ dummyExprSeq;
readonly TransferCmd/*!*/ dummyTransferCmd;
readonly StructuredCmd/*!*/ dummyStructuredCmd;

public static Program ParseLibrary(string libraryName)
{
  string libraryFileName = $"{libraryName}.bpl";
  Assembly asm = Assembly.GetExecutingAssembly();
  var resourceName = $"Core.{libraryFileName}";
  using Stream resourceStream = asm.GetManifestResourceStream(resourceName);
  Parse(new StreamReader(resourceStream), libraryFileName, new List<string>(), out Program program);
  return program;
}

///<summary>
///Returns the number of parsing errors encountered.  If 0, "program" returns as
///the parsed program.
///</summary>
public static int Parse(string/*!*/ filename, List<string/*!*/> defines, out /*maybe null*/ Program program, bool useBaseName=false) /* throws System.IO.IOException */ {
  Contract.Requires(filename != null);
  Contract.Requires(Cce.NonNullElements(defines,true));

  if (filename == "stdin.bpl") {
    return Parse(Console.In, filename, defines, out program, useBaseName);
  } else
  {
    using FileStream stream = new FileStream(filename, FileMode.Open, FileAccess.Read, FileShare.Read);
    return Parse(new StreamReader(stream), filename, defines, out program, useBaseName);
  }
}

public static int Parse(TextReader stream, string/*!*/ filename, List<string> defines, out /*maybe null*/ Program program, bool useBaseName=false) /* throws System.IO.IOException */
{
  var preprocessedSource = ParserHelper.Fill(stream, defines);
  return Parse(preprocessedSource, filename, out program, useBaseName);
}

public static int Parse(string s, string/*!*/ filename, out /*maybe null*/ Program program, bool useBaseName=false) /* throws System.IO.IOException */ {
  Contract.Requires(s != null);
  Contract.Requires(filename != null);

  byte[]/*!*/ buffer = Cce.NonNull(UTF8Encoding.Default.GetBytes(s));
  MemoryStream ms = new MemoryStream(buffer,false);
  Errors errors = new Errors();
  Scanner scanner = new Scanner(ms, errors, filename, useBaseName);

  Parser parser = new Parser(scanner, errors, false);
  parser.Parse();
  if (errors.count == 0)
  {
    program = parser.Pgm;
  }
  else
  {
    program = null;
  }
  return errors.count;
}

public Parser(Scanner/*!*/ scanner, Errors/*!*/ errors, bool disambiguation)
 : this(scanner, errors)
{
  // initialize readonly fields
  Pgm = new Program();
  dummyExpr = new LiteralExpr(Token.NoToken, false);
  dummyCmd = new AssumeCmd(Token.NoToken, dummyExpr);
  dummyBlock = new Block(Token.NoToken, "dummyBlock", new List<Cmd>(), new ReturnCmd(Token.NoToken));
  dummyType = new BasicType(Token.NoToken, SimpleType.Bool);
  dummyExprSeq = new List<Expr> ();
  dummyTransferCmd = new ReturnCmd(Token.NoToken);
  dummyStructuredCmd = new BreakCmd(Token.NoToken, null);
}

// Class to represent the bounds of a bitvector expression t[a:b].
// Objects of this class only exist during parsing and are directly
// turned into BvExtract before they get anywhere else
private class BvBounds : Expr {
  public BigNum Lower;
  public BigNum Upper;
  public BvBounds(IToken/*!*/ tok, BigNum lower, BigNum upper)
    : base(tok, /*immutable=*/ false) {
    Contract.Requires(tok != null);
    this.Lower = lower;
    this.Upper = upper;
  }
  public override Bpl.Type/*!*/ ShallowType { get {Contract.Ensures(Contract.Result<Bpl.Type>() != null); return Bpl.Type.Int; } }
  public override void Resolve(ResolutionContext/*!*/ rc) {
    // Contract.Requires(rc != null);
    rc.Error(this, "bitvector bounds in illegal position");
  }
  public override void Emit(TokenTextWriter/*!*/ stream,
                            int contextBindingStrength, bool fragileContext) {
    Contract.Assert(false);throw new Cce.UnreachableException();
  }
  public override void ComputeFreeVariables(GSet<object>/*!*/ freeVars) { Contract.Assert(false);throw new Cce.UnreachableException(); }

  public override int ContentHash => throw new NotSupportedException("Not supported since this type is translated away");

  public override int ComputeHashCode()
  {
    return base.GetHashCode();
  }
}

/*--------------------------------------------------------------------------*/


	public Parser(Scanner/*!*/ scanner, Errors/*!*/ errors) {
		this.scanner = scanner;
		this.errors = errors;
		Token/*!*/ tok = new Token();
		tok.val = "";
		this.la = tok;
		this.t = new Token(); // just to satisfy its non-null constraint
	}

	void SynErr (int n) {
		if (errDist >= minErrDist) errors.SynErr(la.filename, la.line, la.col, n);
		errDist = 0;
	}

	public void SemErr (string/*!*/ msg) {
		Contract.Requires(msg != null);
		if (errDist >= minErrDist) errors.SemErr(t, msg);
		errDist = 0;
	}

	public void SemErr(IToken/*!*/ tok, string/*!*/ msg) {
	  Contract.Requires(tok != null);
	  Contract.Requires(msg != null);
	  errors.SemErr(tok, msg);
	}

	void Get () {
		for (;;) {
			t = la;
			la = scanner.Scan();
			if (la.kind <= maxT) { ++errDist; break; }

			la = t;
		}
	}

	void Expect (int n) {
		if (la.kind==n) Get(); else { SynErr(n); }
	}

	bool StartOf (int s) {
		return set[s, la.kind];
	}

	void ExpectWeak (int n, int follow) {
		if (la.kind == n) Get();
		else {
			SynErr(n);
			while (!StartOf(follow)) Get();
		}
	}


	bool WeakSeparator(int n, int syFol, int repFol) {
		int kind = la.kind;
		if (kind == n) {Get(); return true;}
		else if (StartOf(repFol)) {return false;}
		else {
			SynErr(n);
			while (!(set[syFol, kind] || set[repFol, kind] || set[0, kind])) {
				Get();
				kind = la.kind;
			}
			return StartOf(syFol);
		}
	}


	void BoogiePL() {
		List<Variable>/*!*/ vs;
		List<Declaration>/*!*/ ds;
		Axiom/*!*/ ax;
		List<Declaration/*!*/>/*!*/ ts;
		DatatypeTypeCtorDecl dt;
		YieldInvariantDecl yi;
		ActionDecl ac;
		YieldProcedureDecl yp;
		Procedure/*!*/ pr;
		Implementation im;
		Implementation/*!*/ nnim;
		bool isPure = false;
		
		while (StartOf(1)) {
			switch (la.kind) {
			case 23: {
				Consts(out ds);
				foreach(Bpl.Declaration/*!*/ v in ds){
				 Contract.Assert(v != null);
				 Pgm.AddTopLevelDeclaration(v);
				}
				
				break;
			}
			case 28: case 29: {
				Function(out ds);
				foreach(Bpl.Declaration/*!*/ d in ds){
				 Contract.Assert(d != null);
				 Pgm.AddTopLevelDeclaration(d);
				}
				
				break;
			}
			case 31: case 32: {
				Axiom(out ax);
				Pgm.AddTopLevelDeclaration(ax); 
				break;
			}
			case 33: {
				UserDefinedTypes(out ts);
				foreach(Declaration/*!*/ td in ts){
				 Contract.Assert(td != null);
				 Pgm.AddTopLevelDeclaration(td);
				}
				
				break;
			}
			case 35: {
				Datatype(out dt);
				Pgm.AddTopLevelDeclaration(dt); 
				break;
			}
			case 9: {
				GlobalVars(out vs);
				foreach(Bpl.Variable/*!*/ v in vs){
				 Contract.Assert(v != null);
				 Pgm.AddTopLevelDeclaration(v);
				}
				
				break;
			}
			case 8: {
				Get();
				if (la.kind == 36) {
					YieldInvariantDecl(out yi);
					Pgm.AddTopLevelDeclaration(yi); 
				} else if (StartOf(2)) {
					YieldProcedureDecl(out yp, out im);
					Pgm.AddTopLevelDeclaration(yp);
					if (im != null) {
					 Pgm.AddTopLevelDeclaration(im);
					}
					
				} else SynErr(126);
				break;
			}
			case 37: case 38: case 39: case 43: case 44: case 45: case 46: case 47: {
				Pure(ref isPure);
				if (la.kind == 47) {
					Procedure(isPure, out pr, out im);
					Pgm.AddTopLevelDeclaration(pr);
					if (im != null) {
					 Pgm.AddTopLevelDeclaration(im);
					}
					isPure = false;
					
				} else if (StartOf(3)) {
					ActionDecl(isPure, out ac, out im, out dt);
					Pgm.AddTopLevelDeclaration(ac);
					if (im != null) {
					 Pgm.AddTopLevelDeclaration(im);
					}
					if (dt != null) {
					 Pgm.AddTopLevelDeclaration(dt);
					}
					isPure = false;
					
				} else SynErr(127);
				break;
			}
			case 52: {
				Implementation(out nnim);
				Pgm.AddTopLevelDeclaration(nnim); 
				break;
			}
			}
		}
		Expect(0);
	}

	void Consts(out List<Declaration>/*!*/ ds) {
		Contract.Ensures(Contract.ValueAtReturn(out ds) != null); IToken/*!*/ y; List<TypedIdent>/*!*/ xs;
		ds = new List<Declaration>();
		var axioms = new List<Axiom>();
		Axiom axiom;
		bool u = false; QKeyValue kv = null; 
		Expect(23);
		y = t; 
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		if (la.kind == 24) {
			Get();
			u = true;  
		}
		IdsType(out xs);
		if (la.kind == 10) {
			Get();
		} else if (la.kind == 25) {
			Get();
			Expect(26);
			while (la.kind == 31 || la.kind == 32) {
				Axiom(out axiom);
				axioms.Add(axiom); ds.Add(axiom); 
			}
			Expect(27);
		} else SynErr(128);
		foreach(TypedIdent/*!*/ x in xs){
		 Contract.Assert(x != null);
		 var constant = new Constant(y, x, u, kv, axioms);
		 ds.Add(constant);
		}
		
	}

	void Function(out List<Declaration>/*!*/ ds) {
		Contract.Ensures(Contract.ValueAtReturn(out ds) != null);
		ds = new List<Declaration>(); IToken/*!*/ z;
		IToken/*!*/ typeParamTok;
		var typeParams = new List<TypeVariable>();
		var arguments = new List<Variable>();
		var axioms = new List<Axiom>();
		TypedIdent/*!*/ tyd;
		TypedIdent retTyd = null;
		Bpl.Type/*!*/ retTy;
		QKeyValue argKv = null;
		QKeyValue kv = null;
		Expr definition = null;
		Expr/*!*/ tmp;
		Axiom ax;
		bool revealed = false;
		
		if (la.kind == 28) {
			Get();
			revealed = true; 
		}
		Expect(29);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Ident(out z);
		if (la.kind == 21) {
			TypeParams(out typeParamTok, out typeParams);
		}
		Expect(11);
		if (StartOf(4)) {
			VarOrType(out tyd, out argKv);
			arguments.Add(new Formal(tyd.tok, tyd, true, argKv)); 
			while (la.kind == 14) {
				Get();
				VarOrType(out tyd, out argKv);
				arguments.Add(new Formal(tyd.tok, tyd, true, argKv)); 
			}
		}
		Expect(12);
		argKv = null; 
		if (la.kind == 30) {
			Get();
			Expect(11);
			VarOrType(out retTyd, out argKv);
			Expect(12);
		} else if (la.kind == 13) {
			Get();
			Type(out retTy);
			retTyd = new TypedIdent(retTy.tok, TypedIdent.NoName, retTy); 
		} else SynErr(129);
		if (la.kind == 26) {
			Get();
			Expression(out tmp);
			definition = tmp; 
			Expect(27);
			if (la.kind == 25) {
				Get();
				Expect(26);
				while (la.kind == 31 || la.kind == 32) {
					Axiom(out ax);
					axioms.Add(ax); 
				}
				Expect(27);
			}
		} else if (la.kind == 25) {
			Get();
			Expect(26);
			while (la.kind == 31 || la.kind == 32) {
				Axiom(out ax);
				axioms.Add(ax); 
			}
			Expect(27);
		} else if (la.kind == 10) {
			Get();
		} else SynErr(130);
		if (retTyd == null) {
		 // construct a dummy type for the case of syntax error
		 retTyd = new TypedIdent(t, TypedIdent.NoName, new BasicType(t, SimpleType.Int));
		}
		Function/*!*/ func = new Function(z, z.val, typeParams, arguments,
		                                 new Formal(retTyd.tok, retTyd, false, argKv), null, kv);
		func.AlwaysRevealed = revealed;
		foreach(var axiom in axioms) {
		   ds.Add(axiom);
		   func.OtherDefinitionAxioms.Add(axiom);
		}
		
		Contract.Assert(func != null);
		ds.Add(func);
		bool allUnnamed = true;
		foreach(Formal/*!*/ f in arguments) {
		 Contract.Assert(f != null);
		 if (f.TypedIdent.HasName) {
		   allUnnamed = false;
		   break;
		 }
		}
		if (!allUnnamed) {
		 Bpl.Type prevType = null;
		 for (int i = arguments.Count; 0 <= --i; ) {
		   TypedIdent/*!*/ curr = Cce.NonNull(arguments[i]).TypedIdent;
		   if (curr.HasName) {
		     // the argument was given as both an identifier and a type
		     prevType = curr.Type;
		   } else {
		     // the argument was given as just one "thing", which syntactically parsed as a type
		     if (prevType == null) {
		       this.errors.SemErr(curr.tok, "the type of the last parameter is unspecified");
		       break;
		     }
		     Bpl.Type ty = curr.Type;
		     var uti = ty as UnresolvedTypeIdentifier;
		     if (uti != null && uti.Arguments.Count == 0) {
		       // the given "thing" was just an identifier, so let's use it as the name of the parameter
		       curr.Name = uti.Name;
		       curr.Type = prevType;
		     } else {
		       this.errors.SemErr(curr.tok, "expecting an identifier as parameter name");
		     }
		   }
		 }
		}
		if (definition != null) {
		 // generate either an axiom or a function body
		 if (kv.FindBoolAttribute("inline")) {
		   if (kv.FindBoolAttribute("define"))
		     SemErr("function cannot have both :inline and :define attributes");
		   func.Body = definition;
		 } else if (kv.FindBoolAttribute("define")) {
		   if (func.TypeParameters.Count > 0)
		     SemErr("function with :define attribute has to be monomorphic");
		   func.DefinitionBody = func.CreateFunctionDefinition(definition);
		 } else {
		   ds.Add(func.CreateDefinitionAxiom(definition, kv));
		 }
		}
		
	}

	void Axiom(out Axiom/*!*/ m) {
		Contract.Ensures(Contract.ValueAtReturn(out m) != null); 
		Expr/*!*/ e; 
		QKeyValue kv = null; 
		bool canHide = false; 
		if (la.kind == 31) {
			Get();
			canHide = true; 
		}
		Expect(32);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		IToken/*!*/ x = t; 
		Proposition(out e);
		Expect(10);
		m = new Axiom(x,e, null, kv, canHide); 
	}

	void UserDefinedTypes(out List<Declaration/*!*/>/*!*/ ts) {
		Contract.Ensures(Cce.NonNullElements(Contract.ValueAtReturn(out ts))); Declaration/*!*/ decl; QKeyValue kv = null; ts = new List<Declaration/*!*/> (); 
		Expect(33);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		UserDefinedType(out decl, kv);
		ts.Add(decl);  
		while (la.kind == 14) {
			Get();
			UserDefinedType(out decl, kv);
			ts.Add(decl);  
		}
		Expect(10);
	}

	void Datatype(out DatatypeTypeCtorDecl datatypeTypeCtorDecl) {
		QKeyValue kv = null; IToken/*!*/ typeParamTok, name; List<TypeVariable> typeParams = new List<TypeVariable>(); 
		Expect(35);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Ident(out name);
		if (la.kind == 21) {
			TypeParams(out typeParamTok, out typeParams);
		}
		datatypeTypeCtorDecl = new DatatypeTypeCtorDecl(name, name.val, typeParams, kv); 
		Expect(26);
		Constructors(datatypeTypeCtorDecl);
		Expect(27);
	}

	void GlobalVars(out List<Variable>/*!*/ ds) {
		Contract.Ensures(Contract.ValueAtReturn(out ds) != null);
		QKeyValue kv = null;
		ds = new List<Variable>();
		var dsx = ds;
		
		Expect(9);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		IdsTypeWheres(true, "global variables", delegate(TypedIdent tyd) { dsx.Add(new GlobalVariable(tyd.tok, tyd, kv)); } );
		Expect(10);
	}

	void YieldInvariantDecl(out YieldInvariantDecl yieldInvariant) {
		List<Requires> invariants = new List<Requires>(); QKeyValue kv = null; IToken name = null; List<Variable> ins; 
		Expect(36);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Ident(out name);
		ProcFormals(true, true, out ins);
		Expect(10);
		while (la.kind == 36) {
			Invariant(invariants);
		}
		yieldInvariant = new YieldInvariantDecl(name, name.val, ins, invariants, kv); 
	}

	void YieldProcedureDecl(out YieldProcedureDecl ypDecl, out Implementation impl) {
		IToken name;
		List<Variable> ins, outs = new List<Variable>();
		MoverType moverType = MoverType.None;
		ActionDeclRef refinedAction = null;
		List<Requires> pre = new List<Requires>();
		List<Ensures> post = new List<Ensures>();
		List<CallCmd> yieldRequires = new List<CallCmd>();
		List<CallCmd> yieldEnsures = new List<CallCmd>();
		List<CallCmd> yieldPreserves = new List<CallCmd>();
		List<IdentifierExpr> mods = new List<IdentifierExpr>();
		List<Variable> locals = null;
		StmtList stmtList = null;
		QKeyValue kv = null;
		impl = null;
		
		if (StartOf(5)) {
			MoverQualifier(ref moverType);
		}
		Expect(47);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Ident(out name);
		ProcFormals(true, true, out ins);
		if (la.kind == 30) {
			Get();
			ProcFormals(false, true, out outs);
		}
		if (la.kind == 10) {
			Get();
			while (StartOf(6)) {
				SpecYieldPrePost(ref refinedAction, name, ins, outs, pre, post, yieldRequires, yieldEnsures, yieldPreserves, mods);
			}
		} else if (StartOf(7)) {
			while (StartOf(6)) {
				SpecYieldPrePost(ref refinedAction, name, ins, outs, pre, post, yieldRequires, yieldEnsures, yieldPreserves, mods);
			}
			ImplBody(out locals, out stmtList);
			impl = new Implementation(name, name.val, new List<TypeVariable>(), Formal.StripWhereClauses(ins), Formal.StripWhereClauses(outs),
			                         locals, stmtList, kv == null ? null : (QKeyValue)kv.Clone(), this.errors);
			
		} else SynErr(131);
		ypDecl = new YieldProcedureDecl(name, name.val, moverType, ins, outs, pre, mods, post, yieldRequires, yieldEnsures, yieldPreserves, refinedAction, kv); 
	}

	void Pure(ref bool isPure) {
		if (la.kind == 37) {
			Get();
			isPure = true; 
		}
	}

	void Procedure(bool isPure, out Procedure/*!*/ proc, out /*maybe null*/ Implementation impl) {
		Contract.Ensures(Contract.ValueAtReturn(out proc) != null); IToken/*!*/ x;
		List<TypeVariable>/*!*/ typeParams;
		List<Variable>/*!*/ ins, outs;
		List<Requires>/*!*/ pre = new List<Requires>();
		List<IdentifierExpr>/*!*/ mods = new List<IdentifierExpr>();
		List<Ensures>/*!*/ post = new List<Ensures>();
		List<Variable>/*!*/ locals = new List<Variable>();
		StmtList/*!*/ stmtList;
		QKeyValue kv = null;
		impl = null;
		
		Expect(47);
		ProcSignature(true, out x, out typeParams, out ins, out outs, out kv);
		if (la.kind == 10) {
			Get();
			while (StartOf(8)) {
				Spec(pre, mods, post);
			}
		} else if (StartOf(9)) {
			while (StartOf(8)) {
				Spec(pre, mods, post);
			}
			ImplBody(out locals, out stmtList);
			impl = new Implementation(x, x.val, typeParams.ConvertAll(tp => new TypeVariable(tp.tok, tp.Name)),
			                         Formal.StripWhereClauses(ins), Formal.StripWhereClauses(outs), locals, stmtList, kv == null ? null : (QKeyValue)kv.Clone(), this.errors);
			
		} else SynErr(132);
		proc = new Procedure(x, x.val, typeParams, ins, outs, isPure, pre, mods, post, kv); 
	}

	void ActionDecl(bool isPure, out ActionDecl actionDecl, out Implementation impl, out DatatypeTypeCtorDecl datatypeTypeCtorDecl) {
		IToken name = null;
		bool isAsync = false;
		MoverType moverType = MoverType.None;
		List<Variable> ins, outs = new List<Variable>();
		List<IdentifierExpr> mods = new List<IdentifierExpr>();
		List<ActionDeclRef> creates = new List<ActionDeclRef>();
		ActionDeclRef refinedAction = null;
		ActionDeclRef invariantAction = null;
		List<Requires> requires = new List<Requires>();
		List<CallCmd> yieldRequires = new List<CallCmd>();
		List<AssertCmd> asserts = new List<AssertCmd>();
		List<Variable> locals;
		StmtList stmtList;
		QKeyValue kv = null;
		datatypeTypeCtorDecl = null;
		impl = null;
		
		if (la.kind == 38) {
			Get();
			isAsync = true; 
		}
		if (StartOf(5)) {
			MoverQualifier(ref moverType);
		}
		Expect(39);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Ident(out name);
		ProcFormals(true, true, out ins);
		if (la.kind == 30) {
			Get();
			ProcFormals(false, true, out outs);
		}
		if (la.kind == 10) {
			Get();
			while (StartOf(10)) {
				SpecAction(ref refinedAction, ref invariantAction, mods, creates, requires, yieldRequires, asserts);
			}
		} else if (StartOf(11)) {
			while (StartOf(10)) {
				SpecAction(ref refinedAction, ref invariantAction, mods, creates, requires, yieldRequires, asserts);
			}
			ImplBody(out locals, out stmtList);
			impl = new Implementation(name, name.val, new List<TypeVariable>(), Formal.StripWhereClauses(ins), Formal.StripWhereClauses(outs),
			                              locals, stmtList, kv == null ? null : (QKeyValue)kv.Clone());
			
		} else SynErr(133);
		if (isPure) {
		 if (moverType == MoverType.None)
		 {
		   moverType = MoverType.Both;
		 }
		 else
		 {
		   this.SemErr("mover type unnecessary for pure action since it is a both mover");
		 }
		}
		if (isAsync) {
		 if (outs.Count > 0)
		 {
		   this.SemErr("async action must not have output parameters");
		 }
		 else
		 {
		   if (moverType == MoverType.None)
		   {
		     moverType = MoverType.Atomic;
		   }
		   datatypeTypeCtorDecl = new DatatypeTypeCtorDecl(name, name.val, new List<TypeVariable>(), null);
		   var fields = ins.Select(v => new Formal(v.tok, new TypedIdent(v.TypedIdent.tok, v.Name, v.TypedIdent.Type), true, v.Attributes)).ToList<Variable>();
		   datatypeTypeCtorDecl.AddConstructor(name, name.val, fields);
		 }
		}
		actionDecl = new ActionDecl(name, name.val, moverType, ins, outs, isPure, creates, refinedAction, invariantAction, requires, yieldRequires, asserts, mods, datatypeTypeCtorDecl, kv);
		
	}

	void Implementation(out Implementation/*!*/ impl) {
		Contract.Ensures(Contract.ValueAtReturn(out impl) != null); IToken/*!*/ x;
		List<TypeVariable>/*!*/ typeParams;
		List<Variable>/*!*/ ins, outs;
		List<Variable>/*!*/ locals;
		StmtList/*!*/ stmtList;
		QKeyValue kv;
		
		Expect(52);
		ProcSignature(false, out x, out typeParams, out ins, out outs, out kv);
		ImplBody(out locals, out stmtList);
		impl = new Implementation(x, x.val, typeParams, ins, outs, locals, stmtList, kv, this.errors); 
	}

	void Attribute(ref QKeyValue kv) {
		Trigger trig = null; 
		AttributeOrTrigger(ref kv, ref trig);
		if (trig != null) this.SemErr("only attributes, not triggers, allowed here"); 
	}

	void IdsTypeWheres(bool allowWhereClauses, string context, System.Action<TypedIdent> action ) {
		IdsTypeWhere(allowWhereClauses, context, action);
		while (la.kind == 14) {
			Get();
			IdsTypeWhere(allowWhereClauses, context, action);
		}
	}

	void LocalVars(List<Variable>/*!*/ ds) {
		Contract.Ensures(Contract.ValueAtReturn(out ds) != null);
		QKeyValue kv = null;
		
		Expect(9);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		IdsTypeWheres(true, "local variables", delegate(TypedIdent tyd) { ds.Add(new LocalVariable(tyd.tok, tyd, kv)); } );
		Expect(10);
	}

	void ProcFormals(bool incoming, bool allowWhereClauses, out List<Variable>/*!*/ ds) {
		Contract.Ensures(Contract.ValueAtReturn(out ds) != null);
		ds = new List<Variable>();
		var dsx = ds;
		var context = allowWhereClauses ? "procedure formals" : "the 'implementation' copies of formals";
		
		Expect(11);
		if (StartOf(12)) {
			AttributesIdsTypeWheres(allowWhereClauses, context, delegate(TypedIdent tyd, QKeyValue kv) { dsx.Add(new Formal(tyd.tok, tyd, incoming, kv)); });
		}
		Expect(12);
	}

	void AttributesIdsTypeWheres(bool allowWhereClauses, string context, System.Action<TypedIdent, QKeyValue> action ) {
		AttributesIdsTypeWhere(allowWhereClauses, context, action);
		while (la.kind == 14) {
			Get();
			AttributesIdsTypeWhere(allowWhereClauses, context, action);
		}
	}

	void BoundVars(out List<Variable>/*!*/ ds) {
		Contract.Ensures(Contract.ValueAtReturn(out ds) != null);
		List<TypedIdent>/*!*/ tyds = new List<TypedIdent>();
		ds = new List<Variable>();
		var dsx = ds;
		
		AttributesIdsTypeWheres(false, "bound variables", delegate(TypedIdent tyd, QKeyValue kv) { dsx.Add(new BoundVariable(tyd.tok, tyd, kv)); } );
	}

	void IdsType(out List<TypedIdent>/*!*/ tyds) {
		Contract.Ensures(Contract.ValueAtReturn(out tyds) != null); List<IToken>/*!*/ ids;  Bpl.Type/*!*/ ty; 
		Idents(out ids);
		Expect(13);
		Type(out ty);
		tyds = new List<TypedIdent>();
		foreach(Token/*!*/ id in ids){
		 Contract.Assert(id != null);
		 tyds.Add(new TypedIdent(id, id.val, ty, null));
		}
		
	}

	void Idents(out List<IToken>/*!*/ xs) {
		Contract.Ensures(Contract.ValueAtReturn(out xs) != null); IToken/*!*/ id; xs = new List<IToken>(); 
		Ident(out id);
		xs.Add(id); 
		while (la.kind == 14) {
			Get();
			Ident(out id);
			xs.Add(id); 
		}
	}

	void Type(out Bpl.Type/*!*/ ty) {
		Contract.Ensures(Contract.ValueAtReturn(out ty) != null); IToken/*!*/ tok; ty = dummyType; 
		if (StartOf(13)) {
			TypeAtom(out ty);
		} else if (StartOf(14)) {
			Ident(out tok);
			List<Bpl.Type>/*!*/ args = new List<Bpl.Type> (); 
			if (StartOf(15)) {
				TypeArgs(args);
			}
			ty = new UnresolvedTypeIdentifier (tok, tok.val, args); 
		} else if (la.kind == 19 || la.kind == 21) {
			MapType(out ty);
		} else SynErr(134);
	}

	void AttributesIdsTypeWhere(bool allowWhereClauses, string context, System.Action<TypedIdent, QKeyValue> action ) {
		QKeyValue kv = null; 
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		IdsTypeWhere(allowWhereClauses, context, delegate(TypedIdent tyd) { action(tyd, kv); });
	}

	void IdsTypeWhere(bool allowWhereClauses, string context, System.Action<TypedIdent> action ) {
		List<IToken>/*!*/ ids;  Bpl.Type/*!*/ ty;  Expr wh = null;  Expr/*!*/ nne; 
		Idents(out ids);
		Expect(13);
		Type(out ty);
		if (la.kind == 15) {
			Get();
			Expression(out nne);
			if (!allowWhereClauses) {
			 this.SemErr("where clause not allowed on " + context);
			} else {
			 wh = nne;
			}
			
		}
		foreach(Token/*!*/ id in ids){
		 Contract.Assert(id != null);
		 action(new TypedIdent(id, id.val, ty, wh));
		}
		
	}

	void Expression(out Expr/*!*/ e0) {
		Contract.Ensures(Contract.ValueAtReturn(out e0) != null); IToken/*!*/ x; Expr/*!*/ e1; 
		ImpliesExpression(false, out e0);
		while (la.kind == 74 || la.kind == 75) {
			EquivOp();
			x = t; 
			ImpliesExpression(false, out e1);
			e0 = Expr.Binary(x, BinaryOperator.Opcode.Iff, e0, e1); 
		}
	}

	void TypeAtom(out Bpl.Type/*!*/ ty) {
		Contract.Ensures(Contract.ValueAtReturn(out ty) != null); ty = dummyType; 
		if (la.kind == 16) {
			Get();
			ty = new BasicType(t, SimpleType.Int); 
		} else if (la.kind == 17) {
			Get();
			ty = new BasicType(t, SimpleType.Real); 
		} else if (la.kind == 18) {
			Get();
			ty = new BasicType(t, SimpleType.Bool); 
		} else if (la.kind == 11) {
			Get();
			Type(out ty);
			Expect(12);
		} else SynErr(135);
	}

	void Ident(out IToken/*!*/ x) {
		Contract.Ensures(Contract.ValueAtReturn(out x) != null);
		switch (la.kind) {
		case 1: {
			Get();
			break;
		}
		case 46: {
			Get();
			t.kind = _ident; 
			break;
		}
		case 45: {
			Get();
			t.kind = _ident; 
			break;
		}
		case 43: {
			Get();
			t.kind = _ident; 
			break;
		}
		case 44: {
			Get();
			t.kind = _ident; 
			break;
		}
		case 62: {
			Get();
			t.kind = _ident; 
			break;
		}
		case 63: {
			Get();
			t.kind = _ident; 
			break;
		}
		case 65: {
			Get();
			t.kind = _ident; 
			break;
		}
		case 64: {
			Get();
			t.kind = _ident; 
			break;
		}
		default: SynErr(136); break;
		}
		x = t;
		if (x.val.StartsWith("\\"))
		 x.val = x.val.Substring(1);
		
	}

	void TypeArgs(List<Bpl.Type>/*!*/ ts) {
		Contract.Requires(ts != null); IToken/*!*/ tok; Bpl.Type/*!*/ ty; 
		if (StartOf(13)) {
			TypeAtom(out ty);
			ts.Add(ty); 
			if (StartOf(15)) {
				TypeArgs(ts);
			}
		} else if (StartOf(14)) {
			Ident(out tok);
			List<Bpl.Type>/*!*/ args = new List<Bpl.Type> ();
			ts.Add(new UnresolvedTypeIdentifier (tok, tok.val, args)); 
			if (StartOf(15)) {
				TypeArgs(ts);
			}
		} else if (la.kind == 19 || la.kind == 21) {
			MapType(out ty);
			ts.Add(ty); 
		} else SynErr(137);
	}

	void MapType(out Bpl.Type/*!*/ ty) {
		Contract.Ensures(Contract.ValueAtReturn(out ty) != null); IToken tok = null;
		IToken/*!*/ nnTok;
		List<Bpl.Type>/*!*/ arguments = new List<Bpl.Type>();
		Bpl.Type/*!*/ result;
		List<TypeVariable>/*!*/ typeParameters = new List<TypeVariable>();
		
		if (la.kind == 21) {
			TypeParams(out nnTok, out typeParameters);
			tok = nnTok; 
		}
		Expect(19);
		if (tok == null) tok = t;  
		if (StartOf(15)) {
			Types(arguments);
		}
		Expect(20);
		Type(out result);
		ty = new MapType(tok, typeParameters, arguments, result);
		
	}

	void TypeParams(out IToken/*!*/ tok, out List<TypeVariable>/*!*/ typeParams) {
		Contract.Ensures(Contract.ValueAtReturn(out tok) != null); Contract.Ensures(Contract.ValueAtReturn(out typeParams) != null); List<IToken>/*!*/ typeParamToks; 
		Expect(21);
		tok = t;  
		Idents(out typeParamToks);
		Expect(22);
		typeParams = new List<TypeVariable> ();
		foreach(Token/*!*/ id in typeParamToks){
		 Contract.Assert(id != null);
		 typeParams.Add(new TypeVariable(id, id.val));}
		
	}

	void Types(List<Bpl.Type>/*!*/ ts) {
		Contract.Requires(ts != null); Bpl.Type/*!*/ ty; 
		Type(out ty);
		ts.Add(ty); 
		while (la.kind == 14) {
			Get();
			Type(out ty);
			ts.Add(ty); 
		}
	}

	void VarOrType(out TypedIdent/*!*/ tyd, out QKeyValue kv) {
		Contract.Ensures(Contract.ValueAtReturn(out tyd) != null);
		string/*!*/ varName = TypedIdent.NoName;
		Bpl.Type/*!*/ ty;
		IToken/*!*/ tok;
		kv = null;
		
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Type(out ty);
		tok = ty.tok; 
		if (la.kind == 13) {
			Get();
			var uti = ty as UnresolvedTypeIdentifier;
			if (uti != null && uti.Arguments.Count == 0) {
			 varName = uti.Name;
			} else {
			 this.SemErr("expected identifier before ':'");
			}
			
			Type(out ty);
		}
		tyd = new TypedIdent(tok, varName, ty); 
	}

	void Proposition(out Expr/*!*/ e) {
		Contract.Ensures(Contract.ValueAtReturn(out e) != null);
		Expression(out e);
	}

	void UserDefinedType(out Declaration/*!*/ decl, QKeyValue kv) {
		Contract.Ensures(Contract.ValueAtReturn(out decl) != null); IToken/*!*/ id; List<IToken>/*!*/ paramTokens = new List<IToken> ();
		Bpl.Type/*!*/ body = dummyType; bool synonym = false; 
		Ident(out id);
		if (StartOf(14)) {
			WhiteSpaceIdents(out paramTokens);
		}
		if (la.kind == 34) {
			Get();
			Type(out body);
			synonym = true; 
		}
		if (synonym) {
		 List<TypeVariable>/*!*/ typeParams = new List<TypeVariable>();
		 foreach(Token/*!*/ t in paramTokens){
		   Contract.Assert(t != null);
		   typeParams.Add(new TypeVariable(t, t.val));}
		 decl = new TypeSynonymDecl(id, id.val, typeParams, body, kv);
		} else {
		 decl = new TypeCtorDecl(id, id.val, paramTokens.Count, kv);
		}
		
	}

	void WhiteSpaceIdents(out List<IToken>/*!*/ xs) {
		Contract.Ensures(Contract.ValueAtReturn(out xs) != null); IToken/*!*/ id; xs = new List<IToken>(); 
		Ident(out id);
		xs.Add(id); 
		while (StartOf(14)) {
			Ident(out id);
			xs.Add(id); 
		}
	}

	void Constructors(DatatypeTypeCtorDecl datatypeTypeCtorDecl) {
		Constructor(datatypeTypeCtorDecl);
		while (la.kind == 14) {
			Get();
			Constructor(datatypeTypeCtorDecl);
		}
	}

	void Constructor(DatatypeTypeCtorDecl datatypeTypeCtorDecl) {
		IToken name; List<Variable> fields = new List<Variable>(); 
		Ident(out name);
		Expect(11);
		if (StartOf(12)) {
			AttributesIdsTypeWheres(false, "datatype constructor", delegate(TypedIdent ti, QKeyValue kv) { fields.Add(new Formal(ti.tok, ti, true, kv)); });
		}
		Expect(12);
		if (!datatypeTypeCtorDecl.AddConstructor(name, name.val, fields)) {
		 this.SemErr($"constructor name {name.val} used more than once in datatype");
		}
		
	}

	void Invariant(List<Requires> invariants) {
		Expr e; IToken tok = null; QKeyValue kv = null; 
		Expect(36);
		tok = t; 
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Proposition(out e);
		Expect(10);
		invariants.Add(new Requires(tok, false, e, null, kv)); 
	}

	void MoverQualifier(ref MoverType moverType) {
		if (la.kind == 43) {
			Get();
			moverType = MoverType.Left; 
		} else if (la.kind == 44) {
			Get();
			moverType = MoverType.Right; 
		} else if (la.kind == 45) {
			Get();
			moverType = MoverType.Both; 
		} else if (la.kind == 46) {
			Get();
			moverType = MoverType.Atomic; 
		} else SynErr(138);
	}

	void SpecAction(ref ActionDeclRef refinedAction, ref ActionDeclRef invariantAction, List<IdentifierExpr> mods, List<ActionDeclRef> creates, List<Requires> requires, List<CallCmd> yieldRequires, List<AssertCmd> asserts) {
		if (la.kind == 41) {
			SpecRefinedActionForAtomicAction(ref refinedAction);
			IToken m; 
			if (la.kind == 42) {
				Get();
				Ident(out m);
				invariantAction = new ActionDeclRef(m, m.val); 
			}
			Expect(10);
		} else if (la.kind == 54) {
			SpecModifies(mods);
		} else if (la.kind == 40) {
			SpecCreates(creates);
		} else if (la.kind == 49) {
			SpecYieldRequires(requires, yieldRequires);
		} else if (la.kind == 48) {
			SpecAsserts(asserts);
		} else SynErr(139);
	}

	void ImplBody(out List<Variable>/*!*/ locals, out StmtList/*!*/ stmtList) {
		Contract.Ensures(Contract.ValueAtReturn(out locals) != null); Contract.Ensures(Contract.ValueAtReturn(out stmtList) != null); locals = new List<Variable>(); 
		Expect(26);
		while (la.kind == 9) {
			LocalVars(locals);
		}
		StmtList(out stmtList);
	}

	void SpecCreates(List<ActionDeclRef> creates) {
		Expect(40);
		List<IToken> cs; 
		Idents(out cs);
		foreach(IToken c in cs) { creates.Add(new ActionDeclRef(c, c.val)); } 
		Expect(10);
	}

	void SpecRefinedActionForAtomicAction(ref ActionDeclRef refinedAction) {
		IToken m; QKeyValue kv = null; 
		Expect(41);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Ident(out m);
		if (refinedAction == null) {
		  refinedAction = new ActionDeclRef(m, m.val, kv);
		} else {
		  this.SemErr("a refines specification already exists");
		}
		
	}

	void SpecRefinedActionForYieldProcedure(ref ActionDeclRef refinedAction, IToken name, List<Variable> ins, List<Variable> outs) {
		IToken tok, m; QKeyValue kv = null, akv = null; MoverType moverType = MoverType.Atomic; List<Variable> locals; StmtList stmtList; 
		Expect(41);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		if (StartOf(16)) {
			if (StartOf(5)) {
				MoverQualifier(ref moverType);
			}
			Expect(39);
			tok = t; 
			while (la.kind == 26) {
				Attribute(ref akv);
			}
			Ident(out m);
			ImplBody(out locals, out stmtList);
			if (refinedAction == null) {
			 var actionName = m.val == "_" ? null : m.val;
			 var actionDecl = new ActionDecl(tok, actionName, moverType, Formal.StripWhereClauses(ins), Formal.StripWhereClauses(outs),
			                               false, new List<ActionDeclRef>(), null, null,
			                               new List<Requires>(), new List<CallCmd>(), new List<AssertCmd>(), new List<IdentifierExpr>(), null, akv);
			 Pgm.AddTopLevelDeclaration(actionDecl);
			 var impl = new Implementation(tok, actionDecl.Name, new List<TypeVariable>(), Formal.StripWhereClauses(ins), Formal.StripWhereClauses(outs),
			                               locals, stmtList, akv == null ? null : (QKeyValue)akv.Clone());
			 Pgm.AddTopLevelDeclaration(impl);
			 refinedAction = new ActionDeclRef(tok, actionDecl.Name);
			} else {
			 this.SemErr("a refines specification already exists");
			}
			
		} else if (StartOf(14)) {
			Ident(out tok);
			if (refinedAction == null) {
			  refinedAction = new ActionDeclRef(tok, tok.val, kv);
			} else {
			  this.SemErr("a refines specification already exists");
			}
			
			Expect(10);
		} else SynErr(140);
	}

	void SpecModifies(List<IdentifierExpr> mods) {
		List<IToken> ms; 
		Expect(54);
		if (StartOf(14)) {
			Idents(out ms);
			foreach(IToken m in ms) { mods.Add(new IdentifierExpr(m, m.val)); } 
		}
		Expect(10);
	}

	void SpecYieldRequires(List<Requires> pre, List<CallCmd> yieldRequires ) {
		Expr e; Cmd cmd; Token tok; QKeyValue kv = null; 
		Expect(49);
		tok = t; 
		if (StartOf(17)) {
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Proposition(out e);
			pre.Add(new Requires(tok, false, e, null, kv)); 
		} else if (la.kind == 38 || la.kind == 53 || la.kind == 71) {
			CallCmd(out cmd);
			yieldRequires.Add((CallCmd)cmd); 
		} else SynErr(141);
		Expect(10);
	}

	void SpecAsserts(List<AssertCmd> asserts ) {
		Expr e; Token tok; QKeyValue kv = null; 
		Expect(48);
		tok = t; 
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Proposition(out e);
		asserts.Add(new AssertCmd(tok, e, kv)); 
		Expect(10);
	}

	void SpecYieldPrePost(ref ActionDeclRef refinedAction, IToken name, List<Variable> ins, List<Variable> outs, List<Requires> pre, List<Ensures> post, List<CallCmd> yieldRequires, List<CallCmd> yieldEnsures, List<CallCmd> yieldPreserves, List<IdentifierExpr> mods) {
		if (la.kind == 41) {
			SpecRefinedActionForYieldProcedure(ref refinedAction, name, ins, outs);
		} else if (la.kind == 49) {
			SpecYieldRequires(pre, yieldRequires);
		} else if (la.kind == 50) {
			SpecYieldEnsures(post, yieldEnsures);
		} else if (la.kind == 51) {
			SpecYieldPreserves(yieldPreserves);
		} else if (la.kind == 54) {
			SpecModifies(mods);
		} else SynErr(142);
	}

	void CallCmd(out Cmd c) {
		Contract.Ensures(Contract.ValueAtReturn(out c) != null);
		IToken x;
		bool isAsync = false;
		bool isFree = false;
		c = null;
		
		if (la.kind == 38) {
			Get();
			isAsync = true; 
		}
		if (la.kind == 53) {
			Get();
			isFree = true; 
		}
		Expect(71);
		x = t; 
		CallParams(isAsync, isFree, x, out c);
		
	}

	void SpecYieldEnsures(List<Ensures> post, List<CallCmd> yieldEnsures ) {
		Expr e; Cmd cmd; Token tok; QKeyValue kv = null; 
		Expect(50);
		tok = t; 
		if (StartOf(17)) {
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Proposition(out e);
			post.Add(new Ensures(tok, false, e, null, kv)); 
		} else if (la.kind == 38 || la.kind == 53 || la.kind == 71) {
			CallCmd(out cmd);
			yieldEnsures.Add((CallCmd)cmd); 
		} else SynErr(143);
		Expect(10);
	}

	void SpecYieldPreserves(List<CallCmd> yieldPreserves ) {
		Cmd cmd; Token tok; 
		Expect(51);
		tok = t; 
		CallCmd(out cmd);
		yieldPreserves.Add((CallCmd)cmd); 
		Expect(10);
	}

	void ProcSignature(bool allowWhereClausesOnFormals, out IToken/*!*/ name, out List<TypeVariable>/*!*/ typeParams,
out List<Variable>/*!*/ ins, out List<Variable>/*!*/ outs, out QKeyValue kv) {
		Contract.Ensures(Contract.ValueAtReturn(out name) != null); Contract.Ensures(Contract.ValueAtReturn(out typeParams) != null); Contract.Ensures(Contract.ValueAtReturn(out ins) != null); Contract.Ensures(Contract.ValueAtReturn(out outs) != null);
		IToken/*!*/ typeParamTok; typeParams = new List<TypeVariable>();
		outs = new List<Variable>(); kv = null; 
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Ident(out name);
		if (la.kind == 21) {
			TypeParams(out typeParamTok, out typeParams);
		}
		ProcFormals(true, allowWhereClausesOnFormals, out ins);
		if (la.kind == 30) {
			Get();
			ProcFormals(false, allowWhereClausesOnFormals, out outs);
		}
	}

	void Spec(List<Requires> pre, List<IdentifierExpr> mods, List<Ensures> post) {
		if (la.kind == 54) {
			SpecModifies(mods);
		} else if (la.kind == 53) {
			Get();
			SpecPrePost(true, pre, post);
		} else if (la.kind == 49 || la.kind == 50) {
			SpecPrePost(false, pre, post);
		} else SynErr(144);
	}

	void SpecPrePost(bool free, List<Requires>/*!*/ pre, List<Ensures>/*!*/ post) {
		Contract.Requires(pre != null); Contract.Requires(post != null); Expr/*!*/ e; Token tok = null; QKeyValue kv = null; 
		if (la.kind == 49) {
			Get();
			tok = t; 
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Proposition(out e);
			Expect(10);
			pre.Add(new Requires(tok, free, e, null, kv)); 
		} else if (la.kind == 50) {
			Get();
			tok = t; 
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Proposition(out e);
			Expect(10);
			post.Add(new Ensures(tok, free, e, null, kv)); 
		} else SynErr(145);
	}

	void StmtList(out StmtList/*!*/ stmtList) {
		Contract.Ensures(Contract.ValueAtReturn(out stmtList) != null); List<BigBlock/*!*/> bigblocks = new List<BigBlock/*!*/>();
		/* built-up state for the current BigBlock: */
		IToken startToken = null;  string currentLabel = null;
		List<Cmd> cs = null;  /* invariant: startToken != null ==> cs != null */
		/* temporary variables: */
		IToken label;  Cmd c;  BigBlock b;
		StructuredCmd ec = null;  StructuredCmd/*!*/ ecn;
		TransferCmd tc = null;  TransferCmd/*!*/ tcn;
		
		while (StartOf(18)) {
			if (StartOf(19)) {
				LabelOrCmd(out c, out label);
				Contract.Assert(c == null || label == null);
				if (c != null) {
				 // LabelOrCmd read a Cmd
				 if (startToken == null) { startToken = c.tok;  cs = new List<Cmd>(); }
				 Contract.Assert(cs != null);
				 cs.Add(c);
				} else if (label != null) {
				 // LabelOrCmd read a label
				 if (startToken != null) {
				   Contract.Assert(cs != null);
				   // dump the built-up state into a BigBlock
				   b = new BigBlock(startToken, currentLabel, cs, null, null);
				   bigblocks.Add(b);
				   cs = null;
				 }
				 startToken = label;
				 currentLabel = label.val;
				 cs = new List<Cmd>();
				}
				
			} else if (la.kind == 57 || la.kind == 59 || la.kind == 61) {
				StructuredCmd(out ecn);
				ec = ecn;
				if (startToken == null) { startToken = ec.tok;  cs = new List<Cmd>(); }
				Contract.Assert(cs != null);
				b = new BigBlock(startToken, currentLabel, cs, ec, null);
				bigblocks.Add(b);
				startToken = null;  currentLabel = null;  cs = null;
				
			} else {
				TransferCmd(out tcn);
				tc = tcn;
				if (startToken == null) { startToken = tc.tok;  cs = new List<Cmd>(); }
				Contract.Assert(cs != null);
				b = new BigBlock(startToken, currentLabel, cs, null, tc);
				bigblocks.Add(b);
				startToken = null;  currentLabel = null;  cs = null;
				
			}
		}
		Expect(27);
		IToken/*!*/ endCurly = t;
		if (startToken == null && bigblocks.Count == 0) {
		 startToken = t;  cs = new List<Cmd>();
		}
		if (startToken != null) {
		 Contract.Assert(cs != null);
		 b = new BigBlock(startToken, currentLabel, cs, null, null);
		 bigblocks.Add(b);
		}
		
		stmtList = new StmtList(bigblocks, endCurly);
		
	}

	void LabelOrCmd(out Cmd c, out IToken label) {
		IToken/*!*/ x; Expr/*!*/ e;
		List<IToken>/*!*/ xs;
		List<IdentifierExpr> ids;
		c = dummyCmd;  label = null;
		Cmd/*!*/ cn;
		QKeyValue kv = null;
		HideRevealCmd.Modes mode;
		IdentifierExpr hideRevealId = null;
		
		if (la.kind == 62 || la.kind == 63) {
			if (la.kind == 62) {
				Get();
				mode = HideRevealCmd.Modes.Reveal; 
			} else {
				Get();
				mode = HideRevealCmd.Modes.Hide;  
			}
			if (la.kind == 1) {
				Get();
				hideRevealId = new IdentifierExpr(t, t.val); 
			} else if (la.kind == 60) {
				Get();
			} else SynErr(146);
			c = hideRevealId == null ? new HideRevealCmd(t, mode) : new HideRevealCmd(hideRevealId, mode); 
			Expect(10);
		} else if (la.kind == 64) {
			Get();
			c = new ChangeScope(t, ChangeScope.Modes.Pop); 
			Expect(10);
		} else if (la.kind == 65) {
			Get();
			c = new ChangeScope(t, ChangeScope.Modes.Push); 
			Expect(10);
		} else if (StartOf(14)) {
			LabelOrAssign(out c, out label);
		} else if (la.kind == 66) {
			Get();
			x = t; 
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Proposition(out e);
			c = new AssertCmd(x, e, kv); 
			Expect(10);
		} else if (la.kind == 67) {
			Get();
			x = t; 
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Proposition(out e);
			c = new AssumeCmd(x, e, kv); 
			Expect(10);
		} else if (la.kind == 68) {
			Get();
			x = t; 
			Idents(out xs);
			Expect(10);
			ids = new List<IdentifierExpr>();
			foreach(IToken/*!*/ y in xs){
			 Contract.Assert(y != null);
			 ids.Add(new IdentifierExpr(y, y.val));
			}
			c = new HavocCmd(x,ids);
			
		} else if (la.kind == 38 || la.kind == 53 || la.kind == 71) {
			CallCmd(out cn);
			Expect(10);
			c = cn; 
		} else if (la.kind == 72) {
			ParCallCmd(out cn);
			c = cn; 
		} else SynErr(147);
	}

	void StructuredCmd(out StructuredCmd/*!*/ ec) {
		Contract.Ensures(Contract.ValueAtReturn(out ec) != null); ec = dummyStructuredCmd;  Contract.Assume(Cce.IsPeerConsistent(ec));
		IfCmd/*!*/ ifcmd;  WhileCmd/*!*/ wcmd;  BreakCmd/*!*/ bcmd;
		
		if (la.kind == 57) {
			IfCmd(out ifcmd);
			ec = ifcmd; 
		} else if (la.kind == 59) {
			WhileCmd(out wcmd);
			ec = wcmd; 
		} else if (la.kind == 61) {
			BreakCmd(out bcmd);
			ec = bcmd; 
		} else SynErr(148);
	}

	void TransferCmd(out TransferCmd/*!*/ tc) {
		Contract.Ensures(Contract.ValueAtReturn(out tc) != null); tc = dummyTransferCmd;
		Token y;  List<IToken>/*!*/ xs;
		List<String> ss = new List<String>();
		QKeyValue kv = null;
		
		if (la.kind == 55) {
			Get();
			y = t; 
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Idents(out xs);
			foreach(IToken/*!*/ s in xs){
			 Contract.Assert(s != null);
			 ss.Add(s.val); }
			tc = new GotoCmd(y, ss) {
			 Attributes = kv
			};
			
		} else if (la.kind == 56) {
			Get();
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			tc = new ReturnCmd(t) { Attributes = kv }; 
		} else SynErr(149);
		Expect(10);
	}

	void IfCmd(out IfCmd/*!*/ ifcmd) {
		Contract.Ensures(Contract.ValueAtReturn(out ifcmd) != null); IToken/*!*/ x;
		Expr guard;
		StmtList/*!*/ thn;
		IfCmd/*!*/ elseIf;  IfCmd elseIfOption = null;
		StmtList/*!*/ els;  StmtList elseOption = null;
		QKeyValue kv = null;
		
		Expect(57);
		x = t; 
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Guard(out guard);
		Expect(26);
		StmtList(out thn);
		if (la.kind == 58) {
			Get();
			if (la.kind == 57) {
				IfCmd(out elseIf);
				elseIfOption = elseIf; 
			} else if (la.kind == 26) {
				Get();
				StmtList(out els);
				elseOption = els; 
			} else SynErr(150);
		}
		ifcmd = new IfCmd(x, guard, thn, elseIfOption, elseOption, kv); 
	}

	void WhileCmd(out WhileCmd wcmd) {
		Contract.Ensures(Contract.ValueAtReturn(out wcmd) != null); IToken x;  Token z;
		Expr guard;  Expr e;  Cmd cmd;  bool isFree;
		List<PredicateCmd> invariants = new List<PredicateCmd>();
		List<CallCmd> yields = new List<CallCmd>();
		StmtList body;
		QKeyValue kv = null;
		
		Expect(59);
		x = t; 
		Guard(out guard);
		Contract.Assume(guard == null || Cce.Owner.None(guard)); 
		while (la.kind == 36 || la.kind == 53) {
			isFree = false; z = la/*lookahead token*/; 
			if (la.kind == 53) {
				Get();
				isFree = true;  
			}
			Expect(36);
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			if (StartOf(20)) {
				Expression(out e);
				if (isFree) {
				 invariants.Add(new AssumeCmd(z, e, kv));
				} else {
				 invariants.Add(new AssertCmd(z, e, kv));
				}
				kv = null;
				
			} else if (la.kind == 38 || la.kind == 53 || la.kind == 71) {
				CallCmd(out cmd);
				yields.Add((CallCmd)cmd);
				kv = null;
				
			} else SynErr(151);
			Expect(10);
		}
		Expect(26);
		StmtList(out body);
		wcmd = new WhileCmd(x, guard, invariants, yields, body); 
	}

	void BreakCmd(out BreakCmd/*!*/ bcmd) {
		Contract.Ensures(Contract.ValueAtReturn(out bcmd) != null); IToken/*!*/ x;  IToken/*!*/ y;
		string breakLabel = null;
		
		Expect(61);
		x = t; 
		if (StartOf(14)) {
			Ident(out y);
			breakLabel = y.val; 
		}
		Expect(10);
		bcmd = new BreakCmd(x, breakLabel); 
	}

	void Guard(out Expr e) {
		Expr/*!*/ ee;  e = null; 
		Expect(11);
		if (la.kind == 60) {
			Get();
			e = null; 
		} else if (StartOf(20)) {
			Expression(out ee);
			e = ee; 
		} else SynErr(152);
		Expect(12);
	}

	void LabelOrAssign(out Cmd c, out IToken label) {
		IToken/*!*/ id; IToken/*!*/ x, y; Expr/*!*/ e0; List<IToken> ids;
		c = dummyCmd;  label = null;
		AssignLhs/*!*/ lhs;
		List<AssignLhs/*!*/>/*!*/ lhss;
		List<Expr/*!*/>/*!*/ rhss;
		List<Expr/*!*/>/*!*/ indexes;
		FieldAccess fieldAccess;
		QKeyValue kv = null;
		NAryExpr lhsExpr;
		
		Ident(out id);
		x = t; 
		if (la.kind == 13) {
			Get();
			c = null; label = x; 
		} else if (la.kind == 11) {
			Get();
			Idents(out ids);
			Expect(12);
			lhsExpr = new NAryExpr(x, new FunctionCall(new IdentifierExpr(id, id.val)), ids.Select(id => new IdentifierExpr(id, id.val)).ToList<Expr>());
			
			Expect(69);
			x = t; /* use location of := */ 
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Expression(out e0);
			Expect(10);
			c = new UnpackCmd(x, lhsExpr, e0, kv);
			
		} else if (StartOf(21)) {
			lhss = new List<AssignLhs/*!*/>(); 
			lhs = new SimpleAssignLhs(id, new IdentifierExpr(id, id.val)); 
			while (la.kind == 19 || la.kind == 70) {
				if (la.kind == 19) {
					MapAssignIndex(out y, out indexes);
					lhs = new MapAssignLhs(y, lhs, indexes); 
				} else {
					FieldAccess(out y, out fieldAccess);
					lhs = new FieldAssignLhs(y, lhs, fieldAccess); 
				}
			}
			lhss.Add(lhs); 
			while (la.kind == 14) {
				Get();
				Ident(out id);
				lhs = new SimpleAssignLhs(id, new IdentifierExpr(id, id.val)); 
				while (la.kind == 19 || la.kind == 70) {
					if (la.kind == 19) {
						MapAssignIndex(out y, out indexes);
						lhs = new MapAssignLhs(y, lhs, indexes); 
					} else {
						FieldAccess(out y, out fieldAccess);
						lhs = new FieldAssignLhs(y, lhs, fieldAccess); 
					}
				}
				lhss.Add(lhs); 
			}
			Expect(69);
			x = t; /* use location of := */ 
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Expression(out e0);
			rhss = new List<Expr/*!*/> ();
			rhss.Add(e0); 
			while (la.kind == 14) {
				Get();
				Expression(out e0);
				rhss.Add(e0); 
			}
			Expect(10);
			c = new AssignCmd(x, lhss, rhss, kv); 
		} else SynErr(153);
	}

	void ParCallCmd(out Cmd d) {
		Contract.Ensures(Contract.ValueAtReturn(out d) != null);
		IToken x;
		Cmd c = null;
		List<CallCmd> callCmds = new List<CallCmd>();
		
		Expect(72);
		x = t; 
		CallParams(false, false, x, out c);
		callCmds.Add((CallCmd)c); 
		while (la.kind == 73) {
			Get();
			CallParams(false, false, x, out c);
			callCmds.Add((CallCmd)c); 
		}
		Expect(10);
		d = new ParCallCmd(x, callCmds); 
	}

	void MapAssignIndex(out IToken/*!*/ x, out List<Expr/*!*/>/*!*/ indexes) {
		Contract.Ensures(Contract.ValueAtReturn(out x) != null); Contract.Ensures(Cce.NonNullElements(Contract.ValueAtReturn(out indexes))); indexes = new List<Expr/*!*/> ();
		Expr/*!*/ e;
		
		Expect(19);
		x = t; 
		if (StartOf(20)) {
			Expression(out e);
			indexes.Add(e); 
			while (la.kind == 14) {
				Get();
				Expression(out e);
				indexes.Add(e); 
			}
		}
		Expect(20);
	}

	void FieldAccess(out IToken x, out FieldAccess fieldAccess) {
		Contract.Ensures(Contract.ValueAtReturn(out fieldAccess) != null); IToken id; 
		Expect(70);
		x = t; 
		Ident(out id);
		fieldAccess = new FieldAccess(id, id.val); 
	}

	void CallParams(bool isAsync, bool isFree, IToken x, out Cmd c) {
		QKeyValue kv = null;
		List<IdentifierExpr> ids = new List<IdentifierExpr>();
		List<Expr> es = new List<Expr>();
		Expr en;
		IToken first;
		IToken p;
		c = null;
		
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Ident(out first);
		if (la.kind == 11) {
			Get();
			if (StartOf(20)) {
				Expression(out en);
				es.Add(en); 
				while (la.kind == 14) {
					Get();
					Expression(out en);
					es.Add(en); 
				}
			}
			Expect(12);
			c = new CallCmd(x, first.val, es, ids, kv); ((CallCmd) c).IsFree = isFree; ((CallCmd) c).IsAsync = isAsync; 
		} else if (la.kind == 14 || la.kind == 69) {
			ids.Add(new IdentifierExpr(first, first.val)); 
			if (la.kind == 14) {
				Get();
				Ident(out p);
				ids.Add(new IdentifierExpr(p, p.val)); 
				while (la.kind == 14) {
					Get();
					Ident(out p);
					ids.Add(new IdentifierExpr(p, p.val)); 
				}
			}
			Expect(69);
			Ident(out first);
			Expect(11);
			if (StartOf(20)) {
				Expression(out en);
				es.Add(en); 
				while (la.kind == 14) {
					Get();
					Expression(out en);
					es.Add(en); 
				}
			}
			Expect(12);
			c = new CallCmd(x, first.val, es, ids, kv); ((CallCmd) c).IsFree = isFree; ((CallCmd) c).IsAsync = isAsync; 
		} else SynErr(154);
	}

	void Expressions(out List<Expr>/*!*/ es) {
		Contract.Ensures(Contract.ValueAtReturn(out es) != null); Expr/*!*/ e; es = new List<Expr>(); 
		Expression(out e);
		es.Add(e); 
		while (la.kind == 14) {
			Get();
			Expression(out e);
			es.Add(e); 
		}
	}

	void ImpliesExpression(bool noExplies, out Expr/*!*/ e0) {
		Contract.Ensures(Contract.ValueAtReturn(out e0) != null); IToken/*!*/ x; Expr/*!*/ e1; 
		LogicalExpression(out e0);
		if (StartOf(22)) {
			if (la.kind == 76 || la.kind == 77) {
				ImpliesOp();
				x = t; 
				ImpliesExpression(true, out e1);
				e0 = Expr.Binary(x, BinaryOperator.Opcode.Imp, e0, e1); 
			} else {
				ExpliesOp();
				if (noExplies)
				 this.SemErr("illegal mixture of ==> and <==, use parentheses to disambiguate");
				x = t; 
				LogicalExpression(out e1);
				e0 = Expr.Binary(x, BinaryOperator.Opcode.Imp, e1, e0); 
				while (la.kind == 78 || la.kind == 79) {
					ExpliesOp();
					x = t; 
					LogicalExpression(out e1);
					e0 = Expr.Binary(x, BinaryOperator.Opcode.Imp, e1, e0); 
				}
			}
		}
	}

	void EquivOp() {
		if (la.kind == 74) {
			Get();
		} else if (la.kind == 75) {
			Get();
		} else SynErr(155);
	}

	void LogicalExpression(out Expr/*!*/ e0) {
		Contract.Ensures(Contract.ValueAtReturn(out e0) != null); IToken/*!*/ x; Expr/*!*/ e1; 
		RelationalExpression(out e0);
		if (StartOf(23)) {
			if (la.kind == 80 || la.kind == 81) {
				AndOp();
				x = t; 
				RelationalExpression(out e1);
				e0 = Expr.Binary(x, BinaryOperator.Opcode.And, e0, e1); 
				while (la.kind == 80 || la.kind == 81) {
					AndOp();
					x = t; 
					RelationalExpression(out e1);
					e0 = Expr.Binary(x, BinaryOperator.Opcode.And, e0, e1); 
				}
			} else {
				OrOp();
				x = t; 
				RelationalExpression(out e1);
				e0 = Expr.Binary(x, BinaryOperator.Opcode.Or, e0, e1); 
				while (la.kind == 82 || la.kind == 83) {
					OrOp();
					x = t; 
					RelationalExpression(out e1);
					e0 = Expr.Binary(x, BinaryOperator.Opcode.Or, e0, e1); 
				}
			}
		}
	}

	void ImpliesOp() {
		if (la.kind == 76) {
			Get();
		} else if (la.kind == 77) {
			Get();
		} else SynErr(156);
	}

	void ExpliesOp() {
		if (la.kind == 78) {
			Get();
		} else if (la.kind == 79) {
			Get();
		} else SynErr(157);
	}

	void RelationalExpression(out Expr/*!*/ e0) {
		Contract.Ensures(Contract.ValueAtReturn(out e0) != null); IToken/*!*/ x; Expr/*!*/ e1; BinaryOperator.Opcode op; 
		BvTerm(out e0);
		if (StartOf(24)) {
			RelOp(out x, out op);
			BvTerm(out e1);
			e0 = Expr.Binary(x, op, e0, e1); 
		}
	}

	void AndOp() {
		if (la.kind == 80) {
			Get();
		} else if (la.kind == 81) {
			Get();
		} else SynErr(158);
	}

	void OrOp() {
		if (la.kind == 82) {
			Get();
		} else if (la.kind == 83) {
			Get();
		} else SynErr(159);
	}

	void BvTerm(out Expr/*!*/ e0) {
		Contract.Ensures(Contract.ValueAtReturn(out e0) != null); IToken/*!*/ x; Expr/*!*/ e1; 
		Term(out e0);
		while (la.kind == 91) {
			Get();
			x = t; 
			Term(out e1);
			e0 = new BvConcatExpr(x, e0, e1); 
		}
	}

	void RelOp(out IToken/*!*/ x, out BinaryOperator.Opcode op) {
		Contract.Ensures(Contract.ValueAtReturn(out x) != null); x = Token.NoToken; op=BinaryOperator.Opcode.Add/*(dummy)*/; 
		switch (la.kind) {
		case 84: {
			Get();
			x = t; op=BinaryOperator.Opcode.Eq; 
			break;
		}
		case 21: {
			Get();
			x = t; op=BinaryOperator.Opcode.Lt; 
			break;
		}
		case 22: {
			Get();
			x = t; op=BinaryOperator.Opcode.Gt; 
			break;
		}
		case 85: {
			Get();
			x = t; op=BinaryOperator.Opcode.Le; 
			break;
		}
		case 86: {
			Get();
			x = t; op=BinaryOperator.Opcode.Ge; 
			break;
		}
		case 87: {
			Get();
			x = t; op=BinaryOperator.Opcode.Neq; 
			break;
		}
		case 88: {
			Get();
			x = t; op=BinaryOperator.Opcode.Neq; 
			break;
		}
		case 89: {
			Get();
			x = t; op=BinaryOperator.Opcode.Le; 
			break;
		}
		case 90: {
			Get();
			x = t; op=BinaryOperator.Opcode.Ge; 
			break;
		}
		default: SynErr(160); break;
		}
	}

	void Term(out Expr/*!*/ e0) {
		Contract.Ensures(Contract.ValueAtReturn(out e0) != null); IToken/*!*/ x; Expr/*!*/ e1; BinaryOperator.Opcode op; 
		Factor(out e0);
		while (la.kind == 92 || la.kind == 93) {
			AddOp(out x, out op);
			Factor(out e1);
			e0 = Expr.Binary(x, op, e0, e1); 
		}
	}

	void Factor(out Expr/*!*/ e0) {
		Contract.Ensures(Contract.ValueAtReturn(out e0) != null); IToken/*!*/ x; Expr/*!*/ e1; BinaryOperator.Opcode op; 
		Power(out e0);
		while (StartOf(25)) {
			MulOp(out x, out op);
			Power(out e1);
			e0 = Expr.Binary(x, op, e0, e1); 
		}
	}

	void AddOp(out IToken/*!*/ x, out BinaryOperator.Opcode op) {
		Contract.Ensures(Contract.ValueAtReturn(out x) != null); x = Token.NoToken; op=BinaryOperator.Opcode.Add/*(dummy)*/; 
		if (la.kind == 92) {
			Get();
			x = t; op=BinaryOperator.Opcode.Add; 
		} else if (la.kind == 93) {
			Get();
			x = t; op=BinaryOperator.Opcode.Sub; 
		} else SynErr(161);
	}

	void Power(out Expr/*!*/ e0) {
		Contract.Ensures(Contract.ValueAtReturn(out e0) != null); IToken/*!*/ x; Expr/*!*/ e1; 
		IsConstructor(out e0);
		if (la.kind == 97) {
			Get();
			x = t; 
			Power(out e1);
			e0 = Expr.Binary(x, BinaryOperator.Opcode.Pow, e0, e1); 
		}
	}

	void MulOp(out IToken/*!*/ x, out BinaryOperator.Opcode op) {
		Contract.Ensures(Contract.ValueAtReturn(out x) != null); x = Token.NoToken; op=BinaryOperator.Opcode.Add/*(dummy)*/; 
		if (la.kind == 60) {
			Get();
			x = t; op=BinaryOperator.Opcode.Mul; 
		} else if (la.kind == 94) {
			Get();
			x = t; op=BinaryOperator.Opcode.Div; 
		} else if (la.kind == 95) {
			Get();
			x = t; op=BinaryOperator.Opcode.Mod; 
		} else if (la.kind == 96) {
			Get();
			x = t; op=BinaryOperator.Opcode.RealDiv; 
		} else SynErr(162);
	}

	void IsConstructor(out Expr/*!*/ e0) {
		Contract.Ensures(Contract.ValueAtReturn(out e0) != null); IToken/*!*/ x, id; 
		UnaryExpression(out e0);
		if (la.kind == 98) {
			Get();
			x = t; 
			Ident(out id);
			var isConstructor = new IsConstructor(id, id.val);
			e0 = new NAryExpr(x, isConstructor, new List<Expr> { e0 });
			
		}
	}

	void UnaryExpression(out Expr/*!*/ e) {
		Contract.Ensures(Contract.ValueAtReturn(out e) != null); IToken/*!*/ x;
		e = dummyExpr;
		
		if (la.kind == 93) {
			Get();
			x = t; 
			UnaryExpression(out e);
			e = Expr.Unary(x, UnaryOperator.Opcode.Neg, e); 
		} else if (la.kind == 99 || la.kind == 100) {
			NegOp();
			x = t; 
			UnaryExpression(out e);
			e = Expr.Unary(x, UnaryOperator.Opcode.Not, e); 
		} else if (StartOf(26)) {
			CoercionExpression(out e);
		} else SynErr(163);
	}

	void NegOp() {
		if (la.kind == 99) {
			Get();
		} else if (la.kind == 100) {
			Get();
		} else SynErr(164);
	}

	void CoercionExpression(out Expr/*!*/ e) {
		Contract.Ensures(Contract.ValueAtReturn(out e) != null); IToken/*!*/ x;
		Bpl.Type/*!*/ coercedTo;
		BigNum bn;
		
		ArrayExpression(out e);
		while (la.kind == 13) {
			Get();
			x = t; 
			if (StartOf(15)) {
				Type(out coercedTo);
				e = Expr.CoerceType(x, e, coercedTo); 
			} else if (la.kind == 3) {
				Nat(out bn);
				if (!(e is LiteralExpr) || !((LiteralExpr)e).isBigNum) {
				 this.SemErr("arguments of extract need to be integer literals");
				 e = new BvBounds(x, bn, BigNum.ZERO);
				} else {
				 e = new BvBounds(x, bn, ((LiteralExpr)e).asBigNum);
				}
				
			} else SynErr(165);
		}
	}

	void ArrayExpression(out Expr/*!*/ e) {
		Contract.Ensures(Contract.ValueAtReturn(out e) != null);
		IToken/*!*/ x, id;
		Expr/*!*/ index0 = dummyExpr; Expr/*!*/ e1;
		bool store; bool bvExtract;
		List<Expr>/*!*/ allArgs = dummyExprSeq;
		
		AtomExpression(out e);
		while (la.kind == 19 || la.kind == 70) {
			if (la.kind == 19) {
				Get();
				x = t; allArgs = new List<Expr> ();
				allArgs.Add(e);
				store = false; bvExtract = false; 
				if (StartOf(27)) {
					if (StartOf(20)) {
						Expression(out index0);
						if (index0 is BvBounds)
						 bvExtract = true;
						else
						 allArgs.Add(index0);
						
						while (la.kind == 14) {
							Get();
							Expression(out e1);
							if (bvExtract || e1 is BvBounds)
							 this.SemErr("bitvectors only have one dimension");
							allArgs.Add(e1);
							
						}
						if (la.kind == 69) {
							Get();
							Expression(out e1);
							if (bvExtract || e1 is BvBounds)
							 this.SemErr("assignment to bitvectors is not possible");
							allArgs.Add(e1); store = true;
							
						}
					} else {
						Get();
						Expression(out e1);
						allArgs.Add(e1); store = true; 
					}
				}
				Expect(20);
				if (store)
				 e = new NAryExpr(x, new MapStore(x, allArgs.Count - 2), allArgs);
				else if (bvExtract)
				 e = new BvExtractExpr(x, e,
				                       ((BvBounds)index0).Upper.ToIntSafe,
				                       ((BvBounds)index0).Lower.ToIntSafe);
				else
				 e = new NAryExpr(x, new MapSelect(x, allArgs.Count - 1), allArgs);
				
			} else {
				Get();
				x = t; 
				if (StartOf(14)) {
					Ident(out id);
					e = new NAryExpr(x, new FieldAccess(id, id.val), new List<Expr> { e }); 
				} else if (la.kind == 11) {
					Get();
					Ident(out id);
					Expect(69);
					x = t; 
					Expression(out e1);
					Expect(12);
					e = new NAryExpr(x, new FieldUpdate(id, id.val), new List<Expr> { e, e1 }); 
				} else SynErr(166);
			}
		}
	}

	void Nat(out BigNum n) {
		Expect(3);
		try {
		 n = BigNum.FromString(t.val);
		} catch (FormatException) {
		 this.SemErr("incorrectly formatted number");
		 n = BigNum.ZERO;
		}
		
	}

	void AtomExpression(out Expr/*!*/ e) {
		Contract.Ensures(Contract.ValueAtReturn(out e) != null); IToken/*!*/ x; int n; BigNum bn; BigDec bd; BigFloat bf;
		List<Expr>/*!*/ es;  List<Variable>/*!*/ ds;  Trigger trig;
		List<TypeVariable>/*!*/ typeParams;
		IdentifierExpr/*!*/ id;
		QKeyValue kv;
		e = dummyExpr;
		List<Variable>/*!*/ locals;
		List<Block/*!*/>/*!*/ blocks;
		
		switch (la.kind) {
		case 101: {
			Get();
			e = new LiteralExpr(t, false); 
			break;
		}
		case 102: {
			Get();
			e = new LiteralExpr(t, true); 
			break;
		}
		case 103: case 104: {
			if (la.kind == 103) {
				Get();
			} else {
				Get();
			}
			e = new LiteralExpr(t, RoundingMode.RNE); 
			break;
		}
		case 105: case 106: {
			if (la.kind == 105) {
				Get();
			} else {
				Get();
			}
			e = new LiteralExpr(t, RoundingMode.RNA); 
			break;
		}
		case 107: case 108: {
			if (la.kind == 107) {
				Get();
			} else {
				Get();
			}
			e = new LiteralExpr(t, RoundingMode.RTP); 
			break;
		}
		case 109: case 110: {
			if (la.kind == 109) {
				Get();
			} else {
				Get();
			}
			e = new LiteralExpr(t, RoundingMode.RTN); 
			break;
		}
		case 111: case 112: {
			if (la.kind == 111) {
				Get();
			} else {
				Get();
			}
			e = new LiteralExpr(t, RoundingMode.RTZ); 
			break;
		}
		case 3: {
			Nat(out bn);
			e = new LiteralExpr(t, bn); 
			break;
		}
		case 5: case 6: {
			Dec(out bd);
			e = new LiteralExpr(t, bd); 
			break;
		}
		case 7: {
			Float(out bf);
			e = new LiteralExpr(t, bf); 
			break;
		}
		case 2: {
			BvLit(out bn, out n);
			e = new LiteralExpr(t, bn, n); 
			break;
		}
		case 4: {
			Get();
			e = new LiteralExpr(t, t.val.Trim('"')); 
			break;
		}
		case 1: case 43: case 44: case 45: case 46: case 62: case 63: case 64: case 65: {
			Ident(out x);
			id = new IdentifierExpr(x, x.val);  e = id; 
			if (la.kind == 11) {
				Get();
				if (StartOf(20)) {
					Expressions(out es);
					e = new NAryExpr(x, new FunctionCall(id), es); 
				} else if (la.kind == 12) {
					e = new NAryExpr(x, new FunctionCall(id), new List<Expr>()); 
				} else SynErr(167);
				Expect(12);
			}
			break;
		}
		case 113: {
			Get();
			x = t; 
			Expect(11);
			Expression(out e);
			Expect(12);
			e = new OldExpr(x, e); 
			break;
		}
		case 16: {
			Get();
			x = t; 
			Expect(11);
			Expression(out e);
			Expect(12);
			e = new NAryExpr(x, new ArithmeticCoercion(x, ArithmeticCoercion.CoercionType.ToInt), new List<Expr>{ e }); 
			break;
		}
		case 17: {
			Get();
			x = t; 
			Expect(11);
			Expression(out e);
			Expect(12);
			e = new NAryExpr(x, new ArithmeticCoercion(x, ArithmeticCoercion.CoercionType.ToReal), new List<Expr>{ e }); 
			break;
		}
		case 11: {
			Get();
			if (StartOf(20)) {
				Expression(out e);
				if (e is BvBounds)
				 this.SemErr("parentheses around bitvector bounds are not allowed"); 
			} else if (la.kind == 117 || la.kind == 118) {
				Forall();
				x = t; 
				QuantifierBody(x, out typeParams, out ds, out kv, out trig, out e);
				if (typeParams.Count + ds.Count > 0)
				 e = new ForallExpr(x, typeParams, ds, kv, trig, e); 
			} else if (la.kind == 119 || la.kind == 120) {
				Exists();
				x = t; 
				QuantifierBody(x, out typeParams, out ds, out kv, out trig, out e);
				if (typeParams.Count + ds.Count > 0)
				 e = new ExistsExpr(x, typeParams, ds, kv, trig, e); 
			} else if (la.kind == 121 || la.kind == 122) {
				Lambda();
				x = t; 
				QuantifierBody(x, out typeParams, out ds, out kv, out trig, out e);
				if (trig != null)
				 SemErr("triggers not allowed in lambda expressions");
				if (typeParams.Count + ds.Count > 0)
				 e = new LambdaExpr(x, typeParams, ds, kv, e); 
			} else if (la.kind == 9) {
				LetExpr(out e);
			} else SynErr(168);
			Expect(12);
			break;
		}
		case 57: {
			IfThenElseExpression(out e);
			break;
		}
		case 114: {
			CodeExpression(out locals, out blocks);
			e = new CodeExpr(locals, blocks); 
			break;
		}
		default: SynErr(169); break;
		}
	}

	void Dec(out BigDec n) {
		string s = ""; 
		if (la.kind == 5) {
			Get();
			s = t.val; 
		} else if (la.kind == 6) {
			Get();
			s = t.val; 
		} else SynErr(170);
		try {
		 n = BigDec.FromString(s);
		} catch (FormatException) {
		 this.SemErr("incorrectly formatted number");
		 n = BigDec.ZERO;
		}
		
	}

	void Float(out BigFloat n) {
		string s = ""; 
		Expect(7);
		s = t.val; 
		try {
		 n = BigFloat.FromString(s);
		} catch (FormatException e) {
		 this.SemErr("incorrectly formatted floating point, " + e.Message);
		 n = BigFloat.ZERO;
		}
		
	}

	void BvLit(out BigNum n, out int m) {
		Expect(2);
		int pos = t.val.IndexOf("bv");
		string a = t.val.Substring(0, pos);
		string b = t.val.Substring(pos + 2);
		try {
		 n = BigNum.FromString(a);
		 m = Convert.ToInt32(b);
		} catch (FormatException) {
		 this.SemErr("incorrectly formatted bitvector");
		 n = BigNum.ZERO;
		 m = 0;
		}
		
	}

	void Forall() {
		if (la.kind == 117) {
			Get();
		} else if (la.kind == 118) {
			Get();
		} else SynErr(171);
	}

	void QuantifierBody(IToken/*!*/ q, out List<TypeVariable>/*!*/ typeParams, out List<Variable>/*!*/ ds,
out QKeyValue kv, out Trigger trig, out Expr/*!*/ body) {
		Contract.Requires(q != null); Contract.Ensures(Contract.ValueAtReturn(out typeParams) != null); Contract.Ensures(Contract.ValueAtReturn(out ds) != null); Contract.Ensures(Contract.ValueAtReturn(out body) != null);
		trig = null; typeParams = new List<TypeVariable> ();
		IToken/*!*/ tok;
		kv = null;
		ds = new List<Variable> ();
		
		if (la.kind == 21) {
			TypeParams(out tok, out typeParams);
			if (StartOf(12)) {
				BoundVars(out ds);
			}
		} else if (StartOf(12)) {
			BoundVars(out ds);
		} else SynErr(172);
		QSep();
		while (la.kind == 26) {
			AttributeOrTrigger(ref kv, ref trig);
		}
		Expression(out body);
	}

	void Exists() {
		if (la.kind == 119) {
			Get();
		} else if (la.kind == 120) {
			Get();
		} else SynErr(173);
	}

	void Lambda() {
		if (la.kind == 121) {
			Get();
		} else if (la.kind == 122) {
			Get();
		} else SynErr(174);
	}

	void LetExpr(out Expr/*!*/ letexpr) {
		IToken tok;
		Variable v;
		var ds = new List<Variable>();
		Expr e0;
		var rhss = new List<Expr>();
		QKeyValue kv = null;
		Expr body;
		
		Expect(9);
		tok = t; 
		LetVar(out v);
		ds.Add(v); 
		while (la.kind == 14) {
			Get();
			LetVar(out v);
			ds.Add(v); 
		}
		Expect(69);
		Expression(out e0);
		rhss.Add(e0); 
		while (la.kind == 14) {
			Get();
			Expression(out e0);
			rhss.Add(e0); 
		}
		Expect(10);
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Expression(out body);
		letexpr = new LetExpr(tok, ds, rhss, kv, body); 
	}

	void IfThenElseExpression(out Expr/*!*/ e) {
		Contract.Ensures(Contract.ValueAtReturn(out e) != null);
		IToken/*!*/ tok;
		Expr/*!*/ e0, e1, e2;
		e = dummyExpr; 
		Expect(57);
		tok = t; 
		Expression(out e0);
		Expect(116);
		Expression(out e1);
		Expect(58);
		Expression(out e2);
		e = new NAryExpr(tok, new IfThenElse(tok), new List<Expr>{ e0, e1, e2 }); 
	}

	void CodeExpression(out List<Variable>/*!*/ locals, out List<Block/*!*/>/*!*/ blocks) {
		Contract.Ensures(Contract.ValueAtReturn(out locals) != null); Contract.Ensures(Cce.NonNullElements(Contract.ValueAtReturn(out blocks))); locals = new List<Variable>(); Block/*!*/ b;
		blocks = new List<Block/*!*/>();
		
		Expect(114);
		while (la.kind == 9) {
			LocalVars(locals);
		}
		SpecBlock(out b);
		blocks.Add(b); 
		while (StartOf(14)) {
			SpecBlock(out b);
			blocks.Add(b); 
		}
		Expect(115);
	}

	void SpecBlock(out Block/*!*/ b) {
		Contract.Ensures(Contract.ValueAtReturn(out b) != null); IToken/*!*/ x; IToken/*!*/ y;
		Cmd c;  IToken label;
		List<Cmd> cs = new List<Cmd>();
		List<IToken>/*!*/ xs;
		List<String> ss = new List<String>();
		b = dummyBlock;
		QKeyValue kv = null;
		Expr/*!*/ e;
		
		Ident(out x);
		Expect(13);
		while (StartOf(19)) {
			LabelOrCmd(out c, out label);
			Contract.Assert(c == null || label == null);
			if (c != null) {
			 cs.Add(c);
			} else if (label != null) {
			 SemErr("SpecBlock's can only have one label");
			}
			
		}
		if (la.kind == 55) {
			Get();
			y = t; 
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Idents(out xs);
			foreach(IToken/*!*/ s in xs){
			 Contract.Assert(s != null);
			 ss.Add(s.val); }
			b = new Block(x,x.val,cs,new GotoCmd(y,ss) {
			 Attributes = kv
			});
			
		} else if (la.kind == 56) {
			Get();
			while (la.kind == 26) {
				Attribute(ref kv);
			}
			Expression(out e);
			b = new Block(x,x.val,cs,new ReturnExprCmd(t,e) {
			 Attributes = kv
			}); 
			
		} else SynErr(175);
		Expect(10);
	}

	void AttributeOrTrigger(ref QKeyValue kv, ref Trigger trig) {
		IToken/*!*/ tok;  Expr/*!*/ e;  List<Expr>/*!*/ es;
		IToken id;
		List<object/*!*/> parameters;  object/*!*/ param;
		
		Expect(26);
		tok = t; 
		if (la.kind == 13) {
			Get();
			Ident(out id);
			parameters = new List<object/*!*/>(); 
			if (StartOf(20)) {
				AttributeParameter(out param);
				parameters.Add(param); 
				while (la.kind == 14) {
					Get();
					AttributeParameter(out param);
					parameters.Add(param); 
				}
			}
			if (id.val == "nopats") {
			 if (parameters.Count == 1 && parameters[0] is Expr) {
			   e = (Expr)parameters[0];
			   if(trig==null){
			     trig = new Trigger(tok, false, new List<Expr> { e }, null);
			   } else {
			     trig.AddLast(new Trigger(tok, false, new List<Expr> { e }, null));
			   }
			 } else {
			   this.SemErr("the 'nopats' quantifier attribute expects a string-literal parameter");
			 }
			} else {
			 if (kv==null) {
			   kv = new QKeyValue(tok, id.val, parameters, null);
			 } else {
			   kv.AddLast(new QKeyValue(tok, id.val, parameters, null));
			 }
			}
			
		} else if (StartOf(20)) {
			Expression(out e);
			es = new List<Expr> { e }; 
			while (la.kind == 14) {
				Get();
				Expression(out e);
				es.Add(e); 
			}
			if (trig==null) {
			 trig = new Trigger(tok, true, es, null);
			} else {
			 trig.AddLast(new Trigger(tok, true, es, null));
			}
			
		} else SynErr(176);
		Expect(27);
	}

	void AttributeParameter(out object/*!*/ o) {
		Contract.Ensures(Contract.ValueAtReturn(out o) != null);
		o = "error";
		Expr/*!*/ e;
		
		if (la.kind == 4) {
			Get();
			o = t.val.Substring(1, t.val.Length-2); 
		} else if (StartOf(20)) {
			Expression(out e);
			o = e; 
		} else SynErr(177);
	}

	void QSep() {
		if (la.kind == 123) {
			Get();
		} else if (la.kind == 124) {
			Get();
		} else SynErr(178);
	}

	void LetVar(out Variable/*!*/ v) {
		QKeyValue kv = null;
		IToken id;
		
		while (la.kind == 26) {
			Attribute(ref kv);
		}
		Ident(out id);
		var tyd = new TypedIdent(id, id.val, dummyType/*will be replaced during type checking*/, null);
		v = new BoundVariable(tyd.tok, tyd, kv);
		
	}



	public void Parse() {
		la = new Token();
		la.val = "";
		Get();
		BoogiePL();
		Expect(0);

		Expect(0);
	}

	static readonly bool[,]/*!*/ set = {
		{_T,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _x,_x,_x,_x, _T,_T,_x,_T, _T,_T,_x,_T, _x,_T,_T,_T, _x,_x,_x,_T, _T,_T,_T,_T, _x,_x,_x,_x, _T,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_T, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_T, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _x,_x,_x,_x, _T,_T,_T,_T, _x,_T,_x,_x, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_T, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_x,_x, _x,_T,_T,_T, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_x,_x, _x,_T,_T,_T, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_T,_x, _x,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_T,_x, _x,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _T,_T,_x,_x, _x,_x,_x,_x, _T,_T,_x,_x, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _T,_T,_x,_x, _x,_x,_x,_x, _T,_T,_x,_x, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_T, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _x,_x,_x,_x, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_T, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _x,_x,_x,_x, _T,_T,_T,_T, _x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_T, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _x,_x,_x,_T, _x,_x,_x,_x, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_T,_T, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_x,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_T,_x,_T, _T,_T,_x,_T, _x,_T,_T,_T, _T,_T,_T,_T, _T,_x,_x,_T, _T,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_T,_T, _T,_T,_T,_T, _T,_x,_x,_T, _T,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _x,_x,_x,_T, _x,_x,_x,_x, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_T,_T, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_x,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_x, _x,_x,_x,_T, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _T,_T,_T,_T, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _T,_T,_T,_T, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _T,_T,_T,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _T,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_T,_T, _T,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _x,_x,_x,_T, _x,_x,_x,_x, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_T,_T, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x},
		{_x,_T,_T,_T, _T,_T,_T,_T, _x,_x,_x,_T, _x,_x,_x,_x, _T,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_T,_T, _T,_T,_x,_x, _x,_T,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_T,_x,_x, _x,_x,_x,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_T, _T,_T,_T,_x, _x,_x,_x,_x, _x,_x,_x,_x, _x,_x,_x}

	};
} // end Parser


public class Errors {
	public int count = 0;                                    // number of errors detected
	public System.IO.TextWriter/*!*/ errorStream = Console.Out;   // error messages go to this stream
	public string errMsgFormat = "{0}({1},{2}): error: {3}"; // 0=filename, 1=line, 2=column, 3=text
	public string warningMsgFormat = "{0}({1},{2}): warning: {3}"; // 0=filename, 1=line, 2=column, 3=text

	public void SynErr(string filename, int line, int col, int n) {
		SynErr(filename, line, col, GetSyntaxErrorString(n));
	}

	public virtual void SynErr(string filename, int line, int col, string/*!*/ msg) {
		Contract.Requires(msg != null);
		errorStream.WriteLine(errMsgFormat, filename, line, col, msg);
		count++;
	}

	string GetSyntaxErrorString(int n) {
		string s;
		switch (n) {
			case 0: s = "EOF expected"; break;
			case 1: s = "ident expected"; break;
			case 2: s = "bvlit expected"; break;
			case 3: s = "digits expected"; break;
			case 4: s = "string expected"; break;
			case 5: s = "decimal expected"; break;
			case 6: s = "dec_float expected"; break;
			case 7: s = "float expected"; break;
			case 8: s = "\"yield\" expected"; break;
			case 9: s = "\"var\" expected"; break;
			case 10: s = "\";\" expected"; break;
			case 11: s = "\"(\" expected"; break;
			case 12: s = "\")\" expected"; break;
			case 13: s = "\":\" expected"; break;
			case 14: s = "\",\" expected"; break;
			case 15: s = "\"where\" expected"; break;
			case 16: s = "\"int\" expected"; break;
			case 17: s = "\"real\" expected"; break;
			case 18: s = "\"bool\" expected"; break;
			case 19: s = "\"[\" expected"; break;
			case 20: s = "\"]\" expected"; break;
			case 21: s = "\"<\" expected"; break;
			case 22: s = "\">\" expected"; break;
			case 23: s = "\"const\" expected"; break;
			case 24: s = "\"unique\" expected"; break;
			case 25: s = "\"uses\" expected"; break;
			case 26: s = "\"{\" expected"; break;
			case 27: s = "\"}\" expected"; break;
			case 28: s = "\"revealed\" expected"; break;
			case 29: s = "\"function\" expected"; break;
			case 30: s = "\"returns\" expected"; break;
			case 31: s = "\"hideable\" expected"; break;
			case 32: s = "\"axiom\" expected"; break;
			case 33: s = "\"type\" expected"; break;
			case 34: s = "\"=\" expected"; break;
			case 35: s = "\"datatype\" expected"; break;
			case 36: s = "\"invariant\" expected"; break;
			case 37: s = "\"pure\" expected"; break;
			case 38: s = "\"async\" expected"; break;
			case 39: s = "\"action\" expected"; break;
			case 40: s = "\"creates\" expected"; break;
			case 41: s = "\"refines\" expected"; break;
			case 42: s = "\"using\" expected"; break;
			case 43: s = "\"left\" expected"; break;
			case 44: s = "\"right\" expected"; break;
			case 45: s = "\"both\" expected"; break;
			case 46: s = "\"atomic\" expected"; break;
			case 47: s = "\"procedure\" expected"; break;
			case 48: s = "\"asserts\" expected"; break;
			case 49: s = "\"requires\" expected"; break;
			case 50: s = "\"ensures\" expected"; break;
			case 51: s = "\"preserves\" expected"; break;
			case 52: s = "\"implementation\" expected"; break;
			case 53: s = "\"free\" expected"; break;
			case 54: s = "\"modifies\" expected"; break;
			case 55: s = "\"goto\" expected"; break;
			case 56: s = "\"return\" expected"; break;
			case 57: s = "\"if\" expected"; break;
			case 58: s = "\"else\" expected"; break;
			case 59: s = "\"while\" expected"; break;
			case 60: s = "\"*\" expected"; break;
			case 61: s = "\"break\" expected"; break;
			case 62: s = "\"reveal\" expected"; break;
			case 63: s = "\"hide\" expected"; break;
			case 64: s = "\"pop\" expected"; break;
			case 65: s = "\"push\" expected"; break;
			case 66: s = "\"assert\" expected"; break;
			case 67: s = "\"assume\" expected"; break;
			case 68: s = "\"havoc\" expected"; break;
			case 69: s = "\":=\" expected"; break;
			case 70: s = "\"->\" expected"; break;
			case 71: s = "\"call\" expected"; break;
			case 72: s = "\"par\" expected"; break;
			case 73: s = "\"|\" expected"; break;
			case 74: s = "\"<==>\" expected"; break;
			case 75: s = "\"\\u21d4\" expected"; break;
			case 76: s = "\"==>\" expected"; break;
			case 77: s = "\"\\u21d2\" expected"; break;
			case 78: s = "\"<==\" expected"; break;
			case 79: s = "\"\\u21d0\" expected"; break;
			case 80: s = "\"&&\" expected"; break;
			case 81: s = "\"\\u2227\" expected"; break;
			case 82: s = "\"||\" expected"; break;
			case 83: s = "\"\\u2228\" expected"; break;
			case 84: s = "\"==\" expected"; break;
			case 85: s = "\"<=\" expected"; break;
			case 86: s = "\">=\" expected"; break;
			case 87: s = "\"!=\" expected"; break;
			case 88: s = "\"\\u2260\" expected"; break;
			case 89: s = "\"\\u2264\" expected"; break;
			case 90: s = "\"\\u2265\" expected"; break;
			case 91: s = "\"++\" expected"; break;
			case 92: s = "\"+\" expected"; break;
			case 93: s = "\"-\" expected"; break;
			case 94: s = "\"div\" expected"; break;
			case 95: s = "\"mod\" expected"; break;
			case 96: s = "\"/\" expected"; break;
			case 97: s = "\"**\" expected"; break;
			case 98: s = "\"is\" expected"; break;
			case 99: s = "\"!\" expected"; break;
			case 100: s = "\"\\u00ac\" expected"; break;
			case 101: s = "\"false\" expected"; break;
			case 102: s = "\"true\" expected"; break;
			case 103: s = "\"roundNearestTiesToEven\" expected"; break;
			case 104: s = "\"RNE\" expected"; break;
			case 105: s = "\"roundNearestTiesToAway\" expected"; break;
			case 106: s = "\"RNA\" expected"; break;
			case 107: s = "\"roundTowardPositive\" expected"; break;
			case 108: s = "\"RTP\" expected"; break;
			case 109: s = "\"roundTowardNegative\" expected"; break;
			case 110: s = "\"RTN\" expected"; break;
			case 111: s = "\"roundTowardZero\" expected"; break;
			case 112: s = "\"RTZ\" expected"; break;
			case 113: s = "\"old\" expected"; break;
			case 114: s = "\"|{\" expected"; break;
			case 115: s = "\"}|\" expected"; break;
			case 116: s = "\"then\" expected"; break;
			case 117: s = "\"forall\" expected"; break;
			case 118: s = "\"\\u2200\" expected"; break;
			case 119: s = "\"exists\" expected"; break;
			case 120: s = "\"\\u2203\" expected"; break;
			case 121: s = "\"lambda\" expected"; break;
			case 122: s = "\"\\u03bb\" expected"; break;
			case 123: s = "\"::\" expected"; break;
			case 124: s = "\"\\u2022\" expected"; break;
			case 125: s = "??? expected"; break;
			case 126: s = "invalid BoogiePL"; break;
			case 127: s = "invalid BoogiePL"; break;
			case 128: s = "invalid Consts"; break;
			case 129: s = "invalid Function"; break;
			case 130: s = "invalid Function"; break;
			case 131: s = "invalid YieldProcedureDecl"; break;
			case 132: s = "invalid Procedure"; break;
			case 133: s = "invalid ActionDecl"; break;
			case 134: s = "invalid Type"; break;
			case 135: s = "invalid TypeAtom"; break;
			case 136: s = "invalid Ident"; break;
			case 137: s = "invalid TypeArgs"; break;
			case 138: s = "invalid MoverQualifier"; break;
			case 139: s = "invalid SpecAction"; break;
			case 140: s = "invalid SpecRefinedActionForYieldProcedure"; break;
			case 141: s = "invalid SpecYieldRequires"; break;
			case 142: s = "invalid SpecYieldPrePost"; break;
			case 143: s = "invalid SpecYieldEnsures"; break;
			case 144: s = "invalid Spec"; break;
			case 145: s = "invalid SpecPrePost"; break;
			case 146: s = "invalid LabelOrCmd"; break;
			case 147: s = "invalid LabelOrCmd"; break;
			case 148: s = "invalid StructuredCmd"; break;
			case 149: s = "invalid TransferCmd"; break;
			case 150: s = "invalid IfCmd"; break;
			case 151: s = "invalid WhileCmd"; break;
			case 152: s = "invalid Guard"; break;
			case 153: s = "invalid LabelOrAssign"; break;
			case 154: s = "invalid CallParams"; break;
			case 155: s = "invalid EquivOp"; break;
			case 156: s = "invalid ImpliesOp"; break;
			case 157: s = "invalid ExpliesOp"; break;
			case 158: s = "invalid AndOp"; break;
			case 159: s = "invalid OrOp"; break;
			case 160: s = "invalid RelOp"; break;
			case 161: s = "invalid AddOp"; break;
			case 162: s = "invalid MulOp"; break;
			case 163: s = "invalid UnaryExpression"; break;
			case 164: s = "invalid NegOp"; break;
			case 165: s = "invalid CoercionExpression"; break;
			case 166: s = "invalid ArrayExpression"; break;
			case 167: s = "invalid AtomExpression"; break;
			case 168: s = "invalid AtomExpression"; break;
			case 169: s = "invalid AtomExpression"; break;
			case 170: s = "invalid Dec"; break;
			case 171: s = "invalid Forall"; break;
			case 172: s = "invalid QuantifierBody"; break;
			case 173: s = "invalid Exists"; break;
			case 174: s = "invalid Lambda"; break;
			case 175: s = "invalid SpecBlock"; break;
			case 176: s = "invalid AttributeOrTrigger"; break;
			case 177: s = "invalid AttributeParameter"; break;
			case 178: s = "invalid QSep"; break;

			default: s = "error " + n; break;
		}
		return s;
	}

	public void SemErr(IToken/*!*/ tok, string/*!*/ msg) {  // semantic errors
		Contract.Requires(tok != null);
		Contract.Requires(msg != null);
		SemErr(tok.filename, tok.line, tok.col, msg);
	}

	public virtual void SemErr(string filename, int line, int col, string/*!*/ msg) {
		Contract.Requires(msg != null);
		errorStream.WriteLine(errMsgFormat, filename, line, col, msg);
		count++;
	}

	public void Warning(IToken/*!*/ tok, string/*!*/ msg) {  // warnings
		Contract.Requires(tok != null);
		Contract.Requires(msg != null);
		Warning(tok.filename, tok.line, tok.col, msg);
	}

	public virtual void Warning(string filename, int line, int col, string msg) {
		Contract.Requires(msg != null);
		errorStream.WriteLine(warningMsgFormat, filename, line, col, msg);
	}
} // Errors


public class FatalError: Exception {
	public FatalError(string m): base(m) {}
}


}