/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { combineLatest } from 'rxjs';
import { filter, map, startWith, switchMap, take } from 'rxjs/operators';
import { UrlTree } from '../url_tree';
const INITIAL_VALUE = Symbol('INITIAL_VALUE');
export function prioritizedGuardValue() {
    return switchMap(obs => {
        return combineLatest(obs.map(o => o.pipe(take(1), startWith(INITIAL_VALUE))))
            .pipe(map((results) => {
            for (const result of results) {
                if (result === true) {
                    // If result is true, check the next one
                    continue;
                }
                else if (result === INITIAL_VALUE) {
                    // If guard has not finished, we need to stop processing.
                    return INITIAL_VALUE;
                }
                else if (result === false || result instanceof UrlTree) {
                    // Result finished and was not true. Return the result.
                    // Note that we only allow false/UrlTree. Other values are considered invalid and
                    // ignored.
                    return result;
                }
            }
            // Everything resolved to true. Return true.
            return true;
        }), filter((item) => item !== INITIAL_VALUE), take(1));
    });
}
//# sourceMappingURL=data:application/json;base64,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