// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ListBuckets`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_buckets(i32)`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder::max_buckets) / [`set_max_buckets(Option<i32>)`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder::set_max_buckets):<br>required: **false**<br><p>Maximum number of buckets to be returned in response. When the number is more than the count of buckets that are owned by an Amazon Web Services account, return all the buckets in response.</p><br>
    ///   - [`continuation_token(impl Into<String>)`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder::continuation_token) / [`set_continuation_token(Option<String>)`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder::set_continuation_token):<br>required: **false**<br><p><code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket with a token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this <code>ContinuationToken</code> for pagination of the list results.</p> <p>Length Constraints: Minimum length of 0. Maximum length of 1024.</p> <p>Required: No.</p><note>  <p>If you specify the <code>bucket-region</code>, <code>prefix</code>, or <code>continuation-token</code> query parameters without using <code>max-buckets</code> to set the maximum number of buckets returned in the response, Amazon S3 applies a default page size of 10,000 and provides a continuation token if there are more buckets.</p> </note><br>
    ///   - [`prefix(impl Into<String>)`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder::prefix) / [`set_prefix(Option<String>)`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder::set_prefix):<br>required: **false**<br><p>Limits the response to bucket names that begin with the specified bucket name prefix.</p><br>
    ///   - [`bucket_region(impl Into<String>)`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder::bucket_region) / [`set_bucket_region(Option<String>)`](crate::operation::list_buckets::builders::ListBucketsFluentBuilder::set_bucket_region):<br>required: **false**<br><p>Limits the response to buckets that are located in the specified Amazon Web Services Region. The Amazon Web Services Region must be expressed according to the Amazon Web Services Region code, such as <code>us-west-2</code> for the US West (Oregon) Region. For a list of the valid values for all of the Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region">Regions and Endpoints</a>.</p><note>  <p>Requests made to a Regional endpoint that is different from the <code>bucket-region</code> parameter are not supported. For example, if you want to limit the response to your buckets in Region <code>us-west-2</code>, the request must be made to an endpoint in Region <code>us-west-2</code>.</p> </note><br>
    /// - On success, responds with [`ListBucketsOutput`](crate::operation::list_buckets::ListBucketsOutput) with field(s):
    ///   - [`buckets(Option<Vec::<Bucket>>)`](crate::operation::list_buckets::ListBucketsOutput::buckets): <p>The list of buckets owned by the requester.</p>
    ///   - [`owner(Option<Owner>)`](crate::operation::list_buckets::ListBucketsOutput::owner): <p>The owner of the buckets listed.</p>
    ///   - [`continuation_token(Option<String>)`](crate::operation::list_buckets::ListBucketsOutput::continuation_token): <p><code>ContinuationToken</code> is included in the response when there are more buckets that can be listed with pagination. The next <code>ListBuckets</code> request to Amazon S3 can be continued with this <code>ContinuationToken</code>. <code>ContinuationToken</code> is obfuscated and is not a real bucket.</p>
    ///   - [`prefix(Option<String>)`](crate::operation::list_buckets::ListBucketsOutput::prefix): <p>If <code>Prefix</code> was sent with the request, it is included in the response.</p> <p>All bucket names in the response begin with the specified bucket name prefix.</p>
    /// - On failure, responds with [`SdkError<ListBucketsError>`](crate::operation::list_buckets::ListBucketsError)
    pub fn list_buckets(&self) -> crate::operation::list_buckets::builders::ListBucketsFluentBuilder {
        crate::operation::list_buckets::builders::ListBucketsFluentBuilder::new(self.handle.clone())
    }
}
