/*
** Copyright (c) 2018-2023 Valve Corporation
** Copyright (c) 2018-2023 LunarG, Inc.
** Copyright (c) 2023 Advanced Micro Devices, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

/*
** This file is generated from the Khronos Vulkan XML API Registry.
**
*/

#ifndef  GFXRECON_GENERATED_VULKAN_STYPE_UTIL_H
#define  GFXRECON_GENERATED_VULKAN_STYPE_UTIL_H

#include "format/platform_types.h"
#include "util/defines.h"

#include "vulkan/vulkan.h"
#include "vk_video/vulkan_video_codec_h264std.h"
#include "vk_video/vulkan_video_codec_h264std_decode.h"
#include "vk_video/vulkan_video_codec_h264std_encode.h"
#include "vk_video/vulkan_video_codec_h265std.h"
#include "vk_video/vulkan_video_codec_h265std_decode.h"
#include "vk_video/vulkan_video_codec_h265std_encode.h"
#include "vk_video/vulkan_video_codecs_common.h"

GFXRECON_BEGIN_NAMESPACE(gfxrecon)
GFXRECON_BEGIN_NAMESPACE(util)

// Instantiating the primary template indicates that either the template was
// called with an invalid Vulkan struct type or that the code generation is out
// of date, both of which are errors
template <typename T> VkStructureType GetSType() = delete;

template <> constexpr VkStructureType GetSType<VkBufferMemoryBarrier>(){ return VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER; }
template <> constexpr VkStructureType GetSType<VkImageMemoryBarrier>(){ return VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER; }
template <> constexpr VkStructureType GetSType<VkMemoryBarrier>(){ return VK_STRUCTURE_TYPE_MEMORY_BARRIER; }
template <> constexpr VkStructureType GetSType<VkApplicationInfo>(){ return VK_STRUCTURE_TYPE_APPLICATION_INFO; }
template <> constexpr VkStructureType GetSType<VkInstanceCreateInfo>(){ return VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkDeviceQueueCreateInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkDeviceCreateInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkSubmitInfo>(){ return VK_STRUCTURE_TYPE_SUBMIT_INFO; }
template <> constexpr VkStructureType GetSType<VkMappedMemoryRange>(){ return VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE; }
template <> constexpr VkStructureType GetSType<VkMemoryAllocateInfo>(){ return VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO; }
template <> constexpr VkStructureType GetSType<VkBindSparseInfo>(){ return VK_STRUCTURE_TYPE_BIND_SPARSE_INFO; }
template <> constexpr VkStructureType GetSType<VkFenceCreateInfo>(){ return VK_STRUCTURE_TYPE_FENCE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkSemaphoreCreateInfo>(){ return VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkEventCreateInfo>(){ return VK_STRUCTURE_TYPE_EVENT_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkQueryPoolCreateInfo>(){ return VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkBufferCreateInfo>(){ return VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkBufferViewCreateInfo>(){ return VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkImageCreateInfo>(){ return VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkImageViewCreateInfo>(){ return VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkShaderModuleCreateInfo>(){ return VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineCacheCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineShaderStageCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkComputePipelineCreateInfo>(){ return VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineVertexInputStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineInputAssemblyStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineTessellationStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineViewportStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineRasterizationStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineMultisampleStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineDepthStencilStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineColorBlendStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineDynamicStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkGraphicsPipelineCreateInfo>(){ return VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineLayoutCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkSamplerCreateInfo>(){ return VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkCopyDescriptorSet>(){ return VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET; }
template <> constexpr VkStructureType GetSType<VkDescriptorPoolCreateInfo>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkDescriptorSetAllocateInfo>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO; }
template <> constexpr VkStructureType GetSType<VkDescriptorSetLayoutCreateInfo>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkWriteDescriptorSet>(){ return VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET; }
template <> constexpr VkStructureType GetSType<VkFramebufferCreateInfo>(){ return VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkRenderPassCreateInfo>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkCommandPoolCreateInfo>(){ return VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkCommandBufferAllocateInfo>(){ return VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO; }
template <> constexpr VkStructureType GetSType<VkCommandBufferInheritanceInfo>(){ return VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO; }
template <> constexpr VkStructureType GetSType<VkCommandBufferBeginInfo>(){ return VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO; }
template <> constexpr VkStructureType GetSType<VkRenderPassBeginInfo>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSubgroupProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkBindBufferMemoryInfo>(){ return VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO; }
template <> constexpr VkStructureType GetSType<VkBindImageMemoryInfo>(){ return VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevice16BitStorageFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES; }
template <> constexpr VkStructureType GetSType<VkMemoryDedicatedRequirements>(){ return VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS; }
template <> constexpr VkStructureType GetSType<VkMemoryDedicatedAllocateInfo>(){ return VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO; }
template <> constexpr VkStructureType GetSType<VkMemoryAllocateFlagsInfo>(){ return VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO; }
template <> constexpr VkStructureType GetSType<VkDeviceGroupRenderPassBeginInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO; }
template <> constexpr VkStructureType GetSType<VkDeviceGroupCommandBufferBeginInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO; }
template <> constexpr VkStructureType GetSType<VkDeviceGroupSubmitInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO; }
template <> constexpr VkStructureType GetSType<VkDeviceGroupBindSparseInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO; }
template <> constexpr VkStructureType GetSType<VkBindBufferMemoryDeviceGroupInfo>(){ return VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO; }
template <> constexpr VkStructureType GetSType<VkBindImageMemoryDeviceGroupInfo>(){ return VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceGroupProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkDeviceGroupDeviceCreateInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkBufferMemoryRequirementsInfo2>(){ return VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2; }
template <> constexpr VkStructureType GetSType<VkImageMemoryRequirementsInfo2>(){ return VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2; }
template <> constexpr VkStructureType GetSType<VkImageSparseMemoryRequirementsInfo2>(){ return VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2; }
template <> constexpr VkStructureType GetSType<VkMemoryRequirements2>(){ return VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2; }
template <> constexpr VkStructureType GetSType<VkSparseImageMemoryRequirements2>(){ return VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFeatures2>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceProperties2>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2; }
template <> constexpr VkStructureType GetSType<VkFormatProperties2>(){ return VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2; }
template <> constexpr VkStructureType GetSType<VkImageFormatProperties2>(){ return VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageFormatInfo2>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2; }
template <> constexpr VkStructureType GetSType<VkQueueFamilyProperties2>(){ return VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMemoryProperties2>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2; }
template <> constexpr VkStructureType GetSType<VkSparseImageFormatProperties2>(){ return VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSparseImageFormatInfo2>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePointClippingProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkRenderPassInputAttachmentAspectCreateInfo>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkImageViewUsageCreateInfo>(){ return VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineTessellationDomainOriginStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkRenderPassMultiviewCreateInfo>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMultiviewFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMultiviewProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVariablePointersFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceProtectedMemoryFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceProtectedMemoryProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkDeviceQueueInfo2>(){ return VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2; }
template <> constexpr VkStructureType GetSType<VkProtectedSubmitInfo>(){ return VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO; }
template <> constexpr VkStructureType GetSType<VkSamplerYcbcrConversionCreateInfo>(){ return VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkSamplerYcbcrConversionInfo>(){ return VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO; }
template <> constexpr VkStructureType GetSType<VkBindImagePlaneMemoryInfo>(){ return VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO; }
template <> constexpr VkStructureType GetSType<VkImagePlaneMemoryRequirementsInfo>(){ return VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSamplerYcbcrConversionFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES; }
template <> constexpr VkStructureType GetSType<VkSamplerYcbcrConversionImageFormatProperties>(){ return VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkDescriptorUpdateTemplateCreateInfo>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExternalImageFormatInfo>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO; }
template <> constexpr VkStructureType GetSType<VkExternalImageFormatProperties>(){ return VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExternalBufferInfo>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO; }
template <> constexpr VkStructureType GetSType<VkExternalBufferProperties>(){ return VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceIDProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkExternalMemoryImageCreateInfo>(){ return VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkExternalMemoryBufferCreateInfo>(){ return VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkExportMemoryAllocateInfo>(){ return VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExternalFenceInfo>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO; }
template <> constexpr VkStructureType GetSType<VkExternalFenceProperties>(){ return VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkExportFenceCreateInfo>(){ return VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkExportSemaphoreCreateInfo>(){ return VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExternalSemaphoreInfo>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO; }
template <> constexpr VkStructureType GetSType<VkExternalSemaphoreProperties>(){ return VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance3Properties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkDescriptorSetLayoutSupport>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderDrawParametersFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVulkan11Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVulkan11Properties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVulkan12Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVulkan12Properties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkImageFormatListCreateInfo>(){ return VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkAttachmentDescription2>(){ return VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2; }
template <> constexpr VkStructureType GetSType<VkAttachmentReference2>(){ return VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2; }
template <> constexpr VkStructureType GetSType<VkSubpassDescription2>(){ return VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2; }
template <> constexpr VkStructureType GetSType<VkSubpassDependency2>(){ return VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2; }
template <> constexpr VkStructureType GetSType<VkRenderPassCreateInfo2>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2; }
template <> constexpr VkStructureType GetSType<VkSubpassBeginInfo>(){ return VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO; }
template <> constexpr VkStructureType GetSType<VkSubpassEndInfo>(){ return VK_STRUCTURE_TYPE_SUBPASS_END_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevice8BitStorageFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDriverProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderAtomicInt64Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderFloat16Int8Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFloatControlsProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkDescriptorSetLayoutBindingFlagsCreateInfo>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDescriptorIndexingFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDescriptorIndexingProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkDescriptorSetVariableDescriptorCountAllocateInfo>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO; }
template <> constexpr VkStructureType GetSType<VkDescriptorSetVariableDescriptorCountLayoutSupport>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT; }
template <> constexpr VkStructureType GetSType<VkSubpassDescriptionDepthStencilResolve>(){ return VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDepthStencilResolveProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceScalarBlockLayoutFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES; }
template <> constexpr VkStructureType GetSType<VkImageStencilUsageCreateInfo>(){ return VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkSamplerReductionModeCreateInfo>(){ return VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSamplerFilterMinmaxProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVulkanMemoryModelFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImagelessFramebufferFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES; }
template <> constexpr VkStructureType GetSType<VkFramebufferAttachmentImageInfo>(){ return VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO; }
template <> constexpr VkStructureType GetSType<VkFramebufferAttachmentsCreateInfo>(){ return VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkRenderPassAttachmentBeginInfo>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceUniformBufferStandardLayoutFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES; }
template <> constexpr VkStructureType GetSType<VkAttachmentReferenceStencilLayout>(){ return VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT; }
template <> constexpr VkStructureType GetSType<VkAttachmentDescriptionStencilLayout>(){ return VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceHostQueryResetFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceTimelineSemaphoreFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceTimelineSemaphoreProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkSemaphoreTypeCreateInfo>(){ return VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkTimelineSemaphoreSubmitInfo>(){ return VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO; }
template <> constexpr VkStructureType GetSType<VkSemaphoreWaitInfo>(){ return VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO; }
template <> constexpr VkStructureType GetSType<VkSemaphoreSignalInfo>(){ return VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceBufferDeviceAddressFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES; }
template <> constexpr VkStructureType GetSType<VkBufferDeviceAddressInfo>(){ return VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO; }
template <> constexpr VkStructureType GetSType<VkBufferOpaqueCaptureAddressCreateInfo>(){ return VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkMemoryOpaqueCaptureAddressAllocateInfo>(){ return VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO; }
template <> constexpr VkStructureType GetSType<VkDeviceMemoryOpaqueCaptureAddressInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVulkan13Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVulkan13Properties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPipelineCreationFeedbackCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderTerminateInvocationFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceToolProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePrivateDataFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES; }
template <> constexpr VkStructureType GetSType<VkDevicePrivateDataCreateInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPrivateDataSlotCreateInfo>(){ return VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePipelineCreationCacheControlFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES; }
template <> constexpr VkStructureType GetSType<VkMemoryBarrier2>(){ return VK_STRUCTURE_TYPE_MEMORY_BARRIER_2; }
template <> constexpr VkStructureType GetSType<VkBufferMemoryBarrier2>(){ return VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2; }
template <> constexpr VkStructureType GetSType<VkImageMemoryBarrier2>(){ return VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2; }
template <> constexpr VkStructureType GetSType<VkDependencyInfo>(){ return VK_STRUCTURE_TYPE_DEPENDENCY_INFO; }
template <> constexpr VkStructureType GetSType<VkSemaphoreSubmitInfo>(){ return VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO; }
template <> constexpr VkStructureType GetSType<VkCommandBufferSubmitInfo>(){ return VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO; }
template <> constexpr VkStructureType GetSType<VkSubmitInfo2>(){ return VK_STRUCTURE_TYPE_SUBMIT_INFO_2; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSynchronization2Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageRobustnessFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES; }
template <> constexpr VkStructureType GetSType<VkBufferCopy2>(){ return VK_STRUCTURE_TYPE_BUFFER_COPY_2; }
template <> constexpr VkStructureType GetSType<VkCopyBufferInfo2>(){ return VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2; }
template <> constexpr VkStructureType GetSType<VkImageCopy2>(){ return VK_STRUCTURE_TYPE_IMAGE_COPY_2; }
template <> constexpr VkStructureType GetSType<VkCopyImageInfo2>(){ return VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2; }
template <> constexpr VkStructureType GetSType<VkBufferImageCopy2>(){ return VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2; }
template <> constexpr VkStructureType GetSType<VkCopyBufferToImageInfo2>(){ return VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2; }
template <> constexpr VkStructureType GetSType<VkCopyImageToBufferInfo2>(){ return VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2; }
template <> constexpr VkStructureType GetSType<VkImageBlit2>(){ return VK_STRUCTURE_TYPE_IMAGE_BLIT_2; }
template <> constexpr VkStructureType GetSType<VkBlitImageInfo2>(){ return VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2; }
template <> constexpr VkStructureType GetSType<VkImageResolve2>(){ return VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2; }
template <> constexpr VkStructureType GetSType<VkResolveImageInfo2>(){ return VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSubgroupSizeControlFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSubgroupSizeControlProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPipelineShaderStageRequiredSubgroupSizeCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceInlineUniformBlockFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceInlineUniformBlockProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkWriteDescriptorSetInlineUniformBlock>(){ return VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK; }
template <> constexpr VkStructureType GetSType<VkDescriptorPoolInlineUniformBlockCreateInfo>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceTextureCompressionASTCHDRFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES; }
template <> constexpr VkStructureType GetSType<VkRenderingAttachmentInfo>(){ return VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO; }
template <> constexpr VkStructureType GetSType<VkRenderingInfo>(){ return VK_STRUCTURE_TYPE_RENDERING_INFO; }
template <> constexpr VkStructureType GetSType<VkPipelineRenderingCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDynamicRenderingFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES; }
template <> constexpr VkStructureType GetSType<VkCommandBufferInheritanceRenderingInfo>(){ return VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderIntegerDotProductFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderIntegerDotProductProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceTexelBufferAlignmentProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkFormatProperties3>(){ return VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance4Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance4Properties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkDeviceBufferMemoryRequirements>(){ return VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS; }
template <> constexpr VkStructureType GetSType<VkDeviceImageMemoryRequirements>(){ return VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVulkan14Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVulkan14Properties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkDeviceQueueGlobalPriorityCreateInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceGlobalPriorityQueryFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES; }
template <> constexpr VkStructureType GetSType<VkQueueFamilyGlobalPriorityProperties>(){ return VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderSubgroupRotateFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderFloatControls2Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderExpectAssumeFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLineRasterizationFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLineRasterizationProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPipelineRasterizationLineStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVertexAttributeDivisorProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPipelineVertexInputDivisorStateCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVertexAttributeDivisorFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceIndexTypeUint8Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES; }
template <> constexpr VkStructureType GetSType<VkMemoryMapInfo>(){ return VK_STRUCTURE_TYPE_MEMORY_MAP_INFO; }
template <> constexpr VkStructureType GetSType<VkMemoryUnmapInfo>(){ return VK_STRUCTURE_TYPE_MEMORY_UNMAP_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance5Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance5Properties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkRenderingAreaInfo>(){ return VK_STRUCTURE_TYPE_RENDERING_AREA_INFO; }
template <> constexpr VkStructureType GetSType<VkImageSubresource2>(){ return VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2; }
template <> constexpr VkStructureType GetSType<VkDeviceImageSubresourceInfo>(){ return VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO; }
template <> constexpr VkStructureType GetSType<VkSubresourceLayout2>(){ return VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2; }
template <> constexpr VkStructureType GetSType<VkPipelineCreateFlags2CreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkBufferUsageFlags2CreateInfo>(){ return VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePushDescriptorProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDynamicRenderingLocalReadFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES; }
template <> constexpr VkStructureType GetSType<VkRenderingAttachmentLocationInfo>(){ return VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO; }
template <> constexpr VkStructureType GetSType<VkRenderingInputAttachmentIndexInfo>(){ return VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance6Features>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance6Properties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkBindMemoryStatus>(){ return VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS; }
template <> constexpr VkStructureType GetSType<VkBindDescriptorSetsInfo>(){ return VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO; }
template <> constexpr VkStructureType GetSType<VkPushConstantsInfo>(){ return VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO; }
template <> constexpr VkStructureType GetSType<VkPushDescriptorSetInfo>(){ return VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO; }
template <> constexpr VkStructureType GetSType<VkPushDescriptorSetWithTemplateInfo>(){ return VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_WITH_TEMPLATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePipelineProtectedAccessFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePipelineRobustnessFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePipelineRobustnessProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkPipelineRobustnessCreateInfo>(){ return VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceHostImageCopyFeatures>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceHostImageCopyProperties>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES; }
template <> constexpr VkStructureType GetSType<VkMemoryToImageCopy>(){ return VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY; }
template <> constexpr VkStructureType GetSType<VkImageToMemoryCopy>(){ return VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY; }
template <> constexpr VkStructureType GetSType<VkCopyMemoryToImageInfo>(){ return VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO; }
template <> constexpr VkStructureType GetSType<VkCopyImageToMemoryInfo>(){ return VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO; }
template <> constexpr VkStructureType GetSType<VkCopyImageToImageInfo>(){ return VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO; }
template <> constexpr VkStructureType GetSType<VkHostImageLayoutTransitionInfo>(){ return VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO; }
template <> constexpr VkStructureType GetSType<VkSubresourceHostMemcpySize>(){ return VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE; }
template <> constexpr VkStructureType GetSType<VkHostImageCopyDevicePerformanceQuery>(){ return VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY; }
template <> constexpr VkStructureType GetSType<VkSwapchainCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPresentInfoKHR>(){ return VK_STRUCTURE_TYPE_PRESENT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkImageSwapchainCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkBindImageMemorySwapchainInfoKHR>(){ return VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkAcquireNextImageInfoKHR>(){ return VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkDeviceGroupPresentCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkDeviceGroupPresentInfoKHR>(){ return VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkDeviceGroupSwapchainCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkDisplayModeCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkDisplaySurfaceCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkDisplayPresentInfoKHR>(){ return VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkXlibSurfaceCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkXcbSurfaceCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkWaylandSurfaceCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkAndroidSurfaceCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkWin32SurfaceCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkQueueFamilyQueryResultStatusPropertiesKHR>(){ return VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkQueueFamilyVideoPropertiesKHR>(){ return VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoProfileInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoProfileListInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVideoFormatInfoKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoFormatPropertiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoPictureResourceInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoReferenceSlotInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoSessionMemoryRequirementsKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR; }
template <> constexpr VkStructureType GetSType<VkBindVideoSessionMemoryInfoKHR>(){ return VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoSessionCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoSessionParametersCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoSessionParametersUpdateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoBeginCodingInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEndCodingInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoCodingControlInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeUsageInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264CapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264QualityLevelPropertiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUALITY_LEVEL_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264SessionCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264SessionParametersAddInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264SessionParametersCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264SessionParametersGetInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264SessionParametersFeedbackInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_FEEDBACK_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264NaluSliceInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264PictureInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264DpbSlotInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264ProfileInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264RateControlInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264RateControlLayerInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264GopRemainingFrameInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265CapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265SessionCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265QualityLevelPropertiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUALITY_LEVEL_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265SessionParametersAddInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265SessionParametersCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265SessionParametersGetInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265SessionParametersFeedbackInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_FEEDBACK_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265NaluSliceSegmentInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265PictureInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265DpbSlotInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265ProfileInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265RateControlInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265RateControlLayerInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265GopRemainingFrameInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH264ProfileInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH264CapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH264SessionParametersAddInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH264SessionParametersCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH264PictureInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH264DpbSlotInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkImportMemoryWin32HandleInfoKHR>(){ return VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkExportMemoryWin32HandleInfoKHR>(){ return VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkMemoryWin32HandlePropertiesKHR>(){ return VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkMemoryGetWin32HandleInfoKHR>(){ return VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkImportMemoryFdInfoKHR>(){ return VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkMemoryFdPropertiesKHR>(){ return VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkMemoryGetFdInfoKHR>(){ return VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkWin32KeyedMutexAcquireReleaseInfoKHR>(){ return VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkImportSemaphoreWin32HandleInfoKHR>(){ return VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkExportSemaphoreWin32HandleInfoKHR>(){ return VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkD3D12FenceSubmitInfoKHR>(){ return VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkSemaphoreGetWin32HandleInfoKHR>(){ return VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkImportSemaphoreFdInfoKHR>(){ return VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkSemaphoreGetFdInfoKHR>(){ return VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPresentRegionsKHR>(){ return VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR; }
template <> constexpr VkStructureType GetSType<VkSharedPresentSurfaceCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkImportFenceWin32HandleInfoKHR>(){ return VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkExportFenceWin32HandleInfoKHR>(){ return VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkFenceGetWin32HandleInfoKHR>(){ return VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkImportFenceFdInfoKHR>(){ return VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkFenceGetFdInfoKHR>(){ return VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePerformanceQueryFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePerformanceQueryPropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPerformanceCounterKHR>(){ return VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR; }
template <> constexpr VkStructureType GetSType<VkPerformanceCounterDescriptionKHR>(){ return VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR; }
template <> constexpr VkStructureType GetSType<VkQueryPoolPerformanceCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkAcquireProfilingLockInfoKHR>(){ return VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPerformanceQuerySubmitInfoKHR>(){ return VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSurfaceInfo2KHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR; }
template <> constexpr VkStructureType GetSType<VkSurfaceCapabilities2KHR>(){ return VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR; }
template <> constexpr VkStructureType GetSType<VkSurfaceFormat2KHR>(){ return VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR; }
template <> constexpr VkStructureType GetSType<VkDisplayProperties2KHR>(){ return VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR; }
template <> constexpr VkStructureType GetSType<VkDisplayPlaneProperties2KHR>(){ return VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR; }
template <> constexpr VkStructureType GetSType<VkDisplayModeProperties2KHR>(){ return VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR; }
template <> constexpr VkStructureType GetSType<VkDisplayPlaneInfo2KHR>(){ return VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR; }
template <> constexpr VkStructureType GetSType<VkDisplayPlaneCapabilities2KHR>(){ return VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePortabilitySubsetFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePortabilitySubsetPropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderClockFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH265ProfileInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH265CapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH265SessionParametersAddInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH265SessionParametersCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH265PictureInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH265DpbSlotInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkFragmentShadingRateAttachmentInfoKHR>(){ return VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineFragmentShadingRateStateCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentShadingRateFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentShadingRatePropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentShadingRateKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR; }
template <> constexpr VkStructureType GetSType<VkRenderingFragmentShadingRateAttachmentInfoKHR>(){ return VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderQuadControlFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkSurfaceProtectedCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePresentWaitFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineInfoKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineExecutablePropertiesKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineExecutableInfoKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineExecutableStatisticKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineExecutableInternalRepresentationKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineLibraryCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPresentIdKHR>(){ return VK_STRUCTURE_TYPE_PRESENT_ID_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePresentIdFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkQueryPoolVideoEncodeFeedbackCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeUsageInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeRateControlLayerInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeRateControlInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeQualityLevelPropertiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeQualityLevelInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeSessionParametersGetInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_GET_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeSessionParametersFeedbackInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_FEEDBACK_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePipelineBinaryFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePipelineBinaryPropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkDevicePipelineBinaryInternalCacheControlKHR>(){ return VK_STRUCTURE_TYPE_DEVICE_PIPELINE_BINARY_INTERNAL_CACHE_CONTROL_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineBinaryKeyKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_BINARY_KEY_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineBinaryCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_BINARY_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineBinaryInfoKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_BINARY_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkReleaseCapturedPipelineDataInfoKHR>(){ return VK_STRUCTURE_TYPE_RELEASE_CAPTURED_PIPELINE_DATA_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineBinaryDataInfoKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_BINARY_DATA_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPipelineBinaryHandlesInfoKHR>(){ return VK_STRUCTURE_TYPE_PIPELINE_BINARY_HANDLES_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkCooperativeMatrixPropertiesKHR>(){ return VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCooperativeMatrixFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCooperativeMatrixPropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeAV1ProfileInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeAV1CapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeAV1SessionParametersCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeAV1PictureInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PICTURE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeAV1DpbSlotInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_DPB_SLOT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVideoEncodeAV1FeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_AV1_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1CapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1QualityLevelPropertiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUALITY_LEVEL_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1SessionCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1SessionParametersCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1PictureInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PICTURE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1DpbSlotInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_DPB_SLOT_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1ProfileInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PROFILE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1GopRemainingFrameInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_GOP_REMAINING_FRAME_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1RateControlInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1RateControlLayerInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_LAYER_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVideoMaintenance1FeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoInlineQueryInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_INLINE_QUERY_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkCalibratedTimestampInfoKHR>(){ return VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkSetDescriptorBufferOffsetsInfoEXT>(){ return VK_STRUCTURE_TYPE_SET_DESCRIPTOR_BUFFER_OFFSETS_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkBindDescriptorBufferEmbeddedSamplersInfoEXT>(){ return VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeQuantizationMapCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoFormatQuantizationMapPropertiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_FORMAT_QUANTIZATION_MAP_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeQuantizationMapInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_SESSION_PARAMETERS_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUANTIZATION_MAP_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH264QuantizationMapCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUANTIZATION_MAP_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeH265QuantizationMapCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUANTIZATION_MAP_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoFormatH265QuantizationMapPropertiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_FORMAT_H265_QUANTIZATION_MAP_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoEncodeAV1QuantizationMapCapabilitiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUANTIZATION_MAP_CAPABILITIES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoFormatAV1QuantizationMapPropertiesKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_FORMAT_AV1_QUANTIZATION_MAP_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance7FeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance7PropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLayeredApiPropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLayeredApiPropertiesListKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_LIST_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLayeredApiVulkanPropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_VULKAN_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMaintenance8FeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_8_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkMemoryBarrierAccessFlags3KHR>(){ return VK_STRUCTURE_TYPE_MEMORY_BARRIER_ACCESS_FLAGS_3_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVideoMaintenance2FeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_2_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH264InlineSessionParametersInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_INLINE_SESSION_PARAMETERS_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeH265InlineSessionParametersInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_INLINE_SESSION_PARAMETERS_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkVideoDecodeAV1InlineSessionParametersInfoKHR>(){ return VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_INLINE_SESSION_PARAMETERS_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDepthClampZeroOneFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkDebugReportCallbackCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineRasterizationStateRasterizationOrderAMD>(){ return VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD; }
template <> constexpr VkStructureType GetSType<VkDebugMarkerObjectNameInfoEXT>(){ return VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkDebugMarkerObjectTagInfoEXT>(){ return VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkDebugMarkerMarkerInfoEXT>(){ return VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkDedicatedAllocationImageCreateInfoNV>(){ return VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkDedicatedAllocationBufferCreateInfoNV>(){ return VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkDedicatedAllocationMemoryAllocateInfoNV>(){ return VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceTransformFeedbackFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceTransformFeedbackPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineRasterizationStateStreamCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkImageViewHandleInfoNVX>(){ return VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX; }
template <> constexpr VkStructureType GetSType<VkImageViewAddressPropertiesNVX>(){ return VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX; }
template <> constexpr VkStructureType GetSType<VkTextureLODGatherFormatPropertiesAMD>(){ return VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD; }
template <> constexpr VkStructureType GetSType<VkStreamDescriptorSurfaceCreateInfoGGP>(){ return VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCornerSampledImageFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkExternalMemoryImageCreateInfoNV>(){ return VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkExportMemoryAllocateInfoNV>(){ return VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkImportMemoryWin32HandleInfoNV>(){ return VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkExportMemoryWin32HandleInfoNV>(){ return VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkWin32KeyedMutexAcquireReleaseInfoNV>(){ return VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkValidationFlagsEXT>(){ return VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT; }
template <> constexpr VkStructureType GetSType<VkViSurfaceCreateInfoNN>(){ return VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN; }
template <> constexpr VkStructureType GetSType<VkImageViewASTCDecodeModeEXT>(){ return VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceASTCDecodeFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkConditionalRenderingBeginInfoEXT>(){ return VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceConditionalRenderingFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkCommandBufferInheritanceConditionalRenderingInfoEXT>(){ return VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineViewportWScalingStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkSurfaceCapabilities2EXT>(){ return VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT; }
template <> constexpr VkStructureType GetSType<VkDisplayPowerInfoEXT>(){ return VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkDeviceEventInfoEXT>(){ return VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkDisplayEventInfoEXT>(){ return VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkSwapchainCounterCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPresentTimesInfoGOOGLE>(){ return VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX; }
template <> constexpr VkStructureType GetSType<VkMultiviewPerViewAttributesInfoNVX>(){ return VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX; }
template <> constexpr VkStructureType GetSType<VkPipelineViewportSwizzleStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDiscardRectanglePropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineDiscardRectangleStateCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceConservativeRasterizationPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineRasterizationConservativeStateCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDepthClipEnableFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineRasterizationDepthClipStateCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkHdrMetadataEXT>(){ return VK_STRUCTURE_TYPE_HDR_METADATA_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG; }
template <> constexpr VkStructureType GetSType<VkIOSSurfaceCreateInfoMVK>(){ return VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK; }
template <> constexpr VkStructureType GetSType<VkMacOSSurfaceCreateInfoMVK>(){ return VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK; }
template <> constexpr VkStructureType GetSType<VkDebugUtilsLabelEXT>(){ return VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT; }
template <> constexpr VkStructureType GetSType<VkDebugUtilsObjectNameInfoEXT>(){ return VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkDebugUtilsMessengerCallbackDataEXT>(){ return VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT; }
template <> constexpr VkStructureType GetSType<VkDebugUtilsMessengerCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkDebugUtilsObjectTagInfoEXT>(){ return VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkAndroidHardwareBufferUsageANDROID>(){ return VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID; }
template <> constexpr VkStructureType GetSType<VkAndroidHardwareBufferPropertiesANDROID>(){ return VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID; }
template <> constexpr VkStructureType GetSType<VkAndroidHardwareBufferFormatPropertiesANDROID>(){ return VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID; }
template <> constexpr VkStructureType GetSType<VkImportAndroidHardwareBufferInfoANDROID>(){ return VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID; }
template <> constexpr VkStructureType GetSType<VkMemoryGetAndroidHardwareBufferInfoANDROID>(){ return VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID; }
template <> constexpr VkStructureType GetSType<VkExternalFormatANDROID>(){ return VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID; }
template <> constexpr VkStructureType GetSType<VkAndroidHardwareBufferFormatProperties2ANDROID>(){ return VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID; }
template <> constexpr VkStructureType GetSType<VkAttachmentSampleCountInfoAMD>(){ return VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD; }
template <> constexpr VkStructureType GetSType<VkSampleLocationsInfoEXT>(){ return VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkRenderPassSampleLocationsBeginInfoEXT>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineSampleLocationsStateCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSampleLocationsPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkMultisamplePropertiesEXT>(){ return VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineColorBlendAdvancedStateCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineCoverageToColorStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPipelineCoverageModulationStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderSMBuiltinsPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderSMBuiltinsFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkDrmFormatModifierPropertiesListEXT>(){ return VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageDrmFormatModifierInfoEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkImageDrmFormatModifierListCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkImageDrmFormatModifierExplicitCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkImageDrmFormatModifierPropertiesEXT>(){ return VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkDrmFormatModifierPropertiesList2EXT>(){ return VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT; }
template <> constexpr VkStructureType GetSType<VkValidationCacheCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkShaderModuleValidationCacheCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineViewportShadingRateImageStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShadingRateImageFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShadingRateImagePropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPipelineViewportCoarseSampleOrderStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkRayTracingShaderGroupCreateInfoNV>(){ return VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkRayTracingPipelineCreateInfoNV>(){ return VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkGeometryTrianglesNV>(){ return VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV; }
template <> constexpr VkStructureType GetSType<VkGeometryAABBNV>(){ return VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV; }
template <> constexpr VkStructureType GetSType<VkGeometryNV>(){ return VK_STRUCTURE_TYPE_GEOMETRY_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureInfoNV>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureCreateInfoNV>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkBindAccelerationStructureMemoryInfoNV>(){ return VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkWriteDescriptorSetAccelerationStructureNV>(){ return VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureMemoryRequirementsInfoNV>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPipelineRepresentativeFragmentTestStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageViewImageFormatInfoEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkFilterCubicImageViewImageFormatPropertiesEXT>(){ return VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkImportMemoryHostPointerInfoEXT>(){ return VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkMemoryHostPointerPropertiesEXT>(){ return VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExternalMemoryHostPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineCompilerControlCreateInfoAMD>(){ return VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderCorePropertiesAMD>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD; }
template <> constexpr VkStructureType GetSType<VkDeviceMemoryOverallocationCreateInfoAMD>(){ return VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPresentFrameTokenGGP>(){ return VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMeshShaderFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMeshShaderPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderImageFootprintFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPipelineViewportExclusiveScissorStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExclusiveScissorFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkQueueFamilyCheckpointPropertiesNV>(){ return VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkCheckpointDataNV>(){ return VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV; }
template <> constexpr VkStructureType GetSType<VkQueueFamilyCheckpointProperties2NV>(){ return VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV; }
template <> constexpr VkStructureType GetSType<VkCheckpointData2NV>(){ return VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL; }
template <> constexpr VkStructureType GetSType<VkInitializePerformanceApiInfoINTEL>(){ return VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL; }
template <> constexpr VkStructureType GetSType<VkQueryPoolPerformanceQueryCreateInfoINTEL>(){ return VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL; }
template <> constexpr VkStructureType GetSType<VkPerformanceMarkerInfoINTEL>(){ return VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL; }
template <> constexpr VkStructureType GetSType<VkPerformanceStreamMarkerInfoINTEL>(){ return VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL; }
template <> constexpr VkStructureType GetSType<VkPerformanceOverrideInfoINTEL>(){ return VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL; }
template <> constexpr VkStructureType GetSType<VkPerformanceConfigurationAcquireInfoINTEL>(){ return VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePCIBusInfoPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkDisplayNativeHdrSurfaceCapabilitiesAMD>(){ return VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD; }
template <> constexpr VkStructureType GetSType<VkSwapchainDisplayNativeHdrCreateInfoAMD>(){ return VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD; }
template <> constexpr VkStructureType GetSType<VkImagePipeSurfaceCreateInfoFUCHSIA>(){ return VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA; }
template <> constexpr VkStructureType GetSType<VkMetalSurfaceCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentDensityMapFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentDensityMapPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkRenderPassFragmentDensityMapCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkRenderingFragmentDensityMapAttachmentInfoEXT>(){ return VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderCoreProperties2AMD>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCoherentMemoryFeaturesAMD>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMemoryBudgetPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMemoryPriorityFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkMemoryPriorityAllocateInfoEXT>(){ return VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceBufferDeviceAddressFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkBufferDeviceAddressCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkValidationFeaturesEXT>(){ return VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkCooperativeMatrixPropertiesNV>(){ return VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCooperativeMatrixFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCooperativeMatrixPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCoverageReductionModeFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPipelineCoverageReductionStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkFramebufferMixedSamplesCombinationNV>(){ return VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceYcbcrImageArraysFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceProvokingVertexFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceProvokingVertexPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineRasterizationProvokingVertexStateCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkSurfaceFullScreenExclusiveInfoEXT>(){ return VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkSurfaceCapabilitiesFullScreenExclusiveEXT>(){ return VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT; }
template <> constexpr VkStructureType GetSType<VkSurfaceFullScreenExclusiveWin32InfoEXT>(){ return VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkHeadlessSurfaceCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderAtomicFloatFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExtendedDynamicStateFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMapMemoryPlacedFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMapMemoryPlacedPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkMemoryMapPlacedInfoEXT>(){ return VK_STRUCTURE_TYPE_MEMORY_MAP_PLACED_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkSurfacePresentModeEXT>(){ return VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_EXT; }
template <> constexpr VkStructureType GetSType<VkSurfacePresentScalingCapabilitiesEXT>(){ return VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_EXT; }
template <> constexpr VkStructureType GetSType<VkSurfacePresentModeCompatibilityEXT>(){ return VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_COMPATIBILITY_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkSwapchainPresentFenceInfoEXT>(){ return VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkSwapchainPresentModesCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkSwapchainPresentModeInfoEXT>(){ return VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkSwapchainPresentScalingCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkReleaseSwapchainImagesInfoEXT>(){ return VK_STRUCTURE_TYPE_RELEASE_SWAPCHAIN_IMAGES_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkGraphicsShaderGroupCreateInfoNV>(){ return VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkGraphicsPipelineShaderGroupsCreateInfoNV>(){ return VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkIndirectCommandsLayoutTokenNV>(){ return VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV; }
template <> constexpr VkStructureType GetSType<VkIndirectCommandsLayoutCreateInfoNV>(){ return VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkGeneratedCommandsInfoNV>(){ return VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkGeneratedCommandsMemoryRequirementsInfoNV>(){ return VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceInheritedViewportScissorFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkCommandBufferInheritanceViewportScissorInfoNV>(){ return VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkRenderPassTransformBeginInfoQCOM>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkCommandBufferInheritanceRenderPassTransformInfoQCOM>(){ return VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDepthBiasControlFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkDepthBiasInfoEXT>(){ return VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkDepthBiasRepresentationInfoEXT>(){ return VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDeviceMemoryReportFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkDeviceMemoryReportCallbackDataEXT>(){ return VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT; }
template <> constexpr VkStructureType GetSType<VkDeviceDeviceMemoryReportCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRobustness2FeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRobustness2PropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkSamplerCustomBorderColorCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCustomBorderColorPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCustomBorderColorFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePresentBarrierFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkSurfaceCapabilitiesPresentBarrierNV>(){ return VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV; }
template <> constexpr VkStructureType GetSType<VkSwapchainPresentBarrierCreateInfoNV>(){ return VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDiagnosticsConfigFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkDeviceDiagnosticsConfigCreateInfoNV>(){ return VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkQueryLowLatencySupportNV>(){ return VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkGraphicsPipelineLibraryCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPipelineFragmentShadingRateEnumStateCreateInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureGeometryMotionTrianglesDataNV>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureMotionInfoNV>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingMotionBlurFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentDensityMap2FeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentDensityMap2PropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkCopyCommandTransformInfoQCOM>(){ return VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageCompressionControlFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkImageCompressionControlEXT>(){ return VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT; }
template <> constexpr VkStructureType GetSType<VkImageCompressionPropertiesEXT>(){ return VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevice4444FormatsFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFaultFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkDeviceFaultCountsEXT>(){ return VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT; }
template <> constexpr VkStructureType GetSType<VkDeviceFaultInfoEXT>(){ return VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkDirectFBSurfaceCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkMutableDescriptorTypeCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkVertexInputBindingDescription2EXT>(){ return VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT; }
template <> constexpr VkStructureType GetSType<VkVertexInputAttributeDescription2EXT>(){ return VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDrmPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceAddressBindingReportFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkDeviceAddressBindingCallbackDataEXT>(){ return VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDepthClipControlFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineViewportDepthClipControlCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePresentModeFifoLatestReadyFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_MODE_FIFO_LATEST_READY_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkImportMemoryZirconHandleInfoFUCHSIA>(){ return VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA; }
template <> constexpr VkStructureType GetSType<VkMemoryZirconHandlePropertiesFUCHSIA>(){ return VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA; }
template <> constexpr VkStructureType GetSType<VkMemoryGetZirconHandleInfoFUCHSIA>(){ return VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA; }
template <> constexpr VkStructureType GetSType<VkImportSemaphoreZirconHandleInfoFUCHSIA>(){ return VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA; }
template <> constexpr VkStructureType GetSType<VkSemaphoreGetZirconHandleInfoFUCHSIA>(){ return VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceInvocationMaskFeaturesHUAWEI>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI; }
template <> constexpr VkStructureType GetSType<VkMemoryGetRemoteAddressInfoNV>(){ return VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExternalMemoryRDMAFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFrameBoundaryFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkFrameBoundaryEXT>(){ return VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkSubpassResolvePerformanceQueryEXT>(){ return VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT; }
template <> constexpr VkStructureType GetSType<VkMultisampledRenderToSingleSampledInfoEXT>(){ return VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExtendedDynamicState2FeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkScreenSurfaceCreateInfoQNX>(){ return VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceColorWriteEnableFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineColorWriteCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageViewMinLodFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkImageViewMinLodCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMultiDrawFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMultiDrawPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImage2DViewOf3DFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderTileImageFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderTileImagePropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkMicromapBuildInfoEXT>(){ return VK_STRUCTURE_TYPE_MICROMAP_BUILD_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkMicromapCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_MICROMAP_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceOpacityMicromapFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceOpacityMicromapPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkMicromapVersionInfoEXT>(){ return VK_STRUCTURE_TYPE_MICROMAP_VERSION_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkCopyMicromapToMemoryInfoEXT>(){ return VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkCopyMemoryToMicromapInfoEXT>(){ return VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkCopyMicromapInfoEXT>(){ return VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkMicromapBuildSizesInfoEXT>(){ return VK_STRUCTURE_TYPE_MICROMAP_BUILD_SIZES_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureTrianglesOpacityMicromapEXT>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDisplacementMicromapFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDisplacementMicromapPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureTrianglesDisplacementMicromapNV>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_DISPLACEMENT_MICROMAP_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_VRS_FEATURES_HUAWEI; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceBorderColorSwizzleFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkSamplerBorderColorComponentMappingCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderCorePropertiesARM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_ARM; }
template <> constexpr VkStructureType GetSType<VkDeviceQueueShaderCoreControlCreateInfoARM>(){ return VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSchedulingControlsFeaturesARM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSchedulingControlsPropertiesARM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_PROPERTIES_ARM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkImageViewSlicedCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE; }
template <> constexpr VkStructureType GetSType<VkDescriptorSetBindingReferenceVALVE>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE; }
template <> constexpr VkStructureType GetSType<VkDescriptorSetLayoutHostMappingInfoVALVE>(){ return VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRenderPassStripedFeaturesARM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRenderPassStripedPropertiesARM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_PROPERTIES_ARM; }
template <> constexpr VkStructureType GetSType<VkRenderPassStripeInfoARM>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_INFO_ARM; }
template <> constexpr VkStructureType GetSType<VkRenderPassStripeBeginInfoARM>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM; }
template <> constexpr VkStructureType GetSType<VkRenderPassStripeSubmitInfoARM>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_SUBMIT_INFO_ARM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM; }
template <> constexpr VkStructureType GetSType<VkSubpassFragmentDensityMapOffsetEndInfoQCOM>(){ return VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkComputePipelineIndirectBufferInfoNV>(){ return VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPipelineIndirectDeviceAddressInfoNV>(){ return VK_STRUCTURE_TYPE_PIPELINE_INDIRECT_DEVICE_ADDRESS_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingLinearSweptSpheresFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_LINEAR_SWEPT_SPHERES_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureGeometryLinearSweptSpheresDataNV>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_LINEAR_SWEPT_SPHERES_DATA_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureGeometrySpheresDataNV>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_SPHERES_DATA_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLinearColorAttachmentFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkImageViewSampleWeightCreateInfoQCOM>(){ return VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageProcessingFeaturesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageProcessingPropertiesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceNestedCommandBufferFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceNestedCommandBufferPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkExternalMemoryAcquireUnmodifiedEXT>(){ return VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExtendedDynamicState3FeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExtendedDynamicState3PropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkRenderPassCreationControlEXT>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT; }
template <> constexpr VkStructureType GetSType<VkRenderPassCreationFeedbackCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkRenderPassSubpassFeedbackCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkDirectDriverLoadingInfoLUNARG>(){ return VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG; }
template <> constexpr VkStructureType GetSType<VkDirectDriverLoadingListLUNARG>(){ return VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineShaderStageModuleIdentifierCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkShaderModuleIdentifierEXT>(){ return VK_STRUCTURE_TYPE_SHADER_MODULE_IDENTIFIER_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceOpticalFlowFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceOpticalFlowPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkOpticalFlowImageFormatInfoNV>(){ return VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkOpticalFlowImageFormatPropertiesNV>(){ return VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkOpticalFlowSessionCreateInfoNV>(){ return VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkOpticalFlowSessionCreatePrivateDataInfoNV>(){ return VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkOpticalFlowExecuteInfoNV>(){ return VK_STRUCTURE_TYPE_OPTICAL_FLOW_EXECUTE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLegacyDitheringFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExternalFormatResolveFeaturesANDROID>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_FEATURES_ANDROID; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExternalFormatResolvePropertiesANDROID>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID; }
template <> constexpr VkStructureType GetSType<VkAndroidHardwareBufferFormatResolvePropertiesANDROID>(){ return VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_RESOLVE_PROPERTIES_ANDROID; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceAntiLagFeaturesAMD>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ANTI_LAG_FEATURES_AMD; }
template <> constexpr VkStructureType GetSType<VkAntiLagPresentationInfoAMD>(){ return VK_STRUCTURE_TYPE_ANTI_LAG_PRESENTATION_INFO_AMD; }
template <> constexpr VkStructureType GetSType<VkAntiLagDataAMD>(){ return VK_STRUCTURE_TYPE_ANTI_LAG_DATA_AMD; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderObjectFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderObjectPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkShaderCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_SHADER_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceTilePropertiesFeaturesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM; }
template <> constexpr VkStructureType GetSType<VkTilePropertiesQCOM>(){ return VK_STRUCTURE_TYPE_TILE_PROPERTIES_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceAmigoProfilingFeaturesSEC>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC; }
template <> constexpr VkStructureType GetSType<VkAmigoProfilingSubmitInfoSEC>(){ return VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCooperativeVectorPropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCooperativeVectorFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkCooperativeVectorPropertiesNV>(){ return VK_STRUCTURE_TYPE_COOPERATIVE_VECTOR_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkConvertCooperativeVectorMatrixInfoNV>(){ return VK_STRUCTURE_TYPE_CONVERT_COOPERATIVE_VECTOR_MATRIX_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkLayerSettingsCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkLatencySleepModeInfoNV>(){ return VK_STRUCTURE_TYPE_LATENCY_SLEEP_MODE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkLatencySleepInfoNV>(){ return VK_STRUCTURE_TYPE_LATENCY_SLEEP_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkSetLatencyMarkerInfoNV>(){ return VK_STRUCTURE_TYPE_SET_LATENCY_MARKER_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkLatencyTimingsFrameReportNV>(){ return VK_STRUCTURE_TYPE_LATENCY_TIMINGS_FRAME_REPORT_NV; }
template <> constexpr VkStructureType GetSType<VkGetLatencyMarkerInfoNV>(){ return VK_STRUCTURE_TYPE_GET_LATENCY_MARKER_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkLatencySubmissionPresentIdNV>(){ return VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV; }
template <> constexpr VkStructureType GetSType<VkSwapchainLatencyCreateInfoNV>(){ return VK_STRUCTURE_TYPE_SWAPCHAIN_LATENCY_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkOutOfBandQueueTypeInfoNV>(){ return VK_STRUCTURE_TYPE_OUT_OF_BAND_QUEUE_TYPE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkLatencySurfaceCapabilitiesNV>(){ return VK_STRUCTURE_TYPE_LATENCY_SURFACE_CAPABILITIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM; }
template <> constexpr VkStructureType GetSType<VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM>(){ return VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePerStageDescriptorSetFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageProcessing2FeaturesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageProcessing2PropertiesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_PROPERTIES_QCOM; }
template <> constexpr VkStructureType GetSType<VkSamplerBlockMatchWindowCreateInfoQCOM>(){ return VK_STRUCTURE_TYPE_SAMPLER_BLOCK_MATCH_WINDOW_CREATE_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCubicWeightsFeaturesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM; }
template <> constexpr VkStructureType GetSType<VkSamplerCubicWeightsCreateInfoQCOM>(){ return VK_STRUCTURE_TYPE_SAMPLER_CUBIC_WEIGHTS_CREATE_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkBlitImageCubicWeightsInfoQCOM>(){ return VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceYcbcrDegammaFeaturesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM; }
template <> constexpr VkStructureType GetSType<VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM>(){ return VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_YCBCR_DEGAMMA_CREATE_INFO_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCubicClampFeaturesQCOM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceLayeredDriverPropertiesMSFT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_DRIVER_PROPERTIES_MSFT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkDisplaySurfaceStereoCreateInfoNV>(){ return VK_STRUCTURE_TYPE_DISPLAY_SURFACE_STEREO_CREATE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkDisplayModeStereoPropertiesNV>(){ return VK_STRUCTURE_TYPE_DISPLAY_MODE_STEREO_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRawAccessChainsFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAW_ACCESS_CHAINS_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCommandBufferInheritanceFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMMAND_BUFFER_INHERITANCE_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderAtomicFloat16VectorFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT16_VECTOR_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingValidationFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_VALIDATION_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePartitionedAccelerationStructureFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePartitionedAccelerationStructurePropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPartitionedAccelerationStructureFlagsNV>(){ return VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_FLAGS_NV; }
template <> constexpr VkStructureType GetSType<VkWriteDescriptorSetPartitionedAccelerationStructureNV>(){ return VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_PARTITIONED_ACCELERATION_STRUCTURE_NV; }
template <> constexpr VkStructureType GetSType<VkPartitionedAccelerationStructureInstancesInputNV>(){ return VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCES_INPUT_NV; }
template <> constexpr VkStructureType GetSType<VkBuildPartitionedAccelerationStructureInfoNV>(){ return VK_STRUCTURE_TYPE_BUILD_PARTITIONED_ACCELERATION_STRUCTURE_INFO_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureBuildSizesInfoKHR>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDeviceGeneratedCommandsPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkGeneratedCommandsMemoryRequirementsInfoEXT>(){ return VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkIndirectExecutionSetPipelineInfoEXT>(){ return VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_PIPELINE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkIndirectExecutionSetShaderLayoutInfoEXT>(){ return VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_LAYOUT_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkIndirectExecutionSetShaderInfoEXT>(){ return VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkIndirectExecutionSetCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkGeneratedCommandsInfoEXT>(){ return VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkWriteIndirectExecutionSetPipelineEXT>(){ return VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_PIPELINE_EXT; }
template <> constexpr VkStructureType GetSType<VkIndirectCommandsLayoutTokenEXT>(){ return VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_EXT; }
template <> constexpr VkStructureType GetSType<VkIndirectCommandsLayoutCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkGeneratedCommandsPipelineInfoEXT>(){ return VK_STRUCTURE_TYPE_GENERATED_COMMANDS_PIPELINE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkGeneratedCommandsShaderInfoEXT>(){ return VK_STRUCTURE_TYPE_GENERATED_COMMANDS_SHADER_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkWriteIndirectExecutionSetShaderEXT>(){ return VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_SHADER_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageAlignmentControlFeaturesMESA>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_FEATURES_MESA; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceImageAlignmentControlPropertiesMESA>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_PROPERTIES_MESA; }
template <> constexpr VkStructureType GetSType<VkImageAlignmentControlCreateInfoMESA>(){ return VK_STRUCTURE_TYPE_IMAGE_ALIGNMENT_CONTROL_CREATE_INFO_MESA; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceDepthClampControlFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPipelineViewportDepthClampControlCreateInfoEXT>(){ return VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLAMP_CONTROL_CREATE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceHdrVividFeaturesHUAWEI>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HDR_VIVID_FEATURES_HUAWEI; }
template <> constexpr VkStructureType GetSType<VkHdrVividDynamicMetadataHUAWEI>(){ return VK_STRUCTURE_TYPE_HDR_VIVID_DYNAMIC_METADATA_HUAWEI; }
template <> constexpr VkStructureType GetSType<VkCooperativeMatrixFlexibleDimensionsPropertiesNV>(){ return VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_FLEXIBLE_DIMENSIONS_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCooperativeMatrix2FeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceCooperativeMatrix2PropertiesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_PROPERTIES_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePipelineOpacityMicromapFeaturesARM>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_OPACITY_MICROMAP_FEATURES_ARM; }
template <> constexpr VkStructureType GetSType<VkImportMemoryMetalHandleInfoEXT>(){ return VK_STRUCTURE_TYPE_IMPORT_MEMORY_METAL_HANDLE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkMemoryMetalHandlePropertiesEXT>(){ return VK_STRUCTURE_TYPE_MEMORY_METAL_HANDLE_PROPERTIES_EXT; }
template <> constexpr VkStructureType GetSType<VkMemoryGetMetalHandleInfoEXT>(){ return VK_STRUCTURE_TYPE_MEMORY_GET_METAL_HANDLE_INFO_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceVertexAttributeRobustnessFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_ROBUSTNESS_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkSetPresentConfigNV>(){ return VK_STRUCTURE_TYPE_SET_PRESENT_CONFIG_NV; }
template <> constexpr VkStructureType GetSType<VkPhysicalDevicePresentMeteringFeaturesNV>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_METERING_FEATURES_NV; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureGeometryTrianglesDataKHR>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureGeometryAabbsDataKHR>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureGeometryInstancesDataKHR>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureGeometryKHR>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureBuildGeometryInfoKHR>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkWriteDescriptorSetAccelerationStructureKHR>(){ return VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceAccelerationStructureFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceAccelerationStructurePropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureDeviceAddressInfoKHR>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkAccelerationStructureVersionInfoKHR>(){ return VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkCopyAccelerationStructureToMemoryInfoKHR>(){ return VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkCopyMemoryToAccelerationStructureInfoKHR>(){ return VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkCopyAccelerationStructureInfoKHR>(){ return VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkRayTracingShaderGroupCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkRayTracingPipelineInterfaceCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkRayTracingPipelineCreateInfoKHR>(){ return VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingPipelineFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayTracingPipelinePropertiesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceRayQueryFeaturesKHR>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMeshShaderFeaturesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT; }
template <> constexpr VkStructureType GetSType<VkPhysicalDeviceMeshShaderPropertiesEXT>(){ return VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT; }

GFXRECON_END_NAMESPACE(util)
GFXRECON_END_NAMESPACE(gfxrecon)

#endif // GFXRECON_GENERATED_VULKAN_STYPE_UTIL_H
