<!--- This file is autogenerated. Do not edit manually! -->
# <code>[pixi](../pixi.md) import</code>

## About
Imports a file into an environment in an existing workspace.

--8<-- "docs/reference/cli/pixi/import_extender:description"

## Usage
```
pixi import [OPTIONS] <FILE>
```

## Arguments
- <a id="arg-<FILE>" href="#arg-<FILE>">`<FILE>`</a>
:  File to import into the workspace
<br>**required**: `true`

## Options
- <a id="arg---format" href="#arg---format">`--format <FORMAT>`</a>
:  Which format to interpret the file as
<br>**options**: `conda-env`
- <a id="arg---platform" href="#arg---platform">`--platform (-p) <PLATFORM>`</a>
:  The platforms for the imported environment
<br>May be provided more than once.
- <a id="arg---environment" href="#arg---environment">`--environment (-e) <ENVIRONMENT>`</a>
:  A name for the created environment
- <a id="arg---feature" href="#arg---feature">`--feature (-f) <FEATURE>`</a>
:  A name for the created feature

## Config Options
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`

## Update Options
- <a id="arg---no-install" href="#arg---no-install">`--no-install`</a>
:  Don't modify the environment, only modify the lock-file
- <a id="arg---revalidate" href="#arg---revalidate">`--revalidate`</a>
:  Run the complete environment validation. This will reinstall a broken environment
- <a id="arg---no-lockfile-update" href="#arg---no-lockfile-update">`--no-lockfile-update`</a>
:  Don't update lockfile, implies the no-install as well
- <a id="arg---frozen" href="#arg---frozen">`--frozen`</a>
:  Install the environment as defined in the lockfile, doesn't update lockfile if it isn't up-to-date with the manifest file
<br>**env**: `PIXI_FROZEN`
- <a id="arg---locked" href="#arg---locked">`--locked`</a>
:  Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn't up-to-date with the manifest file
<br>**env**: `PIXI_LOCKED`

## Global Options
- <a id="arg---manifest-path" href="#arg---manifest-path">`--manifest-path <MANIFEST_PATH>`</a>
:  The path to `pixi.toml`, `pyproject.toml`, or the workspace directory

## Description
Imports a file into an environment in an existing workspace.

If `--format` isn't provided, `import` will try to guess the format based on the file extension.


--8<-- "docs/reference/cli/pixi/import_extender:example"
