/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryConnectionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQuerySourcesInfoCollection;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.utils.ListNode;
import org.jkiss.utils.Pair;

public class SQLQueryRowsSourceContext {
    private static final Log log = Log.getLog(SQLQueryRowsSourceContext.class);
    @NotNull
    private final SQLQueryConnectionContext connectionInfo;
    private final boolean hasUnresolvedSource;
    @NotNull
    private final Map<SQLQueryComplexName, SourceResolutionResult> rowsSources;
    @NotNull
    private final Map<String, SourceResolutionResult> dynamicTableSources;
    @NotNull
    private final Map<String, SourceResolutionResult> sourcesByLoweredAlias;
    @Nullable
    private ListNode<SQLQueryRowsSourceContext> targetRowContexts = null;
    @Nullable
    private ListNode<SQLQueryRowsDataContext> targetDataContexts = null;

    public SQLQueryRowsSourceContext(@NotNull SQLQueryConnectionContext connectionInfo) {
        this(connectionInfo, false);
    }

    private SQLQueryRowsSourceContext(@NotNull SQLQueryConnectionContext connectionInfo, boolean hasUnresolvedSource) {
        this.connectionInfo = connectionInfo;
        this.hasUnresolvedSource = hasUnresolvedSource;
        this.rowsSources = Collections.emptyMap();
        this.dynamicTableSources = Collections.emptyMap();
        this.sourcesByLoweredAlias = Collections.emptyMap();
    }

    private SQLQueryRowsSourceContext(@NotNull SQLQueryRowsSourceContext parent, boolean hasUnresolvedSource, @NotNull Map<SQLQueryComplexName, SourceResolutionResult> rowsSources, @NotNull Map<String, SourceResolutionResult> dynamicTableSources, @NotNull Map<String, SourceResolutionResult> sourcesByLoweredAlias) {
        parent.registerConsumingContext(this);
        this.connectionInfo = parent.connectionInfo;
        this.hasUnresolvedSource = hasUnresolvedSource;
        this.rowsSources = rowsSources;
        this.dynamicTableSources = dynamicTableSources;
        this.sourcesByLoweredAlias = sourcesByLoweredAlias;
    }

    private void registerConsumingContext(@NotNull SQLQueryRowsSourceContext context) {
        this.targetRowContexts = ListNode.push(this.targetRowContexts, (Object)context);
    }

    void registerConsumingContext(@NotNull SQLQueryRowsDataContext context) {
        this.targetDataContexts = ListNode.push(this.targetDataContexts, (Object)context);
    }

    @NotNull
    public SQLDialect getDialect() {
        return this.connectionInfo.dialect;
    }

    @NotNull
    public SQLQueryConnectionContext getConnectionInfo() {
        return this.connectionInfo;
    }

    @NotNull
    public final SQLQueryRowsSourceContext reset() {
        return new SQLQueryRowsSourceContext(this.connectionInfo, false);
    }

    @NotNull
    public final SQLQueryRowsSourceContext resetAsUnresolved() {
        return new SQLQueryRowsSourceContext(this.connectionInfo, true);
    }

    public boolean hasUnresolvedSource() {
        return this.hasUnresolvedSource;
    }

    @Nullable
    public SourceResolutionResult findDynamicRowsSource(@NotNull SQLQuerySymbolEntry name) {
        return this.dynamicTableSources.get(name.getName().toLowerCase());
    }

    @Nullable
    public SourceResolutionInfo findReferencedSource(@NotNull SQLQueryComplexName name) {
        SQLQuerySymbolEntry entry;
        SourceResolutionResult result;
        if (!name.parts.isEmpty() && (result = this.findSourceByAlias((entry = name.parts.getFirst()).getName())) != null) {
            SQLQueryMemberAccessEntry endingPeriod = name.parts.size() > 1 && name.parts.get(1) != null ? name.parts.get(1).getMemberAccess() : (name.parts.size() == 2 && name.parts.get(1) == null ? name.endingPeriodNode : null);
            SQLQueryComplexName key = new SQLQueryComplexName(entry.getSyntaxNode(), List.of(entry), 0, endingPeriod);
            return new SourceResolutionInfo(result, key);
        }
        SQLQueryComplexName namePart = name;
        while (namePart != null) {
            result = this.rowsSources.get(namePart);
            if (result != null) {
                return new SourceResolutionInfo(result, namePart);
            }
            namePart = namePart.trimEnd();
        }
        return null;
    }

    @Nullable
    public SourceResolutionResult findReferencedSourceExact(@NotNull SQLQueryComplexName name) {
        SourceResolutionResult result;
        if (name.stringParts.size() == 1 && name.invalidPartsCount == 0 && (result = this.findSourceByAlias(name.stringParts.getFirst())) != null) {
            return result;
        }
        return this.rowsSources.get(name);
    }

    @Nullable
    private SourceResolutionResult findSourceByAlias(@NotNull String aliasName) {
        return this.sourcesByLoweredAlias.get(aliasName.toLowerCase());
    }

    @NotNull
    public SQLQueryRowsSourceContext combine(@NotNull SQLQueryRowsSourceContext other) {
        return this.setRowsSources((Map<SQLQueryComplexName, SourceResolutionResult>)new HashMap<SQLQueryComplexName, SourceResolutionResult>(other){
            {
                this.putAll(sQLQueryRowsSourceContext2.rowsSources);
                this.putAll(SQLQueryRowsSourceContext.this.rowsSources);
            }
        }, (Map<String, SourceResolutionResult>)new HashMap<String, SourceResolutionResult>(other){
            {
                this.putAll(sQLQueryRowsSourceContext2.sourcesByLoweredAlias);
                this.putAll(SQLQueryRowsSourceContext.this.sourcesByLoweredAlias);
            }
        }, this.hasUnresolvedSource || other.hasUnresolvedSource);
    }

    @NotNull
    public final SQLQueryRowsSourceContext appendSource(@NotNull SQLQueryRowsSourceModel source, @NotNull SQLQueryComplexName classifiedName, @Nullable DBSEntity tableOrNull) {
        SQLQuerySymbolDefinition sQLQuerySymbolDefinition;
        SourceResolutionResult srr = new SourceResolutionResult(source, classifiedName, tableOrNull, null);
        HashMap<SQLQueryComplexName, SourceResolutionResult> rowsSources = new HashMap<SQLQueryComplexName, SourceResolutionResult>(this.rowsSources);
        rowsSources.put(classifiedName, srr);
        if (tableOrNull != null && (sQLQuerySymbolDefinition = classifiedName.parts.getFirst().getDefinition()) instanceof SQLQuerySymbolByDbObjectDefinition) {
            SQLQuerySymbolByDbObjectDefinition subparent = (SQLQuerySymbolByDbObjectDefinition)sQLQuerySymbolDefinition;
            SQLQueryComplexName nameFragment = classifiedName.trimStart();
            while (nameFragment != null) {
                rowsSources.put(nameFragment, srr);
                nameFragment = nameFragment.trimStart();
            }
            SQLQueryComplexName synthesizedName = classifiedName;
            DBSObject o = subparent.getDbObject().getParentObject();
            while (o != null && !(o instanceof DBPDataSource)) {
                String canonicalName = SQLUtils.identifierToCanonicalForm((SQLDialect)this.connectionInfo.dialect, (String)o.getName(), (boolean)false, (boolean)true);
                SQLQuerySymbolEntry entry = new SQLQuerySymbolEntry(classifiedName.syntaxNode, canonicalName, o.getName(), null);
                entry.setDefinition(new SQLQuerySymbolByDbObjectDefinition(o, SQLQuerySemanticUtils.inferSymbolClass(o)));
                synthesizedName = synthesizedName.prepend(entry);
                rowsSources.put(synthesizedName, srr);
                o = o.getParentObject();
            }
        }
        return this.setRowsSources(rowsSources, this.sourcesByLoweredAlias, this.hasUnresolvedSource);
    }

    @NotNull
    public final SQLQueryRowsSourceContext replaceWithAlias(@NotNull SQLQueryRowsSourceModel oldSource, @NotNull SQLQueryRowsSourceModel newSource, @NotNull SQLQuerySymbolEntry alias) {
        SourceResolutionResult oldEntry = this.rowsSources.values().stream().filter(s -> s.source == oldSource).findFirst().orElse(null);
        DBSEntity oldEntryTable = oldEntry == null ? null : oldEntry.tableOrNull;
        SourceResolutionResult newEntry = new SourceResolutionResult(newSource, null, oldEntryTable, alias.getSymbol());
        return this.setRowsSources(this.rowsSources.entrySet().stream().filter(e -> ((SourceResolutionResult)e.getValue()).source == oldSource).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (Map<String, SourceResolutionResult>)new HashMap<String, SourceResolutionResult>(alias, newEntry){
            {
                this.putAll(SQLQueryRowsSourceContext.this.sourcesByLoweredAlias);
                this.put(sQLQuerySymbolEntry.getName().toLowerCase(), sourceResolutionResult);
            }
        }, this.hasUnresolvedSource);
    }

    @NotNull
    public final SQLQueryRowsSourceContext appendCteSources(@NotNull List<Pair<SQLQuerySymbolEntry, SQLQueryRowsSourceModel>> sources) {
        return this.setDynamicRowsSources((Map<String, SourceResolutionResult>)new HashMap<String, SourceResolutionResult>(sources){
            {
                this.putAll(SQLQueryRowsSourceContext.this.dynamicTableSources);
                for (Pair entry : list) {
                    SQLQuerySymbolEntry alias = (SQLQuerySymbolEntry)entry.getFirst();
                    if (alias == null) continue;
                    SQLQueryRowsSourceModel sourceModel = (SQLQueryRowsSourceModel)entry.getSecond();
                    SQLQueryComplexName name = new SQLQueryComplexName(alias.getSyntaxNode(), List.of(alias), 0, null);
                    this.put(alias.getName().toLowerCase(), new SourceResolutionResult(sourceModel, name, null, alias.getSymbol()));
                }
            }
        });
    }

    @NotNull
    public final SQLQueryRowsSourceContext setCteSourcesFrom(@NotNull SQLQueryRowsSourceContext context) {
        return this.setDynamicRowsSources(Map.copyOf(context.dynamicTableSources));
    }

    @NotNull
    public SQLQueryRowsDataContext makeEmptyTuple() {
        return new SQLQueryRowsDataContext(this, Collections.emptyList(), Collections.emptyList());
    }

    @NotNull
    public SQLQueryRowsDataContext makeTuple(@NotNull List<SQLQueryResultColumn> columns, @NotNull List<SQLQueryResultPseudoColumn> pseudoColumns) {
        return new SQLQueryRowsDataContext(this, columns, pseudoColumns);
    }

    @NotNull
    public final SQLQueryRowsDataContext makeTuple(@Nullable SQLQueryRowsSourceModel source, @NotNull List<SQLQueryResultColumn> columns, @NotNull List<SQLQueryResultPseudoColumn> pseudoColumns) {
        List allPseudoColumns = source == null ? pseudoColumns : STMUtils.combineLists(this.connectionInfo.obtainRowsetPseudoColumns(source), pseudoColumns);
        return new SQLQueryRowsDataContext(this, columns, allPseudoColumns);
    }

    @NotNull
    public final SQLQueryRowsDataContext makeTuple(@Nullable SQLQueryRowsSourceModel source, @NotNull Pair<List<SQLQueryResultColumn>, List<SQLQueryResultPseudoColumn>> columnsAndPseudoColumns) {
        return this.makeTuple(source, (List)columnsAndPseudoColumns.getFirst(), (List)columnsAndPseudoColumns.getSecond());
    }

    @NotNull
    public SQLQueryRowsDataContext makeJoinTuple(@NotNull List<SQLQueryResultColumn> columns, @NotNull List<SQLQueryResultPseudoColumn> pseudoColumns, @NotNull SQLQueryRowsDataContext.JoinInfo joinInfo) {
        return new SQLQueryRowsDataContext(this, columns, pseudoColumns, joinInfo);
    }

    @NotNull
    public SQLQuerySourcesInfoCollection getKnownSources(boolean forQuerySubscope) {
        ListNode queue = ListNode.of((Object)this);
        HashSet<SQLQueryRowsSourceContext> queued = new HashSet<SQLQueryRowsSourceContext>();
        queued.add(this);
        HashSet<SourceResolutionResult> allSourceResolutions = new HashSet<SourceResolutionResult>();
        while (queue != null) {
            SQLQueryRowsSourceContext source = (SQLQueryRowsSourceContext)queue.data;
            queue = queue.next;
            allSourceResolutions.addAll(source.rowsSources.values());
            allSourceResolutions.addAll(source.sourcesByLoweredAlias.values());
            allSourceResolutions.addAll(source.dynamicTableSources.values());
            if (!forQuerySubscope) continue;
            ListNode item = source.targetRowContexts;
            while (item != null) {
                if (queued.add((SQLQueryRowsSourceContext)item.data)) {
                    queue = ListNode.push((ListNode)queue, (Object)((SQLQueryRowsSourceContext)item.data));
                }
                item = item.next;
            }
        }
        return new SQLQuerySourcesInfoCollection(allSourceResolutions){
            private final Map<SQLQueryRowsSourceModel, SourceResolutionResult> resolutionResults;
            private final Set<DBSObject> referencedTables;
            private final Set<String> aliasesInUse;
            {
                this.resolutionResults = set.stream().collect(Collectors.toMap(s -> s.source, Function.identity()));
                this.referencedTables = set.stream().map(s -> s.tableOrNull).filter(Objects::nonNull).collect(Collectors.toSet());
                this.aliasesInUse = set.stream().map(s -> s.aliasOrNull).filter(Objects::nonNull).map(SQLQuerySymbol::getName).map(String::toLowerCase).collect(Collectors.toSet());
            }

            @Override
            @NotNull
            public Map<SQLQueryRowsSourceModel, SourceResolutionResult> getResolutionResults() {
                return this.resolutionResults;
            }

            @Override
            @NotNull
            public Set<DBSObject> getReferencedTables() {
                return this.referencedTables;
            }

            @Override
            @NotNull
            public Set<String> getAliasesInUse() {
                return this.aliasesInUse;
            }
        };
    }

    @NotNull
    private SQLQueryRowsSourceContext setRowsSources(@NotNull Map<SQLQueryComplexName, SourceResolutionResult> rowsSources, @NotNull Map<String, SourceResolutionResult> sourcesByLoweredAlias, boolean hasUnresolvedSource) {
        return new SQLQueryRowsSourceContext(this, hasUnresolvedSource, rowsSources, this.dynamicTableSources, sourcesByLoweredAlias);
    }

    @NotNull
    private SQLQueryRowsSourceContext setDynamicRowsSources(@NotNull Map<String, SourceResolutionResult> dynamicTableSources) {
        return new SQLQueryRowsSourceContext(this, this.hasUnresolvedSource, this.rowsSources, dynamicTableSources, this.sourcesByLoweredAlias);
    }

    public record SourceResolutionInfo(@NotNull SourceResolutionResult target, @NotNull SQLQueryComplexName key) {
    }
}

