/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.patch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.Hunk;
import org.eclipse.compare.internal.patch.PatchProjectDiffNode;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.internal.core.mapping.LocalResourceVariant;
import org.eclipse.team.internal.ui.synchronize.patch.PatchModelProvider;
import org.eclipse.team.internal.ui.synchronize.patch.PatchedFileVariant;
import org.eclipse.team.internal.ui.synchronize.patch.PatchedFileVariantComparator;

public class ApplyPatchSubscriber
extends Subscriber {
    private final WorkspacePatcher patcher;
    private final IResourceVariantComparator comparator;

    public ApplyPatchSubscriber(WorkspacePatcher patcher) {
        this.patcher = patcher;
        this.comparator = new PatchedFileVariantComparator();
        this.getPatcher().refresh();
    }

    public String getName() {
        return "Apply Patch Subscriber";
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparator;
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        if (!this.isSupervised(resource)) {
            return null;
        }
        this.refresh(new IResource[]{resource}, 0, null);
        try {
            FilePatch2 diff = (FilePatch2)PatchModelProvider.getPatchObject(resource, this.getPatcher());
            PatchedFileVariant remote = null;
            if (diff.getDiffType(this.patcher.isReversed()) != 2) {
                remote = new PatchedFileVariant(this.getPatcher(), diff);
            }
            LocalResourceVariant base = null;
            if (diff.getDiffType(this.patcher.isReversed()) != 1) {
                base = new LocalResourceVariant(resource);
            }
            ApplyPatchSyncInfo info = new ApplyPatchSyncInfo(resource, (IResourceVariant)base, remote, this.getResourceComparator());
            info.init();
            return info;
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        return resource.getType() == 1 && PatchModelProvider.getPatchObject(resource, this.getPatcher()) != null;
    }

    public IResource[] members(IResource resource) throws TeamException {
        try {
            FilePatch2[] diffs;
            if (resource.getType() == 1) {
                return new IResource[0];
            }
            IContainer container = (IContainer)resource;
            ArrayList<Object> existingChildren = new ArrayList<Object>();
            if (container.isAccessible()) {
                existingChildren.addAll(Arrays.asList(container.members()));
            }
            FilePatch2[] filePatch2Array = diffs = this.getPatcher().getDiffs();
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                FilePatch2 diff = filePatch2Array[n2];
                IFile file = PatchModelProvider.getFile(diff, this.getPatcher());
                if (container.getFullPath().isPrefixOf(file.getFullPath()) && !container.exists(file.getProjectRelativePath())) {
                    existingChildren.add(file);
                }
                ++n2;
            }
            return existingChildren.toArray(new IResource[existingChildren.size()]);
        }
        catch (CoreException e) {
            throw TeamException.asTeamException((CoreException)e);
        }
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        HashSet<FilePatch2> diffs = new HashSet<FilePatch2>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            Object object = PatchModelProvider.getPatchObject(resource, this.getPatcher());
            if (object instanceof FilePatch2) {
                FilePatch2 filePatch = (FilePatch2)object;
                diffs.add(filePatch);
            }
            ++n2;
        }
        this.getPatcher().refresh(diffs.toArray(new FilePatch2[0]));
    }

    public IResource[] roots() {
        HashSet<Object> roots = new HashSet<Object>();
        if (this.getPatcher().isWorkspacePatch()) {
            IDiffElement[] children;
            IDiffElement[] iDiffElementArray = children = PatchModelProvider.getPatchWorkspace(this).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement child = iDiffElementArray[n2];
                DiffProject diffProject = ((PatchProjectDiffNode)child).getDiffProject();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(diffProject.getName());
                if (project.isAccessible()) {
                    roots.add(project);
                }
                ++n2;
            }
        } else {
            roots.add(this.getPatcher().getTarget());
        }
        return roots.toArray(new IResource[0]);
    }

    public WorkspacePatcher getPatcher() {
        return this.patcher;
    }

    public void merged(IResource[] resources) {
        this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])resources));
    }

    private class ApplyPatchSyncInfo
    extends SyncInfo {
        private ApplyPatchSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote, IResourceVariantComparator comparator) {
            super(local, base, remote, comparator);
        }

        protected int calculateKind() throws TeamException {
            if (!ApplyPatchSubscriber.this.getPatcher().isEnabled(PatchModelProvider.getPatchObject(this.getLocal(), ApplyPatchSubscriber.this.patcher))) {
                return 0;
            }
            if (this.getRemote() != null) {
                IHunk[] hunks;
                FilePatch2 filePatch2 = ((PatchedFileVariant)this.getRemote()).getDiff();
                IHunk[] iHunkArray = hunks = filePatch2.getHunks();
                int n = hunks.length;
                int n2 = 0;
                while (n2 < n) {
                    IHunk hunk = iHunkArray[n2];
                    if (ApplyPatchSubscriber.this.patcher.isManuallyMerged((Hunk)hunk)) {
                        return 0;
                    }
                    ++n2;
                }
            } else {
                Object patchObject = PatchModelProvider.getPatchObject(this.getLocal(), ApplyPatchSubscriber.this.patcher);
                if (patchObject instanceof FilePatch2) {
                    IHunk[] hunks;
                    FilePatch2 filePatch2 = (FilePatch2)patchObject;
                    IHunk[] iHunkArray = hunks = filePatch2.getHunks();
                    int n = hunks.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IHunk hunk = iHunkArray[n3];
                        if (ApplyPatchSubscriber.this.patcher.isManuallyMerged((Hunk)hunk)) {
                            return 0;
                        }
                        ++n3;
                    }
                }
            }
            int kind = super.calculateKind();
            if (this.getRemote() != null && ApplyPatchSubscriber.this.getPatcher().getDiffResult(((PatchedFileVariant)this.getRemote()).getDiff()).containsProblems()) {
                kind |= 0xC;
            }
            return kind;
        }
    }
}

