/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.utils.CommonUtils;

public class DBWUtils {
    public static final String LOOPBACK_HOST_NAME = "127.0.0.1";
    public static final String LOOPBACK_IPV6_HOST_NAME = ":1";
    public static final String LOOPBACK_IPV6_FULL_HOST_NAME = "0:0:0:0:0:0:0:1";
    public static final String LOCALHOST_NAME = "localhost";
    public static final String LOCAL_NAME = "local";

    public static void updateConfigWithTunnelInfo(DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo, String localHost, int localPort) {
        if (CommonUtils.isNotEmpty((String)localHost)) {
            connectionInfo.setHostName(localHost);
        } else if (!LOCALHOST_NAME.equals(connectionInfo.getHostName()) && !LOCAL_NAME.equals(connectionInfo.getHostName())) {
            connectionInfo.setHostName(LOOPBACK_HOST_NAME);
        }
        connectionInfo.setHostPort(Integer.toString(localPort));
        if (configuration.getDriver() != null) {
            String newURL = configuration.getDriver().getConnectionURL(connectionInfo);
            connectionInfo.setUrl(newURL);
        }
    }

    @NotNull
    public static String getTargetTunnelHostName(@Nullable DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration cfg) {
        String hostText = cfg.getHostName();
        if (DBWUtils.isLocalAddress(hostText)) {
            DBWNetworkProfile networkProfile = dataSourceContainer == null ? null : DBWUtils.getNetworkProfile(dataSourceContainer);
            for (DBWHandlerConfiguration hc : cfg.getHandlers()) {
                DBWHandlerConfiguration hCfg;
                if (!hc.isEnabled() || hc.getType() != DBWHandlerType.TUNNEL) continue;
                String tunnelHost = null;
                if (networkProfile != null && (hCfg = networkProfile.getConfiguration(hc.getHandlerDescriptor())) != null) {
                    tunnelHost = DBWUtils.getTunnelHostFromConfig(hCfg);
                }
                if (tunnelHost == null) {
                    tunnelHost = DBWUtils.getTunnelHostFromConfig(hc);
                }
                if (CommonUtils.isEmpty(tunnelHost)) continue;
                hostText = tunnelHost;
                break;
            }
        }
        return CommonUtils.notEmpty((String)hostText);
    }

    @Nullable
    public static String getTunnelHostFromConfig(DBWHandlerConfiguration hc) {
        String host = hc.getStringProperty("host");
        if (CommonUtils.isEmpty((String)host)) {
            return null;
        }
        return host;
    }

    public static boolean isLocalAddress(String hostText) {
        return CommonUtils.isEmpty((String)hostText) || hostText.equals(LOCALHOST_NAME) || hostText.equals(LOCAL_NAME) || hostText.equals(LOOPBACK_HOST_NAME) || hostText.equals(LOOPBACK_IPV6_HOST_NAME) || hostText.equals(LOOPBACK_IPV6_FULL_HOST_NAME);
    }

    @Nullable
    public static DBWNetworkProfile getNetworkProfile(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration cfg = dataSourceContainer.getConnectionConfiguration();
        return CommonUtils.isEmpty((String)cfg.getConfigProfileName()) ? null : dataSourceContainer.getRegistry().getNetworkProfile(cfg.getConfigProfileSource(), cfg.getConfigProfileName());
    }

    @NotNull
    private static ConnectivityParameters getExplicitConnectivityParameters(@NotNull DBPConnectionConfiguration configuration) {
        String defaultCatalogName = configuration.getBootstrap().getDefaultCatalogName();
        return new ConnectivityParameters(configuration.getHostName(), configuration.getHostPort(), CommonUtils.isNotEmpty((String)defaultCatalogName) ? defaultCatalogName : configuration.getDatabaseName(), configuration.getUserName(), configuration.getServerName());
    }

    @NotNull
    public static ConnectivityParameters getConnectivityParameters(@NotNull DBPConnectionConfiguration configuration, @NotNull DBPDriver driver) throws DBException {
        ConnectivityParameters explicitConfiguration = DBWUtils.getExplicitConnectivityParameters(configuration);
        return switch (configuration.getConfigurationType()) {
            case DBPDriverConfigurationType.MANUAL -> explicitConfiguration;
            case DBPDriverConfigurationType.URL -> {
                String activeUrl = driver.getConnectionURL(configuration);
                if (CommonUtils.isNotEmpty((String)activeUrl)) {
                    String databaseName;
                    Set<Object> requiredUrlParts;
                    ConnectivityParameters urlConnectivityParams = null;
                    DBPConnectionConfiguration urlConfiguration = null;
                    DatabaseURL.MetaURL metaURL = null;
                    if (CommonUtils.isNotEmpty((String)driver.getSampleURL()) && (urlConfiguration = DatabaseURL.extractConfigurationFromUrl(driver.getSampleURL(), activeUrl)) != null) {
                        metaURL = DatabaseURL.parseSampleURL(driver.getSampleURL());
                    }
                    if (urlConfiguration == null && (urlConfiguration = DatabaseURL.extractConfigurationFromUrl("[jdbc:]{driver}://[{user}:{password}@]{host}[:{port}][/{database}]", activeUrl)) != null) {
                        metaURL = DatabaseURL.parseSampleURL("[jdbc:]{driver}://[{user}:{password}@]{host}[:{port}][/{database}]");
                    }
                    if (urlConfiguration != null) {
                        urlConnectivityParams = DBWUtils.getExplicitConnectivityParameters(urlConfiguration);
                    }
                    if (urlConnectivityParams == null) {
                        URI url = URI.create(activeUrl.startsWith("jdbc:") ? activeUrl.substring("jdbc:".length()) : activeUrl);
                        urlConnectivityParams = new ConnectivityParameters(url.getHost(), url.getPort() != -1 ? Integer.toString(url.getPort()) : null, url.getPath().startsWith("/") ? url.getPath().substring(1) : url.getPath(), url.getUserInfo(), null);
                    }
                    Set<Object> v1 = requiredUrlParts = metaURL != null ? metaURL.getRequiredProperties() : Collections.emptySet();
                    String v2 = requiredUrlParts.contains("database") ? urlConnectivityParams.databaseName() : (databaseName = CommonUtils.isNotEmpty((String)urlConnectivityParams.databaseName()) ? urlConnectivityParams.databaseName() : explicitConfiguration.databaseName());
                    String userName = requiredUrlParts.contains("user") ? urlConnectivityParams.userName() : (CommonUtils.isNotEmpty((String)urlConnectivityParams.userName()) ? urlConnectivityParams.userName() : explicitConfiguration.userName());
                    yield new ConnectivityParameters(urlConnectivityParams.hostName(), urlConnectivityParams.hostPort(), databaseName, userName, urlConnectivityParams.server());
                }
                yield new ConnectivityParameters(driver.getDefaultHost(), driver.getDefaultPort(), explicitConfiguration.databaseName(), explicitConfiguration.userName(), null);
            }
            default -> throw new MatchException(null, null);
        };
    }

    public record ConnectivityParameters(@Nullable String hostName, @Nullable String hostPort, @Nullable String databaseName, @Nullable String userName, @Nullable String server) {
    }
}

