/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import java.util.List;
import java.util.concurrent.Flow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.BaseCompletionEngine;
import org.jkiss.dbeaver.model.ai.engine.LegacyAISettings;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIBaseProperties;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIClient;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModel;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIRequestFilter;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatCompletionChunk;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatCompletionRequest;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatCompletionResult;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.ChatMessage;
import org.jkiss.dbeaver.model.ai.registry.AISettingsRegistry;
import org.jkiss.dbeaver.model.ai.utils.DisposableLazyValue;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OpenAICompletionEngine<PROPS extends OpenAIBaseProperties>
extends BaseCompletionEngine<PROPS> {
    private static final Log log = Log.getLog(OpenAICompletionEngine.class);
    public static final String OPENAI_ENDPOINT = "https://api.openai.com/v1/";
    private final DisposableLazyValue<OpenAIClient, DBException> openAiService = new DisposableLazyValue<OpenAIClient, DBException>(){

        @Override
        @NotNull
        protected OpenAIClient initialize() throws DBException {
            return OpenAICompletionEngine.this.createClient();
        }

        @Override
        protected void onDispose(OpenAIClient disposedValue) {
            disposedValue.close();
        }
    };

    public OpenAICompletionEngine(AISettingsRegistry registry) {
        super(registry);
    }

    @Override
    public int getMaxContextSize(@NotNull DBRProgressMonitor monitor) throws DBException {
        return OpenAIModel.getByName(this.getProperties().getModel()).getMaxTokens();
    }

    @Override
    @NotNull
    public AIEngineResponse requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        ChatCompletionResult completionResult = this.complete(monitor, request.messages());
        List<String> choices = completionResult.getChoices().stream().map(it -> it.getMessage().getContent()).toList();
        return new AIEngineResponse(choices);
    }

    @Override
    @NotNull
    public Flow.Publisher<AIEngineResponseChunk> requestCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        ChatCompletionRequest ccr = new ChatCompletionRequest();
        ccr.setMessages(OpenAICompletionEngine.fromMessages(request.messages()));
        ccr.setTemperature(this.temperature());
        ccr.setFrequencyPenalty(0.0);
        ccr.setPresencePenalty(0.0);
        ccr.setMaxTokens(2000);
        ccr.setN(1);
        ccr.setModel(this.model());
        ccr.setStream(true);
        Flow.Publisher<ChatCompletionChunk> publisher = ((OpenAIClient)this.openAiService.getInstance()).createChatCompletionStream(monitor, ccr);
        return subscriber -> publisher.subscribe(new Flow.Subscriber<ChatCompletionChunk>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscriber.onSubscribe(subscription);
            }

            @Override
            public void onNext(ChatCompletionChunk item) {
                List<String> choices = item.getChoices().stream().filter(it -> it.getMessage() != null).takeWhile(it -> it.getMessage().getContent() != null).map(it -> it.getMessage().getContent()).toList();
                subscriber.onNext(new AIEngineResponseChunk(choices));
            }

            @Override
            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }

    @Override
    public void onSettingsUpdate(@NotNull AISettingsRegistry registry) {
        try {
            this.openAiService.dispose();
        }
        catch (DBException e) {
            log.error((Object)"Error disposing OpenAI service", (Throwable)e);
        }
    }

    @NotNull
    protected ChatCompletionResult complete(@NotNull DBRProgressMonitor monitor, @NotNull List<AIMessage> messages) throws DBException {
        ChatCompletionRequest completionRequest = new ChatCompletionRequest();
        completionRequest.setMessages(OpenAICompletionEngine.fromMessages(messages));
        completionRequest.setTemperature(this.temperature());
        completionRequest.setFrequencyPenalty(0.0);
        completionRequest.setPresencePenalty(0.0);
        completionRequest.setMaxTokens(2000);
        completionRequest.setN(1);
        completionRequest.setModel(this.model());
        return ((OpenAIClient)this.openAiService.getInstance()).createChatCompletion(monitor, completionRequest);
    }

    @NotNull
    private static List<ChatMessage> fromMessages(@NotNull List<AIMessage> messages) {
        return messages.stream().map(m -> new ChatMessage(OpenAICompletionEngine.mapRole(m.getRole()), m.getContent())).toList();
    }

    private static String mapRole(AIMessageType role) {
        return switch (role) {
            case AIMessageType.SYSTEM -> "system";
            case AIMessageType.USER -> "user";
            case AIMessageType.ASSISTANT -> "assistant";
            default -> null;
        };
    }

    protected OpenAIClient createClient() throws DBException {
        return new OpenAIClient(OPENAI_ENDPOINT, List.of(new OpenAIRequestFilter(this.getProperties().getToken())));
    }

    protected String model() throws DBException {
        return OpenAIModel.getByName(this.getProperties().getModel()).getName();
    }

    protected double temperature() throws DBException {
        return this.getProperties().getTemperature();
    }

    @Override
    protected PROPS getProperties() throws DBException {
        return (PROPS)((OpenAIBaseProperties)((LegacyAISettings)this.registry.getSettings().getEngineConfiguration("openai")).getProperties());
    }
}

