/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CubridServer
implements DBSObject,
DBPNamedObject2 {
    private String name;
    private String host;
    private String port;
    private String dbName;
    private String userName;
    private String password;
    private String properties;
    private CubridUser owner;
    private String description;
    private CubridDataSource container;
    private boolean persisted;

    public CubridServer(@NotNull CubridDataSource container, @NotNull JDBCResultSet dbResult) {
        this.container = container;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"link_name");
        this.host = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"host");
        this.port = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"port");
        this.dbName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"db_name");
        this.userName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"user_name");
        this.properties = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"properties");
        this.owner = (CubridUser)container.getSchema(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"owner"));
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
        this.persisted = true;
    }

    public CubridServer(@NotNull CubridDataSource container, String name) {
        this.container = container;
        this.name = name;
        this.host = "localhost";
        this.port = "30000";
        this.owner = (CubridUser)container.getSchema(this.getDataSource().getContainer().getConnectionConfiguration().getUserName().toUpperCase());
        this.persisted = false;
    }

    @Property(viewable=true, editable=true, updatable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Property(viewable=true, order=10)
    @NotNull
    public CubridUser getOwner() {
        return this.owner;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20)
    @NotNull
    public String getHost() {
        return this.host;
    }

    public void setHost(@NotNull String host) {
        this.host = host;
    }

    @Property(viewable=true, editable=true, updatable=true, order=30)
    @NotNull
    public String getPort() {
        return this.port;
    }

    public void setPort(@NotNull String port) {
        this.port = port;
    }

    @Property(viewable=true, editable=true, updatable=true, order=40)
    @NotNull
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@NotNull String dbName) {
        this.dbName = dbName;
    }

    @Property(viewable=true, editable=true, updatable=true, order=50)
    @NotNull
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(@NotNull String userName) {
        this.userName = userName;
    }

    @Property(viewable=true, password=true, editable=true, updatable=true, order=60)
    @Nullable
    public String getPassword() {
        return this.password;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    @Property(viewable=true, editable=true, updatable=true, order=70)
    @Nullable
    public String getProperties() {
        return this.properties;
    }

    public void setProperties(@Nullable String properties) {
        this.properties = properties;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=80)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @NotNull
    public boolean isPersisted() {
        return this.persisted;
    }

    public DBSObject getParentObject() {
        return this.container;
    }

    public DBPDataSource getDataSource() {
        return this.container;
    }
}

