<div align="center">
<img src="https://raw.githubusercontent.com/tracel-ai/cubecl-hip/main/assets/CubeCL.webp" width="256px"/>

<h1>CubeCL Rust bindings for ROCm HIP</h1>

[![Discord](https://img.shields.io/discord/1038839012602941528.svg?color=7289da&&logo=discord)](https://discord.gg/uPEBbYYDB6)
[![Current Crates.io Version](https://img.shields.io/crates/v/cubecl-hip-sys)](https://crates.io/crates/cubecl-hip-sys)
[![Minimum Supported Rust Version](https://img.shields.io/crates/msrv/cubecl-hip-sys)](https://crates.io/crates/cubecl-hip-sys)
[![Test Status](https://github.com/tracel-ai/cubecl-hip/actions/workflows/ci.yml/badge.svg)](https://github.com/tracel-ai/cubecl-hip/actions/workflows/ci.yml)
![license](https://shields.io/badge/license-MIT%2FApache--2.0-blue)

---

<br/>
</div>

This repository contains Rust bindings for AMD ROCm HIP runtime libraries (hiprtc, amdhip64) used by CubeCL.

## ⚠️ Notes
These bindings are unsafe as they are just the raw bindings generated by bindgen with no improvements.

## Limitations

- Works only on Linux
- Bindings generated for AMD GPUs only

## Prerequisites

Install ROCm following the [ROCm documentation][1]:

## Versioning Scheme

The crates in this repository follow the same versioning as HIP. Note that HIP version is somewhat different than ROCm version.
The patch number of HIP version is a monotonic number that uniquely indentify the version of HIP.

Moreover we concatenate two additional digits to the HIP patch version in order to be able to release fixes for the same HIP patch
number.

For instance `6.4.4348200` represents the first release of the bindings for HIP `43482` of ROCm `6.4.x` and `6.4.4348201` represents the second release for these same bindings.

This versioning scheme is in place as of May 2025, any previous version of this crate followed a different versioning scheme based
on ROCm version instead of HIP.

Note also that multiple versions of ROCm can ship the same version of HIP.

## Usage

Add the crate [cubecl-hip-sys][2] to the `Cargo.toml` file of your project. If no feature is set then cargo will select the HIP
version returned by the `hipconfig` utility.

To specify a different version of HIP manually set the environment variable HIP_PATH to a valid HIP installation path. You can
verify that your system points to the expected version with the command `hipconfig --version`.

Remark: Don't set manually the `hip_xxx` feature for this crate. This is the responsibility of the `build.rs` script to set it
accordingly to your `hipconfig` output.

Here is the table of currently available bindings:

| HIP Version | ROCm Version Range |
|:------------|:-------------------|
| 41134       | 6.2.2~6.2.4        |
| 42131       | 6.3.0              |
| 42133       | 6.3.1              |
| 42134       | 6.3.2~6.3.4        |
| 43482       | 6.4.0              |

## Running tests

To run tests you need to first meet the expectations for `Prerequisites` section.

Then execute the following xtask command:

```sh
# test ROCm bindings againt the system default ROCm installation if found
cargo xtask test
# test a specific version that is not the default by providing a value for HIP_PATH using -p
xtask test -p /opt/rocm-6.3.0
```

## Generate bindings for a given version of ROCm

1) To generate the bindings you first need to meet the expectations for `Prerequisites` section.

2) Make sure that `hipconfig` returns the path of the HIP version you want to wrap. Adapt the `HIP_PATH`
environment variable to point to the version you are interested in.

3) Generate the bindings using the dedicated xtask command `bindgen`:

```sh
cargo xtask bindgen
```

4) Declare a new `hip` feature in the `Cargo.toml` in `cubecl-hip-sys` crate with the format
`hip_<patch_version>`. You can retrieve the patch version with the command `hipconfig --version`.
For instance for a new HIP patch version which is `42131` add the following feature:

```toml
[features]
hip_42131 = []
```

5) Add the generated bindings module to the file `crates/cubecl-hip-sys/src/bindings/mod.rs`
conditionally to the new feature you just declared as well as the re-exports:

```rs
#[cfg(feature = "hip_42131")]
mod bindings_42131;
#[cfg(feature = "hip_42131")]
pub use bindings_42131::*;
```

5) Run the tests as explain in the previous section.

6) Open a pull request with the modifications, do not forget to add the new generated bindings
file in the `crates/cubecl-hip-sys/src/bindings/` directory.

7) Note that the CI runner might need to be updated by an administrator so that the new HIP version is available
on the runner.

[1]: https://rocmdocs.amd.com/projects/install-on-linux/en/latest/install/detailed-install.html
[2]: https://crates.io/crates/cubecl-hip-sys
