package teslamaxcompute

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCustomerSaleInfo invokes the teslamaxcompute.QueryCustomerSaleInfo API synchronously
// api document: https://help.aliyun.com/api/teslamaxcompute/querycustomersaleinfo.html
func (client *Client) QueryCustomerSaleInfo(request *QueryCustomerSaleInfoRequest) (response *QueryCustomerSaleInfoResponse, err error) {
	response = CreateQueryCustomerSaleInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCustomerSaleInfoWithChan invokes the teslamaxcompute.QueryCustomerSaleInfo API asynchronously
// api document: https://help.aliyun.com/api/teslamaxcompute/querycustomersaleinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomerSaleInfoWithChan(request *QueryCustomerSaleInfoRequest) (<-chan *QueryCustomerSaleInfoResponse, <-chan error) {
	responseChan := make(chan *QueryCustomerSaleInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCustomerSaleInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCustomerSaleInfoWithCallback invokes the teslamaxcompute.QueryCustomerSaleInfo API asynchronously
// api document: https://help.aliyun.com/api/teslamaxcompute/querycustomersaleinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomerSaleInfoWithCallback(request *QueryCustomerSaleInfoRequest, callback func(response *QueryCustomerSaleInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCustomerSaleInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryCustomerSaleInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCustomerSaleInfoRequest is the request struct for api QueryCustomerSaleInfo
type QueryCustomerSaleInfoRequest struct {
	*requests.RpcRequest
	RegionName string `position:"Query" name:"RegionName"`
}

// QueryCustomerSaleInfoResponse is the response struct for api QueryCustomerSaleInfo
type QueryCustomerSaleInfoResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryCustomerSaleInfoRequest creates a request to invoke QueryCustomerSaleInfo API
func CreateQueryCustomerSaleInfoRequest() (request *QueryCustomerSaleInfoRequest) {
	request = &QueryCustomerSaleInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("TeslaMaxCompute", "2018-01-04", "QueryCustomerSaleInfo", "teslamaxcompute", "openAPI")
	return
}

// CreateQueryCustomerSaleInfoResponse creates a response to parse from QueryCustomerSaleInfo response
func CreateQueryCustomerSaleInfoResponse() (response *QueryCustomerSaleInfoResponse) {
	response = &QueryCustomerSaleInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
