package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStorageBundles invokes the sgw.DescribeStorageBundles API synchronously
func (client *Client) DescribeStorageBundles(request *DescribeStorageBundlesRequest) (response *DescribeStorageBundlesResponse, err error) {
	response = CreateDescribeStorageBundlesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStorageBundlesWithChan invokes the sgw.DescribeStorageBundles API asynchronously
func (client *Client) DescribeStorageBundlesWithChan(request *DescribeStorageBundlesRequest) (<-chan *DescribeStorageBundlesResponse, <-chan error) {
	responseChan := make(chan *DescribeStorageBundlesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStorageBundles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStorageBundlesWithCallback invokes the sgw.DescribeStorageBundles API asynchronously
func (client *Client) DescribeStorageBundlesWithCallback(request *DescribeStorageBundlesRequest, callback func(response *DescribeStorageBundlesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStorageBundlesResponse
		var err error
		defer close(result)
		response, err = client.DescribeStorageBundles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStorageBundlesRequest is the request struct for api DescribeStorageBundles
type DescribeStorageBundlesRequest struct {
	*requests.RpcRequest
	BackendBucketRegionId string           `position:"Query" name:"BackendBucketRegionId"`
	PageNumber            requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId       string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken         string           `position:"Query" name:"SecurityToken"`
	PageSize              requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeStorageBundlesResponse is the response struct for api DescribeStorageBundles
type DescribeStorageBundlesResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	PageNumber     int            `json:"PageNumber" xml:"PageNumber"`
	PageSize       int            `json:"PageSize" xml:"PageSize"`
	StorageBundles StorageBundles `json:"StorageBundles" xml:"StorageBundles"`
}

// CreateDescribeStorageBundlesRequest creates a request to invoke DescribeStorageBundles API
func CreateDescribeStorageBundlesRequest() (request *DescribeStorageBundlesRequest) {
	request = &DescribeStorageBundlesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeStorageBundles", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeStorageBundlesResponse creates a response to parse from DescribeStorageBundles response
func CreateDescribeStorageBundlesResponse() (response *DescribeStorageBundlesResponse) {
	response = &DescribeStorageBundlesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
