package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// JoinThirdCall invokes the scsp.JoinThirdCall API synchronously
func (client *Client) JoinThirdCall(request *JoinThirdCallRequest) (response *JoinThirdCallResponse, err error) {
	response = CreateJoinThirdCallResponse()
	err = client.DoAction(request, response)
	return
}

// JoinThirdCallWithChan invokes the scsp.JoinThirdCall API asynchronously
func (client *Client) JoinThirdCallWithChan(request *JoinThirdCallRequest) (<-chan *JoinThirdCallResponse, <-chan error) {
	responseChan := make(chan *JoinThirdCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.JoinThirdCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// JoinThirdCallWithCallback invokes the scsp.JoinThirdCall API asynchronously
func (client *Client) JoinThirdCallWithCallback(request *JoinThirdCallRequest, callback func(response *JoinThirdCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *JoinThirdCallResponse
		var err error
		defer close(result)
		response, err = client.JoinThirdCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// JoinThirdCallRequest is the request struct for api JoinThirdCall
type JoinThirdCallRequest struct {
	*requests.RpcRequest
	ClientToken      string `position:"Body"`
	InstanceId       string `position:"Body"`
	AccountName      string `position:"Body"`
	CallId           string `position:"Body"`
	JobId            string `position:"Body"`
	ConnectionId     string `position:"Body"`
	HoldConnectionId string `position:"Body"`
}

// JoinThirdCallResponse is the response struct for api JoinThirdCall
type JoinThirdCallResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateJoinThirdCallRequest creates a request to invoke JoinThirdCall API
func CreateJoinThirdCallRequest() (request *JoinThirdCallRequest) {
	request = &JoinThirdCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "JoinThirdCall", "", "")
	request.Method = requests.POST
	return
}

// CreateJoinThirdCallResponse creates a response to parse from JoinThirdCall response
func CreateJoinThirdCallResponse() (response *JoinThirdCallResponse) {
	response = &JoinThirdCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
