package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePolarxDbInstances invokes the polardbx.DescribePolarxDbInstances API synchronously
func (client *Client) DescribePolarxDbInstances(request *DescribePolarxDbInstancesRequest) (response *DescribePolarxDbInstancesResponse, err error) {
	response = CreateDescribePolarxDbInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePolarxDbInstancesWithChan invokes the polardbx.DescribePolarxDbInstances API asynchronously
func (client *Client) DescribePolarxDbInstancesWithChan(request *DescribePolarxDbInstancesRequest) (<-chan *DescribePolarxDbInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribePolarxDbInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePolarxDbInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePolarxDbInstancesWithCallback invokes the polardbx.DescribePolarxDbInstances API asynchronously
func (client *Client) DescribePolarxDbInstancesWithCallback(request *DescribePolarxDbInstancesRequest, callback func(response *DescribePolarxDbInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePolarxDbInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribePolarxDbInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePolarxDbInstancesRequest is the request struct for api DescribePolarxDbInstances
type DescribePolarxDbInstancesRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	DbName         string           `position:"Query" name:"DbName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
}

// DescribePolarxDbInstancesResponse is the response struct for api DescribePolarxDbInstances
type DescribePolarxDbInstancesResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Success     bool        `json:"Success" xml:"Success"`
	PageNumber  string      `json:"PageNumber" xml:"PageNumber"`
	PageSize    string      `json:"PageSize" xml:"PageSize"`
	Total       string      `json:"Total" xml:"Total"`
	DbInstances DbInstances `json:"DbInstances" xml:"DbInstances"`
}

// CreateDescribePolarxDbInstancesRequest creates a request to invoke DescribePolarxDbInstances API
func CreateDescribePolarxDbInstancesRequest() (request *DescribePolarxDbInstancesRequest) {
	request = &DescribePolarxDbInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribePolarxDbInstances", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePolarxDbInstancesResponse creates a response to parse from DescribePolarxDbInstances response
func CreateDescribePolarxDbInstancesResponse() (response *DescribePolarxDbInstancesResponse) {
	response = &DescribePolarxDbInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
