package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestoreTable invokes the polardb.RestoreTable API synchronously
func (client *Client) RestoreTable(request *RestoreTableRequest) (response *RestoreTableResponse, err error) {
	response = CreateRestoreTableResponse()
	err = client.DoAction(request, response)
	return
}

// RestoreTableWithChan invokes the polardb.RestoreTable API asynchronously
func (client *Client) RestoreTableWithChan(request *RestoreTableRequest) (<-chan *RestoreTableResponse, <-chan error) {
	responseChan := make(chan *RestoreTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestoreTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestoreTableWithCallback invokes the polardb.RestoreTable API asynchronously
func (client *Client) RestoreTableWithCallback(request *RestoreTableRequest, callback func(response *RestoreTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestoreTableResponse
		var err error
		defer close(result)
		response, err = client.RestoreTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestoreTableRequest is the request struct for api RestoreTable
type RestoreTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	TableMeta            string           `position:"Query" name:"TableMeta"`
	RestoreTime          string           `position:"Query" name:"RestoreTime"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	BackupId             string           `position:"Query" name:"BackupId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// RestoreTableResponse is the response struct for api RestoreTable
type RestoreTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRestoreTableRequest creates a request to invoke RestoreTable API
func CreateRestoreTableRequest() (request *RestoreTableRequest) {
	request = &RestoreTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "RestoreTable", "", "")
	request.Method = requests.POST
	return
}

// CreateRestoreTableResponse creates a response to parse from RestoreTable response
func CreateRestoreTableResponse() (response *RestoreTableResponse) {
	response = &RestoreTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
