package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TestHttpApi invokes the ft.TestHttpApi API synchronously
func (client *Client) TestHttpApi(request *TestHttpApiRequest) (response *TestHttpApiResponse, err error) {
	response = CreateTestHttpApiResponse()
	err = client.DoAction(request, response)
	return
}

// TestHttpApiWithChan invokes the ft.TestHttpApi API asynchronously
func (client *Client) TestHttpApiWithChan(request *TestHttpApiRequest) (<-chan *TestHttpApiResponse, <-chan error) {
	responseChan := make(chan *TestHttpApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TestHttpApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TestHttpApiWithCallback invokes the ft.TestHttpApi API asynchronously
func (client *Client) TestHttpApiWithCallback(request *TestHttpApiRequest, callback func(response *TestHttpApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TestHttpApiResponse
		var err error
		defer close(result)
		response, err = client.TestHttpApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TestHttpApiRequest is the request struct for api TestHttpApi
type TestHttpApiRequest struct {
	*requests.RpcRequest
	StringValue  string           `position:"Query" name:"StringValue"`
	OtherParam   string           `position:"Query" name:"OtherParam"`
	BooleanParam requests.Boolean `position:"Query" name:"BooleanParam"`
	DefaultValue string           `position:"Query" name:"DefaultValue"`
}

// TestHttpApiResponse is the response struct for api TestHttpApi
type TestHttpApiResponse struct {
	*responses.BaseResponse
	Params         string `json:"Params" xml:"Params"`
	ServiceRpcSign string `json:"ServiceRpcSign" xml:"ServiceRpcSign"`
}

// CreateTestHttpApiRequest creates a request to invoke TestHttpApi API
func CreateTestHttpApiRequest() (request *TestHttpApiRequest) {
	request = &TestHttpApiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2018-07-13", "TestHttpApi", "", "")
	request.Method = requests.POST
	return
}

// CreateTestHttpApiResponse creates a response to parse from TestHttpApi response
func CreateTestHttpApiResponse() (response *TestHttpApiResponse) {
	response = &TestHttpApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
