package faas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishFpgaImage invokes the faas.PublishFpgaImage API synchronously
// api document: https://help.aliyun.com/api/faas/publishfpgaimage.html
func (client *Client) PublishFpgaImage(request *PublishFpgaImageRequest) (response *PublishFpgaImageResponse, err error) {
	response = CreatePublishFpgaImageResponse()
	err = client.DoAction(request, response)
	return
}

// PublishFpgaImageWithChan invokes the faas.PublishFpgaImage API asynchronously
// api document: https://help.aliyun.com/api/faas/publishfpgaimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PublishFpgaImageWithChan(request *PublishFpgaImageRequest) (<-chan *PublishFpgaImageResponse, <-chan error) {
	responseChan := make(chan *PublishFpgaImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishFpgaImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishFpgaImageWithCallback invokes the faas.PublishFpgaImage API asynchronously
// api document: https://help.aliyun.com/api/faas/publishfpgaimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PublishFpgaImageWithCallback(request *PublishFpgaImageRequest, callback func(response *PublishFpgaImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishFpgaImageResponse
		var err error
		defer close(result)
		response, err = client.PublishFpgaImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishFpgaImageRequest is the request struct for api PublishFpgaImage
type PublishFpgaImageRequest struct {
	*requests.RpcRequest
	Description       string `position:"Query" name:"Description"`
	FpgaImageUniqueId string `position:"Query" name:"FpgaImageUniqueId"`
	ECSImageId        string `position:"Query" name:"ECSImageId"`
}

// PublishFpgaImageResponse is the response struct for api PublishFpgaImage
type PublishFpgaImageResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	FpgaImageUniqueId string `json:"FpgaImageUniqueId" xml:"FpgaImageUniqueId"`
	Message           string `json:"Message" xml:"Message"`
	ImageId           string `json:"ImageId" xml:"ImageId"`
}

// CreatePublishFpgaImageRequest creates a request to invoke PublishFpgaImage API
func CreatePublishFpgaImageRequest() (request *PublishFpgaImageRequest) {
	request = &PublishFpgaImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("faas", "2020-02-17", "PublishFpgaImage", "faas", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePublishFpgaImageResponse creates a response to parse from PublishFpgaImage response
func CreatePublishFpgaImageResponse() (response *PublishFpgaImageResponse) {
	response = &PublishFpgaImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
