package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddExistedNodes invokes the ehpc.AddExistedNodes API synchronously
func (client *Client) AddExistedNodes(request *AddExistedNodesRequest) (response *AddExistedNodesResponse, err error) {
	response = CreateAddExistedNodesResponse()
	err = client.DoAction(request, response)
	return
}

// AddExistedNodesWithChan invokes the ehpc.AddExistedNodes API asynchronously
func (client *Client) AddExistedNodesWithChan(request *AddExistedNodesRequest) (<-chan *AddExistedNodesResponse, <-chan error) {
	responseChan := make(chan *AddExistedNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddExistedNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddExistedNodesWithCallback invokes the ehpc.AddExistedNodes API asynchronously
func (client *Client) AddExistedNodesWithCallback(request *AddExistedNodesRequest, callback func(response *AddExistedNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddExistedNodesResponse
		var err error
		defer close(result)
		response, err = client.AddExistedNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddExistedNodesRequest is the request struct for api AddExistedNodes
type AddExistedNodesRequest struct {
	*requests.RpcRequest
	ImageId         string                     `position:"Query" name:"ImageId"`
	Instance        *[]AddExistedNodesInstance `position:"Query" name:"Instance"  type:"Repeated"`
	ClientToken     string                     `position:"Query" name:"ClientToken"`
	ClusterId       string                     `position:"Query" name:"ClusterId"`
	JobQueue        string                     `position:"Query" name:"JobQueue"`
	ImageOwnerAlias string                     `position:"Query" name:"ImageOwnerAlias"`
}

// AddExistedNodesInstance is a repeated param struct in AddExistedNodesRequest
type AddExistedNodesInstance struct {
	Id string `name:"Id"`
}

// AddExistedNodesResponse is the response struct for api AddExistedNodes
type AddExistedNodesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateAddExistedNodesRequest creates a request to invoke AddExistedNodes API
func CreateAddExistedNodesRequest() (request *AddExistedNodesRequest) {
	request = &AddExistedNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "AddExistedNodes", "", "")
	request.Method = requests.GET
	return
}

// CreateAddExistedNodesResponse creates a response to parse from AddExistedNodes response
func CreateAddExistedNodesResponse() (response *AddExistedNodesResponse) {
	response = &AddExistedNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
