package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopService invokes the eas.StopService API synchronously
func (client *Client) StopService(request *StopServiceRequest) (response *StopServiceResponse, err error) {
	response = CreateStopServiceResponse()
	err = client.DoAction(request, response)
	return
}

// StopServiceWithChan invokes the eas.StopService API asynchronously
func (client *Client) StopServiceWithChan(request *StopServiceRequest) (<-chan *StopServiceResponse, <-chan error) {
	responseChan := make(chan *StopServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopServiceWithCallback invokes the eas.StopService API asynchronously
func (client *Client) StopServiceWithCallback(request *StopServiceRequest, callback func(response *StopServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopServiceResponse
		var err error
		defer close(result)
		response, err = client.StopService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopServiceRequest is the request struct for api StopService
type StopServiceRequest struct {
	*requests.RoaRequest
	ServiceName string `position:"Path" name:"ServiceName"`
	ClusterId   string `position:"Path" name:"ClusterId"`
}

// StopServiceResponse is the response struct for api StopService
type StopServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateStopServiceRequest creates a request to invoke StopService API
func CreateStopServiceRequest() (request *StopServiceRequest) {
	request = &StopServiceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "StopService", "/api/v2/services/[ClusterId]/[ServiceName]/stop", "eas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateStopServiceResponse creates a response to parse from StopService response
func CreateStopServiceResponse() (response *StopServiceResponse) {
	response = &StopServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
