package dbs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSandboxFromRDS invokes the dbs.DescribeSandboxFromRDS API synchronously
func (client *Client) DescribeSandboxFromRDS(request *DescribeSandboxFromRDSRequest) (response *DescribeSandboxFromRDSResponse, err error) {
	response = CreateDescribeSandboxFromRDSResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSandboxFromRDSWithChan invokes the dbs.DescribeSandboxFromRDS API asynchronously
func (client *Client) DescribeSandboxFromRDSWithChan(request *DescribeSandboxFromRDSRequest) (<-chan *DescribeSandboxFromRDSResponse, <-chan error) {
	responseChan := make(chan *DescribeSandboxFromRDSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSandboxFromRDS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSandboxFromRDSWithCallback invokes the dbs.DescribeSandboxFromRDS API asynchronously
func (client *Client) DescribeSandboxFromRDSWithCallback(request *DescribeSandboxFromRDSRequest, callback func(response *DescribeSandboxFromRDSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSandboxFromRDSResponse
		var err error
		defer close(result)
		response, err = client.DescribeSandboxFromRDS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSandboxFromRDSRequest is the request struct for api DescribeSandboxFromRDS
type DescribeSandboxFromRDSRequest struct {
	*requests.RpcRequest
	ClientToken   string `position:"Query" name:"ClientToken"`
	RdsInstanceID string `position:"Query" name:"RdsInstanceID"`
	OwnerId       string `position:"Query" name:"OwnerId"`
}

// DescribeSandboxFromRDSResponse is the response struct for api DescribeSandboxFromRDS
type DescribeSandboxFromRDSResponse struct {
	*responses.BaseResponse
	Success                 bool   `json:"Success" xml:"Success"`
	ErrCode                 string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage              string `json:"ErrMessage" xml:"ErrMessage"`
	HttpStatusCode          int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId               string `json:"RequestId" xml:"RequestId"`
	SourceId                string `json:"SourceId" xml:"SourceId"`
	BackupPlanName          string `json:"BackupPlanName" xml:"BackupPlanName"`
	BackupLog               string `json:"BackupLog" xml:"BackupLog"`
	DbsInstanceId           string `json:"DbsInstanceId" xml:"DbsInstanceId"`
	SupportSandbox          bool   `json:"SupportSandbox" xml:"SupportSandbox"`
	SandboxInstanceCount    int    `json:"SandboxInstanceCount" xml:"SandboxInstanceCount"`
	SandboxRecoverStartTime int64  `json:"SandboxRecoverStartTime" xml:"SandboxRecoverStartTime"`
	SandboxRecoverEndTime   int64  `json:"SandboxRecoverEndTime" xml:"SandboxRecoverEndTime"`
	EnabledSandbox          bool   `json:"EnabledSandbox" xml:"EnabledSandbox"`
}

// CreateDescribeSandboxFromRDSRequest creates a request to invoke DescribeSandboxFromRDS API
func CreateDescribeSandboxFromRDSRequest() (request *DescribeSandboxFromRDSRequest) {
	request = &DescribeSandboxFromRDSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dbs", "2019-03-06", "DescribeSandboxFromRDS", "cbs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSandboxFromRDSResponse creates a response to parse from DescribeSandboxFromRDS response
func CreateDescribeSandboxFromRDSResponse() (response *DescribeSandboxFromRDSResponse) {
	response = &DescribeSandboxFromRDSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
