package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFabricChannelMember invokes the baas.CreateFabricChannelMember API synchronously
// api document: https://help.aliyun.com/api/baas/createfabricchannelmember.html
func (client *Client) CreateFabricChannelMember(request *CreateFabricChannelMemberRequest) (response *CreateFabricChannelMemberResponse, err error) {
	response = CreateCreateFabricChannelMemberResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFabricChannelMemberWithChan invokes the baas.CreateFabricChannelMember API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricchannelmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricChannelMemberWithChan(request *CreateFabricChannelMemberRequest) (<-chan *CreateFabricChannelMemberResponse, <-chan error) {
	responseChan := make(chan *CreateFabricChannelMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFabricChannelMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFabricChannelMemberWithCallback invokes the baas.CreateFabricChannelMember API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricchannelmember.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricChannelMemberWithCallback(request *CreateFabricChannelMemberRequest, callback func(response *CreateFabricChannelMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFabricChannelMemberResponse
		var err error
		defer close(result)
		response, err = client.CreateFabricChannelMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFabricChannelMemberRequest is the request struct for api CreateFabricChannelMember
type CreateFabricChannelMemberRequest struct {
	*requests.RpcRequest
	Organization *[]CreateFabricChannelMemberOrganization `position:"Query" name:"Organization"  type:"Repeated"`
	ChannelId    string                                   `position:"Query" name:"ChannelId"`
}

// CreateFabricChannelMemberOrganization is a repeated param struct in CreateFabricChannelMemberRequest
type CreateFabricChannelMemberOrganization struct {
	OrganizationId string `name:"OrganizationId"`
}

// CreateFabricChannelMemberResponse is the response struct for api CreateFabricChannelMember
type CreateFabricChannelMemberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateCreateFabricChannelMemberRequest creates a request to invoke CreateFabricChannelMember API
func CreateCreateFabricChannelMemberRequest() (request *CreateFabricChannelMemberRequest) {
	request = &CreateFabricChannelMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "CreateFabricChannelMember", "baas", "openAPI")
	return
}

// CreateCreateFabricChannelMemberResponse creates a response to parse from CreateFabricChannelMember response
func CreateCreateFabricChannelMemberResponse() (response *CreateFabricChannelMemberResponse) {
	response = &CreateFabricChannelMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
