package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSasAssetStatisticsColumn invokes the aegis.DescribeSasAssetStatisticsColumn API synchronously
// api document: https://help.aliyun.com/api/aegis/describesasassetstatisticscolumn.html
func (client *Client) DescribeSasAssetStatisticsColumn(request *DescribeSasAssetStatisticsColumnRequest) (response *DescribeSasAssetStatisticsColumnResponse, err error) {
	response = CreateDescribeSasAssetStatisticsColumnResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSasAssetStatisticsColumnWithChan invokes the aegis.DescribeSasAssetStatisticsColumn API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesasassetstatisticscolumn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSasAssetStatisticsColumnWithChan(request *DescribeSasAssetStatisticsColumnRequest) (<-chan *DescribeSasAssetStatisticsColumnResponse, <-chan error) {
	responseChan := make(chan *DescribeSasAssetStatisticsColumnResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSasAssetStatisticsColumn(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSasAssetStatisticsColumnWithCallback invokes the aegis.DescribeSasAssetStatisticsColumn API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesasassetstatisticscolumn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSasAssetStatisticsColumnWithCallback(request *DescribeSasAssetStatisticsColumnRequest, callback func(response *DescribeSasAssetStatisticsColumnResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSasAssetStatisticsColumnResponse
		var err error
		defer close(result)
		response, err = client.DescribeSasAssetStatisticsColumn(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSasAssetStatisticsColumnRequest is the request struct for api DescribeSasAssetStatisticsColumn
type DescribeSasAssetStatisticsColumnRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeSasAssetStatisticsColumnResponse is the response struct for api DescribeSasAssetStatisticsColumn
type DescribeSasAssetStatisticsColumnResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	StatisticsColumn string `json:"StatisticsColumn" xml:"StatisticsColumn"`
}

// CreateDescribeSasAssetStatisticsColumnRequest creates a request to invoke DescribeSasAssetStatisticsColumn API
func CreateDescribeSasAssetStatisticsColumnRequest() (request *DescribeSasAssetStatisticsColumnRequest) {
	request = &DescribeSasAssetStatisticsColumnRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeSasAssetStatisticsColumn", "vipaegis", "openAPI")
	return
}

// CreateDescribeSasAssetStatisticsColumnResponse creates a response to parse from DescribeSasAssetStatisticsColumn response
func CreateDescribeSasAssetStatisticsColumnResponse() (response *DescribeSasAssetStatisticsColumnResponse) {
	response = &DescribeSasAssetStatisticsColumnResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
