/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.dml;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQuerySelectionResultModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQuerySelectIntoModel
extends SQLQueryRowsProjectionModel {
    @Nullable
    private final STMTreeNode intoKeywordSyntaxNode;
    @Nullable
    private final SQLQuerySelectIntoTargetsList targets;

    public SQLQuerySelectIntoModel(@NotNull STMTreeNode syntaxNode, @Nullable STMTreeNode intoKeywordSyntaxNode, @NotNull SQLQueryLexicalScope selectListScope, @Nullable SQLQuerySelectIntoTargetsList targets, @NotNull SQLQueryRowsSourceModel fromSource, @Nullable SQLQueryLexicalScope fromScope, @NotNull SQLQueryRowsProjectionModel.FiltersData<SQLQueryValueExpression> filterExprs, @NotNull SQLQueryRowsProjectionModel.FiltersData<SQLQueryLexicalScope> filterScopes, @NotNull SQLQuerySelectionResultModel result, @Nullable SQLQueryLexicalScope tailScope) {
        super(syntaxNode, selectListScope, fromSource, fromScope, filterExprs, filterScopes, result, tailScope);
        this.intoKeywordSyntaxNode = intoKeywordSyntaxNode;
        this.targets = targets;
    }

    @Nullable
    public SQLQuerySelectIntoTargetsList getTargets() {
        return this.targets;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(final @NotNull SQLQueryDataContext context, final @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext sourceContext = super.propagateContextImpl(context, statistics);
        SelectionTargetVisitor propagator = new SelectionTargetVisitor(){

            @Override
            public void visitRowsetTarget(RowsetSelectionTarget target) {
                target.table.propagateContext(context, statistics);
            }

            @Override
            public void visitExpressionTarget(ValueSelectionTarget target) {
                target.expression.propagateContext(context, statistics);
            }
        };
        if (this.targets != null) {
            int expectedColumns;
            int selectedColumns;
            SQLQueryDataContext targetContext;
            SelectionTarget target;
            List<SelectionTarget> targets = this.targets.getTargets();
            Object object = targets.iterator();
            while (object.hasNext()) {
                target = object.next();
                if (target.getNode() == null) continue;
                target.apply(propagator);
            }
            if (statistics.useRealMetadata() && targets.size() == 1 && (object = targets.get(0)) instanceof RowsetSelectionTarget && (targetContext = ((RowsetSelectionTarget)(target = (RowsetSelectionTarget)object)).getNode().getResultDataContext()) != null && (selectedColumns = sourceContext.getColumnsList().size()) != (expectedColumns = targetContext.getColumnsList().size()) && expectedColumns != 0) {
                statistics.appendWarning(Objects.requireNonNullElse(this.intoKeywordSyntaxNode, this.getSyntaxNode()), "Selected result set has " + selectedColumns + " columns while target expected " + expectedColumns + " columns.");
            }
            this.targets.getTargetScope().setSymbolsOrigin(new SQLQuerySymbolOrigin.RowsetRefFromContext(context));
        }
        return context;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsProjectionInto(this, arg);
    }

    public static SQLQueryRowsSourceModel recognize(@NotNull STMTreeNode syntaxNode, @NotNull List<SQLQueryRowsSourceModel> sourceModels, @NotNull SQLQueryModelRecognizer recognizer) {
        SQLQuerySelectIntoTargetsList targetsList;
        STMTreeNode intoKeywordNode = syntaxNode.findFirstChildOfName(STMKnownRuleNames.INTO_TERM);
        STMTreeNode selectTargetList = syntaxNode.findLastChildOfName(STMKnownRuleNames.selectTargetList);
        Throwable throwable = null;
        Object var7_7 = null;
        try (SQLQueryModelRecognizer.LexicalScopeHolder targetScopeHolder = recognizer.openScope();){
            SQLQueryLexicalScope targetScope = targetScopeHolder.lexicalScope;
            if (intoKeywordNode != null) {
                targetScope.registerSyntaxNode(intoKeywordNode);
            }
            if (selectTargetList != null) {
                LinkedList<SelectionTarget> targets = new LinkedList<SelectionTarget>();
                targetsList = new SQLQuerySelectIntoTargetsList(selectTargetList, targets, targetScope);
                targetScope.registerSyntaxNode(selectTargetList);
                for (STMTreeNode targetNode : selectTargetList.findChildrenOfName(STMKnownRuleNames.selectTargetItem)) {
                    STMTreeNode targetItemNode = targetNode.findFirstNonErrorChild();
                    if (targetItemNode == null) continue;
                    targets.add((SelectionTarget)((Object)(switch (targetItemNode.getNodeKindId()) {
                        case 45 -> new RowsetSelectionTarget(recognizer.collectTableReference(targetItemNode, false));
                        default -> new ValueSelectionTarget(recognizer.collectValueExpression(targetItemNode, null));
                    })));
                }
            } else {
                targetsList = null;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return SQLQueryRowsProjectionModel.recognize(syntaxNode, sourceModels, recognizer, (node, selectListScope, sourceModel, fromScope, filterExprs, filtersScope, resultModel, tailScope) -> new SQLQuerySelectIntoModel(node, intoKeywordNode, selectListScope, targetsList, sourceModel, fromScope, filterExprs, filtersScope, resultModel, tailScope));
    }

    public record RowsetSelectionTarget(SQLQueryRowsTableDataModel table) implements SelectionTarget
    {
        @Override
        public SQLQueryNodeModel getNode() {
            return this.table;
        }

        @Override
        public void apply(SelectionTargetVisitor visitor) {
            visitor.visitRowsetTarget(this);
        }
    }

    public static class SQLQuerySelectIntoTargetsList
    extends SQLQueryNodeModel {
        @NotNull
        private final List<SelectionTarget> targets;
        @NotNull
        private final SQLQueryLexicalScope targetScope;

        public SQLQuerySelectIntoTargetsList(@NotNull STMTreeNode syntaxNode, @NotNull List<SelectionTarget> targets, @NotNull SQLQueryLexicalScope targetScope) {
            super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
            this.targets = targets;
            this.targetScope = targetScope;
            targets.stream().map(SelectionTarget::getNode).filter(Objects::nonNull).forEach(this::registerSubnode);
            this.registerLexicalScope(targetScope);
        }

        @NotNull
        public List<SelectionTarget> getTargets() {
            return this.targets;
        }

        public List<SQLQueryNodeModel> getTargetNodes() {
            return this.targets.stream().map(SelectionTarget::getNode).filter(Objects::nonNull).toList();
        }

        @NotNull
        public SQLQueryLexicalScope getTargetScope() {
            return this.targetScope;
        }

        @Override
        protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
            return visitor.visitRowsProjectionIntoTargetsList(this, arg);
        }

        @Nullable
        private SQLQueryDataContext getUnderlyingLegacyDataContext() {
            SQLQueryDataContext sQLQueryDataContext;
            SQLQuerySymbolOrigin sQLQuerySymbolOrigin = this.targetScope.getSymbolsOrigin();
            if (sQLQuerySymbolOrigin instanceof SQLQuerySymbolOrigin.DataContextSymbolOrigin) {
                SQLQuerySymbolOrigin.DataContextSymbolOrigin dsso = (SQLQuerySymbolOrigin.DataContextSymbolOrigin)sQLQuerySymbolOrigin;
                sQLQueryDataContext = dsso.getDataContext();
            } else {
                sQLQueryDataContext = null;
            }
            return sQLQueryDataContext;
        }

        @Override
        @Nullable
        public SQLQueryDataContext getGivenDataContext() {
            return this.getUnderlyingLegacyDataContext();
        }

        @Override
        @Nullable
        public SQLQueryDataContext getResultDataContext() {
            return this.getUnderlyingLegacyDataContext();
        }
    }

    public static interface SelectionTarget {
        public SQLQueryNodeModel getNode();

        public void apply(SelectionTargetVisitor var1);
    }

    public static interface SelectionTargetVisitor {
        public void visitRowsetTarget(RowsetSelectionTarget var1);

        public void visitExpressionTarget(ValueSelectionTarget var1);
    }

    public record ValueSelectionTarget(SQLQueryValueExpression expression) implements SelectionTarget
    {
        @Override
        public SQLQueryNodeModel getNode() {
            return this.expression;
        }

        @Override
        public void apply(SelectionTargetVisitor visitor) {
            visitor.visitExpressionTarget(this);
        }
    }
}

