/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateAccountSettings struct for UpdateAccountSettings
type UpdateAccountSettings struct {
	// Address
	Address *string `json:"address,omitempty"`
	// A default list of comma-separated CIDR block that are allowed to authenticate.
	BoundIps *[]string `json:"bound-ips,omitempty"`
	// City
	City *string `json:"city,omitempty"`
	// Company name
	CompanyName *string `json:"company-name,omitempty"`
	// Country
	Country *string `json:"country,omitempty"`
	// Set the account default key based on the DFC key name. Use \"set-original-akeyless-default-key\" to revert to using the original default key of the account.
	DefaultKeyName *string `json:"default-key-name,omitempty"`
	// Set the default ttl in minutes for sharing item number between 60 and 43200
	DefaultShareLinkTtlMinutes *string `json:"default-share-link-ttl-minutes,omitempty"`
	// If set to true, new versions is enabled by default
	DefaultVersioning *string `json:"default-versioning,omitempty"`
	// Set to update protection with classic keys state [true/false]
	DpEnableClassicKeyProtection *string `json:"dp-enable-classic-key-protection,omitempty"`
	// Set the maximum ttl for dynamic secrets
	DynamicSecretMaxTtl *int64 `json:"dynamic-secret-max-ttl,omitempty"`
	// Set a maximum ttl for dynamic secrets [true/false]
	DynamicSecretMaxTtlEnable *string `json:"dynamic-secret-max-ttl-enable,omitempty"`
	// Enable sharing items [true/false]
	EnableItemSharing *string `json:"enable-item-sharing,omitempty"`
	// Enable password expiration policy [true/false]
	EnablePasswordExpiration *string `json:"enable-password-expiration,omitempty"`
	// If set to true, new version will be created on update
	ForceNewVersions *string `json:"force-new-versions,omitempty"`
	// A default list of comma-separated CIDR block that acts as a trusted Gateway entity.
	GwBoundIps *[]string `json:"gw-bound-ips,omitempty"`
	// Characters that cannot be used for items/targets/roles/auths/event_forwarder names. Empty string will enforce nothing.
	InvalidCharacters *string `json:"invalid-characters,omitempty"`
	// VersionSettingsObjectType defines object types for account version settings
	ItemType *string `json:"item-type,omitempty"`
	// Set or unset the default behaviour of items deletion protection [true/false]
	ItemsDeletionProtection *string `json:"items-deletion-protection,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Default ttl
	JwtTtlDefault *int64 `json:"jwt-ttl-default,omitempty"`
	// Maximum ttl
	JwtTtlMax *int64 `json:"jwt-ttl-max,omitempty"`
	// Minimum ttl
	JwtTtlMin *int64 `json:"jwt-ttl-min,omitempty"`
	// Lock bound-ips setting globally in the account.
	LockBoundIps *string `json:"lock-bound-ips,omitempty"`
	// Lock the account's default protection key, if set - users will not be able to use a different protection key, relevant only if default-key-name is configured [true/false]
	LockDefaultKey *string `json:"lock-default-key,omitempty"`
	// Lock gw-bound-ips setting in the account.
	LockGwBoundIps *string `json:"lock-gw-bound-ips,omitempty"`
	// Set the maximum rotation interval for rotated secrets auto rotation settings
	MaxRotationInterval *int32 `json:"max-rotation-interval,omitempty"`
	// Set a maximum rotation interval for rotated secrets auto rotation settings [true/false]
	MaxRotationIntervalEnable *string `json:"max-rotation-interval-enable,omitempty"`
	// Max versions
	MaxVersions *string `json:"max-versions,omitempty"`
	// Specifies the number of days that a password is valid before it must be changed. A default value of 90 days is used.
	PasswordExpirationDays *string `json:"password-expiration-days,omitempty"`
	// Specifies the number of days before a user receives notification that their password will expire. A default value of 14 days is used.
	PasswordExpirationNotificationDays *string `json:"password-expiration-notification-days,omitempty"`
	// Password length between 5 - to 50 characters
	PasswordLength *int64 `json:"password-length,omitempty"`
	// Phone number
	Phone *string `json:"phone,omitempty"`
	// Postal code
	PostalCode *string `json:"postal-code,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Enable event for objects that have not been used or changed [true/false]
	UsageEventEnable *string `json:"usage-event-enable,omitempty"`
	// Interval by days for unused objects. Default and minimum interval is 90 days
	UsageEventInterval *int64 `json:"usage-event-interval,omitempty"`
	// Usage event is supported for auth method or secrets-and-keys [auth/item]
	UsageEventObjectType *string `json:"usage-event-object-type,omitempty"`
	// Password must contain lower case letters [true/false]
	UseLowerLetters *string `json:"use-lower-letters,omitempty"`
	// Password must contain numbers [true/false]
	UseNumbers *string `json:"use-numbers,omitempty"`
	// Password must contain special characters [true/false]
	UseSpecialCharacters *string `json:"use-special-characters,omitempty"`
	// Password must contain capital letters [true/false]
	UseCapitalLetters *string `json:"use_capital-letters,omitempty"`
}

// NewUpdateAccountSettings instantiates a new UpdateAccountSettings object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateAccountSettings() *UpdateAccountSettings {
	this := UpdateAccountSettings{}
	var invalidCharacters string = "notReceivedInvalidCharacter"
	this.InvalidCharacters = &invalidCharacters
	var json bool = false
	this.Json = &json
	return &this
}

// NewUpdateAccountSettingsWithDefaults instantiates a new UpdateAccountSettings object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateAccountSettingsWithDefaults() *UpdateAccountSettings {
	this := UpdateAccountSettings{}
	var invalidCharacters string = "notReceivedInvalidCharacter"
	this.InvalidCharacters = &invalidCharacters
	var json bool = false
	this.Json = &json
	return &this
}

// GetAddress returns the Address field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetAddress() string {
	if o == nil || o.Address == nil {
		var ret string
		return ret
	}
	return *o.Address
}

// GetAddressOk returns a tuple with the Address field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetAddressOk() (*string, bool) {
	if o == nil || o.Address == nil {
		return nil, false
	}
	return o.Address, true
}

// HasAddress returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasAddress() bool {
	if o != nil && o.Address != nil {
		return true
	}

	return false
}

// SetAddress gets a reference to the given string and assigns it to the Address field.
func (o *UpdateAccountSettings) SetAddress(v string) {
	o.Address = &v
}

// GetBoundIps returns the BoundIps field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetBoundIps() []string {
	if o == nil || o.BoundIps == nil {
		var ret []string
		return ret
	}
	return *o.BoundIps
}

// GetBoundIpsOk returns a tuple with the BoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetBoundIpsOk() (*[]string, bool) {
	if o == nil || o.BoundIps == nil {
		return nil, false
	}
	return o.BoundIps, true
}

// HasBoundIps returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasBoundIps() bool {
	if o != nil && o.BoundIps != nil {
		return true
	}

	return false
}

// SetBoundIps gets a reference to the given []string and assigns it to the BoundIps field.
func (o *UpdateAccountSettings) SetBoundIps(v []string) {
	o.BoundIps = &v
}

// GetCity returns the City field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetCity() string {
	if o == nil || o.City == nil {
		var ret string
		return ret
	}
	return *o.City
}

// GetCityOk returns a tuple with the City field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetCityOk() (*string, bool) {
	if o == nil || o.City == nil {
		return nil, false
	}
	return o.City, true
}

// HasCity returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasCity() bool {
	if o != nil && o.City != nil {
		return true
	}

	return false
}

// SetCity gets a reference to the given string and assigns it to the City field.
func (o *UpdateAccountSettings) SetCity(v string) {
	o.City = &v
}

// GetCompanyName returns the CompanyName field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetCompanyName() string {
	if o == nil || o.CompanyName == nil {
		var ret string
		return ret
	}
	return *o.CompanyName
}

// GetCompanyNameOk returns a tuple with the CompanyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetCompanyNameOk() (*string, bool) {
	if o == nil || o.CompanyName == nil {
		return nil, false
	}
	return o.CompanyName, true
}

// HasCompanyName returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasCompanyName() bool {
	if o != nil && o.CompanyName != nil {
		return true
	}

	return false
}

// SetCompanyName gets a reference to the given string and assigns it to the CompanyName field.
func (o *UpdateAccountSettings) SetCompanyName(v string) {
	o.CompanyName = &v
}

// GetCountry returns the Country field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetCountry() string {
	if o == nil || o.Country == nil {
		var ret string
		return ret
	}
	return *o.Country
}

// GetCountryOk returns a tuple with the Country field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetCountryOk() (*string, bool) {
	if o == nil || o.Country == nil {
		return nil, false
	}
	return o.Country, true
}

// HasCountry returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasCountry() bool {
	if o != nil && o.Country != nil {
		return true
	}

	return false
}

// SetCountry gets a reference to the given string and assigns it to the Country field.
func (o *UpdateAccountSettings) SetCountry(v string) {
	o.Country = &v
}

// GetDefaultKeyName returns the DefaultKeyName field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetDefaultKeyName() string {
	if o == nil || o.DefaultKeyName == nil {
		var ret string
		return ret
	}
	return *o.DefaultKeyName
}

// GetDefaultKeyNameOk returns a tuple with the DefaultKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetDefaultKeyNameOk() (*string, bool) {
	if o == nil || o.DefaultKeyName == nil {
		return nil, false
	}
	return o.DefaultKeyName, true
}

// HasDefaultKeyName returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasDefaultKeyName() bool {
	if o != nil && o.DefaultKeyName != nil {
		return true
	}

	return false
}

// SetDefaultKeyName gets a reference to the given string and assigns it to the DefaultKeyName field.
func (o *UpdateAccountSettings) SetDefaultKeyName(v string) {
	o.DefaultKeyName = &v
}

// GetDefaultShareLinkTtlMinutes returns the DefaultShareLinkTtlMinutes field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetDefaultShareLinkTtlMinutes() string {
	if o == nil || o.DefaultShareLinkTtlMinutes == nil {
		var ret string
		return ret
	}
	return *o.DefaultShareLinkTtlMinutes
}

// GetDefaultShareLinkTtlMinutesOk returns a tuple with the DefaultShareLinkTtlMinutes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetDefaultShareLinkTtlMinutesOk() (*string, bool) {
	if o == nil || o.DefaultShareLinkTtlMinutes == nil {
		return nil, false
	}
	return o.DefaultShareLinkTtlMinutes, true
}

// HasDefaultShareLinkTtlMinutes returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasDefaultShareLinkTtlMinutes() bool {
	if o != nil && o.DefaultShareLinkTtlMinutes != nil {
		return true
	}

	return false
}

// SetDefaultShareLinkTtlMinutes gets a reference to the given string and assigns it to the DefaultShareLinkTtlMinutes field.
func (o *UpdateAccountSettings) SetDefaultShareLinkTtlMinutes(v string) {
	o.DefaultShareLinkTtlMinutes = &v
}

// GetDefaultVersioning returns the DefaultVersioning field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetDefaultVersioning() string {
	if o == nil || o.DefaultVersioning == nil {
		var ret string
		return ret
	}
	return *o.DefaultVersioning
}

// GetDefaultVersioningOk returns a tuple with the DefaultVersioning field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetDefaultVersioningOk() (*string, bool) {
	if o == nil || o.DefaultVersioning == nil {
		return nil, false
	}
	return o.DefaultVersioning, true
}

// HasDefaultVersioning returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasDefaultVersioning() bool {
	if o != nil && o.DefaultVersioning != nil {
		return true
	}

	return false
}

// SetDefaultVersioning gets a reference to the given string and assigns it to the DefaultVersioning field.
func (o *UpdateAccountSettings) SetDefaultVersioning(v string) {
	o.DefaultVersioning = &v
}

// GetDpEnableClassicKeyProtection returns the DpEnableClassicKeyProtection field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetDpEnableClassicKeyProtection() string {
	if o == nil || o.DpEnableClassicKeyProtection == nil {
		var ret string
		return ret
	}
	return *o.DpEnableClassicKeyProtection
}

// GetDpEnableClassicKeyProtectionOk returns a tuple with the DpEnableClassicKeyProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetDpEnableClassicKeyProtectionOk() (*string, bool) {
	if o == nil || o.DpEnableClassicKeyProtection == nil {
		return nil, false
	}
	return o.DpEnableClassicKeyProtection, true
}

// HasDpEnableClassicKeyProtection returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasDpEnableClassicKeyProtection() bool {
	if o != nil && o.DpEnableClassicKeyProtection != nil {
		return true
	}

	return false
}

// SetDpEnableClassicKeyProtection gets a reference to the given string and assigns it to the DpEnableClassicKeyProtection field.
func (o *UpdateAccountSettings) SetDpEnableClassicKeyProtection(v string) {
	o.DpEnableClassicKeyProtection = &v
}

// GetDynamicSecretMaxTtl returns the DynamicSecretMaxTtl field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetDynamicSecretMaxTtl() int64 {
	if o == nil || o.DynamicSecretMaxTtl == nil {
		var ret int64
		return ret
	}
	return *o.DynamicSecretMaxTtl
}

// GetDynamicSecretMaxTtlOk returns a tuple with the DynamicSecretMaxTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetDynamicSecretMaxTtlOk() (*int64, bool) {
	if o == nil || o.DynamicSecretMaxTtl == nil {
		return nil, false
	}
	return o.DynamicSecretMaxTtl, true
}

// HasDynamicSecretMaxTtl returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasDynamicSecretMaxTtl() bool {
	if o != nil && o.DynamicSecretMaxTtl != nil {
		return true
	}

	return false
}

// SetDynamicSecretMaxTtl gets a reference to the given int64 and assigns it to the DynamicSecretMaxTtl field.
func (o *UpdateAccountSettings) SetDynamicSecretMaxTtl(v int64) {
	o.DynamicSecretMaxTtl = &v
}

// GetDynamicSecretMaxTtlEnable returns the DynamicSecretMaxTtlEnable field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetDynamicSecretMaxTtlEnable() string {
	if o == nil || o.DynamicSecretMaxTtlEnable == nil {
		var ret string
		return ret
	}
	return *o.DynamicSecretMaxTtlEnable
}

// GetDynamicSecretMaxTtlEnableOk returns a tuple with the DynamicSecretMaxTtlEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetDynamicSecretMaxTtlEnableOk() (*string, bool) {
	if o == nil || o.DynamicSecretMaxTtlEnable == nil {
		return nil, false
	}
	return o.DynamicSecretMaxTtlEnable, true
}

// HasDynamicSecretMaxTtlEnable returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasDynamicSecretMaxTtlEnable() bool {
	if o != nil && o.DynamicSecretMaxTtlEnable != nil {
		return true
	}

	return false
}

// SetDynamicSecretMaxTtlEnable gets a reference to the given string and assigns it to the DynamicSecretMaxTtlEnable field.
func (o *UpdateAccountSettings) SetDynamicSecretMaxTtlEnable(v string) {
	o.DynamicSecretMaxTtlEnable = &v
}

// GetEnableItemSharing returns the EnableItemSharing field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetEnableItemSharing() string {
	if o == nil || o.EnableItemSharing == nil {
		var ret string
		return ret
	}
	return *o.EnableItemSharing
}

// GetEnableItemSharingOk returns a tuple with the EnableItemSharing field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetEnableItemSharingOk() (*string, bool) {
	if o == nil || o.EnableItemSharing == nil {
		return nil, false
	}
	return o.EnableItemSharing, true
}

// HasEnableItemSharing returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasEnableItemSharing() bool {
	if o != nil && o.EnableItemSharing != nil {
		return true
	}

	return false
}

// SetEnableItemSharing gets a reference to the given string and assigns it to the EnableItemSharing field.
func (o *UpdateAccountSettings) SetEnableItemSharing(v string) {
	o.EnableItemSharing = &v
}

// GetEnablePasswordExpiration returns the EnablePasswordExpiration field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetEnablePasswordExpiration() string {
	if o == nil || o.EnablePasswordExpiration == nil {
		var ret string
		return ret
	}
	return *o.EnablePasswordExpiration
}

// GetEnablePasswordExpirationOk returns a tuple with the EnablePasswordExpiration field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetEnablePasswordExpirationOk() (*string, bool) {
	if o == nil || o.EnablePasswordExpiration == nil {
		return nil, false
	}
	return o.EnablePasswordExpiration, true
}

// HasEnablePasswordExpiration returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasEnablePasswordExpiration() bool {
	if o != nil && o.EnablePasswordExpiration != nil {
		return true
	}

	return false
}

// SetEnablePasswordExpiration gets a reference to the given string and assigns it to the EnablePasswordExpiration field.
func (o *UpdateAccountSettings) SetEnablePasswordExpiration(v string) {
	o.EnablePasswordExpiration = &v
}

// GetForceNewVersions returns the ForceNewVersions field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetForceNewVersions() string {
	if o == nil || o.ForceNewVersions == nil {
		var ret string
		return ret
	}
	return *o.ForceNewVersions
}

// GetForceNewVersionsOk returns a tuple with the ForceNewVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetForceNewVersionsOk() (*string, bool) {
	if o == nil || o.ForceNewVersions == nil {
		return nil, false
	}
	return o.ForceNewVersions, true
}

// HasForceNewVersions returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasForceNewVersions() bool {
	if o != nil && o.ForceNewVersions != nil {
		return true
	}

	return false
}

// SetForceNewVersions gets a reference to the given string and assigns it to the ForceNewVersions field.
func (o *UpdateAccountSettings) SetForceNewVersions(v string) {
	o.ForceNewVersions = &v
}

// GetGwBoundIps returns the GwBoundIps field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetGwBoundIps() []string {
	if o == nil || o.GwBoundIps == nil {
		var ret []string
		return ret
	}
	return *o.GwBoundIps
}

// GetGwBoundIpsOk returns a tuple with the GwBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetGwBoundIpsOk() (*[]string, bool) {
	if o == nil || o.GwBoundIps == nil {
		return nil, false
	}
	return o.GwBoundIps, true
}

// HasGwBoundIps returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasGwBoundIps() bool {
	if o != nil && o.GwBoundIps != nil {
		return true
	}

	return false
}

// SetGwBoundIps gets a reference to the given []string and assigns it to the GwBoundIps field.
func (o *UpdateAccountSettings) SetGwBoundIps(v []string) {
	o.GwBoundIps = &v
}

// GetInvalidCharacters returns the InvalidCharacters field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetInvalidCharacters() string {
	if o == nil || o.InvalidCharacters == nil {
		var ret string
		return ret
	}
	return *o.InvalidCharacters
}

// GetInvalidCharactersOk returns a tuple with the InvalidCharacters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetInvalidCharactersOk() (*string, bool) {
	if o == nil || o.InvalidCharacters == nil {
		return nil, false
	}
	return o.InvalidCharacters, true
}

// HasInvalidCharacters returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasInvalidCharacters() bool {
	if o != nil && o.InvalidCharacters != nil {
		return true
	}

	return false
}

// SetInvalidCharacters gets a reference to the given string and assigns it to the InvalidCharacters field.
func (o *UpdateAccountSettings) SetInvalidCharacters(v string) {
	o.InvalidCharacters = &v
}

// GetItemType returns the ItemType field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetItemType() string {
	if o == nil || o.ItemType == nil {
		var ret string
		return ret
	}
	return *o.ItemType
}

// GetItemTypeOk returns a tuple with the ItemType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetItemTypeOk() (*string, bool) {
	if o == nil || o.ItemType == nil {
		return nil, false
	}
	return o.ItemType, true
}

// HasItemType returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasItemType() bool {
	if o != nil && o.ItemType != nil {
		return true
	}

	return false
}

// SetItemType gets a reference to the given string and assigns it to the ItemType field.
func (o *UpdateAccountSettings) SetItemType(v string) {
	o.ItemType = &v
}

// GetItemsDeletionProtection returns the ItemsDeletionProtection field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetItemsDeletionProtection() string {
	if o == nil || o.ItemsDeletionProtection == nil {
		var ret string
		return ret
	}
	return *o.ItemsDeletionProtection
}

// GetItemsDeletionProtectionOk returns a tuple with the ItemsDeletionProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetItemsDeletionProtectionOk() (*string, bool) {
	if o == nil || o.ItemsDeletionProtection == nil {
		return nil, false
	}
	return o.ItemsDeletionProtection, true
}

// HasItemsDeletionProtection returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasItemsDeletionProtection() bool {
	if o != nil && o.ItemsDeletionProtection != nil {
		return true
	}

	return false
}

// SetItemsDeletionProtection gets a reference to the given string and assigns it to the ItemsDeletionProtection field.
func (o *UpdateAccountSettings) SetItemsDeletionProtection(v string) {
	o.ItemsDeletionProtection = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UpdateAccountSettings) SetJson(v bool) {
	o.Json = &v
}

// GetJwtTtlDefault returns the JwtTtlDefault field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetJwtTtlDefault() int64 {
	if o == nil || o.JwtTtlDefault == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtlDefault
}

// GetJwtTtlDefaultOk returns a tuple with the JwtTtlDefault field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetJwtTtlDefaultOk() (*int64, bool) {
	if o == nil || o.JwtTtlDefault == nil {
		return nil, false
	}
	return o.JwtTtlDefault, true
}

// HasJwtTtlDefault returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasJwtTtlDefault() bool {
	if o != nil && o.JwtTtlDefault != nil {
		return true
	}

	return false
}

// SetJwtTtlDefault gets a reference to the given int64 and assigns it to the JwtTtlDefault field.
func (o *UpdateAccountSettings) SetJwtTtlDefault(v int64) {
	o.JwtTtlDefault = &v
}

// GetJwtTtlMax returns the JwtTtlMax field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetJwtTtlMax() int64 {
	if o == nil || o.JwtTtlMax == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtlMax
}

// GetJwtTtlMaxOk returns a tuple with the JwtTtlMax field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetJwtTtlMaxOk() (*int64, bool) {
	if o == nil || o.JwtTtlMax == nil {
		return nil, false
	}
	return o.JwtTtlMax, true
}

// HasJwtTtlMax returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasJwtTtlMax() bool {
	if o != nil && o.JwtTtlMax != nil {
		return true
	}

	return false
}

// SetJwtTtlMax gets a reference to the given int64 and assigns it to the JwtTtlMax field.
func (o *UpdateAccountSettings) SetJwtTtlMax(v int64) {
	o.JwtTtlMax = &v
}

// GetJwtTtlMin returns the JwtTtlMin field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetJwtTtlMin() int64 {
	if o == nil || o.JwtTtlMin == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtlMin
}

// GetJwtTtlMinOk returns a tuple with the JwtTtlMin field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetJwtTtlMinOk() (*int64, bool) {
	if o == nil || o.JwtTtlMin == nil {
		return nil, false
	}
	return o.JwtTtlMin, true
}

// HasJwtTtlMin returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasJwtTtlMin() bool {
	if o != nil && o.JwtTtlMin != nil {
		return true
	}

	return false
}

// SetJwtTtlMin gets a reference to the given int64 and assigns it to the JwtTtlMin field.
func (o *UpdateAccountSettings) SetJwtTtlMin(v int64) {
	o.JwtTtlMin = &v
}

// GetLockBoundIps returns the LockBoundIps field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetLockBoundIps() string {
	if o == nil || o.LockBoundIps == nil {
		var ret string
		return ret
	}
	return *o.LockBoundIps
}

// GetLockBoundIpsOk returns a tuple with the LockBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetLockBoundIpsOk() (*string, bool) {
	if o == nil || o.LockBoundIps == nil {
		return nil, false
	}
	return o.LockBoundIps, true
}

// HasLockBoundIps returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasLockBoundIps() bool {
	if o != nil && o.LockBoundIps != nil {
		return true
	}

	return false
}

// SetLockBoundIps gets a reference to the given string and assigns it to the LockBoundIps field.
func (o *UpdateAccountSettings) SetLockBoundIps(v string) {
	o.LockBoundIps = &v
}

// GetLockDefaultKey returns the LockDefaultKey field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetLockDefaultKey() string {
	if o == nil || o.LockDefaultKey == nil {
		var ret string
		return ret
	}
	return *o.LockDefaultKey
}

// GetLockDefaultKeyOk returns a tuple with the LockDefaultKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetLockDefaultKeyOk() (*string, bool) {
	if o == nil || o.LockDefaultKey == nil {
		return nil, false
	}
	return o.LockDefaultKey, true
}

// HasLockDefaultKey returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasLockDefaultKey() bool {
	if o != nil && o.LockDefaultKey != nil {
		return true
	}

	return false
}

// SetLockDefaultKey gets a reference to the given string and assigns it to the LockDefaultKey field.
func (o *UpdateAccountSettings) SetLockDefaultKey(v string) {
	o.LockDefaultKey = &v
}

// GetLockGwBoundIps returns the LockGwBoundIps field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetLockGwBoundIps() string {
	if o == nil || o.LockGwBoundIps == nil {
		var ret string
		return ret
	}
	return *o.LockGwBoundIps
}

// GetLockGwBoundIpsOk returns a tuple with the LockGwBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetLockGwBoundIpsOk() (*string, bool) {
	if o == nil || o.LockGwBoundIps == nil {
		return nil, false
	}
	return o.LockGwBoundIps, true
}

// HasLockGwBoundIps returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasLockGwBoundIps() bool {
	if o != nil && o.LockGwBoundIps != nil {
		return true
	}

	return false
}

// SetLockGwBoundIps gets a reference to the given string and assigns it to the LockGwBoundIps field.
func (o *UpdateAccountSettings) SetLockGwBoundIps(v string) {
	o.LockGwBoundIps = &v
}

// GetMaxRotationInterval returns the MaxRotationInterval field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetMaxRotationInterval() int32 {
	if o == nil || o.MaxRotationInterval == nil {
		var ret int32
		return ret
	}
	return *o.MaxRotationInterval
}

// GetMaxRotationIntervalOk returns a tuple with the MaxRotationInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetMaxRotationIntervalOk() (*int32, bool) {
	if o == nil || o.MaxRotationInterval == nil {
		return nil, false
	}
	return o.MaxRotationInterval, true
}

// HasMaxRotationInterval returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasMaxRotationInterval() bool {
	if o != nil && o.MaxRotationInterval != nil {
		return true
	}

	return false
}

// SetMaxRotationInterval gets a reference to the given int32 and assigns it to the MaxRotationInterval field.
func (o *UpdateAccountSettings) SetMaxRotationInterval(v int32) {
	o.MaxRotationInterval = &v
}

// GetMaxRotationIntervalEnable returns the MaxRotationIntervalEnable field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetMaxRotationIntervalEnable() string {
	if o == nil || o.MaxRotationIntervalEnable == nil {
		var ret string
		return ret
	}
	return *o.MaxRotationIntervalEnable
}

// GetMaxRotationIntervalEnableOk returns a tuple with the MaxRotationIntervalEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetMaxRotationIntervalEnableOk() (*string, bool) {
	if o == nil || o.MaxRotationIntervalEnable == nil {
		return nil, false
	}
	return o.MaxRotationIntervalEnable, true
}

// HasMaxRotationIntervalEnable returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasMaxRotationIntervalEnable() bool {
	if o != nil && o.MaxRotationIntervalEnable != nil {
		return true
	}

	return false
}

// SetMaxRotationIntervalEnable gets a reference to the given string and assigns it to the MaxRotationIntervalEnable field.
func (o *UpdateAccountSettings) SetMaxRotationIntervalEnable(v string) {
	o.MaxRotationIntervalEnable = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *UpdateAccountSettings) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetPasswordExpirationDays returns the PasswordExpirationDays field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetPasswordExpirationDays() string {
	if o == nil || o.PasswordExpirationDays == nil {
		var ret string
		return ret
	}
	return *o.PasswordExpirationDays
}

// GetPasswordExpirationDaysOk returns a tuple with the PasswordExpirationDays field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetPasswordExpirationDaysOk() (*string, bool) {
	if o == nil || o.PasswordExpirationDays == nil {
		return nil, false
	}
	return o.PasswordExpirationDays, true
}

// HasPasswordExpirationDays returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasPasswordExpirationDays() bool {
	if o != nil && o.PasswordExpirationDays != nil {
		return true
	}

	return false
}

// SetPasswordExpirationDays gets a reference to the given string and assigns it to the PasswordExpirationDays field.
func (o *UpdateAccountSettings) SetPasswordExpirationDays(v string) {
	o.PasswordExpirationDays = &v
}

// GetPasswordExpirationNotificationDays returns the PasswordExpirationNotificationDays field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetPasswordExpirationNotificationDays() string {
	if o == nil || o.PasswordExpirationNotificationDays == nil {
		var ret string
		return ret
	}
	return *o.PasswordExpirationNotificationDays
}

// GetPasswordExpirationNotificationDaysOk returns a tuple with the PasswordExpirationNotificationDays field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetPasswordExpirationNotificationDaysOk() (*string, bool) {
	if o == nil || o.PasswordExpirationNotificationDays == nil {
		return nil, false
	}
	return o.PasswordExpirationNotificationDays, true
}

// HasPasswordExpirationNotificationDays returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasPasswordExpirationNotificationDays() bool {
	if o != nil && o.PasswordExpirationNotificationDays != nil {
		return true
	}

	return false
}

// SetPasswordExpirationNotificationDays gets a reference to the given string and assigns it to the PasswordExpirationNotificationDays field.
func (o *UpdateAccountSettings) SetPasswordExpirationNotificationDays(v string) {
	o.PasswordExpirationNotificationDays = &v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetPasswordLength() int64 {
	if o == nil || o.PasswordLength == nil {
		var ret int64
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetPasswordLengthOk() (*int64, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given int64 and assigns it to the PasswordLength field.
func (o *UpdateAccountSettings) SetPasswordLength(v int64) {
	o.PasswordLength = &v
}

// GetPhone returns the Phone field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetPhone() string {
	if o == nil || o.Phone == nil {
		var ret string
		return ret
	}
	return *o.Phone
}

// GetPhoneOk returns a tuple with the Phone field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetPhoneOk() (*string, bool) {
	if o == nil || o.Phone == nil {
		return nil, false
	}
	return o.Phone, true
}

// HasPhone returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasPhone() bool {
	if o != nil && o.Phone != nil {
		return true
	}

	return false
}

// SetPhone gets a reference to the given string and assigns it to the Phone field.
func (o *UpdateAccountSettings) SetPhone(v string) {
	o.Phone = &v
}

// GetPostalCode returns the PostalCode field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetPostalCode() string {
	if o == nil || o.PostalCode == nil {
		var ret string
		return ret
	}
	return *o.PostalCode
}

// GetPostalCodeOk returns a tuple with the PostalCode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetPostalCodeOk() (*string, bool) {
	if o == nil || o.PostalCode == nil {
		return nil, false
	}
	return o.PostalCode, true
}

// HasPostalCode returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasPostalCode() bool {
	if o != nil && o.PostalCode != nil {
		return true
	}

	return false
}

// SetPostalCode gets a reference to the given string and assigns it to the PostalCode field.
func (o *UpdateAccountSettings) SetPostalCode(v string) {
	o.PostalCode = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateAccountSettings) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateAccountSettings) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUsageEventEnable returns the UsageEventEnable field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetUsageEventEnable() string {
	if o == nil || o.UsageEventEnable == nil {
		var ret string
		return ret
	}
	return *o.UsageEventEnable
}

// GetUsageEventEnableOk returns a tuple with the UsageEventEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetUsageEventEnableOk() (*string, bool) {
	if o == nil || o.UsageEventEnable == nil {
		return nil, false
	}
	return o.UsageEventEnable, true
}

// HasUsageEventEnable returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasUsageEventEnable() bool {
	if o != nil && o.UsageEventEnable != nil {
		return true
	}

	return false
}

// SetUsageEventEnable gets a reference to the given string and assigns it to the UsageEventEnable field.
func (o *UpdateAccountSettings) SetUsageEventEnable(v string) {
	o.UsageEventEnable = &v
}

// GetUsageEventInterval returns the UsageEventInterval field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetUsageEventInterval() int64 {
	if o == nil || o.UsageEventInterval == nil {
		var ret int64
		return ret
	}
	return *o.UsageEventInterval
}

// GetUsageEventIntervalOk returns a tuple with the UsageEventInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetUsageEventIntervalOk() (*int64, bool) {
	if o == nil || o.UsageEventInterval == nil {
		return nil, false
	}
	return o.UsageEventInterval, true
}

// HasUsageEventInterval returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasUsageEventInterval() bool {
	if o != nil && o.UsageEventInterval != nil {
		return true
	}

	return false
}

// SetUsageEventInterval gets a reference to the given int64 and assigns it to the UsageEventInterval field.
func (o *UpdateAccountSettings) SetUsageEventInterval(v int64) {
	o.UsageEventInterval = &v
}

// GetUsageEventObjectType returns the UsageEventObjectType field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetUsageEventObjectType() string {
	if o == nil || o.UsageEventObjectType == nil {
		var ret string
		return ret
	}
	return *o.UsageEventObjectType
}

// GetUsageEventObjectTypeOk returns a tuple with the UsageEventObjectType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetUsageEventObjectTypeOk() (*string, bool) {
	if o == nil || o.UsageEventObjectType == nil {
		return nil, false
	}
	return o.UsageEventObjectType, true
}

// HasUsageEventObjectType returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasUsageEventObjectType() bool {
	if o != nil && o.UsageEventObjectType != nil {
		return true
	}

	return false
}

// SetUsageEventObjectType gets a reference to the given string and assigns it to the UsageEventObjectType field.
func (o *UpdateAccountSettings) SetUsageEventObjectType(v string) {
	o.UsageEventObjectType = &v
}

// GetUseLowerLetters returns the UseLowerLetters field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetUseLowerLetters() string {
	if o == nil || o.UseLowerLetters == nil {
		var ret string
		return ret
	}
	return *o.UseLowerLetters
}

// GetUseLowerLettersOk returns a tuple with the UseLowerLetters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetUseLowerLettersOk() (*string, bool) {
	if o == nil || o.UseLowerLetters == nil {
		return nil, false
	}
	return o.UseLowerLetters, true
}

// HasUseLowerLetters returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasUseLowerLetters() bool {
	if o != nil && o.UseLowerLetters != nil {
		return true
	}

	return false
}

// SetUseLowerLetters gets a reference to the given string and assigns it to the UseLowerLetters field.
func (o *UpdateAccountSettings) SetUseLowerLetters(v string) {
	o.UseLowerLetters = &v
}

// GetUseNumbers returns the UseNumbers field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetUseNumbers() string {
	if o == nil || o.UseNumbers == nil {
		var ret string
		return ret
	}
	return *o.UseNumbers
}

// GetUseNumbersOk returns a tuple with the UseNumbers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetUseNumbersOk() (*string, bool) {
	if o == nil || o.UseNumbers == nil {
		return nil, false
	}
	return o.UseNumbers, true
}

// HasUseNumbers returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasUseNumbers() bool {
	if o != nil && o.UseNumbers != nil {
		return true
	}

	return false
}

// SetUseNumbers gets a reference to the given string and assigns it to the UseNumbers field.
func (o *UpdateAccountSettings) SetUseNumbers(v string) {
	o.UseNumbers = &v
}

// GetUseSpecialCharacters returns the UseSpecialCharacters field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetUseSpecialCharacters() string {
	if o == nil || o.UseSpecialCharacters == nil {
		var ret string
		return ret
	}
	return *o.UseSpecialCharacters
}

// GetUseSpecialCharactersOk returns a tuple with the UseSpecialCharacters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetUseSpecialCharactersOk() (*string, bool) {
	if o == nil || o.UseSpecialCharacters == nil {
		return nil, false
	}
	return o.UseSpecialCharacters, true
}

// HasUseSpecialCharacters returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasUseSpecialCharacters() bool {
	if o != nil && o.UseSpecialCharacters != nil {
		return true
	}

	return false
}

// SetUseSpecialCharacters gets a reference to the given string and assigns it to the UseSpecialCharacters field.
func (o *UpdateAccountSettings) SetUseSpecialCharacters(v string) {
	o.UseSpecialCharacters = &v
}

// GetUseCapitalLetters returns the UseCapitalLetters field value if set, zero value otherwise.
func (o *UpdateAccountSettings) GetUseCapitalLetters() string {
	if o == nil || o.UseCapitalLetters == nil {
		var ret string
		return ret
	}
	return *o.UseCapitalLetters
}

// GetUseCapitalLettersOk returns a tuple with the UseCapitalLetters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateAccountSettings) GetUseCapitalLettersOk() (*string, bool) {
	if o == nil || o.UseCapitalLetters == nil {
		return nil, false
	}
	return o.UseCapitalLetters, true
}

// HasUseCapitalLetters returns a boolean if a field has been set.
func (o *UpdateAccountSettings) HasUseCapitalLetters() bool {
	if o != nil && o.UseCapitalLetters != nil {
		return true
	}

	return false
}

// SetUseCapitalLetters gets a reference to the given string and assigns it to the UseCapitalLetters field.
func (o *UpdateAccountSettings) SetUseCapitalLetters(v string) {
	o.UseCapitalLetters = &v
}

func (o UpdateAccountSettings) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Address != nil {
		toSerialize["address"] = o.Address
	}
	if o.BoundIps != nil {
		toSerialize["bound-ips"] = o.BoundIps
	}
	if o.City != nil {
		toSerialize["city"] = o.City
	}
	if o.CompanyName != nil {
		toSerialize["company-name"] = o.CompanyName
	}
	if o.Country != nil {
		toSerialize["country"] = o.Country
	}
	if o.DefaultKeyName != nil {
		toSerialize["default-key-name"] = o.DefaultKeyName
	}
	if o.DefaultShareLinkTtlMinutes != nil {
		toSerialize["default-share-link-ttl-minutes"] = o.DefaultShareLinkTtlMinutes
	}
	if o.DefaultVersioning != nil {
		toSerialize["default-versioning"] = o.DefaultVersioning
	}
	if o.DpEnableClassicKeyProtection != nil {
		toSerialize["dp-enable-classic-key-protection"] = o.DpEnableClassicKeyProtection
	}
	if o.DynamicSecretMaxTtl != nil {
		toSerialize["dynamic-secret-max-ttl"] = o.DynamicSecretMaxTtl
	}
	if o.DynamicSecretMaxTtlEnable != nil {
		toSerialize["dynamic-secret-max-ttl-enable"] = o.DynamicSecretMaxTtlEnable
	}
	if o.EnableItemSharing != nil {
		toSerialize["enable-item-sharing"] = o.EnableItemSharing
	}
	if o.EnablePasswordExpiration != nil {
		toSerialize["enable-password-expiration"] = o.EnablePasswordExpiration
	}
	if o.ForceNewVersions != nil {
		toSerialize["force-new-versions"] = o.ForceNewVersions
	}
	if o.GwBoundIps != nil {
		toSerialize["gw-bound-ips"] = o.GwBoundIps
	}
	if o.InvalidCharacters != nil {
		toSerialize["invalid-characters"] = o.InvalidCharacters
	}
	if o.ItemType != nil {
		toSerialize["item-type"] = o.ItemType
	}
	if o.ItemsDeletionProtection != nil {
		toSerialize["items-deletion-protection"] = o.ItemsDeletionProtection
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.JwtTtlDefault != nil {
		toSerialize["jwt-ttl-default"] = o.JwtTtlDefault
	}
	if o.JwtTtlMax != nil {
		toSerialize["jwt-ttl-max"] = o.JwtTtlMax
	}
	if o.JwtTtlMin != nil {
		toSerialize["jwt-ttl-min"] = o.JwtTtlMin
	}
	if o.LockBoundIps != nil {
		toSerialize["lock-bound-ips"] = o.LockBoundIps
	}
	if o.LockDefaultKey != nil {
		toSerialize["lock-default-key"] = o.LockDefaultKey
	}
	if o.LockGwBoundIps != nil {
		toSerialize["lock-gw-bound-ips"] = o.LockGwBoundIps
	}
	if o.MaxRotationInterval != nil {
		toSerialize["max-rotation-interval"] = o.MaxRotationInterval
	}
	if o.MaxRotationIntervalEnable != nil {
		toSerialize["max-rotation-interval-enable"] = o.MaxRotationIntervalEnable
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if o.PasswordExpirationDays != nil {
		toSerialize["password-expiration-days"] = o.PasswordExpirationDays
	}
	if o.PasswordExpirationNotificationDays != nil {
		toSerialize["password-expiration-notification-days"] = o.PasswordExpirationNotificationDays
	}
	if o.PasswordLength != nil {
		toSerialize["password-length"] = o.PasswordLength
	}
	if o.Phone != nil {
		toSerialize["phone"] = o.Phone
	}
	if o.PostalCode != nil {
		toSerialize["postal-code"] = o.PostalCode
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UsageEventEnable != nil {
		toSerialize["usage-event-enable"] = o.UsageEventEnable
	}
	if o.UsageEventInterval != nil {
		toSerialize["usage-event-interval"] = o.UsageEventInterval
	}
	if o.UsageEventObjectType != nil {
		toSerialize["usage-event-object-type"] = o.UsageEventObjectType
	}
	if o.UseLowerLetters != nil {
		toSerialize["use-lower-letters"] = o.UseLowerLetters
	}
	if o.UseNumbers != nil {
		toSerialize["use-numbers"] = o.UseNumbers
	}
	if o.UseSpecialCharacters != nil {
		toSerialize["use-special-characters"] = o.UseSpecialCharacters
	}
	if o.UseCapitalLetters != nil {
		toSerialize["use_capital-letters"] = o.UseCapitalLetters
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateAccountSettings struct {
	value *UpdateAccountSettings
	isSet bool
}

func (v NullableUpdateAccountSettings) Get() *UpdateAccountSettings {
	return v.value
}

func (v *NullableUpdateAccountSettings) Set(val *UpdateAccountSettings) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateAccountSettings) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateAccountSettings) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateAccountSettings(val *UpdateAccountSettings) *NullableUpdateAccountSettings {
	return &NullableUpdateAccountSettings{value: val, isSet: true}
}

func (v NullableUpdateAccountSettings) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateAccountSettings) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


