/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// RotateSecret struct for RotateSecret
type RotateSecret struct {
	RotateAllServicesBoolean *bool `json:"RotateAllServicesBoolean,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Secret name (Rotated Secret or Custom Dynamic Secret)
	Name string `json:"name"`
	// Rotate all associated services
	RotateAllServices *string `json:"rotate-all-services,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewRotateSecret instantiates a new RotateSecret object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRotateSecret(name string, ) *RotateSecret {
	this := RotateSecret{}
	var json bool = false
	this.Json = &json
	this.Name = name
	var rotateAllServices string = "false"
	this.RotateAllServices = &rotateAllServices
	return &this
}

// NewRotateSecretWithDefaults instantiates a new RotateSecret object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRotateSecretWithDefaults() *RotateSecret {
	this := RotateSecret{}
	var json bool = false
	this.Json = &json
	var rotateAllServices string = "false"
	this.RotateAllServices = &rotateAllServices
	return &this
}

// GetRotateAllServicesBoolean returns the RotateAllServicesBoolean field value if set, zero value otherwise.
func (o *RotateSecret) GetRotateAllServicesBoolean() bool {
	if o == nil || o.RotateAllServicesBoolean == nil {
		var ret bool
		return ret
	}
	return *o.RotateAllServicesBoolean
}

// GetRotateAllServicesBooleanOk returns a tuple with the RotateAllServicesBoolean field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotateSecret) GetRotateAllServicesBooleanOk() (*bool, bool) {
	if o == nil || o.RotateAllServicesBoolean == nil {
		return nil, false
	}
	return o.RotateAllServicesBoolean, true
}

// HasRotateAllServicesBoolean returns a boolean if a field has been set.
func (o *RotateSecret) HasRotateAllServicesBoolean() bool {
	if o != nil && o.RotateAllServicesBoolean != nil {
		return true
	}

	return false
}

// SetRotateAllServicesBoolean gets a reference to the given bool and assigns it to the RotateAllServicesBoolean field.
func (o *RotateSecret) SetRotateAllServicesBoolean(v bool) {
	o.RotateAllServicesBoolean = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *RotateSecret) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotateSecret) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *RotateSecret) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *RotateSecret) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *RotateSecret) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *RotateSecret) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *RotateSecret) SetName(v string) {
	o.Name = v
}

// GetRotateAllServices returns the RotateAllServices field value if set, zero value otherwise.
func (o *RotateSecret) GetRotateAllServices() string {
	if o == nil || o.RotateAllServices == nil {
		var ret string
		return ret
	}
	return *o.RotateAllServices
}

// GetRotateAllServicesOk returns a tuple with the RotateAllServices field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotateSecret) GetRotateAllServicesOk() (*string, bool) {
	if o == nil || o.RotateAllServices == nil {
		return nil, false
	}
	return o.RotateAllServices, true
}

// HasRotateAllServices returns a boolean if a field has been set.
func (o *RotateSecret) HasRotateAllServices() bool {
	if o != nil && o.RotateAllServices != nil {
		return true
	}

	return false
}

// SetRotateAllServices gets a reference to the given string and assigns it to the RotateAllServices field.
func (o *RotateSecret) SetRotateAllServices(v string) {
	o.RotateAllServices = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *RotateSecret) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotateSecret) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *RotateSecret) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *RotateSecret) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *RotateSecret) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotateSecret) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *RotateSecret) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *RotateSecret) SetUidToken(v string) {
	o.UidToken = &v
}

func (o RotateSecret) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.RotateAllServicesBoolean != nil {
		toSerialize["RotateAllServicesBoolean"] = o.RotateAllServicesBoolean
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.RotateAllServices != nil {
		toSerialize["rotate-all-services"] = o.RotateAllServices
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableRotateSecret struct {
	value *RotateSecret
	isSet bool
}

func (v NullableRotateSecret) Get() *RotateSecret {
	return v.value
}

func (v *NullableRotateSecret) Set(val *RotateSecret) {
	v.value = val
	v.isSet = true
}

func (v NullableRotateSecret) IsSet() bool {
	return v.isSet
}

func (v *NullableRotateSecret) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRotateSecret(val *RotateSecret) *NullableRotateSecret {
	return &NullableRotateSecret{value: val, isSet: true}
}

func (v NullableRotateSecret) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRotateSecret) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


