/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// Name Name represents an X.509 distinguished name. This only includes the common elements of a DN. Note that Name is only an approximation of the X.509 structure. If an accurate representation is needed, asn1.Unmarshal the raw subject or issuer as an RDNSequence.
type Name struct {
	Country *[]string `json:"Country,omitempty"`
	// ExtraNames contains attributes to be copied, raw, into any marshaled distinguished names. Values override any attributes with the same OID. The ExtraNames field is not populated when parsing, see Names.
	ExtraNames *[]AttributeTypeAndValue `json:"ExtraNames,omitempty"`
	Locality *[]string `json:"Locality,omitempty"`
	// Names contains all parsed attributes. When parsing distinguished names, this can be used to extract non-standard attributes that are not parsed by this package. When marshaling to RDNSequences, the Names field is ignored, see ExtraNames.
	Names *[]AttributeTypeAndValue `json:"Names,omitempty"`
	SerialNumber *string `json:"SerialNumber,omitempty"`
	StreetAddress *[]string `json:"StreetAddress,omitempty"`
}

// NewName instantiates a new Name object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewName() *Name {
	this := Name{}
	return &this
}

// NewNameWithDefaults instantiates a new Name object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewNameWithDefaults() *Name {
	this := Name{}
	return &this
}

// GetCountry returns the Country field value if set, zero value otherwise.
func (o *Name) GetCountry() []string {
	if o == nil || o.Country == nil {
		var ret []string
		return ret
	}
	return *o.Country
}

// GetCountryOk returns a tuple with the Country field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Name) GetCountryOk() (*[]string, bool) {
	if o == nil || o.Country == nil {
		return nil, false
	}
	return o.Country, true
}

// HasCountry returns a boolean if a field has been set.
func (o *Name) HasCountry() bool {
	if o != nil && o.Country != nil {
		return true
	}

	return false
}

// SetCountry gets a reference to the given []string and assigns it to the Country field.
func (o *Name) SetCountry(v []string) {
	o.Country = &v
}

// GetExtraNames returns the ExtraNames field value if set, zero value otherwise.
func (o *Name) GetExtraNames() []AttributeTypeAndValue {
	if o == nil || o.ExtraNames == nil {
		var ret []AttributeTypeAndValue
		return ret
	}
	return *o.ExtraNames
}

// GetExtraNamesOk returns a tuple with the ExtraNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Name) GetExtraNamesOk() (*[]AttributeTypeAndValue, bool) {
	if o == nil || o.ExtraNames == nil {
		return nil, false
	}
	return o.ExtraNames, true
}

// HasExtraNames returns a boolean if a field has been set.
func (o *Name) HasExtraNames() bool {
	if o != nil && o.ExtraNames != nil {
		return true
	}

	return false
}

// SetExtraNames gets a reference to the given []AttributeTypeAndValue and assigns it to the ExtraNames field.
func (o *Name) SetExtraNames(v []AttributeTypeAndValue) {
	o.ExtraNames = &v
}

// GetLocality returns the Locality field value if set, zero value otherwise.
func (o *Name) GetLocality() []string {
	if o == nil || o.Locality == nil {
		var ret []string
		return ret
	}
	return *o.Locality
}

// GetLocalityOk returns a tuple with the Locality field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Name) GetLocalityOk() (*[]string, bool) {
	if o == nil || o.Locality == nil {
		return nil, false
	}
	return o.Locality, true
}

// HasLocality returns a boolean if a field has been set.
func (o *Name) HasLocality() bool {
	if o != nil && o.Locality != nil {
		return true
	}

	return false
}

// SetLocality gets a reference to the given []string and assigns it to the Locality field.
func (o *Name) SetLocality(v []string) {
	o.Locality = &v
}

// GetNames returns the Names field value if set, zero value otherwise.
func (o *Name) GetNames() []AttributeTypeAndValue {
	if o == nil || o.Names == nil {
		var ret []AttributeTypeAndValue
		return ret
	}
	return *o.Names
}

// GetNamesOk returns a tuple with the Names field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Name) GetNamesOk() (*[]AttributeTypeAndValue, bool) {
	if o == nil || o.Names == nil {
		return nil, false
	}
	return o.Names, true
}

// HasNames returns a boolean if a field has been set.
func (o *Name) HasNames() bool {
	if o != nil && o.Names != nil {
		return true
	}

	return false
}

// SetNames gets a reference to the given []AttributeTypeAndValue and assigns it to the Names field.
func (o *Name) SetNames(v []AttributeTypeAndValue) {
	o.Names = &v
}

// GetSerialNumber returns the SerialNumber field value if set, zero value otherwise.
func (o *Name) GetSerialNumber() string {
	if o == nil || o.SerialNumber == nil {
		var ret string
		return ret
	}
	return *o.SerialNumber
}

// GetSerialNumberOk returns a tuple with the SerialNumber field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Name) GetSerialNumberOk() (*string, bool) {
	if o == nil || o.SerialNumber == nil {
		return nil, false
	}
	return o.SerialNumber, true
}

// HasSerialNumber returns a boolean if a field has been set.
func (o *Name) HasSerialNumber() bool {
	if o != nil && o.SerialNumber != nil {
		return true
	}

	return false
}

// SetSerialNumber gets a reference to the given string and assigns it to the SerialNumber field.
func (o *Name) SetSerialNumber(v string) {
	o.SerialNumber = &v
}

// GetStreetAddress returns the StreetAddress field value if set, zero value otherwise.
func (o *Name) GetStreetAddress() []string {
	if o == nil || o.StreetAddress == nil {
		var ret []string
		return ret
	}
	return *o.StreetAddress
}

// GetStreetAddressOk returns a tuple with the StreetAddress field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Name) GetStreetAddressOk() (*[]string, bool) {
	if o == nil || o.StreetAddress == nil {
		return nil, false
	}
	return o.StreetAddress, true
}

// HasStreetAddress returns a boolean if a field has been set.
func (o *Name) HasStreetAddress() bool {
	if o != nil && o.StreetAddress != nil {
		return true
	}

	return false
}

// SetStreetAddress gets a reference to the given []string and assigns it to the StreetAddress field.
func (o *Name) SetStreetAddress(v []string) {
	o.StreetAddress = &v
}

func (o Name) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Country != nil {
		toSerialize["Country"] = o.Country
	}
	if o.ExtraNames != nil {
		toSerialize["ExtraNames"] = o.ExtraNames
	}
	if o.Locality != nil {
		toSerialize["Locality"] = o.Locality
	}
	if o.Names != nil {
		toSerialize["Names"] = o.Names
	}
	if o.SerialNumber != nil {
		toSerialize["SerialNumber"] = o.SerialNumber
	}
	if o.StreetAddress != nil {
		toSerialize["StreetAddress"] = o.StreetAddress
	}
	return json.Marshal(toSerialize)
}

type NullableName struct {
	value *Name
	isSet bool
}

func (v NullableName) Get() *Name {
	return v.value
}

func (v *NullableName) Set(val *Name) {
	v.value = val
	v.isSet = true
}

func (v NullableName) IsSet() bool {
	return v.isSet
}

func (v *NullableName) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableName(val *Name) *NullableName {
	return &NullableName{value: val, isSet: true}
}

func (v NullableName) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableName) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


