/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GenerateCsr struct for GenerateCsr
type GenerateCsr struct {
	Alg *string `json:"alg,omitempty"`
	// A comma-separated list of dns alternative names
	AltNames *string `json:"alt-names,omitempty"`
	// The certificate type to be included in the CSR certificate (ssl-client/ssl-server/certificate-signing)
	CertificateType *string `json:"certificate-type,omitempty"`
	// The city to be included in the CSR certificate
	City *string `json:"city,omitempty"`
	// The common name to be included in the CSR certificate
	CommonName string `json:"common-name"`
	// The country to be included in the CSR certificate
	Country *string `json:"country,omitempty"`
	// Add critical to the key usage extension (will be false if not added)
	Critical *bool `json:"critical,omitempty"`
	// The department to be included in the CSR certificate
	Dep *string `json:"dep,omitempty"`
	// A comma-separated list of email addresses alternative names
	EmailAddresses *string `json:"email-addresses,omitempty"`
	// The flag to indicate if the private key should be exported
	ExportPrivateKey *bool `json:"export-private-key,omitempty"`
	// Generate a new classic key for the csr
	GenerateKey *bool `json:"generate-key,omitempty"`
	// A comma-separated list of ip addresses alternative names
	IpAddresses *string `json:"ip-addresses,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The type of the key to generate (classic-key/dfc)
	KeyType string `json:"key-type"`
	// The key name
	Name string `json:"name"`
	// The organization to be included in the CSR certificate
	Org *string `json:"org,omitempty"`
	// The number of fragments that the item will be split into (not includes customer fragment)
	SplitLevel *int64 `json:"split-level,omitempty"`
	// The state to be included in the CSR certificate
	State *string `json:"state,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// A comma-separated list of uri alternative names
	UriSans *string `json:"uri-sans,omitempty"`
}

// NewGenerateCsr instantiates a new GenerateCsr object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGenerateCsr(commonName string, keyType string, name string, ) *GenerateCsr {
	this := GenerateCsr{}
	this.CommonName = commonName
	var exportPrivateKey bool = false
	this.ExportPrivateKey = &exportPrivateKey
	var json bool = false
	this.Json = &json
	this.KeyType = keyType
	this.Name = name
	var splitLevel int64 = 3
	this.SplitLevel = &splitLevel
	return &this
}

// NewGenerateCsrWithDefaults instantiates a new GenerateCsr object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGenerateCsrWithDefaults() *GenerateCsr {
	this := GenerateCsr{}
	var exportPrivateKey bool = false
	this.ExportPrivateKey = &exportPrivateKey
	var json bool = false
	this.Json = &json
	var keyType string = "classic-key"
	this.KeyType = keyType
	var splitLevel int64 = 3
	this.SplitLevel = &splitLevel
	return &this
}

// GetAlg returns the Alg field value if set, zero value otherwise.
func (o *GenerateCsr) GetAlg() string {
	if o == nil || o.Alg == nil {
		var ret string
		return ret
	}
	return *o.Alg
}

// GetAlgOk returns a tuple with the Alg field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetAlgOk() (*string, bool) {
	if o == nil || o.Alg == nil {
		return nil, false
	}
	return o.Alg, true
}

// HasAlg returns a boolean if a field has been set.
func (o *GenerateCsr) HasAlg() bool {
	if o != nil && o.Alg != nil {
		return true
	}

	return false
}

// SetAlg gets a reference to the given string and assigns it to the Alg field.
func (o *GenerateCsr) SetAlg(v string) {
	o.Alg = &v
}

// GetAltNames returns the AltNames field value if set, zero value otherwise.
func (o *GenerateCsr) GetAltNames() string {
	if o == nil || o.AltNames == nil {
		var ret string
		return ret
	}
	return *o.AltNames
}

// GetAltNamesOk returns a tuple with the AltNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetAltNamesOk() (*string, bool) {
	if o == nil || o.AltNames == nil {
		return nil, false
	}
	return o.AltNames, true
}

// HasAltNames returns a boolean if a field has been set.
func (o *GenerateCsr) HasAltNames() bool {
	if o != nil && o.AltNames != nil {
		return true
	}

	return false
}

// SetAltNames gets a reference to the given string and assigns it to the AltNames field.
func (o *GenerateCsr) SetAltNames(v string) {
	o.AltNames = &v
}

// GetCertificateType returns the CertificateType field value if set, zero value otherwise.
func (o *GenerateCsr) GetCertificateType() string {
	if o == nil || o.CertificateType == nil {
		var ret string
		return ret
	}
	return *o.CertificateType
}

// GetCertificateTypeOk returns a tuple with the CertificateType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetCertificateTypeOk() (*string, bool) {
	if o == nil || o.CertificateType == nil {
		return nil, false
	}
	return o.CertificateType, true
}

// HasCertificateType returns a boolean if a field has been set.
func (o *GenerateCsr) HasCertificateType() bool {
	if o != nil && o.CertificateType != nil {
		return true
	}

	return false
}

// SetCertificateType gets a reference to the given string and assigns it to the CertificateType field.
func (o *GenerateCsr) SetCertificateType(v string) {
	o.CertificateType = &v
}

// GetCity returns the City field value if set, zero value otherwise.
func (o *GenerateCsr) GetCity() string {
	if o == nil || o.City == nil {
		var ret string
		return ret
	}
	return *o.City
}

// GetCityOk returns a tuple with the City field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetCityOk() (*string, bool) {
	if o == nil || o.City == nil {
		return nil, false
	}
	return o.City, true
}

// HasCity returns a boolean if a field has been set.
func (o *GenerateCsr) HasCity() bool {
	if o != nil && o.City != nil {
		return true
	}

	return false
}

// SetCity gets a reference to the given string and assigns it to the City field.
func (o *GenerateCsr) SetCity(v string) {
	o.City = &v
}

// GetCommonName returns the CommonName field value
func (o *GenerateCsr) GetCommonName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.CommonName
}

// GetCommonNameOk returns a tuple with the CommonName field value
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetCommonNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.CommonName, true
}

// SetCommonName sets field value
func (o *GenerateCsr) SetCommonName(v string) {
	o.CommonName = v
}

// GetCountry returns the Country field value if set, zero value otherwise.
func (o *GenerateCsr) GetCountry() string {
	if o == nil || o.Country == nil {
		var ret string
		return ret
	}
	return *o.Country
}

// GetCountryOk returns a tuple with the Country field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetCountryOk() (*string, bool) {
	if o == nil || o.Country == nil {
		return nil, false
	}
	return o.Country, true
}

// HasCountry returns a boolean if a field has been set.
func (o *GenerateCsr) HasCountry() bool {
	if o != nil && o.Country != nil {
		return true
	}

	return false
}

// SetCountry gets a reference to the given string and assigns it to the Country field.
func (o *GenerateCsr) SetCountry(v string) {
	o.Country = &v
}

// GetCritical returns the Critical field value if set, zero value otherwise.
func (o *GenerateCsr) GetCritical() bool {
	if o == nil || o.Critical == nil {
		var ret bool
		return ret
	}
	return *o.Critical
}

// GetCriticalOk returns a tuple with the Critical field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetCriticalOk() (*bool, bool) {
	if o == nil || o.Critical == nil {
		return nil, false
	}
	return o.Critical, true
}

// HasCritical returns a boolean if a field has been set.
func (o *GenerateCsr) HasCritical() bool {
	if o != nil && o.Critical != nil {
		return true
	}

	return false
}

// SetCritical gets a reference to the given bool and assigns it to the Critical field.
func (o *GenerateCsr) SetCritical(v bool) {
	o.Critical = &v
}

// GetDep returns the Dep field value if set, zero value otherwise.
func (o *GenerateCsr) GetDep() string {
	if o == nil || o.Dep == nil {
		var ret string
		return ret
	}
	return *o.Dep
}

// GetDepOk returns a tuple with the Dep field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetDepOk() (*string, bool) {
	if o == nil || o.Dep == nil {
		return nil, false
	}
	return o.Dep, true
}

// HasDep returns a boolean if a field has been set.
func (o *GenerateCsr) HasDep() bool {
	if o != nil && o.Dep != nil {
		return true
	}

	return false
}

// SetDep gets a reference to the given string and assigns it to the Dep field.
func (o *GenerateCsr) SetDep(v string) {
	o.Dep = &v
}

// GetEmailAddresses returns the EmailAddresses field value if set, zero value otherwise.
func (o *GenerateCsr) GetEmailAddresses() string {
	if o == nil || o.EmailAddresses == nil {
		var ret string
		return ret
	}
	return *o.EmailAddresses
}

// GetEmailAddressesOk returns a tuple with the EmailAddresses field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetEmailAddressesOk() (*string, bool) {
	if o == nil || o.EmailAddresses == nil {
		return nil, false
	}
	return o.EmailAddresses, true
}

// HasEmailAddresses returns a boolean if a field has been set.
func (o *GenerateCsr) HasEmailAddresses() bool {
	if o != nil && o.EmailAddresses != nil {
		return true
	}

	return false
}

// SetEmailAddresses gets a reference to the given string and assigns it to the EmailAddresses field.
func (o *GenerateCsr) SetEmailAddresses(v string) {
	o.EmailAddresses = &v
}

// GetExportPrivateKey returns the ExportPrivateKey field value if set, zero value otherwise.
func (o *GenerateCsr) GetExportPrivateKey() bool {
	if o == nil || o.ExportPrivateKey == nil {
		var ret bool
		return ret
	}
	return *o.ExportPrivateKey
}

// GetExportPrivateKeyOk returns a tuple with the ExportPrivateKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetExportPrivateKeyOk() (*bool, bool) {
	if o == nil || o.ExportPrivateKey == nil {
		return nil, false
	}
	return o.ExportPrivateKey, true
}

// HasExportPrivateKey returns a boolean if a field has been set.
func (o *GenerateCsr) HasExportPrivateKey() bool {
	if o != nil && o.ExportPrivateKey != nil {
		return true
	}

	return false
}

// SetExportPrivateKey gets a reference to the given bool and assigns it to the ExportPrivateKey field.
func (o *GenerateCsr) SetExportPrivateKey(v bool) {
	o.ExportPrivateKey = &v
}

// GetGenerateKey returns the GenerateKey field value if set, zero value otherwise.
func (o *GenerateCsr) GetGenerateKey() bool {
	if o == nil || o.GenerateKey == nil {
		var ret bool
		return ret
	}
	return *o.GenerateKey
}

// GetGenerateKeyOk returns a tuple with the GenerateKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetGenerateKeyOk() (*bool, bool) {
	if o == nil || o.GenerateKey == nil {
		return nil, false
	}
	return o.GenerateKey, true
}

// HasGenerateKey returns a boolean if a field has been set.
func (o *GenerateCsr) HasGenerateKey() bool {
	if o != nil && o.GenerateKey != nil {
		return true
	}

	return false
}

// SetGenerateKey gets a reference to the given bool and assigns it to the GenerateKey field.
func (o *GenerateCsr) SetGenerateKey(v bool) {
	o.GenerateKey = &v
}

// GetIpAddresses returns the IpAddresses field value if set, zero value otherwise.
func (o *GenerateCsr) GetIpAddresses() string {
	if o == nil || o.IpAddresses == nil {
		var ret string
		return ret
	}
	return *o.IpAddresses
}

// GetIpAddressesOk returns a tuple with the IpAddresses field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetIpAddressesOk() (*string, bool) {
	if o == nil || o.IpAddresses == nil {
		return nil, false
	}
	return o.IpAddresses, true
}

// HasIpAddresses returns a boolean if a field has been set.
func (o *GenerateCsr) HasIpAddresses() bool {
	if o != nil && o.IpAddresses != nil {
		return true
	}

	return false
}

// SetIpAddresses gets a reference to the given string and assigns it to the IpAddresses field.
func (o *GenerateCsr) SetIpAddresses(v string) {
	o.IpAddresses = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GenerateCsr) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GenerateCsr) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GenerateCsr) SetJson(v bool) {
	o.Json = &v
}

// GetKeyType returns the KeyType field value
func (o *GenerateCsr) GetKeyType() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.KeyType
}

// GetKeyTypeOk returns a tuple with the KeyType field value
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetKeyTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.KeyType, true
}

// SetKeyType sets field value
func (o *GenerateCsr) SetKeyType(v string) {
	o.KeyType = v
}

// GetName returns the Name field value
func (o *GenerateCsr) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *GenerateCsr) SetName(v string) {
	o.Name = v
}

// GetOrg returns the Org field value if set, zero value otherwise.
func (o *GenerateCsr) GetOrg() string {
	if o == nil || o.Org == nil {
		var ret string
		return ret
	}
	return *o.Org
}

// GetOrgOk returns a tuple with the Org field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetOrgOk() (*string, bool) {
	if o == nil || o.Org == nil {
		return nil, false
	}
	return o.Org, true
}

// HasOrg returns a boolean if a field has been set.
func (o *GenerateCsr) HasOrg() bool {
	if o != nil && o.Org != nil {
		return true
	}

	return false
}

// SetOrg gets a reference to the given string and assigns it to the Org field.
func (o *GenerateCsr) SetOrg(v string) {
	o.Org = &v
}

// GetSplitLevel returns the SplitLevel field value if set, zero value otherwise.
func (o *GenerateCsr) GetSplitLevel() int64 {
	if o == nil || o.SplitLevel == nil {
		var ret int64
		return ret
	}
	return *o.SplitLevel
}

// GetSplitLevelOk returns a tuple with the SplitLevel field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetSplitLevelOk() (*int64, bool) {
	if o == nil || o.SplitLevel == nil {
		return nil, false
	}
	return o.SplitLevel, true
}

// HasSplitLevel returns a boolean if a field has been set.
func (o *GenerateCsr) HasSplitLevel() bool {
	if o != nil && o.SplitLevel != nil {
		return true
	}

	return false
}

// SetSplitLevel gets a reference to the given int64 and assigns it to the SplitLevel field.
func (o *GenerateCsr) SetSplitLevel(v int64) {
	o.SplitLevel = &v
}

// GetState returns the State field value if set, zero value otherwise.
func (o *GenerateCsr) GetState() string {
	if o == nil || o.State == nil {
		var ret string
		return ret
	}
	return *o.State
}

// GetStateOk returns a tuple with the State field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetStateOk() (*string, bool) {
	if o == nil || o.State == nil {
		return nil, false
	}
	return o.State, true
}

// HasState returns a boolean if a field has been set.
func (o *GenerateCsr) HasState() bool {
	if o != nil && o.State != nil {
		return true
	}

	return false
}

// SetState gets a reference to the given string and assigns it to the State field.
func (o *GenerateCsr) SetState(v string) {
	o.State = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GenerateCsr) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GenerateCsr) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GenerateCsr) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GenerateCsr) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GenerateCsr) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GenerateCsr) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUriSans returns the UriSans field value if set, zero value otherwise.
func (o *GenerateCsr) GetUriSans() string {
	if o == nil || o.UriSans == nil {
		var ret string
		return ret
	}
	return *o.UriSans
}

// GetUriSansOk returns a tuple with the UriSans field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GenerateCsr) GetUriSansOk() (*string, bool) {
	if o == nil || o.UriSans == nil {
		return nil, false
	}
	return o.UriSans, true
}

// HasUriSans returns a boolean if a field has been set.
func (o *GenerateCsr) HasUriSans() bool {
	if o != nil && o.UriSans != nil {
		return true
	}

	return false
}

// SetUriSans gets a reference to the given string and assigns it to the UriSans field.
func (o *GenerateCsr) SetUriSans(v string) {
	o.UriSans = &v
}

func (o GenerateCsr) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Alg != nil {
		toSerialize["alg"] = o.Alg
	}
	if o.AltNames != nil {
		toSerialize["alt-names"] = o.AltNames
	}
	if o.CertificateType != nil {
		toSerialize["certificate-type"] = o.CertificateType
	}
	if o.City != nil {
		toSerialize["city"] = o.City
	}
	if true {
		toSerialize["common-name"] = o.CommonName
	}
	if o.Country != nil {
		toSerialize["country"] = o.Country
	}
	if o.Critical != nil {
		toSerialize["critical"] = o.Critical
	}
	if o.Dep != nil {
		toSerialize["dep"] = o.Dep
	}
	if o.EmailAddresses != nil {
		toSerialize["email-addresses"] = o.EmailAddresses
	}
	if o.ExportPrivateKey != nil {
		toSerialize["export-private-key"] = o.ExportPrivateKey
	}
	if o.GenerateKey != nil {
		toSerialize["generate-key"] = o.GenerateKey
	}
	if o.IpAddresses != nil {
		toSerialize["ip-addresses"] = o.IpAddresses
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["key-type"] = o.KeyType
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Org != nil {
		toSerialize["org"] = o.Org
	}
	if o.SplitLevel != nil {
		toSerialize["split-level"] = o.SplitLevel
	}
	if o.State != nil {
		toSerialize["state"] = o.State
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UriSans != nil {
		toSerialize["uri-sans"] = o.UriSans
	}
	return json.Marshal(toSerialize)
}

type NullableGenerateCsr struct {
	value *GenerateCsr
	isSet bool
}

func (v NullableGenerateCsr) Get() *GenerateCsr {
	return v.value
}

func (v *NullableGenerateCsr) Set(val *GenerateCsr) {
	v.value = val
	v.isSet = true
}

func (v NullableGenerateCsr) IsSet() bool {
	return v.isSet
}

func (v *NullableGenerateCsr) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGenerateCsr(val *GenerateCsr) *NullableGenerateCsr {
	return &NullableGenerateCsr{value: val, isSet: true}
}

func (v NullableGenerateCsr) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGenerateCsr) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


