/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayUpdateRemoteAccessRdpRecordings gatewayUpdateRemoteAccessRdpRecordings is a command that update remote access rdp recording config
type GatewayUpdateRemoteAccessRdpRecordings struct {
	// AWS access key id. For more information refer to https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html
	AwsStorageAccessKeyId *string `json:"aws-storage-access-key-id,omitempty"`
	// The AWS bucket name. For more information refer to https://docs.aws.amazon.com/s3/
	AwsStorageBucketName *string `json:"aws-storage-bucket-name,omitempty"`
	// The folder name in S3 bucket. For more information refer to https://docs.aws.amazon.com/s3/
	AwsStorageBucketPrefix *string `json:"aws-storage-bucket-prefix,omitempty"`
	// The region where the storage is located
	AwsStorageRegion *string `json:"aws-storage-region,omitempty"`
	// AWS secret access key. For more information refer to https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html
	AwsStorageSecretAccessKey *string `json:"aws-storage-secret-access-key,omitempty"`
	// Azure account name. For more information refer to https://learn.microsoft.com/en-us/azure/storage/common/storage-account-overview
	AzureStorageAccountName *string `json:"azure-storage-account-name,omitempty"`
	// Azure client id. For more information refer to https://learn.microsoft.com/en-us/azure/storage/common/storage-account-get-info?tabs=portal
	AzureStorageClientId *string `json:"azure-storage-client-id,omitempty"`
	// Azure client secret. For more information refer to https://learn.microsoft.com/en-us/azure/storage/common/storage-account-get-info?tabs=portal
	AzureStorageClientSecret *string `json:"azure-storage-client-secret,omitempty"`
	// Azure container name. For more information refer to https://learn.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata
	AzureStorageContainerName *string `json:"azure-storage-container-name,omitempty"`
	// Azure tenant id. For more information refer to https://learn.microsoft.com/en-us/entra/fundamentals/how-to-find-tenant
	AzureStorageTenantId *string `json:"azure-storage-tenant-id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Enable recording of rdp session [true/false]
	RdpSessionRecording *string `json:"rdp-session-recording,omitempty"`
	// Rdp session recording storage destination [local/aws/azure]
	RdpSessionStorage *string `json:"rdp-session-storage,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayUpdateRemoteAccessRdpRecordings instantiates a new GatewayUpdateRemoteAccessRdpRecordings object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayUpdateRemoteAccessRdpRecordings() *GatewayUpdateRemoteAccessRdpRecordings {
	this := GatewayUpdateRemoteAccessRdpRecordings{}
	var json bool = false
	this.Json = &json
	return &this
}

// NewGatewayUpdateRemoteAccessRdpRecordingsWithDefaults instantiates a new GatewayUpdateRemoteAccessRdpRecordings object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayUpdateRemoteAccessRdpRecordingsWithDefaults() *GatewayUpdateRemoteAccessRdpRecordings {
	this := GatewayUpdateRemoteAccessRdpRecordings{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAwsStorageAccessKeyId returns the AwsStorageAccessKeyId field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageAccessKeyId() string {
	if o == nil || o.AwsStorageAccessKeyId == nil {
		var ret string
		return ret
	}
	return *o.AwsStorageAccessKeyId
}

// GetAwsStorageAccessKeyIdOk returns a tuple with the AwsStorageAccessKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageAccessKeyIdOk() (*string, bool) {
	if o == nil || o.AwsStorageAccessKeyId == nil {
		return nil, false
	}
	return o.AwsStorageAccessKeyId, true
}

// HasAwsStorageAccessKeyId returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAwsStorageAccessKeyId() bool {
	if o != nil && o.AwsStorageAccessKeyId != nil {
		return true
	}

	return false
}

// SetAwsStorageAccessKeyId gets a reference to the given string and assigns it to the AwsStorageAccessKeyId field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAwsStorageAccessKeyId(v string) {
	o.AwsStorageAccessKeyId = &v
}

// GetAwsStorageBucketName returns the AwsStorageBucketName field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageBucketName() string {
	if o == nil || o.AwsStorageBucketName == nil {
		var ret string
		return ret
	}
	return *o.AwsStorageBucketName
}

// GetAwsStorageBucketNameOk returns a tuple with the AwsStorageBucketName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageBucketNameOk() (*string, bool) {
	if o == nil || o.AwsStorageBucketName == nil {
		return nil, false
	}
	return o.AwsStorageBucketName, true
}

// HasAwsStorageBucketName returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAwsStorageBucketName() bool {
	if o != nil && o.AwsStorageBucketName != nil {
		return true
	}

	return false
}

// SetAwsStorageBucketName gets a reference to the given string and assigns it to the AwsStorageBucketName field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAwsStorageBucketName(v string) {
	o.AwsStorageBucketName = &v
}

// GetAwsStorageBucketPrefix returns the AwsStorageBucketPrefix field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageBucketPrefix() string {
	if o == nil || o.AwsStorageBucketPrefix == nil {
		var ret string
		return ret
	}
	return *o.AwsStorageBucketPrefix
}

// GetAwsStorageBucketPrefixOk returns a tuple with the AwsStorageBucketPrefix field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageBucketPrefixOk() (*string, bool) {
	if o == nil || o.AwsStorageBucketPrefix == nil {
		return nil, false
	}
	return o.AwsStorageBucketPrefix, true
}

// HasAwsStorageBucketPrefix returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAwsStorageBucketPrefix() bool {
	if o != nil && o.AwsStorageBucketPrefix != nil {
		return true
	}

	return false
}

// SetAwsStorageBucketPrefix gets a reference to the given string and assigns it to the AwsStorageBucketPrefix field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAwsStorageBucketPrefix(v string) {
	o.AwsStorageBucketPrefix = &v
}

// GetAwsStorageRegion returns the AwsStorageRegion field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageRegion() string {
	if o == nil || o.AwsStorageRegion == nil {
		var ret string
		return ret
	}
	return *o.AwsStorageRegion
}

// GetAwsStorageRegionOk returns a tuple with the AwsStorageRegion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageRegionOk() (*string, bool) {
	if o == nil || o.AwsStorageRegion == nil {
		return nil, false
	}
	return o.AwsStorageRegion, true
}

// HasAwsStorageRegion returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAwsStorageRegion() bool {
	if o != nil && o.AwsStorageRegion != nil {
		return true
	}

	return false
}

// SetAwsStorageRegion gets a reference to the given string and assigns it to the AwsStorageRegion field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAwsStorageRegion(v string) {
	o.AwsStorageRegion = &v
}

// GetAwsStorageSecretAccessKey returns the AwsStorageSecretAccessKey field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageSecretAccessKey() string {
	if o == nil || o.AwsStorageSecretAccessKey == nil {
		var ret string
		return ret
	}
	return *o.AwsStorageSecretAccessKey
}

// GetAwsStorageSecretAccessKeyOk returns a tuple with the AwsStorageSecretAccessKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAwsStorageSecretAccessKeyOk() (*string, bool) {
	if o == nil || o.AwsStorageSecretAccessKey == nil {
		return nil, false
	}
	return o.AwsStorageSecretAccessKey, true
}

// HasAwsStorageSecretAccessKey returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAwsStorageSecretAccessKey() bool {
	if o != nil && o.AwsStorageSecretAccessKey != nil {
		return true
	}

	return false
}

// SetAwsStorageSecretAccessKey gets a reference to the given string and assigns it to the AwsStorageSecretAccessKey field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAwsStorageSecretAccessKey(v string) {
	o.AwsStorageSecretAccessKey = &v
}

// GetAzureStorageAccountName returns the AzureStorageAccountName field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageAccountName() string {
	if o == nil || o.AzureStorageAccountName == nil {
		var ret string
		return ret
	}
	return *o.AzureStorageAccountName
}

// GetAzureStorageAccountNameOk returns a tuple with the AzureStorageAccountName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageAccountNameOk() (*string, bool) {
	if o == nil || o.AzureStorageAccountName == nil {
		return nil, false
	}
	return o.AzureStorageAccountName, true
}

// HasAzureStorageAccountName returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAzureStorageAccountName() bool {
	if o != nil && o.AzureStorageAccountName != nil {
		return true
	}

	return false
}

// SetAzureStorageAccountName gets a reference to the given string and assigns it to the AzureStorageAccountName field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAzureStorageAccountName(v string) {
	o.AzureStorageAccountName = &v
}

// GetAzureStorageClientId returns the AzureStorageClientId field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageClientId() string {
	if o == nil || o.AzureStorageClientId == nil {
		var ret string
		return ret
	}
	return *o.AzureStorageClientId
}

// GetAzureStorageClientIdOk returns a tuple with the AzureStorageClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageClientIdOk() (*string, bool) {
	if o == nil || o.AzureStorageClientId == nil {
		return nil, false
	}
	return o.AzureStorageClientId, true
}

// HasAzureStorageClientId returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAzureStorageClientId() bool {
	if o != nil && o.AzureStorageClientId != nil {
		return true
	}

	return false
}

// SetAzureStorageClientId gets a reference to the given string and assigns it to the AzureStorageClientId field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAzureStorageClientId(v string) {
	o.AzureStorageClientId = &v
}

// GetAzureStorageClientSecret returns the AzureStorageClientSecret field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageClientSecret() string {
	if o == nil || o.AzureStorageClientSecret == nil {
		var ret string
		return ret
	}
	return *o.AzureStorageClientSecret
}

// GetAzureStorageClientSecretOk returns a tuple with the AzureStorageClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageClientSecretOk() (*string, bool) {
	if o == nil || o.AzureStorageClientSecret == nil {
		return nil, false
	}
	return o.AzureStorageClientSecret, true
}

// HasAzureStorageClientSecret returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAzureStorageClientSecret() bool {
	if o != nil && o.AzureStorageClientSecret != nil {
		return true
	}

	return false
}

// SetAzureStorageClientSecret gets a reference to the given string and assigns it to the AzureStorageClientSecret field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAzureStorageClientSecret(v string) {
	o.AzureStorageClientSecret = &v
}

// GetAzureStorageContainerName returns the AzureStorageContainerName field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageContainerName() string {
	if o == nil || o.AzureStorageContainerName == nil {
		var ret string
		return ret
	}
	return *o.AzureStorageContainerName
}

// GetAzureStorageContainerNameOk returns a tuple with the AzureStorageContainerName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageContainerNameOk() (*string, bool) {
	if o == nil || o.AzureStorageContainerName == nil {
		return nil, false
	}
	return o.AzureStorageContainerName, true
}

// HasAzureStorageContainerName returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAzureStorageContainerName() bool {
	if o != nil && o.AzureStorageContainerName != nil {
		return true
	}

	return false
}

// SetAzureStorageContainerName gets a reference to the given string and assigns it to the AzureStorageContainerName field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAzureStorageContainerName(v string) {
	o.AzureStorageContainerName = &v
}

// GetAzureStorageTenantId returns the AzureStorageTenantId field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageTenantId() string {
	if o == nil || o.AzureStorageTenantId == nil {
		var ret string
		return ret
	}
	return *o.AzureStorageTenantId
}

// GetAzureStorageTenantIdOk returns a tuple with the AzureStorageTenantId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetAzureStorageTenantIdOk() (*string, bool) {
	if o == nil || o.AzureStorageTenantId == nil {
		return nil, false
	}
	return o.AzureStorageTenantId, true
}

// HasAzureStorageTenantId returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasAzureStorageTenantId() bool {
	if o != nil && o.AzureStorageTenantId != nil {
		return true
	}

	return false
}

// SetAzureStorageTenantId gets a reference to the given string and assigns it to the AzureStorageTenantId field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetAzureStorageTenantId(v string) {
	o.AzureStorageTenantId = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetJson(v bool) {
	o.Json = &v
}

// GetRdpSessionRecording returns the RdpSessionRecording field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetRdpSessionRecording() string {
	if o == nil || o.RdpSessionRecording == nil {
		var ret string
		return ret
	}
	return *o.RdpSessionRecording
}

// GetRdpSessionRecordingOk returns a tuple with the RdpSessionRecording field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetRdpSessionRecordingOk() (*string, bool) {
	if o == nil || o.RdpSessionRecording == nil {
		return nil, false
	}
	return o.RdpSessionRecording, true
}

// HasRdpSessionRecording returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasRdpSessionRecording() bool {
	if o != nil && o.RdpSessionRecording != nil {
		return true
	}

	return false
}

// SetRdpSessionRecording gets a reference to the given string and assigns it to the RdpSessionRecording field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetRdpSessionRecording(v string) {
	o.RdpSessionRecording = &v
}

// GetRdpSessionStorage returns the RdpSessionStorage field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetRdpSessionStorage() string {
	if o == nil || o.RdpSessionStorage == nil {
		var ret string
		return ret
	}
	return *o.RdpSessionStorage
}

// GetRdpSessionStorageOk returns a tuple with the RdpSessionStorage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetRdpSessionStorageOk() (*string, bool) {
	if o == nil || o.RdpSessionStorage == nil {
		return nil, false
	}
	return o.RdpSessionStorage, true
}

// HasRdpSessionStorage returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasRdpSessionStorage() bool {
	if o != nil && o.RdpSessionStorage != nil {
		return true
	}

	return false
}

// SetRdpSessionStorage gets a reference to the given string and assigns it to the RdpSessionStorage field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetRdpSessionStorage(v string) {
	o.RdpSessionStorage = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccessRdpRecordings) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayUpdateRemoteAccessRdpRecordings) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayUpdateRemoteAccessRdpRecordings) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AwsStorageAccessKeyId != nil {
		toSerialize["aws-storage-access-key-id"] = o.AwsStorageAccessKeyId
	}
	if o.AwsStorageBucketName != nil {
		toSerialize["aws-storage-bucket-name"] = o.AwsStorageBucketName
	}
	if o.AwsStorageBucketPrefix != nil {
		toSerialize["aws-storage-bucket-prefix"] = o.AwsStorageBucketPrefix
	}
	if o.AwsStorageRegion != nil {
		toSerialize["aws-storage-region"] = o.AwsStorageRegion
	}
	if o.AwsStorageSecretAccessKey != nil {
		toSerialize["aws-storage-secret-access-key"] = o.AwsStorageSecretAccessKey
	}
	if o.AzureStorageAccountName != nil {
		toSerialize["azure-storage-account-name"] = o.AzureStorageAccountName
	}
	if o.AzureStorageClientId != nil {
		toSerialize["azure-storage-client-id"] = o.AzureStorageClientId
	}
	if o.AzureStorageClientSecret != nil {
		toSerialize["azure-storage-client-secret"] = o.AzureStorageClientSecret
	}
	if o.AzureStorageContainerName != nil {
		toSerialize["azure-storage-container-name"] = o.AzureStorageContainerName
	}
	if o.AzureStorageTenantId != nil {
		toSerialize["azure-storage-tenant-id"] = o.AzureStorageTenantId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.RdpSessionRecording != nil {
		toSerialize["rdp-session-recording"] = o.RdpSessionRecording
	}
	if o.RdpSessionStorage != nil {
		toSerialize["rdp-session-storage"] = o.RdpSessionStorage
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayUpdateRemoteAccessRdpRecordings struct {
	value *GatewayUpdateRemoteAccessRdpRecordings
	isSet bool
}

func (v NullableGatewayUpdateRemoteAccessRdpRecordings) Get() *GatewayUpdateRemoteAccessRdpRecordings {
	return v.value
}

func (v *NullableGatewayUpdateRemoteAccessRdpRecordings) Set(val *GatewayUpdateRemoteAccessRdpRecordings) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayUpdateRemoteAccessRdpRecordings) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayUpdateRemoteAccessRdpRecordings) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayUpdateRemoteAccessRdpRecordings(val *GatewayUpdateRemoteAccessRdpRecordings) *NullableGatewayUpdateRemoteAccessRdpRecordings {
	return &NullableGatewayUpdateRemoteAccessRdpRecordings{value: val, isSet: true}
}

func (v NullableGatewayUpdateRemoteAccessRdpRecordings) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayUpdateRemoteAccessRdpRecordings) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


