/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayUpdateLogForwardingAwsS3 gatewayUpdateLogForwardingAwsS3 is a command that updates log forwarding config (aws-s3 target)
type GatewayUpdateLogForwardingAwsS3 struct {
	// AWS access id relevant for access_key auth-type
	AccessId *string `json:"access-id,omitempty"`
	// AWS access key relevant for access_key auth-type
	AccessKey *string `json:"access-key,omitempty"`
	// AWS auth type [access_key/cloud_id/assume_role]
	AuthType *string `json:"auth-type,omitempty"`
	// AWS S3 bucket name
	BucketName *string `json:"bucket-name,omitempty"`
	// Enable Log Forwarding [true/false]
	Enable *string `json:"enable,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// AWS S3 destination folder for logs
	LogFolder *string `json:"log-folder,omitempty"`
	// Logs format [text/json]
	OutputFormat *string `json:"output-format,omitempty"`
	// Pull interval in seconds
	PullInterval *string `json:"pull-interval,omitempty"`
	// AWS region
	Region *string `json:"region,omitempty"`
	// AWS role arn relevant for assume_role auth-type
	RoleArn *string `json:"role-arn,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayUpdateLogForwardingAwsS3 instantiates a new GatewayUpdateLogForwardingAwsS3 object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayUpdateLogForwardingAwsS3() *GatewayUpdateLogForwardingAwsS3 {
	this := GatewayUpdateLogForwardingAwsS3{}
	var enable string = "true"
	this.Enable = &enable
	var json bool = false
	this.Json = &json
	var logFolder string = "use-existing"
	this.LogFolder = &logFolder
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	return &this
}

// NewGatewayUpdateLogForwardingAwsS3WithDefaults instantiates a new GatewayUpdateLogForwardingAwsS3 object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayUpdateLogForwardingAwsS3WithDefaults() *GatewayUpdateLogForwardingAwsS3 {
	this := GatewayUpdateLogForwardingAwsS3{}
	var enable string = "true"
	this.Enable = &enable
	var json bool = false
	this.Json = &json
	var logFolder string = "use-existing"
	this.LogFolder = &logFolder
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	return &this
}

// GetAccessId returns the AccessId field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetAccessId() string {
	if o == nil || o.AccessId == nil {
		var ret string
		return ret
	}
	return *o.AccessId
}

// GetAccessIdOk returns a tuple with the AccessId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetAccessIdOk() (*string, bool) {
	if o == nil || o.AccessId == nil {
		return nil, false
	}
	return o.AccessId, true
}

// HasAccessId returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasAccessId() bool {
	if o != nil && o.AccessId != nil {
		return true
	}

	return false
}

// SetAccessId gets a reference to the given string and assigns it to the AccessId field.
func (o *GatewayUpdateLogForwardingAwsS3) SetAccessId(v string) {
	o.AccessId = &v
}

// GetAccessKey returns the AccessKey field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetAccessKey() string {
	if o == nil || o.AccessKey == nil {
		var ret string
		return ret
	}
	return *o.AccessKey
}

// GetAccessKeyOk returns a tuple with the AccessKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetAccessKeyOk() (*string, bool) {
	if o == nil || o.AccessKey == nil {
		return nil, false
	}
	return o.AccessKey, true
}

// HasAccessKey returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasAccessKey() bool {
	if o != nil && o.AccessKey != nil {
		return true
	}

	return false
}

// SetAccessKey gets a reference to the given string and assigns it to the AccessKey field.
func (o *GatewayUpdateLogForwardingAwsS3) SetAccessKey(v string) {
	o.AccessKey = &v
}

// GetAuthType returns the AuthType field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetAuthType() string {
	if o == nil || o.AuthType == nil {
		var ret string
		return ret
	}
	return *o.AuthType
}

// GetAuthTypeOk returns a tuple with the AuthType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetAuthTypeOk() (*string, bool) {
	if o == nil || o.AuthType == nil {
		return nil, false
	}
	return o.AuthType, true
}

// HasAuthType returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasAuthType() bool {
	if o != nil && o.AuthType != nil {
		return true
	}

	return false
}

// SetAuthType gets a reference to the given string and assigns it to the AuthType field.
func (o *GatewayUpdateLogForwardingAwsS3) SetAuthType(v string) {
	o.AuthType = &v
}

// GetBucketName returns the BucketName field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetBucketName() string {
	if o == nil || o.BucketName == nil {
		var ret string
		return ret
	}
	return *o.BucketName
}

// GetBucketNameOk returns a tuple with the BucketName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetBucketNameOk() (*string, bool) {
	if o == nil || o.BucketName == nil {
		return nil, false
	}
	return o.BucketName, true
}

// HasBucketName returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasBucketName() bool {
	if o != nil && o.BucketName != nil {
		return true
	}

	return false
}

// SetBucketName gets a reference to the given string and assigns it to the BucketName field.
func (o *GatewayUpdateLogForwardingAwsS3) SetBucketName(v string) {
	o.BucketName = &v
}

// GetEnable returns the Enable field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetEnable() string {
	if o == nil || o.Enable == nil {
		var ret string
		return ret
	}
	return *o.Enable
}

// GetEnableOk returns a tuple with the Enable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetEnableOk() (*string, bool) {
	if o == nil || o.Enable == nil {
		return nil, false
	}
	return o.Enable, true
}

// HasEnable returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasEnable() bool {
	if o != nil && o.Enable != nil {
		return true
	}

	return false
}

// SetEnable gets a reference to the given string and assigns it to the Enable field.
func (o *GatewayUpdateLogForwardingAwsS3) SetEnable(v string) {
	o.Enable = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayUpdateLogForwardingAwsS3) SetJson(v bool) {
	o.Json = &v
}

// GetLogFolder returns the LogFolder field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetLogFolder() string {
	if o == nil || o.LogFolder == nil {
		var ret string
		return ret
	}
	return *o.LogFolder
}

// GetLogFolderOk returns a tuple with the LogFolder field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetLogFolderOk() (*string, bool) {
	if o == nil || o.LogFolder == nil {
		return nil, false
	}
	return o.LogFolder, true
}

// HasLogFolder returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasLogFolder() bool {
	if o != nil && o.LogFolder != nil {
		return true
	}

	return false
}

// SetLogFolder gets a reference to the given string and assigns it to the LogFolder field.
func (o *GatewayUpdateLogForwardingAwsS3) SetLogFolder(v string) {
	o.LogFolder = &v
}

// GetOutputFormat returns the OutputFormat field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetOutputFormat() string {
	if o == nil || o.OutputFormat == nil {
		var ret string
		return ret
	}
	return *o.OutputFormat
}

// GetOutputFormatOk returns a tuple with the OutputFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetOutputFormatOk() (*string, bool) {
	if o == nil || o.OutputFormat == nil {
		return nil, false
	}
	return o.OutputFormat, true
}

// HasOutputFormat returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasOutputFormat() bool {
	if o != nil && o.OutputFormat != nil {
		return true
	}

	return false
}

// SetOutputFormat gets a reference to the given string and assigns it to the OutputFormat field.
func (o *GatewayUpdateLogForwardingAwsS3) SetOutputFormat(v string) {
	o.OutputFormat = &v
}

// GetPullInterval returns the PullInterval field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetPullInterval() string {
	if o == nil || o.PullInterval == nil {
		var ret string
		return ret
	}
	return *o.PullInterval
}

// GetPullIntervalOk returns a tuple with the PullInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetPullIntervalOk() (*string, bool) {
	if o == nil || o.PullInterval == nil {
		return nil, false
	}
	return o.PullInterval, true
}

// HasPullInterval returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasPullInterval() bool {
	if o != nil && o.PullInterval != nil {
		return true
	}

	return false
}

// SetPullInterval gets a reference to the given string and assigns it to the PullInterval field.
func (o *GatewayUpdateLogForwardingAwsS3) SetPullInterval(v string) {
	o.PullInterval = &v
}

// GetRegion returns the Region field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetRegion() string {
	if o == nil || o.Region == nil {
		var ret string
		return ret
	}
	return *o.Region
}

// GetRegionOk returns a tuple with the Region field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetRegionOk() (*string, bool) {
	if o == nil || o.Region == nil {
		return nil, false
	}
	return o.Region, true
}

// HasRegion returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasRegion() bool {
	if o != nil && o.Region != nil {
		return true
	}

	return false
}

// SetRegion gets a reference to the given string and assigns it to the Region field.
func (o *GatewayUpdateLogForwardingAwsS3) SetRegion(v string) {
	o.Region = &v
}

// GetRoleArn returns the RoleArn field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetRoleArn() string {
	if o == nil || o.RoleArn == nil {
		var ret string
		return ret
	}
	return *o.RoleArn
}

// GetRoleArnOk returns a tuple with the RoleArn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetRoleArnOk() (*string, bool) {
	if o == nil || o.RoleArn == nil {
		return nil, false
	}
	return o.RoleArn, true
}

// HasRoleArn returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasRoleArn() bool {
	if o != nil && o.RoleArn != nil {
		return true
	}

	return false
}

// SetRoleArn gets a reference to the given string and assigns it to the RoleArn field.
func (o *GatewayUpdateLogForwardingAwsS3) SetRoleArn(v string) {
	o.RoleArn = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayUpdateLogForwardingAwsS3) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayUpdateLogForwardingAwsS3) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateLogForwardingAwsS3) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayUpdateLogForwardingAwsS3) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayUpdateLogForwardingAwsS3) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayUpdateLogForwardingAwsS3) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessId != nil {
		toSerialize["access-id"] = o.AccessId
	}
	if o.AccessKey != nil {
		toSerialize["access-key"] = o.AccessKey
	}
	if o.AuthType != nil {
		toSerialize["auth-type"] = o.AuthType
	}
	if o.BucketName != nil {
		toSerialize["bucket-name"] = o.BucketName
	}
	if o.Enable != nil {
		toSerialize["enable"] = o.Enable
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.LogFolder != nil {
		toSerialize["log-folder"] = o.LogFolder
	}
	if o.OutputFormat != nil {
		toSerialize["output-format"] = o.OutputFormat
	}
	if o.PullInterval != nil {
		toSerialize["pull-interval"] = o.PullInterval
	}
	if o.Region != nil {
		toSerialize["region"] = o.Region
	}
	if o.RoleArn != nil {
		toSerialize["role-arn"] = o.RoleArn
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayUpdateLogForwardingAwsS3 struct {
	value *GatewayUpdateLogForwardingAwsS3
	isSet bool
}

func (v NullableGatewayUpdateLogForwardingAwsS3) Get() *GatewayUpdateLogForwardingAwsS3 {
	return v.value
}

func (v *NullableGatewayUpdateLogForwardingAwsS3) Set(val *GatewayUpdateLogForwardingAwsS3) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayUpdateLogForwardingAwsS3) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayUpdateLogForwardingAwsS3) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayUpdateLogForwardingAwsS3(val *GatewayUpdateLogForwardingAwsS3) *NullableGatewayUpdateLogForwardingAwsS3 {
	return &NullableGatewayUpdateLogForwardingAwsS3{value: val, isSet: true}
}

func (v NullableGatewayUpdateLogForwardingAwsS3) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayUpdateLogForwardingAwsS3) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


