/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DSProducerDetails struct for DSProducerDetails
type DSProducerDetails struct {
	AccessTokenManagerId *string `json:"access_token_manager_id,omitempty"`
	AclRules *[]string `json:"acl_rules,omitempty"`
	Active *bool `json:"active,omitempty"`
	AdminName *string `json:"admin_name,omitempty"`
	AdminPwd *string `json:"admin_pwd,omitempty"`
	AdminRotationIntervalDays *int64 `json:"admin_rotation_interval_days,omitempty"`
	AdministrativePort *string `json:"administrative_port,omitempty"`
	ArtifactoryAdminApikey *string `json:"artifactory_admin_apikey,omitempty"`
	ArtifactoryAdminUsername *string `json:"artifactory_admin_username,omitempty"`
	ArtifactoryBaseUrl *string `json:"artifactory_base_url,omitempty"`
	ArtifactoryTokenAudience *string `json:"artifactory_token_audience,omitempty"`
	ArtifactoryTokenScope *string `json:"artifactory_token_scope,omitempty"`
	AuthorizationPort *string `json:"authorization_port,omitempty"`
	AwsAccessKeyId *string `json:"aws_access_key_id,omitempty"`
	AwsAccessMode *string `json:"aws_access_mode,omitempty"`
	AwsRegion *string `json:"aws_region,omitempty"`
	AwsRoleArns *string `json:"aws_role_arns,omitempty"`
	AwsSecretAccessKey *string `json:"aws_secret_access_key,omitempty"`
	AwsSessionTags *string `json:"aws_session_tags,omitempty"`
	AwsSessionToken *string `json:"aws_session_token,omitempty"`
	AwsTransitiveTagKeys *string `json:"aws_transitive_tag_keys,omitempty"`
	AwsUserConsoleAccess *bool `json:"aws_user_console_access,omitempty"`
	AwsUserGroups *string `json:"aws_user_groups,omitempty"`
	AwsUserPolicies *string `json:"aws_user_policies,omitempty"`
	AwsUserProgrammaticAccess *bool `json:"aws_user_programmatic_access,omitempty"`
	AzureAppObjectId *string `json:"azure_app_object_id,omitempty"`
	AzureClientId *string `json:"azure_client_id,omitempty"`
	AzureClientSecret *string `json:"azure_client_secret,omitempty"`
	AzureFixedUserNameSubClaimKey *string `json:"azure_fixed_user_name_sub_claim_key,omitempty"`
	AzureFixedUserOnly *bool `json:"azure_fixed_user_only,omitempty"`
	AzureResourceGroupName *string `json:"azure_resource_group_name,omitempty"`
	AzureResourceName *string `json:"azure_resource_name,omitempty"`
	AzureSubscriptionId *string `json:"azure_subscription_id,omitempty"`
	AzureTenantId *string `json:"azure_tenant_id,omitempty"`
	AzureUserGroupsObjId *string `json:"azure_user_groups_obj_id,omitempty"`
	AzureUserPortalAccess *bool `json:"azure_user_portal_access,omitempty"`
	AzureUserProgrammaticAccess *bool `json:"azure_user_programmatic_access,omitempty"`
	AzureUserRolesTemplateId *string `json:"azure_user_roles_template_id,omitempty"`
	AzureUsername *string `json:"azure_username,omitempty"`
	CassandraCreationStatements *string `json:"cassandra_creation_statements,omitempty"`
	ChefOrganizations *string `json:"chef_organizations,omitempty"`
	ChefServerAccessMode *string `json:"chef_server_access_mode,omitempty"`
	ChefServerHostName *string `json:"chef_server_host_name,omitempty"`
	ChefServerKey *string `json:"chef_server_key,omitempty"`
	ChefServerPort *string `json:"chef_server_port,omitempty"`
	ChefServerUrl *string `json:"chef_server_url,omitempty"`
	ChefServerUsername *string `json:"chef_server_username,omitempty"`
	ChefSkipSsl *bool `json:"chef_skip_ssl,omitempty"`
	ClientAuthenticationType *string `json:"client_authentication_type,omitempty"`
	CloudServiceProvider *string `json:"cloud_service_provider,omitempty"`
	ClusterMode *bool `json:"cluster_mode,omitempty"`
	ConnectionType *string `json:"connection_type,omitempty"`
	CreateSyncUrl *string `json:"create_sync_url,omitempty"`
	DbClientId *string `json:"db_client_id,omitempty"`
	DbClientSecret *string `json:"db_client_secret,omitempty"`
	DbHostName *string `json:"db_host_name,omitempty"`
	DbIsolationLevel *string `json:"db_isolation_level,omitempty"`
	DbMaxIdleConns *string `json:"db_max_idle_conns,omitempty"`
	DbMaxOpenConns *string `json:"db_max_open_conns,omitempty"`
	DbName *string `json:"db_name,omitempty"`
	DbPort *string `json:"db_port,omitempty"`
	// (Optional) Private Key in PEM format
	DbPrivateKey *string `json:"db_private_key,omitempty"`
	DbPrivateKeyPassphrase *string `json:"db_private_key_passphrase,omitempty"`
	DbPwd *string `json:"db_pwd,omitempty"`
	// (Optional) DBServerCertificates defines the set of root certificate authorities that clients use when verifying server certificates. If DBServerCertificates is empty, TLS uses the host's root CA set.
	DbServerCertificates *string `json:"db_server_certificates,omitempty"`
	// (Optional) ServerName is used to verify the hostname on the returned certificates unless InsecureSkipVerify is given. It is also included in the client's handshake to support virtual hosting unless it is an IP address.
	DbServerName *string `json:"db_server_name,omitempty"`
	DbTenantId *string `json:"db_tenant_id,omitempty"`
	DbUserName *string `json:"db_user_name,omitempty"`
	DeleteProtection *bool `json:"delete_protection,omitempty"`
	DynamicSecretId *int64 `json:"dynamic_secret_id,omitempty"`
	DynamicSecretKey *string `json:"dynamic_secret_key,omitempty"`
	DynamicSecretName *string `json:"dynamic_secret_name,omitempty"`
	DynamicSecretType *string `json:"dynamic_secret_type,omitempty"`
	EksAccessKeyId *string `json:"eks_access_key_id,omitempty"`
	EksAssumeRole *string `json:"eks_assume_role,omitempty"`
	EksClusterCaCertificate *string `json:"eks_cluster_ca_certificate,omitempty"`
	EksClusterEndpoint *string `json:"eks_cluster_endpoint,omitempty"`
	EksClusterName *string `json:"eks_cluster_name,omitempty"`
	EksRegion *string `json:"eks_region,omitempty"`
	EksSecretAccessKey *string `json:"eks_secret_access_key,omitempty"`
	EnableAdminRotation *bool `json:"enable_admin_rotation,omitempty"`
	// relevant for PRIVATE_KEY_JWT client authentication type
	EnforceReplayPrevention *bool `json:"enforce_replay_prevention,omitempty"`
	ExternallyProvidedUser *string `json:"externally_provided_user,omitempty"`
	FailureMessage *string `json:"failure_message,omitempty"`
	FixedUserOnly *string `json:"fixed_user_only,omitempty"`
	GcpKeyAlgo *string `json:"gcp_key_algo,omitempty"`
	GcpRoleBindings *map[string][]string `json:"gcp_role_bindings,omitempty"`
	// GCPServiceAccountEmail overrides the deprecated field from the target
	GcpServiceAccountEmail *string `json:"gcp_service_account_email,omitempty"`
	GcpServiceAccountKey *string `json:"gcp_service_account_key,omitempty"`
	GcpServiceAccountKeyBase64 *string `json:"gcp_service_account_key_base64,omitempty"`
	GcpServiceAccountKeyId *string `json:"gcp_service_account_key_id,omitempty"`
	GcpServiceAccountType *string `json:"gcp_service_account_type,omitempty"`
	GcpTmpServiceAccountName *string `json:"gcp_tmp_service_account_name,omitempty"`
	GcpTokenLifetime *string `json:"gcp_token_lifetime,omitempty"`
	GcpTokenScope *string `json:"gcp_token_scope,omitempty"`
	GcpTokenType *string `json:"gcp_token_type,omitempty"`
	GithubAppId *int64 `json:"github_app_id,omitempty"`
	GithubAppPrivateKey *string `json:"github_app_private_key,omitempty"`
	GithubBaseUrl *string `json:"github_base_url,omitempty"`
	GithubInstallationId *int64 `json:"github_installation_id,omitempty"`
	GithubInstallationTokenPermissions *map[string]string `json:"github_installation_token_permissions,omitempty"`
	GithubInstallationTokenRepositories *[]string `json:"github_installation_token_repositories,omitempty"`
	GithubInstallationTokenRepositoriesIds *[]int64 `json:"github_installation_token_repositories_ids,omitempty"`
	GithubOrganizationName *string `json:"github_organization_name,omitempty"`
	GithubRepositoryPath *string `json:"github_repository_path,omitempty"`
	GitlabAccessToken *string `json:"gitlab_access_token,omitempty"`
	GitlabAccessType *string `json:"gitlab_access_type,omitempty"`
	GitlabCertificate *string `json:"gitlab_certificate,omitempty"`
	GitlabGroupName *string `json:"gitlab_group_name,omitempty"`
	GitlabProjectName *string `json:"gitlab_project_name,omitempty"`
	GitlabRole *string `json:"gitlab_role,omitempty"`
	GitlabTokenScope *[]string `json:"gitlab_token_scope,omitempty"`
	GitlabUrl *string `json:"gitlab_url,omitempty"`
	GkeClusterCaCertificate *string `json:"gke_cluster_ca_certificate,omitempty"`
	GkeClusterEndpoint *string `json:"gke_cluster_endpoint,omitempty"`
	GkeClusterName *string `json:"gke_cluster_name,omitempty"`
	GkeServiceAccountKey *string `json:"gke_service_account_key,omitempty"`
	GkeServiceAccountName *string `json:"gke_service_account_name,omitempty"`
	GoogleWorkspaceAccessMode *string `json:"google_workspace_access_mode,omitempty"`
	GoogleWorkspaceAdminName *string `json:"google_workspace_admin_name,omitempty"`
	GoogleWorkspaceGroupName *string `json:"google_workspace_group_name,omitempty"`
	GoogleWorkspaceGroupRole *string `json:"google_workspace_group_role,omitempty"`
	GoogleWorkspaceRoleName *string `json:"google_workspace_role_name,omitempty"`
	GoogleWorkspaceRoleScope *string `json:"google_workspace_role_scope,omitempty"`
	GrantTypes *[]string `json:"grant_types,omitempty"`
	Groups *string `json:"groups,omitempty"`
	HanadbCreationStatements *string `json:"hanadb_creation_statements,omitempty"`
	HanadbRevocationStatements *string `json:"hanadb_revocation_statements,omitempty"`
	HostName *string `json:"host_name,omitempty"`
	HostPort *string `json:"host_port,omitempty"`
	ImplementationType *string `json:"implementation_type,omitempty"`
	IsFixedUser *string `json:"is_fixed_user,omitempty"`
	// relevant for CLIENT_TLS_CERTIFICATE client authentication type
	Issuer *string `json:"issuer,omitempty"`
	ItemTargetsAssoc *[]ItemTargetAssociation `json:"item_targets_assoc,omitempty"`
	Jwks *string `json:"jwks,omitempty"`
	JwksUrl *string `json:"jwks_url,omitempty"`
	// comma-separated list of allowed namespaces. Can hold just * which signifies that any namespace is allowed
	K8sAllowedNamespaces *string `json:"k8s_allowed_namespaces,omitempty"`
	K8sAuthType *string `json:"k8s_auth_type,omitempty"`
	K8sBearerToken *string `json:"k8s_bearer_token,omitempty"`
	// For K8s Client certificates authentication
	K8sClientCertData *string `json:"k8s_client_cert_data,omitempty"`
	K8sClientKeyData *string `json:"k8s_client_key_data,omitempty"`
	K8sClusterCaCertificate *string `json:"k8s_cluster_ca_certificate,omitempty"`
	K8sClusterEndpoint *string `json:"k8s_cluster_endpoint,omitempty"`
	K8sClusterName *string `json:"k8s_cluster_name,omitempty"`
	// when native k8s is in dynamic mode, user can define allowed namespaces, K8sServiceAccount doesn't exist from the start and will only be created at time of getting dynamic secret value By default dynamic mode is false and producer behaves like it did before
	K8sDynamicMode *bool `json:"k8s_dynamic_mode,omitempty"`
	// Yaml definition for creation of temporary objects. Field that can hold multiple docs from which following will be extracted: ServiceAccount, Role/ClusterRole and RoleBinding/ClusterRoleBinding. If ServiceAccount not specified - it will be generated automatically
	K8sMultipleDocYamlTempDefinition *[]int32 `json:"k8s_multiple_doc_yaml_temp_definition,omitempty"`
	K8sNamespace *string `json:"k8s_namespace,omitempty"`
	// Name of the pre-existing Role or ClusterRole to bind a generated service account to.
	K8sRoleName *string `json:"k8s_role_name,omitempty"`
	K8sRoleType *string `json:"k8s_role_type,omitempty"`
	K8sServiceAccount *string `json:"k8s_service_account,omitempty"`
	LastAdminRotation *int64 `json:"last_admin_rotation,omitempty"`
	LdapAudience *string `json:"ldap_audience,omitempty"`
	LdapBindDn *string `json:"ldap_bind_dn,omitempty"`
	LdapBindPassword *string `json:"ldap_bind_password,omitempty"`
	LdapCertificate *string `json:"ldap_certificate,omitempty"`
	LdapGroupDn *string `json:"ldap_group_dn,omitempty"`
	LdapTokenExpiration *string `json:"ldap_token_expiration,omitempty"`
	LdapUrl *string `json:"ldap_url,omitempty"`
	LdapUserAttr *string `json:"ldap_user_attr,omitempty"`
	LdapUserDn *string `json:"ldap_user_dn,omitempty"`
	Metadata *string `json:"metadata,omitempty"`
	MongodbAtlasApiPrivateKey *string `json:"mongodb_atlas_api_private_key,omitempty"`
	MongodbAtlasApiPublicKey *string `json:"mongodb_atlas_api_public_key,omitempty"`
	// mongodb atlas fields
	MongodbAtlasProjectId *string `json:"mongodb_atlas_project_id,omitempty"`
	MongodbCustomData *string `json:"mongodb_custom_data,omitempty"`
	// common fields
	MongodbDbName *string `json:"mongodb_db_name,omitempty"`
	MongodbDefaultAuthDb *string `json:"mongodb_default_auth_db,omitempty"`
	MongodbHostPort *string `json:"mongodb_host_port,omitempty"`
	MongodbIsAtlas *bool `json:"mongodb_is_atlas,omitempty"`
	MongodbPassword *string `json:"mongodb_password,omitempty"`
	// common fields
	MongodbRoles *string `json:"mongodb_roles,omitempty"`
	// mongodb fields
	MongodbUriConnection *string `json:"mongodb_uri_connection,omitempty"`
	MongodbUriOptions *string `json:"mongodb_uri_options,omitempty"`
	MongodbUsername *string `json:"mongodb_username,omitempty"`
	MssqlCreationStatements *string `json:"mssql_creation_statements,omitempty"`
	MssqlRevocationStatements *string `json:"mssql_revocation_statements,omitempty"`
	MysqlCreationStatements *string `json:"mysql_creation_statements,omitempty"`
	MysqlRevocationStatements *string `json:"mysql_revocation_statements,omitempty"`
	OracleCreationStatements *string `json:"oracle_creation_statements,omitempty"`
	OracleRevocationStatements *string `json:"oracle_revocation_statements,omitempty"`
	Password *string `json:"password,omitempty"`
	PasswordLength *int64 `json:"password_length,omitempty"`
	PasswordPolicy *string `json:"password_policy,omitempty"`
	Payload *string `json:"payload,omitempty"`
	PingUrl *string `json:"ping_url,omitempty"`
	PostgresCreationStatements *string `json:"postgres_creation_statements,omitempty"`
	PostgresRevocationStatements *string `json:"postgres_revocation_statements,omitempty"`
	PrivilegedUser *string `json:"privileged_user,omitempty"`
	RabbitmqServerPassword *string `json:"rabbitmq_server_password,omitempty"`
	RabbitmqServerUri *string `json:"rabbitmq_server_uri,omitempty"`
	RabbitmqServerUser *string `json:"rabbitmq_server_user,omitempty"`
	RabbitmqUserConfPermission *string `json:"rabbitmq_user_conf_permission,omitempty"`
	RabbitmqUserReadPermission *string `json:"rabbitmq_user_read_permission,omitempty"`
	RabbitmqUserTags *string `json:"rabbitmq_user_tags,omitempty"`
	RabbitmqUserVhost *string `json:"rabbitmq_user_vhost,omitempty"`
	RabbitmqUserWritePermission *string `json:"rabbitmq_user_write_permission,omitempty"`
	RedirectUris *[]string `json:"redirect_uris,omitempty"`
	RedshiftCreationStatements *string `json:"redshift_creation_statements,omitempty"`
	RestrictedScopes *[]string `json:"restricted_scopes,omitempty"`
	RevokeSyncUrl *string `json:"revoke_sync_url,omitempty"`
	RotateSyncUrl *string `json:"rotate_sync_url,omitempty"`
	Scopes *[]string `json:"scopes,omitempty"`
	SecureRemoteAccessDetails *SecureRemoteAccess `json:"secure_remote_access_details,omitempty"`
	SessionExtensionWarnIntervalMin *int64 `json:"session_extension_warn_interval_min,omitempty"`
	SfAccount *string `json:"sf_account,omitempty"`
	// generated  users info
	SfUserRole *string `json:"sf_user_role,omitempty"`
	SfWarehouseName *string `json:"sf_warehouse_name,omitempty"`
	// TODO delete this after migration
	ShouldStop *string `json:"should_stop,omitempty"`
	SigningAlgorithm *string `json:"signing_algorithm,omitempty"`
	// (Optional) SSLConnectionCertificate defines the certificate for SSL connection. Must be base64 certificate loaded by UI using file loader field
	SslConnectionCertificate *string `json:"ssl_connection_certificate,omitempty"`
	// (Optional) SSLConnectionMode defines if SSL mode will be used to connect to DB
	SslConnectionMode *bool `json:"ssl_connection_mode,omitempty"`
	SubjectDn *string `json:"subject_dn,omitempty"`
	Tags *[]string `json:"tags,omitempty"`
	TimeoutSeconds *int64 `json:"timeout_seconds,omitempty"`
	UseGwCloudIdentity *bool `json:"use_gw_cloud_identity,omitempty"`
	UseGwServiceAccount *bool `json:"use_gw_service_account,omitempty"`
	UserName *string `json:"user_name,omitempty"`
	UserPassword *string `json:"user_password,omitempty"`
	UserPrincipalName *string `json:"user_principal_name,omitempty"`
	UserTtl *string `json:"user_ttl,omitempty"`
	UsernameLength *int64 `json:"username_length,omitempty"`
	UsernamePolicy *string `json:"username_policy,omitempty"`
	VenafiAllowSubdomains *bool `json:"venafi_allow_subdomains,omitempty"`
	VenafiAllowedDomains *[]string `json:"venafi_allowed_domains,omitempty"`
	VenafiApiKey *string `json:"venafi_api_key,omitempty"`
	VenafiAutoGeneratedFolder *string `json:"venafi_auto_generated_folder,omitempty"`
	VenafiBaseUrl *string `json:"venafi_base_url,omitempty"`
	VenafiRootFirstInChain *bool `json:"venafi_root_first_in_chain,omitempty"`
	VenafiSignUsingAkeylessPki *bool `json:"venafi_sign_using_akeyless_pki,omitempty"`
	VenafiSignerKeyName *string `json:"venafi_signer_key_name,omitempty"`
	VenafiStorePrivateKey *bool `json:"venafi_store_private_key,omitempty"`
	VenafiTppAccessToken *string `json:"venafi_tpp_access_token,omitempty"`
	VenafiTppClientId *string `json:"venafi_tpp_client_id,omitempty"`
	// Deprecated: VenafiAccessToken and VenafiRefreshToken should be used instead
	VenafiTppPassword *string `json:"venafi_tpp_password,omitempty"`
	VenafiTppRefreshToken *string `json:"venafi_tpp_refresh_token,omitempty"`
	// Deprecated: VenafiAccessToken and VenafiRefreshToken should be used instead
	VenafiTppUsername *string `json:"venafi_tpp_username,omitempty"`
	VenafiUseTpp *bool `json:"venafi_use_tpp,omitempty"`
	VenafiZone *string `json:"venafi_zone,omitempty"`
	WarnBeforeUserExpirationMin *int64 `json:"warn_before_user_expiration_min,omitempty"`
}

// NewDSProducerDetails instantiates a new DSProducerDetails object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDSProducerDetails() *DSProducerDetails {
	this := DSProducerDetails{}
	return &this
}

// NewDSProducerDetailsWithDefaults instantiates a new DSProducerDetails object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDSProducerDetailsWithDefaults() *DSProducerDetails {
	this := DSProducerDetails{}
	return &this
}

// GetAccessTokenManagerId returns the AccessTokenManagerId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAccessTokenManagerId() string {
	if o == nil || o.AccessTokenManagerId == nil {
		var ret string
		return ret
	}
	return *o.AccessTokenManagerId
}

// GetAccessTokenManagerIdOk returns a tuple with the AccessTokenManagerId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAccessTokenManagerIdOk() (*string, bool) {
	if o == nil || o.AccessTokenManagerId == nil {
		return nil, false
	}
	return o.AccessTokenManagerId, true
}

// HasAccessTokenManagerId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAccessTokenManagerId() bool {
	if o != nil && o.AccessTokenManagerId != nil {
		return true
	}

	return false
}

// SetAccessTokenManagerId gets a reference to the given string and assigns it to the AccessTokenManagerId field.
func (o *DSProducerDetails) SetAccessTokenManagerId(v string) {
	o.AccessTokenManagerId = &v
}

// GetAclRules returns the AclRules field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAclRules() []string {
	if o == nil || o.AclRules == nil {
		var ret []string
		return ret
	}
	return *o.AclRules
}

// GetAclRulesOk returns a tuple with the AclRules field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAclRulesOk() (*[]string, bool) {
	if o == nil || o.AclRules == nil {
		return nil, false
	}
	return o.AclRules, true
}

// HasAclRules returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAclRules() bool {
	if o != nil && o.AclRules != nil {
		return true
	}

	return false
}

// SetAclRules gets a reference to the given []string and assigns it to the AclRules field.
func (o *DSProducerDetails) SetAclRules(v []string) {
	o.AclRules = &v
}

// GetActive returns the Active field value if set, zero value otherwise.
func (o *DSProducerDetails) GetActive() bool {
	if o == nil || o.Active == nil {
		var ret bool
		return ret
	}
	return *o.Active
}

// GetActiveOk returns a tuple with the Active field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetActiveOk() (*bool, bool) {
	if o == nil || o.Active == nil {
		return nil, false
	}
	return o.Active, true
}

// HasActive returns a boolean if a field has been set.
func (o *DSProducerDetails) HasActive() bool {
	if o != nil && o.Active != nil {
		return true
	}

	return false
}

// SetActive gets a reference to the given bool and assigns it to the Active field.
func (o *DSProducerDetails) SetActive(v bool) {
	o.Active = &v
}

// GetAdminName returns the AdminName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAdminName() string {
	if o == nil || o.AdminName == nil {
		var ret string
		return ret
	}
	return *o.AdminName
}

// GetAdminNameOk returns a tuple with the AdminName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAdminNameOk() (*string, bool) {
	if o == nil || o.AdminName == nil {
		return nil, false
	}
	return o.AdminName, true
}

// HasAdminName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAdminName() bool {
	if o != nil && o.AdminName != nil {
		return true
	}

	return false
}

// SetAdminName gets a reference to the given string and assigns it to the AdminName field.
func (o *DSProducerDetails) SetAdminName(v string) {
	o.AdminName = &v
}

// GetAdminPwd returns the AdminPwd field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAdminPwd() string {
	if o == nil || o.AdminPwd == nil {
		var ret string
		return ret
	}
	return *o.AdminPwd
}

// GetAdminPwdOk returns a tuple with the AdminPwd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAdminPwdOk() (*string, bool) {
	if o == nil || o.AdminPwd == nil {
		return nil, false
	}
	return o.AdminPwd, true
}

// HasAdminPwd returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAdminPwd() bool {
	if o != nil && o.AdminPwd != nil {
		return true
	}

	return false
}

// SetAdminPwd gets a reference to the given string and assigns it to the AdminPwd field.
func (o *DSProducerDetails) SetAdminPwd(v string) {
	o.AdminPwd = &v
}

// GetAdminRotationIntervalDays returns the AdminRotationIntervalDays field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAdminRotationIntervalDays() int64 {
	if o == nil || o.AdminRotationIntervalDays == nil {
		var ret int64
		return ret
	}
	return *o.AdminRotationIntervalDays
}

// GetAdminRotationIntervalDaysOk returns a tuple with the AdminRotationIntervalDays field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAdminRotationIntervalDaysOk() (*int64, bool) {
	if o == nil || o.AdminRotationIntervalDays == nil {
		return nil, false
	}
	return o.AdminRotationIntervalDays, true
}

// HasAdminRotationIntervalDays returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAdminRotationIntervalDays() bool {
	if o != nil && o.AdminRotationIntervalDays != nil {
		return true
	}

	return false
}

// SetAdminRotationIntervalDays gets a reference to the given int64 and assigns it to the AdminRotationIntervalDays field.
func (o *DSProducerDetails) SetAdminRotationIntervalDays(v int64) {
	o.AdminRotationIntervalDays = &v
}

// GetAdministrativePort returns the AdministrativePort field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAdministrativePort() string {
	if o == nil || o.AdministrativePort == nil {
		var ret string
		return ret
	}
	return *o.AdministrativePort
}

// GetAdministrativePortOk returns a tuple with the AdministrativePort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAdministrativePortOk() (*string, bool) {
	if o == nil || o.AdministrativePort == nil {
		return nil, false
	}
	return o.AdministrativePort, true
}

// HasAdministrativePort returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAdministrativePort() bool {
	if o != nil && o.AdministrativePort != nil {
		return true
	}

	return false
}

// SetAdministrativePort gets a reference to the given string and assigns it to the AdministrativePort field.
func (o *DSProducerDetails) SetAdministrativePort(v string) {
	o.AdministrativePort = &v
}

// GetArtifactoryAdminApikey returns the ArtifactoryAdminApikey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetArtifactoryAdminApikey() string {
	if o == nil || o.ArtifactoryAdminApikey == nil {
		var ret string
		return ret
	}
	return *o.ArtifactoryAdminApikey
}

// GetArtifactoryAdminApikeyOk returns a tuple with the ArtifactoryAdminApikey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetArtifactoryAdminApikeyOk() (*string, bool) {
	if o == nil || o.ArtifactoryAdminApikey == nil {
		return nil, false
	}
	return o.ArtifactoryAdminApikey, true
}

// HasArtifactoryAdminApikey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasArtifactoryAdminApikey() bool {
	if o != nil && o.ArtifactoryAdminApikey != nil {
		return true
	}

	return false
}

// SetArtifactoryAdminApikey gets a reference to the given string and assigns it to the ArtifactoryAdminApikey field.
func (o *DSProducerDetails) SetArtifactoryAdminApikey(v string) {
	o.ArtifactoryAdminApikey = &v
}

// GetArtifactoryAdminUsername returns the ArtifactoryAdminUsername field value if set, zero value otherwise.
func (o *DSProducerDetails) GetArtifactoryAdminUsername() string {
	if o == nil || o.ArtifactoryAdminUsername == nil {
		var ret string
		return ret
	}
	return *o.ArtifactoryAdminUsername
}

// GetArtifactoryAdminUsernameOk returns a tuple with the ArtifactoryAdminUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetArtifactoryAdminUsernameOk() (*string, bool) {
	if o == nil || o.ArtifactoryAdminUsername == nil {
		return nil, false
	}
	return o.ArtifactoryAdminUsername, true
}

// HasArtifactoryAdminUsername returns a boolean if a field has been set.
func (o *DSProducerDetails) HasArtifactoryAdminUsername() bool {
	if o != nil && o.ArtifactoryAdminUsername != nil {
		return true
	}

	return false
}

// SetArtifactoryAdminUsername gets a reference to the given string and assigns it to the ArtifactoryAdminUsername field.
func (o *DSProducerDetails) SetArtifactoryAdminUsername(v string) {
	o.ArtifactoryAdminUsername = &v
}

// GetArtifactoryBaseUrl returns the ArtifactoryBaseUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetArtifactoryBaseUrl() string {
	if o == nil || o.ArtifactoryBaseUrl == nil {
		var ret string
		return ret
	}
	return *o.ArtifactoryBaseUrl
}

// GetArtifactoryBaseUrlOk returns a tuple with the ArtifactoryBaseUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetArtifactoryBaseUrlOk() (*string, bool) {
	if o == nil || o.ArtifactoryBaseUrl == nil {
		return nil, false
	}
	return o.ArtifactoryBaseUrl, true
}

// HasArtifactoryBaseUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasArtifactoryBaseUrl() bool {
	if o != nil && o.ArtifactoryBaseUrl != nil {
		return true
	}

	return false
}

// SetArtifactoryBaseUrl gets a reference to the given string and assigns it to the ArtifactoryBaseUrl field.
func (o *DSProducerDetails) SetArtifactoryBaseUrl(v string) {
	o.ArtifactoryBaseUrl = &v
}

// GetArtifactoryTokenAudience returns the ArtifactoryTokenAudience field value if set, zero value otherwise.
func (o *DSProducerDetails) GetArtifactoryTokenAudience() string {
	if o == nil || o.ArtifactoryTokenAudience == nil {
		var ret string
		return ret
	}
	return *o.ArtifactoryTokenAudience
}

// GetArtifactoryTokenAudienceOk returns a tuple with the ArtifactoryTokenAudience field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetArtifactoryTokenAudienceOk() (*string, bool) {
	if o == nil || o.ArtifactoryTokenAudience == nil {
		return nil, false
	}
	return o.ArtifactoryTokenAudience, true
}

// HasArtifactoryTokenAudience returns a boolean if a field has been set.
func (o *DSProducerDetails) HasArtifactoryTokenAudience() bool {
	if o != nil && o.ArtifactoryTokenAudience != nil {
		return true
	}

	return false
}

// SetArtifactoryTokenAudience gets a reference to the given string and assigns it to the ArtifactoryTokenAudience field.
func (o *DSProducerDetails) SetArtifactoryTokenAudience(v string) {
	o.ArtifactoryTokenAudience = &v
}

// GetArtifactoryTokenScope returns the ArtifactoryTokenScope field value if set, zero value otherwise.
func (o *DSProducerDetails) GetArtifactoryTokenScope() string {
	if o == nil || o.ArtifactoryTokenScope == nil {
		var ret string
		return ret
	}
	return *o.ArtifactoryTokenScope
}

// GetArtifactoryTokenScopeOk returns a tuple with the ArtifactoryTokenScope field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetArtifactoryTokenScopeOk() (*string, bool) {
	if o == nil || o.ArtifactoryTokenScope == nil {
		return nil, false
	}
	return o.ArtifactoryTokenScope, true
}

// HasArtifactoryTokenScope returns a boolean if a field has been set.
func (o *DSProducerDetails) HasArtifactoryTokenScope() bool {
	if o != nil && o.ArtifactoryTokenScope != nil {
		return true
	}

	return false
}

// SetArtifactoryTokenScope gets a reference to the given string and assigns it to the ArtifactoryTokenScope field.
func (o *DSProducerDetails) SetArtifactoryTokenScope(v string) {
	o.ArtifactoryTokenScope = &v
}

// GetAuthorizationPort returns the AuthorizationPort field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAuthorizationPort() string {
	if o == nil || o.AuthorizationPort == nil {
		var ret string
		return ret
	}
	return *o.AuthorizationPort
}

// GetAuthorizationPortOk returns a tuple with the AuthorizationPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAuthorizationPortOk() (*string, bool) {
	if o == nil || o.AuthorizationPort == nil {
		return nil, false
	}
	return o.AuthorizationPort, true
}

// HasAuthorizationPort returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAuthorizationPort() bool {
	if o != nil && o.AuthorizationPort != nil {
		return true
	}

	return false
}

// SetAuthorizationPort gets a reference to the given string and assigns it to the AuthorizationPort field.
func (o *DSProducerDetails) SetAuthorizationPort(v string) {
	o.AuthorizationPort = &v
}

// GetAwsAccessKeyId returns the AwsAccessKeyId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsAccessKeyId() string {
	if o == nil || o.AwsAccessKeyId == nil {
		var ret string
		return ret
	}
	return *o.AwsAccessKeyId
}

// GetAwsAccessKeyIdOk returns a tuple with the AwsAccessKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsAccessKeyIdOk() (*string, bool) {
	if o == nil || o.AwsAccessKeyId == nil {
		return nil, false
	}
	return o.AwsAccessKeyId, true
}

// HasAwsAccessKeyId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsAccessKeyId() bool {
	if o != nil && o.AwsAccessKeyId != nil {
		return true
	}

	return false
}

// SetAwsAccessKeyId gets a reference to the given string and assigns it to the AwsAccessKeyId field.
func (o *DSProducerDetails) SetAwsAccessKeyId(v string) {
	o.AwsAccessKeyId = &v
}

// GetAwsAccessMode returns the AwsAccessMode field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsAccessMode() string {
	if o == nil || o.AwsAccessMode == nil {
		var ret string
		return ret
	}
	return *o.AwsAccessMode
}

// GetAwsAccessModeOk returns a tuple with the AwsAccessMode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsAccessModeOk() (*string, bool) {
	if o == nil || o.AwsAccessMode == nil {
		return nil, false
	}
	return o.AwsAccessMode, true
}

// HasAwsAccessMode returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsAccessMode() bool {
	if o != nil && o.AwsAccessMode != nil {
		return true
	}

	return false
}

// SetAwsAccessMode gets a reference to the given string and assigns it to the AwsAccessMode field.
func (o *DSProducerDetails) SetAwsAccessMode(v string) {
	o.AwsAccessMode = &v
}

// GetAwsRegion returns the AwsRegion field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsRegion() string {
	if o == nil || o.AwsRegion == nil {
		var ret string
		return ret
	}
	return *o.AwsRegion
}

// GetAwsRegionOk returns a tuple with the AwsRegion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsRegionOk() (*string, bool) {
	if o == nil || o.AwsRegion == nil {
		return nil, false
	}
	return o.AwsRegion, true
}

// HasAwsRegion returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsRegion() bool {
	if o != nil && o.AwsRegion != nil {
		return true
	}

	return false
}

// SetAwsRegion gets a reference to the given string and assigns it to the AwsRegion field.
func (o *DSProducerDetails) SetAwsRegion(v string) {
	o.AwsRegion = &v
}

// GetAwsRoleArns returns the AwsRoleArns field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsRoleArns() string {
	if o == nil || o.AwsRoleArns == nil {
		var ret string
		return ret
	}
	return *o.AwsRoleArns
}

// GetAwsRoleArnsOk returns a tuple with the AwsRoleArns field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsRoleArnsOk() (*string, bool) {
	if o == nil || o.AwsRoleArns == nil {
		return nil, false
	}
	return o.AwsRoleArns, true
}

// HasAwsRoleArns returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsRoleArns() bool {
	if o != nil && o.AwsRoleArns != nil {
		return true
	}

	return false
}

// SetAwsRoleArns gets a reference to the given string and assigns it to the AwsRoleArns field.
func (o *DSProducerDetails) SetAwsRoleArns(v string) {
	o.AwsRoleArns = &v
}

// GetAwsSecretAccessKey returns the AwsSecretAccessKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsSecretAccessKey() string {
	if o == nil || o.AwsSecretAccessKey == nil {
		var ret string
		return ret
	}
	return *o.AwsSecretAccessKey
}

// GetAwsSecretAccessKeyOk returns a tuple with the AwsSecretAccessKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsSecretAccessKeyOk() (*string, bool) {
	if o == nil || o.AwsSecretAccessKey == nil {
		return nil, false
	}
	return o.AwsSecretAccessKey, true
}

// HasAwsSecretAccessKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsSecretAccessKey() bool {
	if o != nil && o.AwsSecretAccessKey != nil {
		return true
	}

	return false
}

// SetAwsSecretAccessKey gets a reference to the given string and assigns it to the AwsSecretAccessKey field.
func (o *DSProducerDetails) SetAwsSecretAccessKey(v string) {
	o.AwsSecretAccessKey = &v
}

// GetAwsSessionTags returns the AwsSessionTags field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsSessionTags() string {
	if o == nil || o.AwsSessionTags == nil {
		var ret string
		return ret
	}
	return *o.AwsSessionTags
}

// GetAwsSessionTagsOk returns a tuple with the AwsSessionTags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsSessionTagsOk() (*string, bool) {
	if o == nil || o.AwsSessionTags == nil {
		return nil, false
	}
	return o.AwsSessionTags, true
}

// HasAwsSessionTags returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsSessionTags() bool {
	if o != nil && o.AwsSessionTags != nil {
		return true
	}

	return false
}

// SetAwsSessionTags gets a reference to the given string and assigns it to the AwsSessionTags field.
func (o *DSProducerDetails) SetAwsSessionTags(v string) {
	o.AwsSessionTags = &v
}

// GetAwsSessionToken returns the AwsSessionToken field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsSessionToken() string {
	if o == nil || o.AwsSessionToken == nil {
		var ret string
		return ret
	}
	return *o.AwsSessionToken
}

// GetAwsSessionTokenOk returns a tuple with the AwsSessionToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsSessionTokenOk() (*string, bool) {
	if o == nil || o.AwsSessionToken == nil {
		return nil, false
	}
	return o.AwsSessionToken, true
}

// HasAwsSessionToken returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsSessionToken() bool {
	if o != nil && o.AwsSessionToken != nil {
		return true
	}

	return false
}

// SetAwsSessionToken gets a reference to the given string and assigns it to the AwsSessionToken field.
func (o *DSProducerDetails) SetAwsSessionToken(v string) {
	o.AwsSessionToken = &v
}

// GetAwsTransitiveTagKeys returns the AwsTransitiveTagKeys field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsTransitiveTagKeys() string {
	if o == nil || o.AwsTransitiveTagKeys == nil {
		var ret string
		return ret
	}
	return *o.AwsTransitiveTagKeys
}

// GetAwsTransitiveTagKeysOk returns a tuple with the AwsTransitiveTagKeys field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsTransitiveTagKeysOk() (*string, bool) {
	if o == nil || o.AwsTransitiveTagKeys == nil {
		return nil, false
	}
	return o.AwsTransitiveTagKeys, true
}

// HasAwsTransitiveTagKeys returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsTransitiveTagKeys() bool {
	if o != nil && o.AwsTransitiveTagKeys != nil {
		return true
	}

	return false
}

// SetAwsTransitiveTagKeys gets a reference to the given string and assigns it to the AwsTransitiveTagKeys field.
func (o *DSProducerDetails) SetAwsTransitiveTagKeys(v string) {
	o.AwsTransitiveTagKeys = &v
}

// GetAwsUserConsoleAccess returns the AwsUserConsoleAccess field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsUserConsoleAccess() bool {
	if o == nil || o.AwsUserConsoleAccess == nil {
		var ret bool
		return ret
	}
	return *o.AwsUserConsoleAccess
}

// GetAwsUserConsoleAccessOk returns a tuple with the AwsUserConsoleAccess field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsUserConsoleAccessOk() (*bool, bool) {
	if o == nil || o.AwsUserConsoleAccess == nil {
		return nil, false
	}
	return o.AwsUserConsoleAccess, true
}

// HasAwsUserConsoleAccess returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsUserConsoleAccess() bool {
	if o != nil && o.AwsUserConsoleAccess != nil {
		return true
	}

	return false
}

// SetAwsUserConsoleAccess gets a reference to the given bool and assigns it to the AwsUserConsoleAccess field.
func (o *DSProducerDetails) SetAwsUserConsoleAccess(v bool) {
	o.AwsUserConsoleAccess = &v
}

// GetAwsUserGroups returns the AwsUserGroups field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsUserGroups() string {
	if o == nil || o.AwsUserGroups == nil {
		var ret string
		return ret
	}
	return *o.AwsUserGroups
}

// GetAwsUserGroupsOk returns a tuple with the AwsUserGroups field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsUserGroupsOk() (*string, bool) {
	if o == nil || o.AwsUserGroups == nil {
		return nil, false
	}
	return o.AwsUserGroups, true
}

// HasAwsUserGroups returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsUserGroups() bool {
	if o != nil && o.AwsUserGroups != nil {
		return true
	}

	return false
}

// SetAwsUserGroups gets a reference to the given string and assigns it to the AwsUserGroups field.
func (o *DSProducerDetails) SetAwsUserGroups(v string) {
	o.AwsUserGroups = &v
}

// GetAwsUserPolicies returns the AwsUserPolicies field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsUserPolicies() string {
	if o == nil || o.AwsUserPolicies == nil {
		var ret string
		return ret
	}
	return *o.AwsUserPolicies
}

// GetAwsUserPoliciesOk returns a tuple with the AwsUserPolicies field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsUserPoliciesOk() (*string, bool) {
	if o == nil || o.AwsUserPolicies == nil {
		return nil, false
	}
	return o.AwsUserPolicies, true
}

// HasAwsUserPolicies returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsUserPolicies() bool {
	if o != nil && o.AwsUserPolicies != nil {
		return true
	}

	return false
}

// SetAwsUserPolicies gets a reference to the given string and assigns it to the AwsUserPolicies field.
func (o *DSProducerDetails) SetAwsUserPolicies(v string) {
	o.AwsUserPolicies = &v
}

// GetAwsUserProgrammaticAccess returns the AwsUserProgrammaticAccess field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAwsUserProgrammaticAccess() bool {
	if o == nil || o.AwsUserProgrammaticAccess == nil {
		var ret bool
		return ret
	}
	return *o.AwsUserProgrammaticAccess
}

// GetAwsUserProgrammaticAccessOk returns a tuple with the AwsUserProgrammaticAccess field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAwsUserProgrammaticAccessOk() (*bool, bool) {
	if o == nil || o.AwsUserProgrammaticAccess == nil {
		return nil, false
	}
	return o.AwsUserProgrammaticAccess, true
}

// HasAwsUserProgrammaticAccess returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAwsUserProgrammaticAccess() bool {
	if o != nil && o.AwsUserProgrammaticAccess != nil {
		return true
	}

	return false
}

// SetAwsUserProgrammaticAccess gets a reference to the given bool and assigns it to the AwsUserProgrammaticAccess field.
func (o *DSProducerDetails) SetAwsUserProgrammaticAccess(v bool) {
	o.AwsUserProgrammaticAccess = &v
}

// GetAzureAppObjectId returns the AzureAppObjectId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureAppObjectId() string {
	if o == nil || o.AzureAppObjectId == nil {
		var ret string
		return ret
	}
	return *o.AzureAppObjectId
}

// GetAzureAppObjectIdOk returns a tuple with the AzureAppObjectId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureAppObjectIdOk() (*string, bool) {
	if o == nil || o.AzureAppObjectId == nil {
		return nil, false
	}
	return o.AzureAppObjectId, true
}

// HasAzureAppObjectId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureAppObjectId() bool {
	if o != nil && o.AzureAppObjectId != nil {
		return true
	}

	return false
}

// SetAzureAppObjectId gets a reference to the given string and assigns it to the AzureAppObjectId field.
func (o *DSProducerDetails) SetAzureAppObjectId(v string) {
	o.AzureAppObjectId = &v
}

// GetAzureClientId returns the AzureClientId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureClientId() string {
	if o == nil || o.AzureClientId == nil {
		var ret string
		return ret
	}
	return *o.AzureClientId
}

// GetAzureClientIdOk returns a tuple with the AzureClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureClientIdOk() (*string, bool) {
	if o == nil || o.AzureClientId == nil {
		return nil, false
	}
	return o.AzureClientId, true
}

// HasAzureClientId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureClientId() bool {
	if o != nil && o.AzureClientId != nil {
		return true
	}

	return false
}

// SetAzureClientId gets a reference to the given string and assigns it to the AzureClientId field.
func (o *DSProducerDetails) SetAzureClientId(v string) {
	o.AzureClientId = &v
}

// GetAzureClientSecret returns the AzureClientSecret field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureClientSecret() string {
	if o == nil || o.AzureClientSecret == nil {
		var ret string
		return ret
	}
	return *o.AzureClientSecret
}

// GetAzureClientSecretOk returns a tuple with the AzureClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureClientSecretOk() (*string, bool) {
	if o == nil || o.AzureClientSecret == nil {
		return nil, false
	}
	return o.AzureClientSecret, true
}

// HasAzureClientSecret returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureClientSecret() bool {
	if o != nil && o.AzureClientSecret != nil {
		return true
	}

	return false
}

// SetAzureClientSecret gets a reference to the given string and assigns it to the AzureClientSecret field.
func (o *DSProducerDetails) SetAzureClientSecret(v string) {
	o.AzureClientSecret = &v
}

// GetAzureFixedUserNameSubClaimKey returns the AzureFixedUserNameSubClaimKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureFixedUserNameSubClaimKey() string {
	if o == nil || o.AzureFixedUserNameSubClaimKey == nil {
		var ret string
		return ret
	}
	return *o.AzureFixedUserNameSubClaimKey
}

// GetAzureFixedUserNameSubClaimKeyOk returns a tuple with the AzureFixedUserNameSubClaimKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureFixedUserNameSubClaimKeyOk() (*string, bool) {
	if o == nil || o.AzureFixedUserNameSubClaimKey == nil {
		return nil, false
	}
	return o.AzureFixedUserNameSubClaimKey, true
}

// HasAzureFixedUserNameSubClaimKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureFixedUserNameSubClaimKey() bool {
	if o != nil && o.AzureFixedUserNameSubClaimKey != nil {
		return true
	}

	return false
}

// SetAzureFixedUserNameSubClaimKey gets a reference to the given string and assigns it to the AzureFixedUserNameSubClaimKey field.
func (o *DSProducerDetails) SetAzureFixedUserNameSubClaimKey(v string) {
	o.AzureFixedUserNameSubClaimKey = &v
}

// GetAzureFixedUserOnly returns the AzureFixedUserOnly field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureFixedUserOnly() bool {
	if o == nil || o.AzureFixedUserOnly == nil {
		var ret bool
		return ret
	}
	return *o.AzureFixedUserOnly
}

// GetAzureFixedUserOnlyOk returns a tuple with the AzureFixedUserOnly field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureFixedUserOnlyOk() (*bool, bool) {
	if o == nil || o.AzureFixedUserOnly == nil {
		return nil, false
	}
	return o.AzureFixedUserOnly, true
}

// HasAzureFixedUserOnly returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureFixedUserOnly() bool {
	if o != nil && o.AzureFixedUserOnly != nil {
		return true
	}

	return false
}

// SetAzureFixedUserOnly gets a reference to the given bool and assigns it to the AzureFixedUserOnly field.
func (o *DSProducerDetails) SetAzureFixedUserOnly(v bool) {
	o.AzureFixedUserOnly = &v
}

// GetAzureResourceGroupName returns the AzureResourceGroupName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureResourceGroupName() string {
	if o == nil || o.AzureResourceGroupName == nil {
		var ret string
		return ret
	}
	return *o.AzureResourceGroupName
}

// GetAzureResourceGroupNameOk returns a tuple with the AzureResourceGroupName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureResourceGroupNameOk() (*string, bool) {
	if o == nil || o.AzureResourceGroupName == nil {
		return nil, false
	}
	return o.AzureResourceGroupName, true
}

// HasAzureResourceGroupName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureResourceGroupName() bool {
	if o != nil && o.AzureResourceGroupName != nil {
		return true
	}

	return false
}

// SetAzureResourceGroupName gets a reference to the given string and assigns it to the AzureResourceGroupName field.
func (o *DSProducerDetails) SetAzureResourceGroupName(v string) {
	o.AzureResourceGroupName = &v
}

// GetAzureResourceName returns the AzureResourceName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureResourceName() string {
	if o == nil || o.AzureResourceName == nil {
		var ret string
		return ret
	}
	return *o.AzureResourceName
}

// GetAzureResourceNameOk returns a tuple with the AzureResourceName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureResourceNameOk() (*string, bool) {
	if o == nil || o.AzureResourceName == nil {
		return nil, false
	}
	return o.AzureResourceName, true
}

// HasAzureResourceName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureResourceName() bool {
	if o != nil && o.AzureResourceName != nil {
		return true
	}

	return false
}

// SetAzureResourceName gets a reference to the given string and assigns it to the AzureResourceName field.
func (o *DSProducerDetails) SetAzureResourceName(v string) {
	o.AzureResourceName = &v
}

// GetAzureSubscriptionId returns the AzureSubscriptionId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureSubscriptionId() string {
	if o == nil || o.AzureSubscriptionId == nil {
		var ret string
		return ret
	}
	return *o.AzureSubscriptionId
}

// GetAzureSubscriptionIdOk returns a tuple with the AzureSubscriptionId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureSubscriptionIdOk() (*string, bool) {
	if o == nil || o.AzureSubscriptionId == nil {
		return nil, false
	}
	return o.AzureSubscriptionId, true
}

// HasAzureSubscriptionId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureSubscriptionId() bool {
	if o != nil && o.AzureSubscriptionId != nil {
		return true
	}

	return false
}

// SetAzureSubscriptionId gets a reference to the given string and assigns it to the AzureSubscriptionId field.
func (o *DSProducerDetails) SetAzureSubscriptionId(v string) {
	o.AzureSubscriptionId = &v
}

// GetAzureTenantId returns the AzureTenantId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureTenantId() string {
	if o == nil || o.AzureTenantId == nil {
		var ret string
		return ret
	}
	return *o.AzureTenantId
}

// GetAzureTenantIdOk returns a tuple with the AzureTenantId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureTenantIdOk() (*string, bool) {
	if o == nil || o.AzureTenantId == nil {
		return nil, false
	}
	return o.AzureTenantId, true
}

// HasAzureTenantId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureTenantId() bool {
	if o != nil && o.AzureTenantId != nil {
		return true
	}

	return false
}

// SetAzureTenantId gets a reference to the given string and assigns it to the AzureTenantId field.
func (o *DSProducerDetails) SetAzureTenantId(v string) {
	o.AzureTenantId = &v
}

// GetAzureUserGroupsObjId returns the AzureUserGroupsObjId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureUserGroupsObjId() string {
	if o == nil || o.AzureUserGroupsObjId == nil {
		var ret string
		return ret
	}
	return *o.AzureUserGroupsObjId
}

// GetAzureUserGroupsObjIdOk returns a tuple with the AzureUserGroupsObjId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureUserGroupsObjIdOk() (*string, bool) {
	if o == nil || o.AzureUserGroupsObjId == nil {
		return nil, false
	}
	return o.AzureUserGroupsObjId, true
}

// HasAzureUserGroupsObjId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureUserGroupsObjId() bool {
	if o != nil && o.AzureUserGroupsObjId != nil {
		return true
	}

	return false
}

// SetAzureUserGroupsObjId gets a reference to the given string and assigns it to the AzureUserGroupsObjId field.
func (o *DSProducerDetails) SetAzureUserGroupsObjId(v string) {
	o.AzureUserGroupsObjId = &v
}

// GetAzureUserPortalAccess returns the AzureUserPortalAccess field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureUserPortalAccess() bool {
	if o == nil || o.AzureUserPortalAccess == nil {
		var ret bool
		return ret
	}
	return *o.AzureUserPortalAccess
}

// GetAzureUserPortalAccessOk returns a tuple with the AzureUserPortalAccess field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureUserPortalAccessOk() (*bool, bool) {
	if o == nil || o.AzureUserPortalAccess == nil {
		return nil, false
	}
	return o.AzureUserPortalAccess, true
}

// HasAzureUserPortalAccess returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureUserPortalAccess() bool {
	if o != nil && o.AzureUserPortalAccess != nil {
		return true
	}

	return false
}

// SetAzureUserPortalAccess gets a reference to the given bool and assigns it to the AzureUserPortalAccess field.
func (o *DSProducerDetails) SetAzureUserPortalAccess(v bool) {
	o.AzureUserPortalAccess = &v
}

// GetAzureUserProgrammaticAccess returns the AzureUserProgrammaticAccess field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureUserProgrammaticAccess() bool {
	if o == nil || o.AzureUserProgrammaticAccess == nil {
		var ret bool
		return ret
	}
	return *o.AzureUserProgrammaticAccess
}

// GetAzureUserProgrammaticAccessOk returns a tuple with the AzureUserProgrammaticAccess field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureUserProgrammaticAccessOk() (*bool, bool) {
	if o == nil || o.AzureUserProgrammaticAccess == nil {
		return nil, false
	}
	return o.AzureUserProgrammaticAccess, true
}

// HasAzureUserProgrammaticAccess returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureUserProgrammaticAccess() bool {
	if o != nil && o.AzureUserProgrammaticAccess != nil {
		return true
	}

	return false
}

// SetAzureUserProgrammaticAccess gets a reference to the given bool and assigns it to the AzureUserProgrammaticAccess field.
func (o *DSProducerDetails) SetAzureUserProgrammaticAccess(v bool) {
	o.AzureUserProgrammaticAccess = &v
}

// GetAzureUserRolesTemplateId returns the AzureUserRolesTemplateId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureUserRolesTemplateId() string {
	if o == nil || o.AzureUserRolesTemplateId == nil {
		var ret string
		return ret
	}
	return *o.AzureUserRolesTemplateId
}

// GetAzureUserRolesTemplateIdOk returns a tuple with the AzureUserRolesTemplateId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureUserRolesTemplateIdOk() (*string, bool) {
	if o == nil || o.AzureUserRolesTemplateId == nil {
		return nil, false
	}
	return o.AzureUserRolesTemplateId, true
}

// HasAzureUserRolesTemplateId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureUserRolesTemplateId() bool {
	if o != nil && o.AzureUserRolesTemplateId != nil {
		return true
	}

	return false
}

// SetAzureUserRolesTemplateId gets a reference to the given string and assigns it to the AzureUserRolesTemplateId field.
func (o *DSProducerDetails) SetAzureUserRolesTemplateId(v string) {
	o.AzureUserRolesTemplateId = &v
}

// GetAzureUsername returns the AzureUsername field value if set, zero value otherwise.
func (o *DSProducerDetails) GetAzureUsername() string {
	if o == nil || o.AzureUsername == nil {
		var ret string
		return ret
	}
	return *o.AzureUsername
}

// GetAzureUsernameOk returns a tuple with the AzureUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetAzureUsernameOk() (*string, bool) {
	if o == nil || o.AzureUsername == nil {
		return nil, false
	}
	return o.AzureUsername, true
}

// HasAzureUsername returns a boolean if a field has been set.
func (o *DSProducerDetails) HasAzureUsername() bool {
	if o != nil && o.AzureUsername != nil {
		return true
	}

	return false
}

// SetAzureUsername gets a reference to the given string and assigns it to the AzureUsername field.
func (o *DSProducerDetails) SetAzureUsername(v string) {
	o.AzureUsername = &v
}

// GetCassandraCreationStatements returns the CassandraCreationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetCassandraCreationStatements() string {
	if o == nil || o.CassandraCreationStatements == nil {
		var ret string
		return ret
	}
	return *o.CassandraCreationStatements
}

// GetCassandraCreationStatementsOk returns a tuple with the CassandraCreationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetCassandraCreationStatementsOk() (*string, bool) {
	if o == nil || o.CassandraCreationStatements == nil {
		return nil, false
	}
	return o.CassandraCreationStatements, true
}

// HasCassandraCreationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasCassandraCreationStatements() bool {
	if o != nil && o.CassandraCreationStatements != nil {
		return true
	}

	return false
}

// SetCassandraCreationStatements gets a reference to the given string and assigns it to the CassandraCreationStatements field.
func (o *DSProducerDetails) SetCassandraCreationStatements(v string) {
	o.CassandraCreationStatements = &v
}

// GetChefOrganizations returns the ChefOrganizations field value if set, zero value otherwise.
func (o *DSProducerDetails) GetChefOrganizations() string {
	if o == nil || o.ChefOrganizations == nil {
		var ret string
		return ret
	}
	return *o.ChefOrganizations
}

// GetChefOrganizationsOk returns a tuple with the ChefOrganizations field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetChefOrganizationsOk() (*string, bool) {
	if o == nil || o.ChefOrganizations == nil {
		return nil, false
	}
	return o.ChefOrganizations, true
}

// HasChefOrganizations returns a boolean if a field has been set.
func (o *DSProducerDetails) HasChefOrganizations() bool {
	if o != nil && o.ChefOrganizations != nil {
		return true
	}

	return false
}

// SetChefOrganizations gets a reference to the given string and assigns it to the ChefOrganizations field.
func (o *DSProducerDetails) SetChefOrganizations(v string) {
	o.ChefOrganizations = &v
}

// GetChefServerAccessMode returns the ChefServerAccessMode field value if set, zero value otherwise.
func (o *DSProducerDetails) GetChefServerAccessMode() string {
	if o == nil || o.ChefServerAccessMode == nil {
		var ret string
		return ret
	}
	return *o.ChefServerAccessMode
}

// GetChefServerAccessModeOk returns a tuple with the ChefServerAccessMode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetChefServerAccessModeOk() (*string, bool) {
	if o == nil || o.ChefServerAccessMode == nil {
		return nil, false
	}
	return o.ChefServerAccessMode, true
}

// HasChefServerAccessMode returns a boolean if a field has been set.
func (o *DSProducerDetails) HasChefServerAccessMode() bool {
	if o != nil && o.ChefServerAccessMode != nil {
		return true
	}

	return false
}

// SetChefServerAccessMode gets a reference to the given string and assigns it to the ChefServerAccessMode field.
func (o *DSProducerDetails) SetChefServerAccessMode(v string) {
	o.ChefServerAccessMode = &v
}

// GetChefServerHostName returns the ChefServerHostName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetChefServerHostName() string {
	if o == nil || o.ChefServerHostName == nil {
		var ret string
		return ret
	}
	return *o.ChefServerHostName
}

// GetChefServerHostNameOk returns a tuple with the ChefServerHostName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetChefServerHostNameOk() (*string, bool) {
	if o == nil || o.ChefServerHostName == nil {
		return nil, false
	}
	return o.ChefServerHostName, true
}

// HasChefServerHostName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasChefServerHostName() bool {
	if o != nil && o.ChefServerHostName != nil {
		return true
	}

	return false
}

// SetChefServerHostName gets a reference to the given string and assigns it to the ChefServerHostName field.
func (o *DSProducerDetails) SetChefServerHostName(v string) {
	o.ChefServerHostName = &v
}

// GetChefServerKey returns the ChefServerKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetChefServerKey() string {
	if o == nil || o.ChefServerKey == nil {
		var ret string
		return ret
	}
	return *o.ChefServerKey
}

// GetChefServerKeyOk returns a tuple with the ChefServerKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetChefServerKeyOk() (*string, bool) {
	if o == nil || o.ChefServerKey == nil {
		return nil, false
	}
	return o.ChefServerKey, true
}

// HasChefServerKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasChefServerKey() bool {
	if o != nil && o.ChefServerKey != nil {
		return true
	}

	return false
}

// SetChefServerKey gets a reference to the given string and assigns it to the ChefServerKey field.
func (o *DSProducerDetails) SetChefServerKey(v string) {
	o.ChefServerKey = &v
}

// GetChefServerPort returns the ChefServerPort field value if set, zero value otherwise.
func (o *DSProducerDetails) GetChefServerPort() string {
	if o == nil || o.ChefServerPort == nil {
		var ret string
		return ret
	}
	return *o.ChefServerPort
}

// GetChefServerPortOk returns a tuple with the ChefServerPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetChefServerPortOk() (*string, bool) {
	if o == nil || o.ChefServerPort == nil {
		return nil, false
	}
	return o.ChefServerPort, true
}

// HasChefServerPort returns a boolean if a field has been set.
func (o *DSProducerDetails) HasChefServerPort() bool {
	if o != nil && o.ChefServerPort != nil {
		return true
	}

	return false
}

// SetChefServerPort gets a reference to the given string and assigns it to the ChefServerPort field.
func (o *DSProducerDetails) SetChefServerPort(v string) {
	o.ChefServerPort = &v
}

// GetChefServerUrl returns the ChefServerUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetChefServerUrl() string {
	if o == nil || o.ChefServerUrl == nil {
		var ret string
		return ret
	}
	return *o.ChefServerUrl
}

// GetChefServerUrlOk returns a tuple with the ChefServerUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetChefServerUrlOk() (*string, bool) {
	if o == nil || o.ChefServerUrl == nil {
		return nil, false
	}
	return o.ChefServerUrl, true
}

// HasChefServerUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasChefServerUrl() bool {
	if o != nil && o.ChefServerUrl != nil {
		return true
	}

	return false
}

// SetChefServerUrl gets a reference to the given string and assigns it to the ChefServerUrl field.
func (o *DSProducerDetails) SetChefServerUrl(v string) {
	o.ChefServerUrl = &v
}

// GetChefServerUsername returns the ChefServerUsername field value if set, zero value otherwise.
func (o *DSProducerDetails) GetChefServerUsername() string {
	if o == nil || o.ChefServerUsername == nil {
		var ret string
		return ret
	}
	return *o.ChefServerUsername
}

// GetChefServerUsernameOk returns a tuple with the ChefServerUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetChefServerUsernameOk() (*string, bool) {
	if o == nil || o.ChefServerUsername == nil {
		return nil, false
	}
	return o.ChefServerUsername, true
}

// HasChefServerUsername returns a boolean if a field has been set.
func (o *DSProducerDetails) HasChefServerUsername() bool {
	if o != nil && o.ChefServerUsername != nil {
		return true
	}

	return false
}

// SetChefServerUsername gets a reference to the given string and assigns it to the ChefServerUsername field.
func (o *DSProducerDetails) SetChefServerUsername(v string) {
	o.ChefServerUsername = &v
}

// GetChefSkipSsl returns the ChefSkipSsl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetChefSkipSsl() bool {
	if o == nil || o.ChefSkipSsl == nil {
		var ret bool
		return ret
	}
	return *o.ChefSkipSsl
}

// GetChefSkipSslOk returns a tuple with the ChefSkipSsl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetChefSkipSslOk() (*bool, bool) {
	if o == nil || o.ChefSkipSsl == nil {
		return nil, false
	}
	return o.ChefSkipSsl, true
}

// HasChefSkipSsl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasChefSkipSsl() bool {
	if o != nil && o.ChefSkipSsl != nil {
		return true
	}

	return false
}

// SetChefSkipSsl gets a reference to the given bool and assigns it to the ChefSkipSsl field.
func (o *DSProducerDetails) SetChefSkipSsl(v bool) {
	o.ChefSkipSsl = &v
}

// GetClientAuthenticationType returns the ClientAuthenticationType field value if set, zero value otherwise.
func (o *DSProducerDetails) GetClientAuthenticationType() string {
	if o == nil || o.ClientAuthenticationType == nil {
		var ret string
		return ret
	}
	return *o.ClientAuthenticationType
}

// GetClientAuthenticationTypeOk returns a tuple with the ClientAuthenticationType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetClientAuthenticationTypeOk() (*string, bool) {
	if o == nil || o.ClientAuthenticationType == nil {
		return nil, false
	}
	return o.ClientAuthenticationType, true
}

// HasClientAuthenticationType returns a boolean if a field has been set.
func (o *DSProducerDetails) HasClientAuthenticationType() bool {
	if o != nil && o.ClientAuthenticationType != nil {
		return true
	}

	return false
}

// SetClientAuthenticationType gets a reference to the given string and assigns it to the ClientAuthenticationType field.
func (o *DSProducerDetails) SetClientAuthenticationType(v string) {
	o.ClientAuthenticationType = &v
}

// GetCloudServiceProvider returns the CloudServiceProvider field value if set, zero value otherwise.
func (o *DSProducerDetails) GetCloudServiceProvider() string {
	if o == nil || o.CloudServiceProvider == nil {
		var ret string
		return ret
	}
	return *o.CloudServiceProvider
}

// GetCloudServiceProviderOk returns a tuple with the CloudServiceProvider field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetCloudServiceProviderOk() (*string, bool) {
	if o == nil || o.CloudServiceProvider == nil {
		return nil, false
	}
	return o.CloudServiceProvider, true
}

// HasCloudServiceProvider returns a boolean if a field has been set.
func (o *DSProducerDetails) HasCloudServiceProvider() bool {
	if o != nil && o.CloudServiceProvider != nil {
		return true
	}

	return false
}

// SetCloudServiceProvider gets a reference to the given string and assigns it to the CloudServiceProvider field.
func (o *DSProducerDetails) SetCloudServiceProvider(v string) {
	o.CloudServiceProvider = &v
}

// GetClusterMode returns the ClusterMode field value if set, zero value otherwise.
func (o *DSProducerDetails) GetClusterMode() bool {
	if o == nil || o.ClusterMode == nil {
		var ret bool
		return ret
	}
	return *o.ClusterMode
}

// GetClusterModeOk returns a tuple with the ClusterMode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetClusterModeOk() (*bool, bool) {
	if o == nil || o.ClusterMode == nil {
		return nil, false
	}
	return o.ClusterMode, true
}

// HasClusterMode returns a boolean if a field has been set.
func (o *DSProducerDetails) HasClusterMode() bool {
	if o != nil && o.ClusterMode != nil {
		return true
	}

	return false
}

// SetClusterMode gets a reference to the given bool and assigns it to the ClusterMode field.
func (o *DSProducerDetails) SetClusterMode(v bool) {
	o.ClusterMode = &v
}

// GetConnectionType returns the ConnectionType field value if set, zero value otherwise.
func (o *DSProducerDetails) GetConnectionType() string {
	if o == nil || o.ConnectionType == nil {
		var ret string
		return ret
	}
	return *o.ConnectionType
}

// GetConnectionTypeOk returns a tuple with the ConnectionType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetConnectionTypeOk() (*string, bool) {
	if o == nil || o.ConnectionType == nil {
		return nil, false
	}
	return o.ConnectionType, true
}

// HasConnectionType returns a boolean if a field has been set.
func (o *DSProducerDetails) HasConnectionType() bool {
	if o != nil && o.ConnectionType != nil {
		return true
	}

	return false
}

// SetConnectionType gets a reference to the given string and assigns it to the ConnectionType field.
func (o *DSProducerDetails) SetConnectionType(v string) {
	o.ConnectionType = &v
}

// GetCreateSyncUrl returns the CreateSyncUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetCreateSyncUrl() string {
	if o == nil || o.CreateSyncUrl == nil {
		var ret string
		return ret
	}
	return *o.CreateSyncUrl
}

// GetCreateSyncUrlOk returns a tuple with the CreateSyncUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetCreateSyncUrlOk() (*string, bool) {
	if o == nil || o.CreateSyncUrl == nil {
		return nil, false
	}
	return o.CreateSyncUrl, true
}

// HasCreateSyncUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasCreateSyncUrl() bool {
	if o != nil && o.CreateSyncUrl != nil {
		return true
	}

	return false
}

// SetCreateSyncUrl gets a reference to the given string and assigns it to the CreateSyncUrl field.
func (o *DSProducerDetails) SetCreateSyncUrl(v string) {
	o.CreateSyncUrl = &v
}

// GetDbClientId returns the DbClientId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbClientId() string {
	if o == nil || o.DbClientId == nil {
		var ret string
		return ret
	}
	return *o.DbClientId
}

// GetDbClientIdOk returns a tuple with the DbClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbClientIdOk() (*string, bool) {
	if o == nil || o.DbClientId == nil {
		return nil, false
	}
	return o.DbClientId, true
}

// HasDbClientId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbClientId() bool {
	if o != nil && o.DbClientId != nil {
		return true
	}

	return false
}

// SetDbClientId gets a reference to the given string and assigns it to the DbClientId field.
func (o *DSProducerDetails) SetDbClientId(v string) {
	o.DbClientId = &v
}

// GetDbClientSecret returns the DbClientSecret field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbClientSecret() string {
	if o == nil || o.DbClientSecret == nil {
		var ret string
		return ret
	}
	return *o.DbClientSecret
}

// GetDbClientSecretOk returns a tuple with the DbClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbClientSecretOk() (*string, bool) {
	if o == nil || o.DbClientSecret == nil {
		return nil, false
	}
	return o.DbClientSecret, true
}

// HasDbClientSecret returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbClientSecret() bool {
	if o != nil && o.DbClientSecret != nil {
		return true
	}

	return false
}

// SetDbClientSecret gets a reference to the given string and assigns it to the DbClientSecret field.
func (o *DSProducerDetails) SetDbClientSecret(v string) {
	o.DbClientSecret = &v
}

// GetDbHostName returns the DbHostName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbHostName() string {
	if o == nil || o.DbHostName == nil {
		var ret string
		return ret
	}
	return *o.DbHostName
}

// GetDbHostNameOk returns a tuple with the DbHostName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbHostNameOk() (*string, bool) {
	if o == nil || o.DbHostName == nil {
		return nil, false
	}
	return o.DbHostName, true
}

// HasDbHostName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbHostName() bool {
	if o != nil && o.DbHostName != nil {
		return true
	}

	return false
}

// SetDbHostName gets a reference to the given string and assigns it to the DbHostName field.
func (o *DSProducerDetails) SetDbHostName(v string) {
	o.DbHostName = &v
}

// GetDbIsolationLevel returns the DbIsolationLevel field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbIsolationLevel() string {
	if o == nil || o.DbIsolationLevel == nil {
		var ret string
		return ret
	}
	return *o.DbIsolationLevel
}

// GetDbIsolationLevelOk returns a tuple with the DbIsolationLevel field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbIsolationLevelOk() (*string, bool) {
	if o == nil || o.DbIsolationLevel == nil {
		return nil, false
	}
	return o.DbIsolationLevel, true
}

// HasDbIsolationLevel returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbIsolationLevel() bool {
	if o != nil && o.DbIsolationLevel != nil {
		return true
	}

	return false
}

// SetDbIsolationLevel gets a reference to the given string and assigns it to the DbIsolationLevel field.
func (o *DSProducerDetails) SetDbIsolationLevel(v string) {
	o.DbIsolationLevel = &v
}

// GetDbMaxIdleConns returns the DbMaxIdleConns field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbMaxIdleConns() string {
	if o == nil || o.DbMaxIdleConns == nil {
		var ret string
		return ret
	}
	return *o.DbMaxIdleConns
}

// GetDbMaxIdleConnsOk returns a tuple with the DbMaxIdleConns field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbMaxIdleConnsOk() (*string, bool) {
	if o == nil || o.DbMaxIdleConns == nil {
		return nil, false
	}
	return o.DbMaxIdleConns, true
}

// HasDbMaxIdleConns returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbMaxIdleConns() bool {
	if o != nil && o.DbMaxIdleConns != nil {
		return true
	}

	return false
}

// SetDbMaxIdleConns gets a reference to the given string and assigns it to the DbMaxIdleConns field.
func (o *DSProducerDetails) SetDbMaxIdleConns(v string) {
	o.DbMaxIdleConns = &v
}

// GetDbMaxOpenConns returns the DbMaxOpenConns field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbMaxOpenConns() string {
	if o == nil || o.DbMaxOpenConns == nil {
		var ret string
		return ret
	}
	return *o.DbMaxOpenConns
}

// GetDbMaxOpenConnsOk returns a tuple with the DbMaxOpenConns field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbMaxOpenConnsOk() (*string, bool) {
	if o == nil || o.DbMaxOpenConns == nil {
		return nil, false
	}
	return o.DbMaxOpenConns, true
}

// HasDbMaxOpenConns returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbMaxOpenConns() bool {
	if o != nil && o.DbMaxOpenConns != nil {
		return true
	}

	return false
}

// SetDbMaxOpenConns gets a reference to the given string and assigns it to the DbMaxOpenConns field.
func (o *DSProducerDetails) SetDbMaxOpenConns(v string) {
	o.DbMaxOpenConns = &v
}

// GetDbName returns the DbName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbName() string {
	if o == nil || o.DbName == nil {
		var ret string
		return ret
	}
	return *o.DbName
}

// GetDbNameOk returns a tuple with the DbName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbNameOk() (*string, bool) {
	if o == nil || o.DbName == nil {
		return nil, false
	}
	return o.DbName, true
}

// HasDbName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbName() bool {
	if o != nil && o.DbName != nil {
		return true
	}

	return false
}

// SetDbName gets a reference to the given string and assigns it to the DbName field.
func (o *DSProducerDetails) SetDbName(v string) {
	o.DbName = &v
}

// GetDbPort returns the DbPort field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbPort() string {
	if o == nil || o.DbPort == nil {
		var ret string
		return ret
	}
	return *o.DbPort
}

// GetDbPortOk returns a tuple with the DbPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbPortOk() (*string, bool) {
	if o == nil || o.DbPort == nil {
		return nil, false
	}
	return o.DbPort, true
}

// HasDbPort returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbPort() bool {
	if o != nil && o.DbPort != nil {
		return true
	}

	return false
}

// SetDbPort gets a reference to the given string and assigns it to the DbPort field.
func (o *DSProducerDetails) SetDbPort(v string) {
	o.DbPort = &v
}

// GetDbPrivateKey returns the DbPrivateKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbPrivateKey() string {
	if o == nil || o.DbPrivateKey == nil {
		var ret string
		return ret
	}
	return *o.DbPrivateKey
}

// GetDbPrivateKeyOk returns a tuple with the DbPrivateKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbPrivateKeyOk() (*string, bool) {
	if o == nil || o.DbPrivateKey == nil {
		return nil, false
	}
	return o.DbPrivateKey, true
}

// HasDbPrivateKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbPrivateKey() bool {
	if o != nil && o.DbPrivateKey != nil {
		return true
	}

	return false
}

// SetDbPrivateKey gets a reference to the given string and assigns it to the DbPrivateKey field.
func (o *DSProducerDetails) SetDbPrivateKey(v string) {
	o.DbPrivateKey = &v
}

// GetDbPrivateKeyPassphrase returns the DbPrivateKeyPassphrase field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbPrivateKeyPassphrase() string {
	if o == nil || o.DbPrivateKeyPassphrase == nil {
		var ret string
		return ret
	}
	return *o.DbPrivateKeyPassphrase
}

// GetDbPrivateKeyPassphraseOk returns a tuple with the DbPrivateKeyPassphrase field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbPrivateKeyPassphraseOk() (*string, bool) {
	if o == nil || o.DbPrivateKeyPassphrase == nil {
		return nil, false
	}
	return o.DbPrivateKeyPassphrase, true
}

// HasDbPrivateKeyPassphrase returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbPrivateKeyPassphrase() bool {
	if o != nil && o.DbPrivateKeyPassphrase != nil {
		return true
	}

	return false
}

// SetDbPrivateKeyPassphrase gets a reference to the given string and assigns it to the DbPrivateKeyPassphrase field.
func (o *DSProducerDetails) SetDbPrivateKeyPassphrase(v string) {
	o.DbPrivateKeyPassphrase = &v
}

// GetDbPwd returns the DbPwd field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbPwd() string {
	if o == nil || o.DbPwd == nil {
		var ret string
		return ret
	}
	return *o.DbPwd
}

// GetDbPwdOk returns a tuple with the DbPwd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbPwdOk() (*string, bool) {
	if o == nil || o.DbPwd == nil {
		return nil, false
	}
	return o.DbPwd, true
}

// HasDbPwd returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbPwd() bool {
	if o != nil && o.DbPwd != nil {
		return true
	}

	return false
}

// SetDbPwd gets a reference to the given string and assigns it to the DbPwd field.
func (o *DSProducerDetails) SetDbPwd(v string) {
	o.DbPwd = &v
}

// GetDbServerCertificates returns the DbServerCertificates field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbServerCertificates() string {
	if o == nil || o.DbServerCertificates == nil {
		var ret string
		return ret
	}
	return *o.DbServerCertificates
}

// GetDbServerCertificatesOk returns a tuple with the DbServerCertificates field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbServerCertificatesOk() (*string, bool) {
	if o == nil || o.DbServerCertificates == nil {
		return nil, false
	}
	return o.DbServerCertificates, true
}

// HasDbServerCertificates returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbServerCertificates() bool {
	if o != nil && o.DbServerCertificates != nil {
		return true
	}

	return false
}

// SetDbServerCertificates gets a reference to the given string and assigns it to the DbServerCertificates field.
func (o *DSProducerDetails) SetDbServerCertificates(v string) {
	o.DbServerCertificates = &v
}

// GetDbServerName returns the DbServerName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbServerName() string {
	if o == nil || o.DbServerName == nil {
		var ret string
		return ret
	}
	return *o.DbServerName
}

// GetDbServerNameOk returns a tuple with the DbServerName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbServerNameOk() (*string, bool) {
	if o == nil || o.DbServerName == nil {
		return nil, false
	}
	return o.DbServerName, true
}

// HasDbServerName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbServerName() bool {
	if o != nil && o.DbServerName != nil {
		return true
	}

	return false
}

// SetDbServerName gets a reference to the given string and assigns it to the DbServerName field.
func (o *DSProducerDetails) SetDbServerName(v string) {
	o.DbServerName = &v
}

// GetDbTenantId returns the DbTenantId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbTenantId() string {
	if o == nil || o.DbTenantId == nil {
		var ret string
		return ret
	}
	return *o.DbTenantId
}

// GetDbTenantIdOk returns a tuple with the DbTenantId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbTenantIdOk() (*string, bool) {
	if o == nil || o.DbTenantId == nil {
		return nil, false
	}
	return o.DbTenantId, true
}

// HasDbTenantId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbTenantId() bool {
	if o != nil && o.DbTenantId != nil {
		return true
	}

	return false
}

// SetDbTenantId gets a reference to the given string and assigns it to the DbTenantId field.
func (o *DSProducerDetails) SetDbTenantId(v string) {
	o.DbTenantId = &v
}

// GetDbUserName returns the DbUserName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDbUserName() string {
	if o == nil || o.DbUserName == nil {
		var ret string
		return ret
	}
	return *o.DbUserName
}

// GetDbUserNameOk returns a tuple with the DbUserName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDbUserNameOk() (*string, bool) {
	if o == nil || o.DbUserName == nil {
		return nil, false
	}
	return o.DbUserName, true
}

// HasDbUserName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDbUserName() bool {
	if o != nil && o.DbUserName != nil {
		return true
	}

	return false
}

// SetDbUserName gets a reference to the given string and assigns it to the DbUserName field.
func (o *DSProducerDetails) SetDbUserName(v string) {
	o.DbUserName = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDeleteProtection() bool {
	if o == nil || o.DeleteProtection == nil {
		var ret bool
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDeleteProtectionOk() (*bool, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given bool and assigns it to the DeleteProtection field.
func (o *DSProducerDetails) SetDeleteProtection(v bool) {
	o.DeleteProtection = &v
}

// GetDynamicSecretId returns the DynamicSecretId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDynamicSecretId() int64 {
	if o == nil || o.DynamicSecretId == nil {
		var ret int64
		return ret
	}
	return *o.DynamicSecretId
}

// GetDynamicSecretIdOk returns a tuple with the DynamicSecretId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDynamicSecretIdOk() (*int64, bool) {
	if o == nil || o.DynamicSecretId == nil {
		return nil, false
	}
	return o.DynamicSecretId, true
}

// HasDynamicSecretId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDynamicSecretId() bool {
	if o != nil && o.DynamicSecretId != nil {
		return true
	}

	return false
}

// SetDynamicSecretId gets a reference to the given int64 and assigns it to the DynamicSecretId field.
func (o *DSProducerDetails) SetDynamicSecretId(v int64) {
	o.DynamicSecretId = &v
}

// GetDynamicSecretKey returns the DynamicSecretKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDynamicSecretKey() string {
	if o == nil || o.DynamicSecretKey == nil {
		var ret string
		return ret
	}
	return *o.DynamicSecretKey
}

// GetDynamicSecretKeyOk returns a tuple with the DynamicSecretKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDynamicSecretKeyOk() (*string, bool) {
	if o == nil || o.DynamicSecretKey == nil {
		return nil, false
	}
	return o.DynamicSecretKey, true
}

// HasDynamicSecretKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDynamicSecretKey() bool {
	if o != nil && o.DynamicSecretKey != nil {
		return true
	}

	return false
}

// SetDynamicSecretKey gets a reference to the given string and assigns it to the DynamicSecretKey field.
func (o *DSProducerDetails) SetDynamicSecretKey(v string) {
	o.DynamicSecretKey = &v
}

// GetDynamicSecretName returns the DynamicSecretName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDynamicSecretName() string {
	if o == nil || o.DynamicSecretName == nil {
		var ret string
		return ret
	}
	return *o.DynamicSecretName
}

// GetDynamicSecretNameOk returns a tuple with the DynamicSecretName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDynamicSecretNameOk() (*string, bool) {
	if o == nil || o.DynamicSecretName == nil {
		return nil, false
	}
	return o.DynamicSecretName, true
}

// HasDynamicSecretName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDynamicSecretName() bool {
	if o != nil && o.DynamicSecretName != nil {
		return true
	}

	return false
}

// SetDynamicSecretName gets a reference to the given string and assigns it to the DynamicSecretName field.
func (o *DSProducerDetails) SetDynamicSecretName(v string) {
	o.DynamicSecretName = &v
}

// GetDynamicSecretType returns the DynamicSecretType field value if set, zero value otherwise.
func (o *DSProducerDetails) GetDynamicSecretType() string {
	if o == nil || o.DynamicSecretType == nil {
		var ret string
		return ret
	}
	return *o.DynamicSecretType
}

// GetDynamicSecretTypeOk returns a tuple with the DynamicSecretType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetDynamicSecretTypeOk() (*string, bool) {
	if o == nil || o.DynamicSecretType == nil {
		return nil, false
	}
	return o.DynamicSecretType, true
}

// HasDynamicSecretType returns a boolean if a field has been set.
func (o *DSProducerDetails) HasDynamicSecretType() bool {
	if o != nil && o.DynamicSecretType != nil {
		return true
	}

	return false
}

// SetDynamicSecretType gets a reference to the given string and assigns it to the DynamicSecretType field.
func (o *DSProducerDetails) SetDynamicSecretType(v string) {
	o.DynamicSecretType = &v
}

// GetEksAccessKeyId returns the EksAccessKeyId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetEksAccessKeyId() string {
	if o == nil || o.EksAccessKeyId == nil {
		var ret string
		return ret
	}
	return *o.EksAccessKeyId
}

// GetEksAccessKeyIdOk returns a tuple with the EksAccessKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetEksAccessKeyIdOk() (*string, bool) {
	if o == nil || o.EksAccessKeyId == nil {
		return nil, false
	}
	return o.EksAccessKeyId, true
}

// HasEksAccessKeyId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasEksAccessKeyId() bool {
	if o != nil && o.EksAccessKeyId != nil {
		return true
	}

	return false
}

// SetEksAccessKeyId gets a reference to the given string and assigns it to the EksAccessKeyId field.
func (o *DSProducerDetails) SetEksAccessKeyId(v string) {
	o.EksAccessKeyId = &v
}

// GetEksAssumeRole returns the EksAssumeRole field value if set, zero value otherwise.
func (o *DSProducerDetails) GetEksAssumeRole() string {
	if o == nil || o.EksAssumeRole == nil {
		var ret string
		return ret
	}
	return *o.EksAssumeRole
}

// GetEksAssumeRoleOk returns a tuple with the EksAssumeRole field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetEksAssumeRoleOk() (*string, bool) {
	if o == nil || o.EksAssumeRole == nil {
		return nil, false
	}
	return o.EksAssumeRole, true
}

// HasEksAssumeRole returns a boolean if a field has been set.
func (o *DSProducerDetails) HasEksAssumeRole() bool {
	if o != nil && o.EksAssumeRole != nil {
		return true
	}

	return false
}

// SetEksAssumeRole gets a reference to the given string and assigns it to the EksAssumeRole field.
func (o *DSProducerDetails) SetEksAssumeRole(v string) {
	o.EksAssumeRole = &v
}

// GetEksClusterCaCertificate returns the EksClusterCaCertificate field value if set, zero value otherwise.
func (o *DSProducerDetails) GetEksClusterCaCertificate() string {
	if o == nil || o.EksClusterCaCertificate == nil {
		var ret string
		return ret
	}
	return *o.EksClusterCaCertificate
}

// GetEksClusterCaCertificateOk returns a tuple with the EksClusterCaCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetEksClusterCaCertificateOk() (*string, bool) {
	if o == nil || o.EksClusterCaCertificate == nil {
		return nil, false
	}
	return o.EksClusterCaCertificate, true
}

// HasEksClusterCaCertificate returns a boolean if a field has been set.
func (o *DSProducerDetails) HasEksClusterCaCertificate() bool {
	if o != nil && o.EksClusterCaCertificate != nil {
		return true
	}

	return false
}

// SetEksClusterCaCertificate gets a reference to the given string and assigns it to the EksClusterCaCertificate field.
func (o *DSProducerDetails) SetEksClusterCaCertificate(v string) {
	o.EksClusterCaCertificate = &v
}

// GetEksClusterEndpoint returns the EksClusterEndpoint field value if set, zero value otherwise.
func (o *DSProducerDetails) GetEksClusterEndpoint() string {
	if o == nil || o.EksClusterEndpoint == nil {
		var ret string
		return ret
	}
	return *o.EksClusterEndpoint
}

// GetEksClusterEndpointOk returns a tuple with the EksClusterEndpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetEksClusterEndpointOk() (*string, bool) {
	if o == nil || o.EksClusterEndpoint == nil {
		return nil, false
	}
	return o.EksClusterEndpoint, true
}

// HasEksClusterEndpoint returns a boolean if a field has been set.
func (o *DSProducerDetails) HasEksClusterEndpoint() bool {
	if o != nil && o.EksClusterEndpoint != nil {
		return true
	}

	return false
}

// SetEksClusterEndpoint gets a reference to the given string and assigns it to the EksClusterEndpoint field.
func (o *DSProducerDetails) SetEksClusterEndpoint(v string) {
	o.EksClusterEndpoint = &v
}

// GetEksClusterName returns the EksClusterName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetEksClusterName() string {
	if o == nil || o.EksClusterName == nil {
		var ret string
		return ret
	}
	return *o.EksClusterName
}

// GetEksClusterNameOk returns a tuple with the EksClusterName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetEksClusterNameOk() (*string, bool) {
	if o == nil || o.EksClusterName == nil {
		return nil, false
	}
	return o.EksClusterName, true
}

// HasEksClusterName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasEksClusterName() bool {
	if o != nil && o.EksClusterName != nil {
		return true
	}

	return false
}

// SetEksClusterName gets a reference to the given string and assigns it to the EksClusterName field.
func (o *DSProducerDetails) SetEksClusterName(v string) {
	o.EksClusterName = &v
}

// GetEksRegion returns the EksRegion field value if set, zero value otherwise.
func (o *DSProducerDetails) GetEksRegion() string {
	if o == nil || o.EksRegion == nil {
		var ret string
		return ret
	}
	return *o.EksRegion
}

// GetEksRegionOk returns a tuple with the EksRegion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetEksRegionOk() (*string, bool) {
	if o == nil || o.EksRegion == nil {
		return nil, false
	}
	return o.EksRegion, true
}

// HasEksRegion returns a boolean if a field has been set.
func (o *DSProducerDetails) HasEksRegion() bool {
	if o != nil && o.EksRegion != nil {
		return true
	}

	return false
}

// SetEksRegion gets a reference to the given string and assigns it to the EksRegion field.
func (o *DSProducerDetails) SetEksRegion(v string) {
	o.EksRegion = &v
}

// GetEksSecretAccessKey returns the EksSecretAccessKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetEksSecretAccessKey() string {
	if o == nil || o.EksSecretAccessKey == nil {
		var ret string
		return ret
	}
	return *o.EksSecretAccessKey
}

// GetEksSecretAccessKeyOk returns a tuple with the EksSecretAccessKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetEksSecretAccessKeyOk() (*string, bool) {
	if o == nil || o.EksSecretAccessKey == nil {
		return nil, false
	}
	return o.EksSecretAccessKey, true
}

// HasEksSecretAccessKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasEksSecretAccessKey() bool {
	if o != nil && o.EksSecretAccessKey != nil {
		return true
	}

	return false
}

// SetEksSecretAccessKey gets a reference to the given string and assigns it to the EksSecretAccessKey field.
func (o *DSProducerDetails) SetEksSecretAccessKey(v string) {
	o.EksSecretAccessKey = &v
}

// GetEnableAdminRotation returns the EnableAdminRotation field value if set, zero value otherwise.
func (o *DSProducerDetails) GetEnableAdminRotation() bool {
	if o == nil || o.EnableAdminRotation == nil {
		var ret bool
		return ret
	}
	return *o.EnableAdminRotation
}

// GetEnableAdminRotationOk returns a tuple with the EnableAdminRotation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetEnableAdminRotationOk() (*bool, bool) {
	if o == nil || o.EnableAdminRotation == nil {
		return nil, false
	}
	return o.EnableAdminRotation, true
}

// HasEnableAdminRotation returns a boolean if a field has been set.
func (o *DSProducerDetails) HasEnableAdminRotation() bool {
	if o != nil && o.EnableAdminRotation != nil {
		return true
	}

	return false
}

// SetEnableAdminRotation gets a reference to the given bool and assigns it to the EnableAdminRotation field.
func (o *DSProducerDetails) SetEnableAdminRotation(v bool) {
	o.EnableAdminRotation = &v
}

// GetEnforceReplayPrevention returns the EnforceReplayPrevention field value if set, zero value otherwise.
func (o *DSProducerDetails) GetEnforceReplayPrevention() bool {
	if o == nil || o.EnforceReplayPrevention == nil {
		var ret bool
		return ret
	}
	return *o.EnforceReplayPrevention
}

// GetEnforceReplayPreventionOk returns a tuple with the EnforceReplayPrevention field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetEnforceReplayPreventionOk() (*bool, bool) {
	if o == nil || o.EnforceReplayPrevention == nil {
		return nil, false
	}
	return o.EnforceReplayPrevention, true
}

// HasEnforceReplayPrevention returns a boolean if a field has been set.
func (o *DSProducerDetails) HasEnforceReplayPrevention() bool {
	if o != nil && o.EnforceReplayPrevention != nil {
		return true
	}

	return false
}

// SetEnforceReplayPrevention gets a reference to the given bool and assigns it to the EnforceReplayPrevention field.
func (o *DSProducerDetails) SetEnforceReplayPrevention(v bool) {
	o.EnforceReplayPrevention = &v
}

// GetExternallyProvidedUser returns the ExternallyProvidedUser field value if set, zero value otherwise.
func (o *DSProducerDetails) GetExternallyProvidedUser() string {
	if o == nil || o.ExternallyProvidedUser == nil {
		var ret string
		return ret
	}
	return *o.ExternallyProvidedUser
}

// GetExternallyProvidedUserOk returns a tuple with the ExternallyProvidedUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetExternallyProvidedUserOk() (*string, bool) {
	if o == nil || o.ExternallyProvidedUser == nil {
		return nil, false
	}
	return o.ExternallyProvidedUser, true
}

// HasExternallyProvidedUser returns a boolean if a field has been set.
func (o *DSProducerDetails) HasExternallyProvidedUser() bool {
	if o != nil && o.ExternallyProvidedUser != nil {
		return true
	}

	return false
}

// SetExternallyProvidedUser gets a reference to the given string and assigns it to the ExternallyProvidedUser field.
func (o *DSProducerDetails) SetExternallyProvidedUser(v string) {
	o.ExternallyProvidedUser = &v
}

// GetFailureMessage returns the FailureMessage field value if set, zero value otherwise.
func (o *DSProducerDetails) GetFailureMessage() string {
	if o == nil || o.FailureMessage == nil {
		var ret string
		return ret
	}
	return *o.FailureMessage
}

// GetFailureMessageOk returns a tuple with the FailureMessage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetFailureMessageOk() (*string, bool) {
	if o == nil || o.FailureMessage == nil {
		return nil, false
	}
	return o.FailureMessage, true
}

// HasFailureMessage returns a boolean if a field has been set.
func (o *DSProducerDetails) HasFailureMessage() bool {
	if o != nil && o.FailureMessage != nil {
		return true
	}

	return false
}

// SetFailureMessage gets a reference to the given string and assigns it to the FailureMessage field.
func (o *DSProducerDetails) SetFailureMessage(v string) {
	o.FailureMessage = &v
}

// GetFixedUserOnly returns the FixedUserOnly field value if set, zero value otherwise.
func (o *DSProducerDetails) GetFixedUserOnly() string {
	if o == nil || o.FixedUserOnly == nil {
		var ret string
		return ret
	}
	return *o.FixedUserOnly
}

// GetFixedUserOnlyOk returns a tuple with the FixedUserOnly field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetFixedUserOnlyOk() (*string, bool) {
	if o == nil || o.FixedUserOnly == nil {
		return nil, false
	}
	return o.FixedUserOnly, true
}

// HasFixedUserOnly returns a boolean if a field has been set.
func (o *DSProducerDetails) HasFixedUserOnly() bool {
	if o != nil && o.FixedUserOnly != nil {
		return true
	}

	return false
}

// SetFixedUserOnly gets a reference to the given string and assigns it to the FixedUserOnly field.
func (o *DSProducerDetails) SetFixedUserOnly(v string) {
	o.FixedUserOnly = &v
}

// GetGcpKeyAlgo returns the GcpKeyAlgo field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpKeyAlgo() string {
	if o == nil || o.GcpKeyAlgo == nil {
		var ret string
		return ret
	}
	return *o.GcpKeyAlgo
}

// GetGcpKeyAlgoOk returns a tuple with the GcpKeyAlgo field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpKeyAlgoOk() (*string, bool) {
	if o == nil || o.GcpKeyAlgo == nil {
		return nil, false
	}
	return o.GcpKeyAlgo, true
}

// HasGcpKeyAlgo returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpKeyAlgo() bool {
	if o != nil && o.GcpKeyAlgo != nil {
		return true
	}

	return false
}

// SetGcpKeyAlgo gets a reference to the given string and assigns it to the GcpKeyAlgo field.
func (o *DSProducerDetails) SetGcpKeyAlgo(v string) {
	o.GcpKeyAlgo = &v
}

// GetGcpRoleBindings returns the GcpRoleBindings field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpRoleBindings() map[string][]string {
	if o == nil || o.GcpRoleBindings == nil {
		var ret map[string][]string
		return ret
	}
	return *o.GcpRoleBindings
}

// GetGcpRoleBindingsOk returns a tuple with the GcpRoleBindings field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpRoleBindingsOk() (*map[string][]string, bool) {
	if o == nil || o.GcpRoleBindings == nil {
		return nil, false
	}
	return o.GcpRoleBindings, true
}

// HasGcpRoleBindings returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpRoleBindings() bool {
	if o != nil && o.GcpRoleBindings != nil {
		return true
	}

	return false
}

// SetGcpRoleBindings gets a reference to the given map[string][]string and assigns it to the GcpRoleBindings field.
func (o *DSProducerDetails) SetGcpRoleBindings(v map[string][]string) {
	o.GcpRoleBindings = &v
}

// GetGcpServiceAccountEmail returns the GcpServiceAccountEmail field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpServiceAccountEmail() string {
	if o == nil || o.GcpServiceAccountEmail == nil {
		var ret string
		return ret
	}
	return *o.GcpServiceAccountEmail
}

// GetGcpServiceAccountEmailOk returns a tuple with the GcpServiceAccountEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpServiceAccountEmailOk() (*string, bool) {
	if o == nil || o.GcpServiceAccountEmail == nil {
		return nil, false
	}
	return o.GcpServiceAccountEmail, true
}

// HasGcpServiceAccountEmail returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpServiceAccountEmail() bool {
	if o != nil && o.GcpServiceAccountEmail != nil {
		return true
	}

	return false
}

// SetGcpServiceAccountEmail gets a reference to the given string and assigns it to the GcpServiceAccountEmail field.
func (o *DSProducerDetails) SetGcpServiceAccountEmail(v string) {
	o.GcpServiceAccountEmail = &v
}

// GetGcpServiceAccountKey returns the GcpServiceAccountKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpServiceAccountKey() string {
	if o == nil || o.GcpServiceAccountKey == nil {
		var ret string
		return ret
	}
	return *o.GcpServiceAccountKey
}

// GetGcpServiceAccountKeyOk returns a tuple with the GcpServiceAccountKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpServiceAccountKeyOk() (*string, bool) {
	if o == nil || o.GcpServiceAccountKey == nil {
		return nil, false
	}
	return o.GcpServiceAccountKey, true
}

// HasGcpServiceAccountKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpServiceAccountKey() bool {
	if o != nil && o.GcpServiceAccountKey != nil {
		return true
	}

	return false
}

// SetGcpServiceAccountKey gets a reference to the given string and assigns it to the GcpServiceAccountKey field.
func (o *DSProducerDetails) SetGcpServiceAccountKey(v string) {
	o.GcpServiceAccountKey = &v
}

// GetGcpServiceAccountKeyBase64 returns the GcpServiceAccountKeyBase64 field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpServiceAccountKeyBase64() string {
	if o == nil || o.GcpServiceAccountKeyBase64 == nil {
		var ret string
		return ret
	}
	return *o.GcpServiceAccountKeyBase64
}

// GetGcpServiceAccountKeyBase64Ok returns a tuple with the GcpServiceAccountKeyBase64 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpServiceAccountKeyBase64Ok() (*string, bool) {
	if o == nil || o.GcpServiceAccountKeyBase64 == nil {
		return nil, false
	}
	return o.GcpServiceAccountKeyBase64, true
}

// HasGcpServiceAccountKeyBase64 returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpServiceAccountKeyBase64() bool {
	if o != nil && o.GcpServiceAccountKeyBase64 != nil {
		return true
	}

	return false
}

// SetGcpServiceAccountKeyBase64 gets a reference to the given string and assigns it to the GcpServiceAccountKeyBase64 field.
func (o *DSProducerDetails) SetGcpServiceAccountKeyBase64(v string) {
	o.GcpServiceAccountKeyBase64 = &v
}

// GetGcpServiceAccountKeyId returns the GcpServiceAccountKeyId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpServiceAccountKeyId() string {
	if o == nil || o.GcpServiceAccountKeyId == nil {
		var ret string
		return ret
	}
	return *o.GcpServiceAccountKeyId
}

// GetGcpServiceAccountKeyIdOk returns a tuple with the GcpServiceAccountKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpServiceAccountKeyIdOk() (*string, bool) {
	if o == nil || o.GcpServiceAccountKeyId == nil {
		return nil, false
	}
	return o.GcpServiceAccountKeyId, true
}

// HasGcpServiceAccountKeyId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpServiceAccountKeyId() bool {
	if o != nil && o.GcpServiceAccountKeyId != nil {
		return true
	}

	return false
}

// SetGcpServiceAccountKeyId gets a reference to the given string and assigns it to the GcpServiceAccountKeyId field.
func (o *DSProducerDetails) SetGcpServiceAccountKeyId(v string) {
	o.GcpServiceAccountKeyId = &v
}

// GetGcpServiceAccountType returns the GcpServiceAccountType field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpServiceAccountType() string {
	if o == nil || o.GcpServiceAccountType == nil {
		var ret string
		return ret
	}
	return *o.GcpServiceAccountType
}

// GetGcpServiceAccountTypeOk returns a tuple with the GcpServiceAccountType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpServiceAccountTypeOk() (*string, bool) {
	if o == nil || o.GcpServiceAccountType == nil {
		return nil, false
	}
	return o.GcpServiceAccountType, true
}

// HasGcpServiceAccountType returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpServiceAccountType() bool {
	if o != nil && o.GcpServiceAccountType != nil {
		return true
	}

	return false
}

// SetGcpServiceAccountType gets a reference to the given string and assigns it to the GcpServiceAccountType field.
func (o *DSProducerDetails) SetGcpServiceAccountType(v string) {
	o.GcpServiceAccountType = &v
}

// GetGcpTmpServiceAccountName returns the GcpTmpServiceAccountName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpTmpServiceAccountName() string {
	if o == nil || o.GcpTmpServiceAccountName == nil {
		var ret string
		return ret
	}
	return *o.GcpTmpServiceAccountName
}

// GetGcpTmpServiceAccountNameOk returns a tuple with the GcpTmpServiceAccountName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpTmpServiceAccountNameOk() (*string, bool) {
	if o == nil || o.GcpTmpServiceAccountName == nil {
		return nil, false
	}
	return o.GcpTmpServiceAccountName, true
}

// HasGcpTmpServiceAccountName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpTmpServiceAccountName() bool {
	if o != nil && o.GcpTmpServiceAccountName != nil {
		return true
	}

	return false
}

// SetGcpTmpServiceAccountName gets a reference to the given string and assigns it to the GcpTmpServiceAccountName field.
func (o *DSProducerDetails) SetGcpTmpServiceAccountName(v string) {
	o.GcpTmpServiceAccountName = &v
}

// GetGcpTokenLifetime returns the GcpTokenLifetime field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpTokenLifetime() string {
	if o == nil || o.GcpTokenLifetime == nil {
		var ret string
		return ret
	}
	return *o.GcpTokenLifetime
}

// GetGcpTokenLifetimeOk returns a tuple with the GcpTokenLifetime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpTokenLifetimeOk() (*string, bool) {
	if o == nil || o.GcpTokenLifetime == nil {
		return nil, false
	}
	return o.GcpTokenLifetime, true
}

// HasGcpTokenLifetime returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpTokenLifetime() bool {
	if o != nil && o.GcpTokenLifetime != nil {
		return true
	}

	return false
}

// SetGcpTokenLifetime gets a reference to the given string and assigns it to the GcpTokenLifetime field.
func (o *DSProducerDetails) SetGcpTokenLifetime(v string) {
	o.GcpTokenLifetime = &v
}

// GetGcpTokenScope returns the GcpTokenScope field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpTokenScope() string {
	if o == nil || o.GcpTokenScope == nil {
		var ret string
		return ret
	}
	return *o.GcpTokenScope
}

// GetGcpTokenScopeOk returns a tuple with the GcpTokenScope field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpTokenScopeOk() (*string, bool) {
	if o == nil || o.GcpTokenScope == nil {
		return nil, false
	}
	return o.GcpTokenScope, true
}

// HasGcpTokenScope returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpTokenScope() bool {
	if o != nil && o.GcpTokenScope != nil {
		return true
	}

	return false
}

// SetGcpTokenScope gets a reference to the given string and assigns it to the GcpTokenScope field.
func (o *DSProducerDetails) SetGcpTokenScope(v string) {
	o.GcpTokenScope = &v
}

// GetGcpTokenType returns the GcpTokenType field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGcpTokenType() string {
	if o == nil || o.GcpTokenType == nil {
		var ret string
		return ret
	}
	return *o.GcpTokenType
}

// GetGcpTokenTypeOk returns a tuple with the GcpTokenType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGcpTokenTypeOk() (*string, bool) {
	if o == nil || o.GcpTokenType == nil {
		return nil, false
	}
	return o.GcpTokenType, true
}

// HasGcpTokenType returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGcpTokenType() bool {
	if o != nil && o.GcpTokenType != nil {
		return true
	}

	return false
}

// SetGcpTokenType gets a reference to the given string and assigns it to the GcpTokenType field.
func (o *DSProducerDetails) SetGcpTokenType(v string) {
	o.GcpTokenType = &v
}

// GetGithubAppId returns the GithubAppId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGithubAppId() int64 {
	if o == nil || o.GithubAppId == nil {
		var ret int64
		return ret
	}
	return *o.GithubAppId
}

// GetGithubAppIdOk returns a tuple with the GithubAppId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGithubAppIdOk() (*int64, bool) {
	if o == nil || o.GithubAppId == nil {
		return nil, false
	}
	return o.GithubAppId, true
}

// HasGithubAppId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGithubAppId() bool {
	if o != nil && o.GithubAppId != nil {
		return true
	}

	return false
}

// SetGithubAppId gets a reference to the given int64 and assigns it to the GithubAppId field.
func (o *DSProducerDetails) SetGithubAppId(v int64) {
	o.GithubAppId = &v
}

// GetGithubAppPrivateKey returns the GithubAppPrivateKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGithubAppPrivateKey() string {
	if o == nil || o.GithubAppPrivateKey == nil {
		var ret string
		return ret
	}
	return *o.GithubAppPrivateKey
}

// GetGithubAppPrivateKeyOk returns a tuple with the GithubAppPrivateKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGithubAppPrivateKeyOk() (*string, bool) {
	if o == nil || o.GithubAppPrivateKey == nil {
		return nil, false
	}
	return o.GithubAppPrivateKey, true
}

// HasGithubAppPrivateKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGithubAppPrivateKey() bool {
	if o != nil && o.GithubAppPrivateKey != nil {
		return true
	}

	return false
}

// SetGithubAppPrivateKey gets a reference to the given string and assigns it to the GithubAppPrivateKey field.
func (o *DSProducerDetails) SetGithubAppPrivateKey(v string) {
	o.GithubAppPrivateKey = &v
}

// GetGithubBaseUrl returns the GithubBaseUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGithubBaseUrl() string {
	if o == nil || o.GithubBaseUrl == nil {
		var ret string
		return ret
	}
	return *o.GithubBaseUrl
}

// GetGithubBaseUrlOk returns a tuple with the GithubBaseUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGithubBaseUrlOk() (*string, bool) {
	if o == nil || o.GithubBaseUrl == nil {
		return nil, false
	}
	return o.GithubBaseUrl, true
}

// HasGithubBaseUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGithubBaseUrl() bool {
	if o != nil && o.GithubBaseUrl != nil {
		return true
	}

	return false
}

// SetGithubBaseUrl gets a reference to the given string and assigns it to the GithubBaseUrl field.
func (o *DSProducerDetails) SetGithubBaseUrl(v string) {
	o.GithubBaseUrl = &v
}

// GetGithubInstallationId returns the GithubInstallationId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGithubInstallationId() int64 {
	if o == nil || o.GithubInstallationId == nil {
		var ret int64
		return ret
	}
	return *o.GithubInstallationId
}

// GetGithubInstallationIdOk returns a tuple with the GithubInstallationId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGithubInstallationIdOk() (*int64, bool) {
	if o == nil || o.GithubInstallationId == nil {
		return nil, false
	}
	return o.GithubInstallationId, true
}

// HasGithubInstallationId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGithubInstallationId() bool {
	if o != nil && o.GithubInstallationId != nil {
		return true
	}

	return false
}

// SetGithubInstallationId gets a reference to the given int64 and assigns it to the GithubInstallationId field.
func (o *DSProducerDetails) SetGithubInstallationId(v int64) {
	o.GithubInstallationId = &v
}

// GetGithubInstallationTokenPermissions returns the GithubInstallationTokenPermissions field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGithubInstallationTokenPermissions() map[string]string {
	if o == nil || o.GithubInstallationTokenPermissions == nil {
		var ret map[string]string
		return ret
	}
	return *o.GithubInstallationTokenPermissions
}

// GetGithubInstallationTokenPermissionsOk returns a tuple with the GithubInstallationTokenPermissions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGithubInstallationTokenPermissionsOk() (*map[string]string, bool) {
	if o == nil || o.GithubInstallationTokenPermissions == nil {
		return nil, false
	}
	return o.GithubInstallationTokenPermissions, true
}

// HasGithubInstallationTokenPermissions returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGithubInstallationTokenPermissions() bool {
	if o != nil && o.GithubInstallationTokenPermissions != nil {
		return true
	}

	return false
}

// SetGithubInstallationTokenPermissions gets a reference to the given map[string]string and assigns it to the GithubInstallationTokenPermissions field.
func (o *DSProducerDetails) SetGithubInstallationTokenPermissions(v map[string]string) {
	o.GithubInstallationTokenPermissions = &v
}

// GetGithubInstallationTokenRepositories returns the GithubInstallationTokenRepositories field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGithubInstallationTokenRepositories() []string {
	if o == nil || o.GithubInstallationTokenRepositories == nil {
		var ret []string
		return ret
	}
	return *o.GithubInstallationTokenRepositories
}

// GetGithubInstallationTokenRepositoriesOk returns a tuple with the GithubInstallationTokenRepositories field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGithubInstallationTokenRepositoriesOk() (*[]string, bool) {
	if o == nil || o.GithubInstallationTokenRepositories == nil {
		return nil, false
	}
	return o.GithubInstallationTokenRepositories, true
}

// HasGithubInstallationTokenRepositories returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGithubInstallationTokenRepositories() bool {
	if o != nil && o.GithubInstallationTokenRepositories != nil {
		return true
	}

	return false
}

// SetGithubInstallationTokenRepositories gets a reference to the given []string and assigns it to the GithubInstallationTokenRepositories field.
func (o *DSProducerDetails) SetGithubInstallationTokenRepositories(v []string) {
	o.GithubInstallationTokenRepositories = &v
}

// GetGithubInstallationTokenRepositoriesIds returns the GithubInstallationTokenRepositoriesIds field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGithubInstallationTokenRepositoriesIds() []int64 {
	if o == nil || o.GithubInstallationTokenRepositoriesIds == nil {
		var ret []int64
		return ret
	}
	return *o.GithubInstallationTokenRepositoriesIds
}

// GetGithubInstallationTokenRepositoriesIdsOk returns a tuple with the GithubInstallationTokenRepositoriesIds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGithubInstallationTokenRepositoriesIdsOk() (*[]int64, bool) {
	if o == nil || o.GithubInstallationTokenRepositoriesIds == nil {
		return nil, false
	}
	return o.GithubInstallationTokenRepositoriesIds, true
}

// HasGithubInstallationTokenRepositoriesIds returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGithubInstallationTokenRepositoriesIds() bool {
	if o != nil && o.GithubInstallationTokenRepositoriesIds != nil {
		return true
	}

	return false
}

// SetGithubInstallationTokenRepositoriesIds gets a reference to the given []int64 and assigns it to the GithubInstallationTokenRepositoriesIds field.
func (o *DSProducerDetails) SetGithubInstallationTokenRepositoriesIds(v []int64) {
	o.GithubInstallationTokenRepositoriesIds = &v
}

// GetGithubOrganizationName returns the GithubOrganizationName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGithubOrganizationName() string {
	if o == nil || o.GithubOrganizationName == nil {
		var ret string
		return ret
	}
	return *o.GithubOrganizationName
}

// GetGithubOrganizationNameOk returns a tuple with the GithubOrganizationName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGithubOrganizationNameOk() (*string, bool) {
	if o == nil || o.GithubOrganizationName == nil {
		return nil, false
	}
	return o.GithubOrganizationName, true
}

// HasGithubOrganizationName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGithubOrganizationName() bool {
	if o != nil && o.GithubOrganizationName != nil {
		return true
	}

	return false
}

// SetGithubOrganizationName gets a reference to the given string and assigns it to the GithubOrganizationName field.
func (o *DSProducerDetails) SetGithubOrganizationName(v string) {
	o.GithubOrganizationName = &v
}

// GetGithubRepositoryPath returns the GithubRepositoryPath field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGithubRepositoryPath() string {
	if o == nil || o.GithubRepositoryPath == nil {
		var ret string
		return ret
	}
	return *o.GithubRepositoryPath
}

// GetGithubRepositoryPathOk returns a tuple with the GithubRepositoryPath field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGithubRepositoryPathOk() (*string, bool) {
	if o == nil || o.GithubRepositoryPath == nil {
		return nil, false
	}
	return o.GithubRepositoryPath, true
}

// HasGithubRepositoryPath returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGithubRepositoryPath() bool {
	if o != nil && o.GithubRepositoryPath != nil {
		return true
	}

	return false
}

// SetGithubRepositoryPath gets a reference to the given string and assigns it to the GithubRepositoryPath field.
func (o *DSProducerDetails) SetGithubRepositoryPath(v string) {
	o.GithubRepositoryPath = &v
}

// GetGitlabAccessToken returns the GitlabAccessToken field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGitlabAccessToken() string {
	if o == nil || o.GitlabAccessToken == nil {
		var ret string
		return ret
	}
	return *o.GitlabAccessToken
}

// GetGitlabAccessTokenOk returns a tuple with the GitlabAccessToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGitlabAccessTokenOk() (*string, bool) {
	if o == nil || o.GitlabAccessToken == nil {
		return nil, false
	}
	return o.GitlabAccessToken, true
}

// HasGitlabAccessToken returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGitlabAccessToken() bool {
	if o != nil && o.GitlabAccessToken != nil {
		return true
	}

	return false
}

// SetGitlabAccessToken gets a reference to the given string and assigns it to the GitlabAccessToken field.
func (o *DSProducerDetails) SetGitlabAccessToken(v string) {
	o.GitlabAccessToken = &v
}

// GetGitlabAccessType returns the GitlabAccessType field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGitlabAccessType() string {
	if o == nil || o.GitlabAccessType == nil {
		var ret string
		return ret
	}
	return *o.GitlabAccessType
}

// GetGitlabAccessTypeOk returns a tuple with the GitlabAccessType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGitlabAccessTypeOk() (*string, bool) {
	if o == nil || o.GitlabAccessType == nil {
		return nil, false
	}
	return o.GitlabAccessType, true
}

// HasGitlabAccessType returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGitlabAccessType() bool {
	if o != nil && o.GitlabAccessType != nil {
		return true
	}

	return false
}

// SetGitlabAccessType gets a reference to the given string and assigns it to the GitlabAccessType field.
func (o *DSProducerDetails) SetGitlabAccessType(v string) {
	o.GitlabAccessType = &v
}

// GetGitlabCertificate returns the GitlabCertificate field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGitlabCertificate() string {
	if o == nil || o.GitlabCertificate == nil {
		var ret string
		return ret
	}
	return *o.GitlabCertificate
}

// GetGitlabCertificateOk returns a tuple with the GitlabCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGitlabCertificateOk() (*string, bool) {
	if o == nil || o.GitlabCertificate == nil {
		return nil, false
	}
	return o.GitlabCertificate, true
}

// HasGitlabCertificate returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGitlabCertificate() bool {
	if o != nil && o.GitlabCertificate != nil {
		return true
	}

	return false
}

// SetGitlabCertificate gets a reference to the given string and assigns it to the GitlabCertificate field.
func (o *DSProducerDetails) SetGitlabCertificate(v string) {
	o.GitlabCertificate = &v
}

// GetGitlabGroupName returns the GitlabGroupName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGitlabGroupName() string {
	if o == nil || o.GitlabGroupName == nil {
		var ret string
		return ret
	}
	return *o.GitlabGroupName
}

// GetGitlabGroupNameOk returns a tuple with the GitlabGroupName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGitlabGroupNameOk() (*string, bool) {
	if o == nil || o.GitlabGroupName == nil {
		return nil, false
	}
	return o.GitlabGroupName, true
}

// HasGitlabGroupName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGitlabGroupName() bool {
	if o != nil && o.GitlabGroupName != nil {
		return true
	}

	return false
}

// SetGitlabGroupName gets a reference to the given string and assigns it to the GitlabGroupName field.
func (o *DSProducerDetails) SetGitlabGroupName(v string) {
	o.GitlabGroupName = &v
}

// GetGitlabProjectName returns the GitlabProjectName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGitlabProjectName() string {
	if o == nil || o.GitlabProjectName == nil {
		var ret string
		return ret
	}
	return *o.GitlabProjectName
}

// GetGitlabProjectNameOk returns a tuple with the GitlabProjectName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGitlabProjectNameOk() (*string, bool) {
	if o == nil || o.GitlabProjectName == nil {
		return nil, false
	}
	return o.GitlabProjectName, true
}

// HasGitlabProjectName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGitlabProjectName() bool {
	if o != nil && o.GitlabProjectName != nil {
		return true
	}

	return false
}

// SetGitlabProjectName gets a reference to the given string and assigns it to the GitlabProjectName field.
func (o *DSProducerDetails) SetGitlabProjectName(v string) {
	o.GitlabProjectName = &v
}

// GetGitlabRole returns the GitlabRole field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGitlabRole() string {
	if o == nil || o.GitlabRole == nil {
		var ret string
		return ret
	}
	return *o.GitlabRole
}

// GetGitlabRoleOk returns a tuple with the GitlabRole field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGitlabRoleOk() (*string, bool) {
	if o == nil || o.GitlabRole == nil {
		return nil, false
	}
	return o.GitlabRole, true
}

// HasGitlabRole returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGitlabRole() bool {
	if o != nil && o.GitlabRole != nil {
		return true
	}

	return false
}

// SetGitlabRole gets a reference to the given string and assigns it to the GitlabRole field.
func (o *DSProducerDetails) SetGitlabRole(v string) {
	o.GitlabRole = &v
}

// GetGitlabTokenScope returns the GitlabTokenScope field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGitlabTokenScope() []string {
	if o == nil || o.GitlabTokenScope == nil {
		var ret []string
		return ret
	}
	return *o.GitlabTokenScope
}

// GetGitlabTokenScopeOk returns a tuple with the GitlabTokenScope field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGitlabTokenScopeOk() (*[]string, bool) {
	if o == nil || o.GitlabTokenScope == nil {
		return nil, false
	}
	return o.GitlabTokenScope, true
}

// HasGitlabTokenScope returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGitlabTokenScope() bool {
	if o != nil && o.GitlabTokenScope != nil {
		return true
	}

	return false
}

// SetGitlabTokenScope gets a reference to the given []string and assigns it to the GitlabTokenScope field.
func (o *DSProducerDetails) SetGitlabTokenScope(v []string) {
	o.GitlabTokenScope = &v
}

// GetGitlabUrl returns the GitlabUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGitlabUrl() string {
	if o == nil || o.GitlabUrl == nil {
		var ret string
		return ret
	}
	return *o.GitlabUrl
}

// GetGitlabUrlOk returns a tuple with the GitlabUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGitlabUrlOk() (*string, bool) {
	if o == nil || o.GitlabUrl == nil {
		return nil, false
	}
	return o.GitlabUrl, true
}

// HasGitlabUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGitlabUrl() bool {
	if o != nil && o.GitlabUrl != nil {
		return true
	}

	return false
}

// SetGitlabUrl gets a reference to the given string and assigns it to the GitlabUrl field.
func (o *DSProducerDetails) SetGitlabUrl(v string) {
	o.GitlabUrl = &v
}

// GetGkeClusterCaCertificate returns the GkeClusterCaCertificate field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGkeClusterCaCertificate() string {
	if o == nil || o.GkeClusterCaCertificate == nil {
		var ret string
		return ret
	}
	return *o.GkeClusterCaCertificate
}

// GetGkeClusterCaCertificateOk returns a tuple with the GkeClusterCaCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGkeClusterCaCertificateOk() (*string, bool) {
	if o == nil || o.GkeClusterCaCertificate == nil {
		return nil, false
	}
	return o.GkeClusterCaCertificate, true
}

// HasGkeClusterCaCertificate returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGkeClusterCaCertificate() bool {
	if o != nil && o.GkeClusterCaCertificate != nil {
		return true
	}

	return false
}

// SetGkeClusterCaCertificate gets a reference to the given string and assigns it to the GkeClusterCaCertificate field.
func (o *DSProducerDetails) SetGkeClusterCaCertificate(v string) {
	o.GkeClusterCaCertificate = &v
}

// GetGkeClusterEndpoint returns the GkeClusterEndpoint field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGkeClusterEndpoint() string {
	if o == nil || o.GkeClusterEndpoint == nil {
		var ret string
		return ret
	}
	return *o.GkeClusterEndpoint
}

// GetGkeClusterEndpointOk returns a tuple with the GkeClusterEndpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGkeClusterEndpointOk() (*string, bool) {
	if o == nil || o.GkeClusterEndpoint == nil {
		return nil, false
	}
	return o.GkeClusterEndpoint, true
}

// HasGkeClusterEndpoint returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGkeClusterEndpoint() bool {
	if o != nil && o.GkeClusterEndpoint != nil {
		return true
	}

	return false
}

// SetGkeClusterEndpoint gets a reference to the given string and assigns it to the GkeClusterEndpoint field.
func (o *DSProducerDetails) SetGkeClusterEndpoint(v string) {
	o.GkeClusterEndpoint = &v
}

// GetGkeClusterName returns the GkeClusterName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGkeClusterName() string {
	if o == nil || o.GkeClusterName == nil {
		var ret string
		return ret
	}
	return *o.GkeClusterName
}

// GetGkeClusterNameOk returns a tuple with the GkeClusterName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGkeClusterNameOk() (*string, bool) {
	if o == nil || o.GkeClusterName == nil {
		return nil, false
	}
	return o.GkeClusterName, true
}

// HasGkeClusterName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGkeClusterName() bool {
	if o != nil && o.GkeClusterName != nil {
		return true
	}

	return false
}

// SetGkeClusterName gets a reference to the given string and assigns it to the GkeClusterName field.
func (o *DSProducerDetails) SetGkeClusterName(v string) {
	o.GkeClusterName = &v
}

// GetGkeServiceAccountKey returns the GkeServiceAccountKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGkeServiceAccountKey() string {
	if o == nil || o.GkeServiceAccountKey == nil {
		var ret string
		return ret
	}
	return *o.GkeServiceAccountKey
}

// GetGkeServiceAccountKeyOk returns a tuple with the GkeServiceAccountKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGkeServiceAccountKeyOk() (*string, bool) {
	if o == nil || o.GkeServiceAccountKey == nil {
		return nil, false
	}
	return o.GkeServiceAccountKey, true
}

// HasGkeServiceAccountKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGkeServiceAccountKey() bool {
	if o != nil && o.GkeServiceAccountKey != nil {
		return true
	}

	return false
}

// SetGkeServiceAccountKey gets a reference to the given string and assigns it to the GkeServiceAccountKey field.
func (o *DSProducerDetails) SetGkeServiceAccountKey(v string) {
	o.GkeServiceAccountKey = &v
}

// GetGkeServiceAccountName returns the GkeServiceAccountName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGkeServiceAccountName() string {
	if o == nil || o.GkeServiceAccountName == nil {
		var ret string
		return ret
	}
	return *o.GkeServiceAccountName
}

// GetGkeServiceAccountNameOk returns a tuple with the GkeServiceAccountName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGkeServiceAccountNameOk() (*string, bool) {
	if o == nil || o.GkeServiceAccountName == nil {
		return nil, false
	}
	return o.GkeServiceAccountName, true
}

// HasGkeServiceAccountName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGkeServiceAccountName() bool {
	if o != nil && o.GkeServiceAccountName != nil {
		return true
	}

	return false
}

// SetGkeServiceAccountName gets a reference to the given string and assigns it to the GkeServiceAccountName field.
func (o *DSProducerDetails) SetGkeServiceAccountName(v string) {
	o.GkeServiceAccountName = &v
}

// GetGoogleWorkspaceAccessMode returns the GoogleWorkspaceAccessMode field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGoogleWorkspaceAccessMode() string {
	if o == nil || o.GoogleWorkspaceAccessMode == nil {
		var ret string
		return ret
	}
	return *o.GoogleWorkspaceAccessMode
}

// GetGoogleWorkspaceAccessModeOk returns a tuple with the GoogleWorkspaceAccessMode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGoogleWorkspaceAccessModeOk() (*string, bool) {
	if o == nil || o.GoogleWorkspaceAccessMode == nil {
		return nil, false
	}
	return o.GoogleWorkspaceAccessMode, true
}

// HasGoogleWorkspaceAccessMode returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGoogleWorkspaceAccessMode() bool {
	if o != nil && o.GoogleWorkspaceAccessMode != nil {
		return true
	}

	return false
}

// SetGoogleWorkspaceAccessMode gets a reference to the given string and assigns it to the GoogleWorkspaceAccessMode field.
func (o *DSProducerDetails) SetGoogleWorkspaceAccessMode(v string) {
	o.GoogleWorkspaceAccessMode = &v
}

// GetGoogleWorkspaceAdminName returns the GoogleWorkspaceAdminName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGoogleWorkspaceAdminName() string {
	if o == nil || o.GoogleWorkspaceAdminName == nil {
		var ret string
		return ret
	}
	return *o.GoogleWorkspaceAdminName
}

// GetGoogleWorkspaceAdminNameOk returns a tuple with the GoogleWorkspaceAdminName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGoogleWorkspaceAdminNameOk() (*string, bool) {
	if o == nil || o.GoogleWorkspaceAdminName == nil {
		return nil, false
	}
	return o.GoogleWorkspaceAdminName, true
}

// HasGoogleWorkspaceAdminName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGoogleWorkspaceAdminName() bool {
	if o != nil && o.GoogleWorkspaceAdminName != nil {
		return true
	}

	return false
}

// SetGoogleWorkspaceAdminName gets a reference to the given string and assigns it to the GoogleWorkspaceAdminName field.
func (o *DSProducerDetails) SetGoogleWorkspaceAdminName(v string) {
	o.GoogleWorkspaceAdminName = &v
}

// GetGoogleWorkspaceGroupName returns the GoogleWorkspaceGroupName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGoogleWorkspaceGroupName() string {
	if o == nil || o.GoogleWorkspaceGroupName == nil {
		var ret string
		return ret
	}
	return *o.GoogleWorkspaceGroupName
}

// GetGoogleWorkspaceGroupNameOk returns a tuple with the GoogleWorkspaceGroupName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGoogleWorkspaceGroupNameOk() (*string, bool) {
	if o == nil || o.GoogleWorkspaceGroupName == nil {
		return nil, false
	}
	return o.GoogleWorkspaceGroupName, true
}

// HasGoogleWorkspaceGroupName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGoogleWorkspaceGroupName() bool {
	if o != nil && o.GoogleWorkspaceGroupName != nil {
		return true
	}

	return false
}

// SetGoogleWorkspaceGroupName gets a reference to the given string and assigns it to the GoogleWorkspaceGroupName field.
func (o *DSProducerDetails) SetGoogleWorkspaceGroupName(v string) {
	o.GoogleWorkspaceGroupName = &v
}

// GetGoogleWorkspaceGroupRole returns the GoogleWorkspaceGroupRole field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGoogleWorkspaceGroupRole() string {
	if o == nil || o.GoogleWorkspaceGroupRole == nil {
		var ret string
		return ret
	}
	return *o.GoogleWorkspaceGroupRole
}

// GetGoogleWorkspaceGroupRoleOk returns a tuple with the GoogleWorkspaceGroupRole field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGoogleWorkspaceGroupRoleOk() (*string, bool) {
	if o == nil || o.GoogleWorkspaceGroupRole == nil {
		return nil, false
	}
	return o.GoogleWorkspaceGroupRole, true
}

// HasGoogleWorkspaceGroupRole returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGoogleWorkspaceGroupRole() bool {
	if o != nil && o.GoogleWorkspaceGroupRole != nil {
		return true
	}

	return false
}

// SetGoogleWorkspaceGroupRole gets a reference to the given string and assigns it to the GoogleWorkspaceGroupRole field.
func (o *DSProducerDetails) SetGoogleWorkspaceGroupRole(v string) {
	o.GoogleWorkspaceGroupRole = &v
}

// GetGoogleWorkspaceRoleName returns the GoogleWorkspaceRoleName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGoogleWorkspaceRoleName() string {
	if o == nil || o.GoogleWorkspaceRoleName == nil {
		var ret string
		return ret
	}
	return *o.GoogleWorkspaceRoleName
}

// GetGoogleWorkspaceRoleNameOk returns a tuple with the GoogleWorkspaceRoleName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGoogleWorkspaceRoleNameOk() (*string, bool) {
	if o == nil || o.GoogleWorkspaceRoleName == nil {
		return nil, false
	}
	return o.GoogleWorkspaceRoleName, true
}

// HasGoogleWorkspaceRoleName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGoogleWorkspaceRoleName() bool {
	if o != nil && o.GoogleWorkspaceRoleName != nil {
		return true
	}

	return false
}

// SetGoogleWorkspaceRoleName gets a reference to the given string and assigns it to the GoogleWorkspaceRoleName field.
func (o *DSProducerDetails) SetGoogleWorkspaceRoleName(v string) {
	o.GoogleWorkspaceRoleName = &v
}

// GetGoogleWorkspaceRoleScope returns the GoogleWorkspaceRoleScope field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGoogleWorkspaceRoleScope() string {
	if o == nil || o.GoogleWorkspaceRoleScope == nil {
		var ret string
		return ret
	}
	return *o.GoogleWorkspaceRoleScope
}

// GetGoogleWorkspaceRoleScopeOk returns a tuple with the GoogleWorkspaceRoleScope field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGoogleWorkspaceRoleScopeOk() (*string, bool) {
	if o == nil || o.GoogleWorkspaceRoleScope == nil {
		return nil, false
	}
	return o.GoogleWorkspaceRoleScope, true
}

// HasGoogleWorkspaceRoleScope returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGoogleWorkspaceRoleScope() bool {
	if o != nil && o.GoogleWorkspaceRoleScope != nil {
		return true
	}

	return false
}

// SetGoogleWorkspaceRoleScope gets a reference to the given string and assigns it to the GoogleWorkspaceRoleScope field.
func (o *DSProducerDetails) SetGoogleWorkspaceRoleScope(v string) {
	o.GoogleWorkspaceRoleScope = &v
}

// GetGrantTypes returns the GrantTypes field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGrantTypes() []string {
	if o == nil || o.GrantTypes == nil {
		var ret []string
		return ret
	}
	return *o.GrantTypes
}

// GetGrantTypesOk returns a tuple with the GrantTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGrantTypesOk() (*[]string, bool) {
	if o == nil || o.GrantTypes == nil {
		return nil, false
	}
	return o.GrantTypes, true
}

// HasGrantTypes returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGrantTypes() bool {
	if o != nil && o.GrantTypes != nil {
		return true
	}

	return false
}

// SetGrantTypes gets a reference to the given []string and assigns it to the GrantTypes field.
func (o *DSProducerDetails) SetGrantTypes(v []string) {
	o.GrantTypes = &v
}

// GetGroups returns the Groups field value if set, zero value otherwise.
func (o *DSProducerDetails) GetGroups() string {
	if o == nil || o.Groups == nil {
		var ret string
		return ret
	}
	return *o.Groups
}

// GetGroupsOk returns a tuple with the Groups field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetGroupsOk() (*string, bool) {
	if o == nil || o.Groups == nil {
		return nil, false
	}
	return o.Groups, true
}

// HasGroups returns a boolean if a field has been set.
func (o *DSProducerDetails) HasGroups() bool {
	if o != nil && o.Groups != nil {
		return true
	}

	return false
}

// SetGroups gets a reference to the given string and assigns it to the Groups field.
func (o *DSProducerDetails) SetGroups(v string) {
	o.Groups = &v
}

// GetHanadbCreationStatements returns the HanadbCreationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetHanadbCreationStatements() string {
	if o == nil || o.HanadbCreationStatements == nil {
		var ret string
		return ret
	}
	return *o.HanadbCreationStatements
}

// GetHanadbCreationStatementsOk returns a tuple with the HanadbCreationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetHanadbCreationStatementsOk() (*string, bool) {
	if o == nil || o.HanadbCreationStatements == nil {
		return nil, false
	}
	return o.HanadbCreationStatements, true
}

// HasHanadbCreationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasHanadbCreationStatements() bool {
	if o != nil && o.HanadbCreationStatements != nil {
		return true
	}

	return false
}

// SetHanadbCreationStatements gets a reference to the given string and assigns it to the HanadbCreationStatements field.
func (o *DSProducerDetails) SetHanadbCreationStatements(v string) {
	o.HanadbCreationStatements = &v
}

// GetHanadbRevocationStatements returns the HanadbRevocationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetHanadbRevocationStatements() string {
	if o == nil || o.HanadbRevocationStatements == nil {
		var ret string
		return ret
	}
	return *o.HanadbRevocationStatements
}

// GetHanadbRevocationStatementsOk returns a tuple with the HanadbRevocationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetHanadbRevocationStatementsOk() (*string, bool) {
	if o == nil || o.HanadbRevocationStatements == nil {
		return nil, false
	}
	return o.HanadbRevocationStatements, true
}

// HasHanadbRevocationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasHanadbRevocationStatements() bool {
	if o != nil && o.HanadbRevocationStatements != nil {
		return true
	}

	return false
}

// SetHanadbRevocationStatements gets a reference to the given string and assigns it to the HanadbRevocationStatements field.
func (o *DSProducerDetails) SetHanadbRevocationStatements(v string) {
	o.HanadbRevocationStatements = &v
}

// GetHostName returns the HostName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetHostName() string {
	if o == nil || o.HostName == nil {
		var ret string
		return ret
	}
	return *o.HostName
}

// GetHostNameOk returns a tuple with the HostName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetHostNameOk() (*string, bool) {
	if o == nil || o.HostName == nil {
		return nil, false
	}
	return o.HostName, true
}

// HasHostName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasHostName() bool {
	if o != nil && o.HostName != nil {
		return true
	}

	return false
}

// SetHostName gets a reference to the given string and assigns it to the HostName field.
func (o *DSProducerDetails) SetHostName(v string) {
	o.HostName = &v
}

// GetHostPort returns the HostPort field value if set, zero value otherwise.
func (o *DSProducerDetails) GetHostPort() string {
	if o == nil || o.HostPort == nil {
		var ret string
		return ret
	}
	return *o.HostPort
}

// GetHostPortOk returns a tuple with the HostPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetHostPortOk() (*string, bool) {
	if o == nil || o.HostPort == nil {
		return nil, false
	}
	return o.HostPort, true
}

// HasHostPort returns a boolean if a field has been set.
func (o *DSProducerDetails) HasHostPort() bool {
	if o != nil && o.HostPort != nil {
		return true
	}

	return false
}

// SetHostPort gets a reference to the given string and assigns it to the HostPort field.
func (o *DSProducerDetails) SetHostPort(v string) {
	o.HostPort = &v
}

// GetImplementationType returns the ImplementationType field value if set, zero value otherwise.
func (o *DSProducerDetails) GetImplementationType() string {
	if o == nil || o.ImplementationType == nil {
		var ret string
		return ret
	}
	return *o.ImplementationType
}

// GetImplementationTypeOk returns a tuple with the ImplementationType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetImplementationTypeOk() (*string, bool) {
	if o == nil || o.ImplementationType == nil {
		return nil, false
	}
	return o.ImplementationType, true
}

// HasImplementationType returns a boolean if a field has been set.
func (o *DSProducerDetails) HasImplementationType() bool {
	if o != nil && o.ImplementationType != nil {
		return true
	}

	return false
}

// SetImplementationType gets a reference to the given string and assigns it to the ImplementationType field.
func (o *DSProducerDetails) SetImplementationType(v string) {
	o.ImplementationType = &v
}

// GetIsFixedUser returns the IsFixedUser field value if set, zero value otherwise.
func (o *DSProducerDetails) GetIsFixedUser() string {
	if o == nil || o.IsFixedUser == nil {
		var ret string
		return ret
	}
	return *o.IsFixedUser
}

// GetIsFixedUserOk returns a tuple with the IsFixedUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetIsFixedUserOk() (*string, bool) {
	if o == nil || o.IsFixedUser == nil {
		return nil, false
	}
	return o.IsFixedUser, true
}

// HasIsFixedUser returns a boolean if a field has been set.
func (o *DSProducerDetails) HasIsFixedUser() bool {
	if o != nil && o.IsFixedUser != nil {
		return true
	}

	return false
}

// SetIsFixedUser gets a reference to the given string and assigns it to the IsFixedUser field.
func (o *DSProducerDetails) SetIsFixedUser(v string) {
	o.IsFixedUser = &v
}

// GetIssuer returns the Issuer field value if set, zero value otherwise.
func (o *DSProducerDetails) GetIssuer() string {
	if o == nil || o.Issuer == nil {
		var ret string
		return ret
	}
	return *o.Issuer
}

// GetIssuerOk returns a tuple with the Issuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetIssuerOk() (*string, bool) {
	if o == nil || o.Issuer == nil {
		return nil, false
	}
	return o.Issuer, true
}

// HasIssuer returns a boolean if a field has been set.
func (o *DSProducerDetails) HasIssuer() bool {
	if o != nil && o.Issuer != nil {
		return true
	}

	return false
}

// SetIssuer gets a reference to the given string and assigns it to the Issuer field.
func (o *DSProducerDetails) SetIssuer(v string) {
	o.Issuer = &v
}

// GetItemTargetsAssoc returns the ItemTargetsAssoc field value if set, zero value otherwise.
func (o *DSProducerDetails) GetItemTargetsAssoc() []ItemTargetAssociation {
	if o == nil || o.ItemTargetsAssoc == nil {
		var ret []ItemTargetAssociation
		return ret
	}
	return *o.ItemTargetsAssoc
}

// GetItemTargetsAssocOk returns a tuple with the ItemTargetsAssoc field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetItemTargetsAssocOk() (*[]ItemTargetAssociation, bool) {
	if o == nil || o.ItemTargetsAssoc == nil {
		return nil, false
	}
	return o.ItemTargetsAssoc, true
}

// HasItemTargetsAssoc returns a boolean if a field has been set.
func (o *DSProducerDetails) HasItemTargetsAssoc() bool {
	if o != nil && o.ItemTargetsAssoc != nil {
		return true
	}

	return false
}

// SetItemTargetsAssoc gets a reference to the given []ItemTargetAssociation and assigns it to the ItemTargetsAssoc field.
func (o *DSProducerDetails) SetItemTargetsAssoc(v []ItemTargetAssociation) {
	o.ItemTargetsAssoc = &v
}

// GetJwks returns the Jwks field value if set, zero value otherwise.
func (o *DSProducerDetails) GetJwks() string {
	if o == nil || o.Jwks == nil {
		var ret string
		return ret
	}
	return *o.Jwks
}

// GetJwksOk returns a tuple with the Jwks field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetJwksOk() (*string, bool) {
	if o == nil || o.Jwks == nil {
		return nil, false
	}
	return o.Jwks, true
}

// HasJwks returns a boolean if a field has been set.
func (o *DSProducerDetails) HasJwks() bool {
	if o != nil && o.Jwks != nil {
		return true
	}

	return false
}

// SetJwks gets a reference to the given string and assigns it to the Jwks field.
func (o *DSProducerDetails) SetJwks(v string) {
	o.Jwks = &v
}

// GetJwksUrl returns the JwksUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetJwksUrl() string {
	if o == nil || o.JwksUrl == nil {
		var ret string
		return ret
	}
	return *o.JwksUrl
}

// GetJwksUrlOk returns a tuple with the JwksUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetJwksUrlOk() (*string, bool) {
	if o == nil || o.JwksUrl == nil {
		return nil, false
	}
	return o.JwksUrl, true
}

// HasJwksUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasJwksUrl() bool {
	if o != nil && o.JwksUrl != nil {
		return true
	}

	return false
}

// SetJwksUrl gets a reference to the given string and assigns it to the JwksUrl field.
func (o *DSProducerDetails) SetJwksUrl(v string) {
	o.JwksUrl = &v
}

// GetK8sAllowedNamespaces returns the K8sAllowedNamespaces field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sAllowedNamespaces() string {
	if o == nil || o.K8sAllowedNamespaces == nil {
		var ret string
		return ret
	}
	return *o.K8sAllowedNamespaces
}

// GetK8sAllowedNamespacesOk returns a tuple with the K8sAllowedNamespaces field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sAllowedNamespacesOk() (*string, bool) {
	if o == nil || o.K8sAllowedNamespaces == nil {
		return nil, false
	}
	return o.K8sAllowedNamespaces, true
}

// HasK8sAllowedNamespaces returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sAllowedNamespaces() bool {
	if o != nil && o.K8sAllowedNamespaces != nil {
		return true
	}

	return false
}

// SetK8sAllowedNamespaces gets a reference to the given string and assigns it to the K8sAllowedNamespaces field.
func (o *DSProducerDetails) SetK8sAllowedNamespaces(v string) {
	o.K8sAllowedNamespaces = &v
}

// GetK8sAuthType returns the K8sAuthType field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sAuthType() string {
	if o == nil || o.K8sAuthType == nil {
		var ret string
		return ret
	}
	return *o.K8sAuthType
}

// GetK8sAuthTypeOk returns a tuple with the K8sAuthType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sAuthTypeOk() (*string, bool) {
	if o == nil || o.K8sAuthType == nil {
		return nil, false
	}
	return o.K8sAuthType, true
}

// HasK8sAuthType returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sAuthType() bool {
	if o != nil && o.K8sAuthType != nil {
		return true
	}

	return false
}

// SetK8sAuthType gets a reference to the given string and assigns it to the K8sAuthType field.
func (o *DSProducerDetails) SetK8sAuthType(v string) {
	o.K8sAuthType = &v
}

// GetK8sBearerToken returns the K8sBearerToken field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sBearerToken() string {
	if o == nil || o.K8sBearerToken == nil {
		var ret string
		return ret
	}
	return *o.K8sBearerToken
}

// GetK8sBearerTokenOk returns a tuple with the K8sBearerToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sBearerTokenOk() (*string, bool) {
	if o == nil || o.K8sBearerToken == nil {
		return nil, false
	}
	return o.K8sBearerToken, true
}

// HasK8sBearerToken returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sBearerToken() bool {
	if o != nil && o.K8sBearerToken != nil {
		return true
	}

	return false
}

// SetK8sBearerToken gets a reference to the given string and assigns it to the K8sBearerToken field.
func (o *DSProducerDetails) SetK8sBearerToken(v string) {
	o.K8sBearerToken = &v
}

// GetK8sClientCertData returns the K8sClientCertData field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sClientCertData() string {
	if o == nil || o.K8sClientCertData == nil {
		var ret string
		return ret
	}
	return *o.K8sClientCertData
}

// GetK8sClientCertDataOk returns a tuple with the K8sClientCertData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sClientCertDataOk() (*string, bool) {
	if o == nil || o.K8sClientCertData == nil {
		return nil, false
	}
	return o.K8sClientCertData, true
}

// HasK8sClientCertData returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sClientCertData() bool {
	if o != nil && o.K8sClientCertData != nil {
		return true
	}

	return false
}

// SetK8sClientCertData gets a reference to the given string and assigns it to the K8sClientCertData field.
func (o *DSProducerDetails) SetK8sClientCertData(v string) {
	o.K8sClientCertData = &v
}

// GetK8sClientKeyData returns the K8sClientKeyData field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sClientKeyData() string {
	if o == nil || o.K8sClientKeyData == nil {
		var ret string
		return ret
	}
	return *o.K8sClientKeyData
}

// GetK8sClientKeyDataOk returns a tuple with the K8sClientKeyData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sClientKeyDataOk() (*string, bool) {
	if o == nil || o.K8sClientKeyData == nil {
		return nil, false
	}
	return o.K8sClientKeyData, true
}

// HasK8sClientKeyData returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sClientKeyData() bool {
	if o != nil && o.K8sClientKeyData != nil {
		return true
	}

	return false
}

// SetK8sClientKeyData gets a reference to the given string and assigns it to the K8sClientKeyData field.
func (o *DSProducerDetails) SetK8sClientKeyData(v string) {
	o.K8sClientKeyData = &v
}

// GetK8sClusterCaCertificate returns the K8sClusterCaCertificate field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sClusterCaCertificate() string {
	if o == nil || o.K8sClusterCaCertificate == nil {
		var ret string
		return ret
	}
	return *o.K8sClusterCaCertificate
}

// GetK8sClusterCaCertificateOk returns a tuple with the K8sClusterCaCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sClusterCaCertificateOk() (*string, bool) {
	if o == nil || o.K8sClusterCaCertificate == nil {
		return nil, false
	}
	return o.K8sClusterCaCertificate, true
}

// HasK8sClusterCaCertificate returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sClusterCaCertificate() bool {
	if o != nil && o.K8sClusterCaCertificate != nil {
		return true
	}

	return false
}

// SetK8sClusterCaCertificate gets a reference to the given string and assigns it to the K8sClusterCaCertificate field.
func (o *DSProducerDetails) SetK8sClusterCaCertificate(v string) {
	o.K8sClusterCaCertificate = &v
}

// GetK8sClusterEndpoint returns the K8sClusterEndpoint field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sClusterEndpoint() string {
	if o == nil || o.K8sClusterEndpoint == nil {
		var ret string
		return ret
	}
	return *o.K8sClusterEndpoint
}

// GetK8sClusterEndpointOk returns a tuple with the K8sClusterEndpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sClusterEndpointOk() (*string, bool) {
	if o == nil || o.K8sClusterEndpoint == nil {
		return nil, false
	}
	return o.K8sClusterEndpoint, true
}

// HasK8sClusterEndpoint returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sClusterEndpoint() bool {
	if o != nil && o.K8sClusterEndpoint != nil {
		return true
	}

	return false
}

// SetK8sClusterEndpoint gets a reference to the given string and assigns it to the K8sClusterEndpoint field.
func (o *DSProducerDetails) SetK8sClusterEndpoint(v string) {
	o.K8sClusterEndpoint = &v
}

// GetK8sClusterName returns the K8sClusterName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sClusterName() string {
	if o == nil || o.K8sClusterName == nil {
		var ret string
		return ret
	}
	return *o.K8sClusterName
}

// GetK8sClusterNameOk returns a tuple with the K8sClusterName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sClusterNameOk() (*string, bool) {
	if o == nil || o.K8sClusterName == nil {
		return nil, false
	}
	return o.K8sClusterName, true
}

// HasK8sClusterName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sClusterName() bool {
	if o != nil && o.K8sClusterName != nil {
		return true
	}

	return false
}

// SetK8sClusterName gets a reference to the given string and assigns it to the K8sClusterName field.
func (o *DSProducerDetails) SetK8sClusterName(v string) {
	o.K8sClusterName = &v
}

// GetK8sDynamicMode returns the K8sDynamicMode field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sDynamicMode() bool {
	if o == nil || o.K8sDynamicMode == nil {
		var ret bool
		return ret
	}
	return *o.K8sDynamicMode
}

// GetK8sDynamicModeOk returns a tuple with the K8sDynamicMode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sDynamicModeOk() (*bool, bool) {
	if o == nil || o.K8sDynamicMode == nil {
		return nil, false
	}
	return o.K8sDynamicMode, true
}

// HasK8sDynamicMode returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sDynamicMode() bool {
	if o != nil && o.K8sDynamicMode != nil {
		return true
	}

	return false
}

// SetK8sDynamicMode gets a reference to the given bool and assigns it to the K8sDynamicMode field.
func (o *DSProducerDetails) SetK8sDynamicMode(v bool) {
	o.K8sDynamicMode = &v
}

// GetK8sMultipleDocYamlTempDefinition returns the K8sMultipleDocYamlTempDefinition field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sMultipleDocYamlTempDefinition() []int32 {
	if o == nil || o.K8sMultipleDocYamlTempDefinition == nil {
		var ret []int32
		return ret
	}
	return *o.K8sMultipleDocYamlTempDefinition
}

// GetK8sMultipleDocYamlTempDefinitionOk returns a tuple with the K8sMultipleDocYamlTempDefinition field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sMultipleDocYamlTempDefinitionOk() (*[]int32, bool) {
	if o == nil || o.K8sMultipleDocYamlTempDefinition == nil {
		return nil, false
	}
	return o.K8sMultipleDocYamlTempDefinition, true
}

// HasK8sMultipleDocYamlTempDefinition returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sMultipleDocYamlTempDefinition() bool {
	if o != nil && o.K8sMultipleDocYamlTempDefinition != nil {
		return true
	}

	return false
}

// SetK8sMultipleDocYamlTempDefinition gets a reference to the given []int32 and assigns it to the K8sMultipleDocYamlTempDefinition field.
func (o *DSProducerDetails) SetK8sMultipleDocYamlTempDefinition(v []int32) {
	o.K8sMultipleDocYamlTempDefinition = &v
}

// GetK8sNamespace returns the K8sNamespace field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sNamespace() string {
	if o == nil || o.K8sNamespace == nil {
		var ret string
		return ret
	}
	return *o.K8sNamespace
}

// GetK8sNamespaceOk returns a tuple with the K8sNamespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sNamespaceOk() (*string, bool) {
	if o == nil || o.K8sNamespace == nil {
		return nil, false
	}
	return o.K8sNamespace, true
}

// HasK8sNamespace returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sNamespace() bool {
	if o != nil && o.K8sNamespace != nil {
		return true
	}

	return false
}

// SetK8sNamespace gets a reference to the given string and assigns it to the K8sNamespace field.
func (o *DSProducerDetails) SetK8sNamespace(v string) {
	o.K8sNamespace = &v
}

// GetK8sRoleName returns the K8sRoleName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sRoleName() string {
	if o == nil || o.K8sRoleName == nil {
		var ret string
		return ret
	}
	return *o.K8sRoleName
}

// GetK8sRoleNameOk returns a tuple with the K8sRoleName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sRoleNameOk() (*string, bool) {
	if o == nil || o.K8sRoleName == nil {
		return nil, false
	}
	return o.K8sRoleName, true
}

// HasK8sRoleName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sRoleName() bool {
	if o != nil && o.K8sRoleName != nil {
		return true
	}

	return false
}

// SetK8sRoleName gets a reference to the given string and assigns it to the K8sRoleName field.
func (o *DSProducerDetails) SetK8sRoleName(v string) {
	o.K8sRoleName = &v
}

// GetK8sRoleType returns the K8sRoleType field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sRoleType() string {
	if o == nil || o.K8sRoleType == nil {
		var ret string
		return ret
	}
	return *o.K8sRoleType
}

// GetK8sRoleTypeOk returns a tuple with the K8sRoleType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sRoleTypeOk() (*string, bool) {
	if o == nil || o.K8sRoleType == nil {
		return nil, false
	}
	return o.K8sRoleType, true
}

// HasK8sRoleType returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sRoleType() bool {
	if o != nil && o.K8sRoleType != nil {
		return true
	}

	return false
}

// SetK8sRoleType gets a reference to the given string and assigns it to the K8sRoleType field.
func (o *DSProducerDetails) SetK8sRoleType(v string) {
	o.K8sRoleType = &v
}

// GetK8sServiceAccount returns the K8sServiceAccount field value if set, zero value otherwise.
func (o *DSProducerDetails) GetK8sServiceAccount() string {
	if o == nil || o.K8sServiceAccount == nil {
		var ret string
		return ret
	}
	return *o.K8sServiceAccount
}

// GetK8sServiceAccountOk returns a tuple with the K8sServiceAccount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetK8sServiceAccountOk() (*string, bool) {
	if o == nil || o.K8sServiceAccount == nil {
		return nil, false
	}
	return o.K8sServiceAccount, true
}

// HasK8sServiceAccount returns a boolean if a field has been set.
func (o *DSProducerDetails) HasK8sServiceAccount() bool {
	if o != nil && o.K8sServiceAccount != nil {
		return true
	}

	return false
}

// SetK8sServiceAccount gets a reference to the given string and assigns it to the K8sServiceAccount field.
func (o *DSProducerDetails) SetK8sServiceAccount(v string) {
	o.K8sServiceAccount = &v
}

// GetLastAdminRotation returns the LastAdminRotation field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLastAdminRotation() int64 {
	if o == nil || o.LastAdminRotation == nil {
		var ret int64
		return ret
	}
	return *o.LastAdminRotation
}

// GetLastAdminRotationOk returns a tuple with the LastAdminRotation field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLastAdminRotationOk() (*int64, bool) {
	if o == nil || o.LastAdminRotation == nil {
		return nil, false
	}
	return o.LastAdminRotation, true
}

// HasLastAdminRotation returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLastAdminRotation() bool {
	if o != nil && o.LastAdminRotation != nil {
		return true
	}

	return false
}

// SetLastAdminRotation gets a reference to the given int64 and assigns it to the LastAdminRotation field.
func (o *DSProducerDetails) SetLastAdminRotation(v int64) {
	o.LastAdminRotation = &v
}

// GetLdapAudience returns the LdapAudience field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLdapAudience() string {
	if o == nil || o.LdapAudience == nil {
		var ret string
		return ret
	}
	return *o.LdapAudience
}

// GetLdapAudienceOk returns a tuple with the LdapAudience field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLdapAudienceOk() (*string, bool) {
	if o == nil || o.LdapAudience == nil {
		return nil, false
	}
	return o.LdapAudience, true
}

// HasLdapAudience returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLdapAudience() bool {
	if o != nil && o.LdapAudience != nil {
		return true
	}

	return false
}

// SetLdapAudience gets a reference to the given string and assigns it to the LdapAudience field.
func (o *DSProducerDetails) SetLdapAudience(v string) {
	o.LdapAudience = &v
}

// GetLdapBindDn returns the LdapBindDn field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLdapBindDn() string {
	if o == nil || o.LdapBindDn == nil {
		var ret string
		return ret
	}
	return *o.LdapBindDn
}

// GetLdapBindDnOk returns a tuple with the LdapBindDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLdapBindDnOk() (*string, bool) {
	if o == nil || o.LdapBindDn == nil {
		return nil, false
	}
	return o.LdapBindDn, true
}

// HasLdapBindDn returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLdapBindDn() bool {
	if o != nil && o.LdapBindDn != nil {
		return true
	}

	return false
}

// SetLdapBindDn gets a reference to the given string and assigns it to the LdapBindDn field.
func (o *DSProducerDetails) SetLdapBindDn(v string) {
	o.LdapBindDn = &v
}

// GetLdapBindPassword returns the LdapBindPassword field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLdapBindPassword() string {
	if o == nil || o.LdapBindPassword == nil {
		var ret string
		return ret
	}
	return *o.LdapBindPassword
}

// GetLdapBindPasswordOk returns a tuple with the LdapBindPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLdapBindPasswordOk() (*string, bool) {
	if o == nil || o.LdapBindPassword == nil {
		return nil, false
	}
	return o.LdapBindPassword, true
}

// HasLdapBindPassword returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLdapBindPassword() bool {
	if o != nil && o.LdapBindPassword != nil {
		return true
	}

	return false
}

// SetLdapBindPassword gets a reference to the given string and assigns it to the LdapBindPassword field.
func (o *DSProducerDetails) SetLdapBindPassword(v string) {
	o.LdapBindPassword = &v
}

// GetLdapCertificate returns the LdapCertificate field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLdapCertificate() string {
	if o == nil || o.LdapCertificate == nil {
		var ret string
		return ret
	}
	return *o.LdapCertificate
}

// GetLdapCertificateOk returns a tuple with the LdapCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLdapCertificateOk() (*string, bool) {
	if o == nil || o.LdapCertificate == nil {
		return nil, false
	}
	return o.LdapCertificate, true
}

// HasLdapCertificate returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLdapCertificate() bool {
	if o != nil && o.LdapCertificate != nil {
		return true
	}

	return false
}

// SetLdapCertificate gets a reference to the given string and assigns it to the LdapCertificate field.
func (o *DSProducerDetails) SetLdapCertificate(v string) {
	o.LdapCertificate = &v
}

// GetLdapGroupDn returns the LdapGroupDn field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLdapGroupDn() string {
	if o == nil || o.LdapGroupDn == nil {
		var ret string
		return ret
	}
	return *o.LdapGroupDn
}

// GetLdapGroupDnOk returns a tuple with the LdapGroupDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLdapGroupDnOk() (*string, bool) {
	if o == nil || o.LdapGroupDn == nil {
		return nil, false
	}
	return o.LdapGroupDn, true
}

// HasLdapGroupDn returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLdapGroupDn() bool {
	if o != nil && o.LdapGroupDn != nil {
		return true
	}

	return false
}

// SetLdapGroupDn gets a reference to the given string and assigns it to the LdapGroupDn field.
func (o *DSProducerDetails) SetLdapGroupDn(v string) {
	o.LdapGroupDn = &v
}

// GetLdapTokenExpiration returns the LdapTokenExpiration field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLdapTokenExpiration() string {
	if o == nil || o.LdapTokenExpiration == nil {
		var ret string
		return ret
	}
	return *o.LdapTokenExpiration
}

// GetLdapTokenExpirationOk returns a tuple with the LdapTokenExpiration field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLdapTokenExpirationOk() (*string, bool) {
	if o == nil || o.LdapTokenExpiration == nil {
		return nil, false
	}
	return o.LdapTokenExpiration, true
}

// HasLdapTokenExpiration returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLdapTokenExpiration() bool {
	if o != nil && o.LdapTokenExpiration != nil {
		return true
	}

	return false
}

// SetLdapTokenExpiration gets a reference to the given string and assigns it to the LdapTokenExpiration field.
func (o *DSProducerDetails) SetLdapTokenExpiration(v string) {
	o.LdapTokenExpiration = &v
}

// GetLdapUrl returns the LdapUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLdapUrl() string {
	if o == nil || o.LdapUrl == nil {
		var ret string
		return ret
	}
	return *o.LdapUrl
}

// GetLdapUrlOk returns a tuple with the LdapUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLdapUrlOk() (*string, bool) {
	if o == nil || o.LdapUrl == nil {
		return nil, false
	}
	return o.LdapUrl, true
}

// HasLdapUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLdapUrl() bool {
	if o != nil && o.LdapUrl != nil {
		return true
	}

	return false
}

// SetLdapUrl gets a reference to the given string and assigns it to the LdapUrl field.
func (o *DSProducerDetails) SetLdapUrl(v string) {
	o.LdapUrl = &v
}

// GetLdapUserAttr returns the LdapUserAttr field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLdapUserAttr() string {
	if o == nil || o.LdapUserAttr == nil {
		var ret string
		return ret
	}
	return *o.LdapUserAttr
}

// GetLdapUserAttrOk returns a tuple with the LdapUserAttr field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLdapUserAttrOk() (*string, bool) {
	if o == nil || o.LdapUserAttr == nil {
		return nil, false
	}
	return o.LdapUserAttr, true
}

// HasLdapUserAttr returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLdapUserAttr() bool {
	if o != nil && o.LdapUserAttr != nil {
		return true
	}

	return false
}

// SetLdapUserAttr gets a reference to the given string and assigns it to the LdapUserAttr field.
func (o *DSProducerDetails) SetLdapUserAttr(v string) {
	o.LdapUserAttr = &v
}

// GetLdapUserDn returns the LdapUserDn field value if set, zero value otherwise.
func (o *DSProducerDetails) GetLdapUserDn() string {
	if o == nil || o.LdapUserDn == nil {
		var ret string
		return ret
	}
	return *o.LdapUserDn
}

// GetLdapUserDnOk returns a tuple with the LdapUserDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetLdapUserDnOk() (*string, bool) {
	if o == nil || o.LdapUserDn == nil {
		return nil, false
	}
	return o.LdapUserDn, true
}

// HasLdapUserDn returns a boolean if a field has been set.
func (o *DSProducerDetails) HasLdapUserDn() bool {
	if o != nil && o.LdapUserDn != nil {
		return true
	}

	return false
}

// SetLdapUserDn gets a reference to the given string and assigns it to the LdapUserDn field.
func (o *DSProducerDetails) SetLdapUserDn(v string) {
	o.LdapUserDn = &v
}

// GetMetadata returns the Metadata field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMetadata() string {
	if o == nil || o.Metadata == nil {
		var ret string
		return ret
	}
	return *o.Metadata
}

// GetMetadataOk returns a tuple with the Metadata field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMetadataOk() (*string, bool) {
	if o == nil || o.Metadata == nil {
		return nil, false
	}
	return o.Metadata, true
}

// HasMetadata returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMetadata() bool {
	if o != nil && o.Metadata != nil {
		return true
	}

	return false
}

// SetMetadata gets a reference to the given string and assigns it to the Metadata field.
func (o *DSProducerDetails) SetMetadata(v string) {
	o.Metadata = &v
}

// GetMongodbAtlasApiPrivateKey returns the MongodbAtlasApiPrivateKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbAtlasApiPrivateKey() string {
	if o == nil || o.MongodbAtlasApiPrivateKey == nil {
		var ret string
		return ret
	}
	return *o.MongodbAtlasApiPrivateKey
}

// GetMongodbAtlasApiPrivateKeyOk returns a tuple with the MongodbAtlasApiPrivateKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbAtlasApiPrivateKeyOk() (*string, bool) {
	if o == nil || o.MongodbAtlasApiPrivateKey == nil {
		return nil, false
	}
	return o.MongodbAtlasApiPrivateKey, true
}

// HasMongodbAtlasApiPrivateKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbAtlasApiPrivateKey() bool {
	if o != nil && o.MongodbAtlasApiPrivateKey != nil {
		return true
	}

	return false
}

// SetMongodbAtlasApiPrivateKey gets a reference to the given string and assigns it to the MongodbAtlasApiPrivateKey field.
func (o *DSProducerDetails) SetMongodbAtlasApiPrivateKey(v string) {
	o.MongodbAtlasApiPrivateKey = &v
}

// GetMongodbAtlasApiPublicKey returns the MongodbAtlasApiPublicKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbAtlasApiPublicKey() string {
	if o == nil || o.MongodbAtlasApiPublicKey == nil {
		var ret string
		return ret
	}
	return *o.MongodbAtlasApiPublicKey
}

// GetMongodbAtlasApiPublicKeyOk returns a tuple with the MongodbAtlasApiPublicKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbAtlasApiPublicKeyOk() (*string, bool) {
	if o == nil || o.MongodbAtlasApiPublicKey == nil {
		return nil, false
	}
	return o.MongodbAtlasApiPublicKey, true
}

// HasMongodbAtlasApiPublicKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbAtlasApiPublicKey() bool {
	if o != nil && o.MongodbAtlasApiPublicKey != nil {
		return true
	}

	return false
}

// SetMongodbAtlasApiPublicKey gets a reference to the given string and assigns it to the MongodbAtlasApiPublicKey field.
func (o *DSProducerDetails) SetMongodbAtlasApiPublicKey(v string) {
	o.MongodbAtlasApiPublicKey = &v
}

// GetMongodbAtlasProjectId returns the MongodbAtlasProjectId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbAtlasProjectId() string {
	if o == nil || o.MongodbAtlasProjectId == nil {
		var ret string
		return ret
	}
	return *o.MongodbAtlasProjectId
}

// GetMongodbAtlasProjectIdOk returns a tuple with the MongodbAtlasProjectId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbAtlasProjectIdOk() (*string, bool) {
	if o == nil || o.MongodbAtlasProjectId == nil {
		return nil, false
	}
	return o.MongodbAtlasProjectId, true
}

// HasMongodbAtlasProjectId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbAtlasProjectId() bool {
	if o != nil && o.MongodbAtlasProjectId != nil {
		return true
	}

	return false
}

// SetMongodbAtlasProjectId gets a reference to the given string and assigns it to the MongodbAtlasProjectId field.
func (o *DSProducerDetails) SetMongodbAtlasProjectId(v string) {
	o.MongodbAtlasProjectId = &v
}

// GetMongodbCustomData returns the MongodbCustomData field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbCustomData() string {
	if o == nil || o.MongodbCustomData == nil {
		var ret string
		return ret
	}
	return *o.MongodbCustomData
}

// GetMongodbCustomDataOk returns a tuple with the MongodbCustomData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbCustomDataOk() (*string, bool) {
	if o == nil || o.MongodbCustomData == nil {
		return nil, false
	}
	return o.MongodbCustomData, true
}

// HasMongodbCustomData returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbCustomData() bool {
	if o != nil && o.MongodbCustomData != nil {
		return true
	}

	return false
}

// SetMongodbCustomData gets a reference to the given string and assigns it to the MongodbCustomData field.
func (o *DSProducerDetails) SetMongodbCustomData(v string) {
	o.MongodbCustomData = &v
}

// GetMongodbDbName returns the MongodbDbName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbDbName() string {
	if o == nil || o.MongodbDbName == nil {
		var ret string
		return ret
	}
	return *o.MongodbDbName
}

// GetMongodbDbNameOk returns a tuple with the MongodbDbName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbDbNameOk() (*string, bool) {
	if o == nil || o.MongodbDbName == nil {
		return nil, false
	}
	return o.MongodbDbName, true
}

// HasMongodbDbName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbDbName() bool {
	if o != nil && o.MongodbDbName != nil {
		return true
	}

	return false
}

// SetMongodbDbName gets a reference to the given string and assigns it to the MongodbDbName field.
func (o *DSProducerDetails) SetMongodbDbName(v string) {
	o.MongodbDbName = &v
}

// GetMongodbDefaultAuthDb returns the MongodbDefaultAuthDb field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbDefaultAuthDb() string {
	if o == nil || o.MongodbDefaultAuthDb == nil {
		var ret string
		return ret
	}
	return *o.MongodbDefaultAuthDb
}

// GetMongodbDefaultAuthDbOk returns a tuple with the MongodbDefaultAuthDb field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbDefaultAuthDbOk() (*string, bool) {
	if o == nil || o.MongodbDefaultAuthDb == nil {
		return nil, false
	}
	return o.MongodbDefaultAuthDb, true
}

// HasMongodbDefaultAuthDb returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbDefaultAuthDb() bool {
	if o != nil && o.MongodbDefaultAuthDb != nil {
		return true
	}

	return false
}

// SetMongodbDefaultAuthDb gets a reference to the given string and assigns it to the MongodbDefaultAuthDb field.
func (o *DSProducerDetails) SetMongodbDefaultAuthDb(v string) {
	o.MongodbDefaultAuthDb = &v
}

// GetMongodbHostPort returns the MongodbHostPort field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbHostPort() string {
	if o == nil || o.MongodbHostPort == nil {
		var ret string
		return ret
	}
	return *o.MongodbHostPort
}

// GetMongodbHostPortOk returns a tuple with the MongodbHostPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbHostPortOk() (*string, bool) {
	if o == nil || o.MongodbHostPort == nil {
		return nil, false
	}
	return o.MongodbHostPort, true
}

// HasMongodbHostPort returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbHostPort() bool {
	if o != nil && o.MongodbHostPort != nil {
		return true
	}

	return false
}

// SetMongodbHostPort gets a reference to the given string and assigns it to the MongodbHostPort field.
func (o *DSProducerDetails) SetMongodbHostPort(v string) {
	o.MongodbHostPort = &v
}

// GetMongodbIsAtlas returns the MongodbIsAtlas field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbIsAtlas() bool {
	if o == nil || o.MongodbIsAtlas == nil {
		var ret bool
		return ret
	}
	return *o.MongodbIsAtlas
}

// GetMongodbIsAtlasOk returns a tuple with the MongodbIsAtlas field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbIsAtlasOk() (*bool, bool) {
	if o == nil || o.MongodbIsAtlas == nil {
		return nil, false
	}
	return o.MongodbIsAtlas, true
}

// HasMongodbIsAtlas returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbIsAtlas() bool {
	if o != nil && o.MongodbIsAtlas != nil {
		return true
	}

	return false
}

// SetMongodbIsAtlas gets a reference to the given bool and assigns it to the MongodbIsAtlas field.
func (o *DSProducerDetails) SetMongodbIsAtlas(v bool) {
	o.MongodbIsAtlas = &v
}

// GetMongodbPassword returns the MongodbPassword field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbPassword() string {
	if o == nil || o.MongodbPassword == nil {
		var ret string
		return ret
	}
	return *o.MongodbPassword
}

// GetMongodbPasswordOk returns a tuple with the MongodbPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbPasswordOk() (*string, bool) {
	if o == nil || o.MongodbPassword == nil {
		return nil, false
	}
	return o.MongodbPassword, true
}

// HasMongodbPassword returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbPassword() bool {
	if o != nil && o.MongodbPassword != nil {
		return true
	}

	return false
}

// SetMongodbPassword gets a reference to the given string and assigns it to the MongodbPassword field.
func (o *DSProducerDetails) SetMongodbPassword(v string) {
	o.MongodbPassword = &v
}

// GetMongodbRoles returns the MongodbRoles field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbRoles() string {
	if o == nil || o.MongodbRoles == nil {
		var ret string
		return ret
	}
	return *o.MongodbRoles
}

// GetMongodbRolesOk returns a tuple with the MongodbRoles field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbRolesOk() (*string, bool) {
	if o == nil || o.MongodbRoles == nil {
		return nil, false
	}
	return o.MongodbRoles, true
}

// HasMongodbRoles returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbRoles() bool {
	if o != nil && o.MongodbRoles != nil {
		return true
	}

	return false
}

// SetMongodbRoles gets a reference to the given string and assigns it to the MongodbRoles field.
func (o *DSProducerDetails) SetMongodbRoles(v string) {
	o.MongodbRoles = &v
}

// GetMongodbUriConnection returns the MongodbUriConnection field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbUriConnection() string {
	if o == nil || o.MongodbUriConnection == nil {
		var ret string
		return ret
	}
	return *o.MongodbUriConnection
}

// GetMongodbUriConnectionOk returns a tuple with the MongodbUriConnection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbUriConnectionOk() (*string, bool) {
	if o == nil || o.MongodbUriConnection == nil {
		return nil, false
	}
	return o.MongodbUriConnection, true
}

// HasMongodbUriConnection returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbUriConnection() bool {
	if o != nil && o.MongodbUriConnection != nil {
		return true
	}

	return false
}

// SetMongodbUriConnection gets a reference to the given string and assigns it to the MongodbUriConnection field.
func (o *DSProducerDetails) SetMongodbUriConnection(v string) {
	o.MongodbUriConnection = &v
}

// GetMongodbUriOptions returns the MongodbUriOptions field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbUriOptions() string {
	if o == nil || o.MongodbUriOptions == nil {
		var ret string
		return ret
	}
	return *o.MongodbUriOptions
}

// GetMongodbUriOptionsOk returns a tuple with the MongodbUriOptions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbUriOptionsOk() (*string, bool) {
	if o == nil || o.MongodbUriOptions == nil {
		return nil, false
	}
	return o.MongodbUriOptions, true
}

// HasMongodbUriOptions returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbUriOptions() bool {
	if o != nil && o.MongodbUriOptions != nil {
		return true
	}

	return false
}

// SetMongodbUriOptions gets a reference to the given string and assigns it to the MongodbUriOptions field.
func (o *DSProducerDetails) SetMongodbUriOptions(v string) {
	o.MongodbUriOptions = &v
}

// GetMongodbUsername returns the MongodbUsername field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMongodbUsername() string {
	if o == nil || o.MongodbUsername == nil {
		var ret string
		return ret
	}
	return *o.MongodbUsername
}

// GetMongodbUsernameOk returns a tuple with the MongodbUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMongodbUsernameOk() (*string, bool) {
	if o == nil || o.MongodbUsername == nil {
		return nil, false
	}
	return o.MongodbUsername, true
}

// HasMongodbUsername returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMongodbUsername() bool {
	if o != nil && o.MongodbUsername != nil {
		return true
	}

	return false
}

// SetMongodbUsername gets a reference to the given string and assigns it to the MongodbUsername field.
func (o *DSProducerDetails) SetMongodbUsername(v string) {
	o.MongodbUsername = &v
}

// GetMssqlCreationStatements returns the MssqlCreationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMssqlCreationStatements() string {
	if o == nil || o.MssqlCreationStatements == nil {
		var ret string
		return ret
	}
	return *o.MssqlCreationStatements
}

// GetMssqlCreationStatementsOk returns a tuple with the MssqlCreationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMssqlCreationStatementsOk() (*string, bool) {
	if o == nil || o.MssqlCreationStatements == nil {
		return nil, false
	}
	return o.MssqlCreationStatements, true
}

// HasMssqlCreationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMssqlCreationStatements() bool {
	if o != nil && o.MssqlCreationStatements != nil {
		return true
	}

	return false
}

// SetMssqlCreationStatements gets a reference to the given string and assigns it to the MssqlCreationStatements field.
func (o *DSProducerDetails) SetMssqlCreationStatements(v string) {
	o.MssqlCreationStatements = &v
}

// GetMssqlRevocationStatements returns the MssqlRevocationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMssqlRevocationStatements() string {
	if o == nil || o.MssqlRevocationStatements == nil {
		var ret string
		return ret
	}
	return *o.MssqlRevocationStatements
}

// GetMssqlRevocationStatementsOk returns a tuple with the MssqlRevocationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMssqlRevocationStatementsOk() (*string, bool) {
	if o == nil || o.MssqlRevocationStatements == nil {
		return nil, false
	}
	return o.MssqlRevocationStatements, true
}

// HasMssqlRevocationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMssqlRevocationStatements() bool {
	if o != nil && o.MssqlRevocationStatements != nil {
		return true
	}

	return false
}

// SetMssqlRevocationStatements gets a reference to the given string and assigns it to the MssqlRevocationStatements field.
func (o *DSProducerDetails) SetMssqlRevocationStatements(v string) {
	o.MssqlRevocationStatements = &v
}

// GetMysqlCreationStatements returns the MysqlCreationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMysqlCreationStatements() string {
	if o == nil || o.MysqlCreationStatements == nil {
		var ret string
		return ret
	}
	return *o.MysqlCreationStatements
}

// GetMysqlCreationStatementsOk returns a tuple with the MysqlCreationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMysqlCreationStatementsOk() (*string, bool) {
	if o == nil || o.MysqlCreationStatements == nil {
		return nil, false
	}
	return o.MysqlCreationStatements, true
}

// HasMysqlCreationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMysqlCreationStatements() bool {
	if o != nil && o.MysqlCreationStatements != nil {
		return true
	}

	return false
}

// SetMysqlCreationStatements gets a reference to the given string and assigns it to the MysqlCreationStatements field.
func (o *DSProducerDetails) SetMysqlCreationStatements(v string) {
	o.MysqlCreationStatements = &v
}

// GetMysqlRevocationStatements returns the MysqlRevocationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetMysqlRevocationStatements() string {
	if o == nil || o.MysqlRevocationStatements == nil {
		var ret string
		return ret
	}
	return *o.MysqlRevocationStatements
}

// GetMysqlRevocationStatementsOk returns a tuple with the MysqlRevocationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetMysqlRevocationStatementsOk() (*string, bool) {
	if o == nil || o.MysqlRevocationStatements == nil {
		return nil, false
	}
	return o.MysqlRevocationStatements, true
}

// HasMysqlRevocationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasMysqlRevocationStatements() bool {
	if o != nil && o.MysqlRevocationStatements != nil {
		return true
	}

	return false
}

// SetMysqlRevocationStatements gets a reference to the given string and assigns it to the MysqlRevocationStatements field.
func (o *DSProducerDetails) SetMysqlRevocationStatements(v string) {
	o.MysqlRevocationStatements = &v
}

// GetOracleCreationStatements returns the OracleCreationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetOracleCreationStatements() string {
	if o == nil || o.OracleCreationStatements == nil {
		var ret string
		return ret
	}
	return *o.OracleCreationStatements
}

// GetOracleCreationStatementsOk returns a tuple with the OracleCreationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetOracleCreationStatementsOk() (*string, bool) {
	if o == nil || o.OracleCreationStatements == nil {
		return nil, false
	}
	return o.OracleCreationStatements, true
}

// HasOracleCreationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasOracleCreationStatements() bool {
	if o != nil && o.OracleCreationStatements != nil {
		return true
	}

	return false
}

// SetOracleCreationStatements gets a reference to the given string and assigns it to the OracleCreationStatements field.
func (o *DSProducerDetails) SetOracleCreationStatements(v string) {
	o.OracleCreationStatements = &v
}

// GetOracleRevocationStatements returns the OracleRevocationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetOracleRevocationStatements() string {
	if o == nil || o.OracleRevocationStatements == nil {
		var ret string
		return ret
	}
	return *o.OracleRevocationStatements
}

// GetOracleRevocationStatementsOk returns a tuple with the OracleRevocationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetOracleRevocationStatementsOk() (*string, bool) {
	if o == nil || o.OracleRevocationStatements == nil {
		return nil, false
	}
	return o.OracleRevocationStatements, true
}

// HasOracleRevocationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasOracleRevocationStatements() bool {
	if o != nil && o.OracleRevocationStatements != nil {
		return true
	}

	return false
}

// SetOracleRevocationStatements gets a reference to the given string and assigns it to the OracleRevocationStatements field.
func (o *DSProducerDetails) SetOracleRevocationStatements(v string) {
	o.OracleRevocationStatements = &v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *DSProducerDetails) GetPassword() string {
	if o == nil || o.Password == nil {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetPasswordOk() (*string, bool) {
	if o == nil || o.Password == nil {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *DSProducerDetails) HasPassword() bool {
	if o != nil && o.Password != nil {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *DSProducerDetails) SetPassword(v string) {
	o.Password = &v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *DSProducerDetails) GetPasswordLength() int64 {
	if o == nil || o.PasswordLength == nil {
		var ret int64
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetPasswordLengthOk() (*int64, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *DSProducerDetails) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given int64 and assigns it to the PasswordLength field.
func (o *DSProducerDetails) SetPasswordLength(v int64) {
	o.PasswordLength = &v
}

// GetPasswordPolicy returns the PasswordPolicy field value if set, zero value otherwise.
func (o *DSProducerDetails) GetPasswordPolicy() string {
	if o == nil || o.PasswordPolicy == nil {
		var ret string
		return ret
	}
	return *o.PasswordPolicy
}

// GetPasswordPolicyOk returns a tuple with the PasswordPolicy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetPasswordPolicyOk() (*string, bool) {
	if o == nil || o.PasswordPolicy == nil {
		return nil, false
	}
	return o.PasswordPolicy, true
}

// HasPasswordPolicy returns a boolean if a field has been set.
func (o *DSProducerDetails) HasPasswordPolicy() bool {
	if o != nil && o.PasswordPolicy != nil {
		return true
	}

	return false
}

// SetPasswordPolicy gets a reference to the given string and assigns it to the PasswordPolicy field.
func (o *DSProducerDetails) SetPasswordPolicy(v string) {
	o.PasswordPolicy = &v
}

// GetPayload returns the Payload field value if set, zero value otherwise.
func (o *DSProducerDetails) GetPayload() string {
	if o == nil || o.Payload == nil {
		var ret string
		return ret
	}
	return *o.Payload
}

// GetPayloadOk returns a tuple with the Payload field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetPayloadOk() (*string, bool) {
	if o == nil || o.Payload == nil {
		return nil, false
	}
	return o.Payload, true
}

// HasPayload returns a boolean if a field has been set.
func (o *DSProducerDetails) HasPayload() bool {
	if o != nil && o.Payload != nil {
		return true
	}

	return false
}

// SetPayload gets a reference to the given string and assigns it to the Payload field.
func (o *DSProducerDetails) SetPayload(v string) {
	o.Payload = &v
}

// GetPingUrl returns the PingUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetPingUrl() string {
	if o == nil || o.PingUrl == nil {
		var ret string
		return ret
	}
	return *o.PingUrl
}

// GetPingUrlOk returns a tuple with the PingUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetPingUrlOk() (*string, bool) {
	if o == nil || o.PingUrl == nil {
		return nil, false
	}
	return o.PingUrl, true
}

// HasPingUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasPingUrl() bool {
	if o != nil && o.PingUrl != nil {
		return true
	}

	return false
}

// SetPingUrl gets a reference to the given string and assigns it to the PingUrl field.
func (o *DSProducerDetails) SetPingUrl(v string) {
	o.PingUrl = &v
}

// GetPostgresCreationStatements returns the PostgresCreationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetPostgresCreationStatements() string {
	if o == nil || o.PostgresCreationStatements == nil {
		var ret string
		return ret
	}
	return *o.PostgresCreationStatements
}

// GetPostgresCreationStatementsOk returns a tuple with the PostgresCreationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetPostgresCreationStatementsOk() (*string, bool) {
	if o == nil || o.PostgresCreationStatements == nil {
		return nil, false
	}
	return o.PostgresCreationStatements, true
}

// HasPostgresCreationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasPostgresCreationStatements() bool {
	if o != nil && o.PostgresCreationStatements != nil {
		return true
	}

	return false
}

// SetPostgresCreationStatements gets a reference to the given string and assigns it to the PostgresCreationStatements field.
func (o *DSProducerDetails) SetPostgresCreationStatements(v string) {
	o.PostgresCreationStatements = &v
}

// GetPostgresRevocationStatements returns the PostgresRevocationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetPostgresRevocationStatements() string {
	if o == nil || o.PostgresRevocationStatements == nil {
		var ret string
		return ret
	}
	return *o.PostgresRevocationStatements
}

// GetPostgresRevocationStatementsOk returns a tuple with the PostgresRevocationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetPostgresRevocationStatementsOk() (*string, bool) {
	if o == nil || o.PostgresRevocationStatements == nil {
		return nil, false
	}
	return o.PostgresRevocationStatements, true
}

// HasPostgresRevocationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasPostgresRevocationStatements() bool {
	if o != nil && o.PostgresRevocationStatements != nil {
		return true
	}

	return false
}

// SetPostgresRevocationStatements gets a reference to the given string and assigns it to the PostgresRevocationStatements field.
func (o *DSProducerDetails) SetPostgresRevocationStatements(v string) {
	o.PostgresRevocationStatements = &v
}

// GetPrivilegedUser returns the PrivilegedUser field value if set, zero value otherwise.
func (o *DSProducerDetails) GetPrivilegedUser() string {
	if o == nil || o.PrivilegedUser == nil {
		var ret string
		return ret
	}
	return *o.PrivilegedUser
}

// GetPrivilegedUserOk returns a tuple with the PrivilegedUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetPrivilegedUserOk() (*string, bool) {
	if o == nil || o.PrivilegedUser == nil {
		return nil, false
	}
	return o.PrivilegedUser, true
}

// HasPrivilegedUser returns a boolean if a field has been set.
func (o *DSProducerDetails) HasPrivilegedUser() bool {
	if o != nil && o.PrivilegedUser != nil {
		return true
	}

	return false
}

// SetPrivilegedUser gets a reference to the given string and assigns it to the PrivilegedUser field.
func (o *DSProducerDetails) SetPrivilegedUser(v string) {
	o.PrivilegedUser = &v
}

// GetRabbitmqServerPassword returns the RabbitmqServerPassword field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRabbitmqServerPassword() string {
	if o == nil || o.RabbitmqServerPassword == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqServerPassword
}

// GetRabbitmqServerPasswordOk returns a tuple with the RabbitmqServerPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRabbitmqServerPasswordOk() (*string, bool) {
	if o == nil || o.RabbitmqServerPassword == nil {
		return nil, false
	}
	return o.RabbitmqServerPassword, true
}

// HasRabbitmqServerPassword returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRabbitmqServerPassword() bool {
	if o != nil && o.RabbitmqServerPassword != nil {
		return true
	}

	return false
}

// SetRabbitmqServerPassword gets a reference to the given string and assigns it to the RabbitmqServerPassword field.
func (o *DSProducerDetails) SetRabbitmqServerPassword(v string) {
	o.RabbitmqServerPassword = &v
}

// GetRabbitmqServerUri returns the RabbitmqServerUri field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRabbitmqServerUri() string {
	if o == nil || o.RabbitmqServerUri == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqServerUri
}

// GetRabbitmqServerUriOk returns a tuple with the RabbitmqServerUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRabbitmqServerUriOk() (*string, bool) {
	if o == nil || o.RabbitmqServerUri == nil {
		return nil, false
	}
	return o.RabbitmqServerUri, true
}

// HasRabbitmqServerUri returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRabbitmqServerUri() bool {
	if o != nil && o.RabbitmqServerUri != nil {
		return true
	}

	return false
}

// SetRabbitmqServerUri gets a reference to the given string and assigns it to the RabbitmqServerUri field.
func (o *DSProducerDetails) SetRabbitmqServerUri(v string) {
	o.RabbitmqServerUri = &v
}

// GetRabbitmqServerUser returns the RabbitmqServerUser field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRabbitmqServerUser() string {
	if o == nil || o.RabbitmqServerUser == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqServerUser
}

// GetRabbitmqServerUserOk returns a tuple with the RabbitmqServerUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRabbitmqServerUserOk() (*string, bool) {
	if o == nil || o.RabbitmqServerUser == nil {
		return nil, false
	}
	return o.RabbitmqServerUser, true
}

// HasRabbitmqServerUser returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRabbitmqServerUser() bool {
	if o != nil && o.RabbitmqServerUser != nil {
		return true
	}

	return false
}

// SetRabbitmqServerUser gets a reference to the given string and assigns it to the RabbitmqServerUser field.
func (o *DSProducerDetails) SetRabbitmqServerUser(v string) {
	o.RabbitmqServerUser = &v
}

// GetRabbitmqUserConfPermission returns the RabbitmqUserConfPermission field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRabbitmqUserConfPermission() string {
	if o == nil || o.RabbitmqUserConfPermission == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqUserConfPermission
}

// GetRabbitmqUserConfPermissionOk returns a tuple with the RabbitmqUserConfPermission field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRabbitmqUserConfPermissionOk() (*string, bool) {
	if o == nil || o.RabbitmqUserConfPermission == nil {
		return nil, false
	}
	return o.RabbitmqUserConfPermission, true
}

// HasRabbitmqUserConfPermission returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRabbitmqUserConfPermission() bool {
	if o != nil && o.RabbitmqUserConfPermission != nil {
		return true
	}

	return false
}

// SetRabbitmqUserConfPermission gets a reference to the given string and assigns it to the RabbitmqUserConfPermission field.
func (o *DSProducerDetails) SetRabbitmqUserConfPermission(v string) {
	o.RabbitmqUserConfPermission = &v
}

// GetRabbitmqUserReadPermission returns the RabbitmqUserReadPermission field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRabbitmqUserReadPermission() string {
	if o == nil || o.RabbitmqUserReadPermission == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqUserReadPermission
}

// GetRabbitmqUserReadPermissionOk returns a tuple with the RabbitmqUserReadPermission field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRabbitmqUserReadPermissionOk() (*string, bool) {
	if o == nil || o.RabbitmqUserReadPermission == nil {
		return nil, false
	}
	return o.RabbitmqUserReadPermission, true
}

// HasRabbitmqUserReadPermission returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRabbitmqUserReadPermission() bool {
	if o != nil && o.RabbitmqUserReadPermission != nil {
		return true
	}

	return false
}

// SetRabbitmqUserReadPermission gets a reference to the given string and assigns it to the RabbitmqUserReadPermission field.
func (o *DSProducerDetails) SetRabbitmqUserReadPermission(v string) {
	o.RabbitmqUserReadPermission = &v
}

// GetRabbitmqUserTags returns the RabbitmqUserTags field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRabbitmqUserTags() string {
	if o == nil || o.RabbitmqUserTags == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqUserTags
}

// GetRabbitmqUserTagsOk returns a tuple with the RabbitmqUserTags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRabbitmqUserTagsOk() (*string, bool) {
	if o == nil || o.RabbitmqUserTags == nil {
		return nil, false
	}
	return o.RabbitmqUserTags, true
}

// HasRabbitmqUserTags returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRabbitmqUserTags() bool {
	if o != nil && o.RabbitmqUserTags != nil {
		return true
	}

	return false
}

// SetRabbitmqUserTags gets a reference to the given string and assigns it to the RabbitmqUserTags field.
func (o *DSProducerDetails) SetRabbitmqUserTags(v string) {
	o.RabbitmqUserTags = &v
}

// GetRabbitmqUserVhost returns the RabbitmqUserVhost field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRabbitmqUserVhost() string {
	if o == nil || o.RabbitmqUserVhost == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqUserVhost
}

// GetRabbitmqUserVhostOk returns a tuple with the RabbitmqUserVhost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRabbitmqUserVhostOk() (*string, bool) {
	if o == nil || o.RabbitmqUserVhost == nil {
		return nil, false
	}
	return o.RabbitmqUserVhost, true
}

// HasRabbitmqUserVhost returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRabbitmqUserVhost() bool {
	if o != nil && o.RabbitmqUserVhost != nil {
		return true
	}

	return false
}

// SetRabbitmqUserVhost gets a reference to the given string and assigns it to the RabbitmqUserVhost field.
func (o *DSProducerDetails) SetRabbitmqUserVhost(v string) {
	o.RabbitmqUserVhost = &v
}

// GetRabbitmqUserWritePermission returns the RabbitmqUserWritePermission field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRabbitmqUserWritePermission() string {
	if o == nil || o.RabbitmqUserWritePermission == nil {
		var ret string
		return ret
	}
	return *o.RabbitmqUserWritePermission
}

// GetRabbitmqUserWritePermissionOk returns a tuple with the RabbitmqUserWritePermission field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRabbitmqUserWritePermissionOk() (*string, bool) {
	if o == nil || o.RabbitmqUserWritePermission == nil {
		return nil, false
	}
	return o.RabbitmqUserWritePermission, true
}

// HasRabbitmqUserWritePermission returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRabbitmqUserWritePermission() bool {
	if o != nil && o.RabbitmqUserWritePermission != nil {
		return true
	}

	return false
}

// SetRabbitmqUserWritePermission gets a reference to the given string and assigns it to the RabbitmqUserWritePermission field.
func (o *DSProducerDetails) SetRabbitmqUserWritePermission(v string) {
	o.RabbitmqUserWritePermission = &v
}

// GetRedirectUris returns the RedirectUris field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRedirectUris() []string {
	if o == nil || o.RedirectUris == nil {
		var ret []string
		return ret
	}
	return *o.RedirectUris
}

// GetRedirectUrisOk returns a tuple with the RedirectUris field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRedirectUrisOk() (*[]string, bool) {
	if o == nil || o.RedirectUris == nil {
		return nil, false
	}
	return o.RedirectUris, true
}

// HasRedirectUris returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRedirectUris() bool {
	if o != nil && o.RedirectUris != nil {
		return true
	}

	return false
}

// SetRedirectUris gets a reference to the given []string and assigns it to the RedirectUris field.
func (o *DSProducerDetails) SetRedirectUris(v []string) {
	o.RedirectUris = &v
}

// GetRedshiftCreationStatements returns the RedshiftCreationStatements field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRedshiftCreationStatements() string {
	if o == nil || o.RedshiftCreationStatements == nil {
		var ret string
		return ret
	}
	return *o.RedshiftCreationStatements
}

// GetRedshiftCreationStatementsOk returns a tuple with the RedshiftCreationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRedshiftCreationStatementsOk() (*string, bool) {
	if o == nil || o.RedshiftCreationStatements == nil {
		return nil, false
	}
	return o.RedshiftCreationStatements, true
}

// HasRedshiftCreationStatements returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRedshiftCreationStatements() bool {
	if o != nil && o.RedshiftCreationStatements != nil {
		return true
	}

	return false
}

// SetRedshiftCreationStatements gets a reference to the given string and assigns it to the RedshiftCreationStatements field.
func (o *DSProducerDetails) SetRedshiftCreationStatements(v string) {
	o.RedshiftCreationStatements = &v
}

// GetRestrictedScopes returns the RestrictedScopes field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRestrictedScopes() []string {
	if o == nil || o.RestrictedScopes == nil {
		var ret []string
		return ret
	}
	return *o.RestrictedScopes
}

// GetRestrictedScopesOk returns a tuple with the RestrictedScopes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRestrictedScopesOk() (*[]string, bool) {
	if o == nil || o.RestrictedScopes == nil {
		return nil, false
	}
	return o.RestrictedScopes, true
}

// HasRestrictedScopes returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRestrictedScopes() bool {
	if o != nil && o.RestrictedScopes != nil {
		return true
	}

	return false
}

// SetRestrictedScopes gets a reference to the given []string and assigns it to the RestrictedScopes field.
func (o *DSProducerDetails) SetRestrictedScopes(v []string) {
	o.RestrictedScopes = &v
}

// GetRevokeSyncUrl returns the RevokeSyncUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRevokeSyncUrl() string {
	if o == nil || o.RevokeSyncUrl == nil {
		var ret string
		return ret
	}
	return *o.RevokeSyncUrl
}

// GetRevokeSyncUrlOk returns a tuple with the RevokeSyncUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRevokeSyncUrlOk() (*string, bool) {
	if o == nil || o.RevokeSyncUrl == nil {
		return nil, false
	}
	return o.RevokeSyncUrl, true
}

// HasRevokeSyncUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRevokeSyncUrl() bool {
	if o != nil && o.RevokeSyncUrl != nil {
		return true
	}

	return false
}

// SetRevokeSyncUrl gets a reference to the given string and assigns it to the RevokeSyncUrl field.
func (o *DSProducerDetails) SetRevokeSyncUrl(v string) {
	o.RevokeSyncUrl = &v
}

// GetRotateSyncUrl returns the RotateSyncUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetRotateSyncUrl() string {
	if o == nil || o.RotateSyncUrl == nil {
		var ret string
		return ret
	}
	return *o.RotateSyncUrl
}

// GetRotateSyncUrlOk returns a tuple with the RotateSyncUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetRotateSyncUrlOk() (*string, bool) {
	if o == nil || o.RotateSyncUrl == nil {
		return nil, false
	}
	return o.RotateSyncUrl, true
}

// HasRotateSyncUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasRotateSyncUrl() bool {
	if o != nil && o.RotateSyncUrl != nil {
		return true
	}

	return false
}

// SetRotateSyncUrl gets a reference to the given string and assigns it to the RotateSyncUrl field.
func (o *DSProducerDetails) SetRotateSyncUrl(v string) {
	o.RotateSyncUrl = &v
}

// GetScopes returns the Scopes field value if set, zero value otherwise.
func (o *DSProducerDetails) GetScopes() []string {
	if o == nil || o.Scopes == nil {
		var ret []string
		return ret
	}
	return *o.Scopes
}

// GetScopesOk returns a tuple with the Scopes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetScopesOk() (*[]string, bool) {
	if o == nil || o.Scopes == nil {
		return nil, false
	}
	return o.Scopes, true
}

// HasScopes returns a boolean if a field has been set.
func (o *DSProducerDetails) HasScopes() bool {
	if o != nil && o.Scopes != nil {
		return true
	}

	return false
}

// SetScopes gets a reference to the given []string and assigns it to the Scopes field.
func (o *DSProducerDetails) SetScopes(v []string) {
	o.Scopes = &v
}

// GetSecureRemoteAccessDetails returns the SecureRemoteAccessDetails field value if set, zero value otherwise.
func (o *DSProducerDetails) GetSecureRemoteAccessDetails() SecureRemoteAccess {
	if o == nil || o.SecureRemoteAccessDetails == nil {
		var ret SecureRemoteAccess
		return ret
	}
	return *o.SecureRemoteAccessDetails
}

// GetSecureRemoteAccessDetailsOk returns a tuple with the SecureRemoteAccessDetails field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetSecureRemoteAccessDetailsOk() (*SecureRemoteAccess, bool) {
	if o == nil || o.SecureRemoteAccessDetails == nil {
		return nil, false
	}
	return o.SecureRemoteAccessDetails, true
}

// HasSecureRemoteAccessDetails returns a boolean if a field has been set.
func (o *DSProducerDetails) HasSecureRemoteAccessDetails() bool {
	if o != nil && o.SecureRemoteAccessDetails != nil {
		return true
	}

	return false
}

// SetSecureRemoteAccessDetails gets a reference to the given SecureRemoteAccess and assigns it to the SecureRemoteAccessDetails field.
func (o *DSProducerDetails) SetSecureRemoteAccessDetails(v SecureRemoteAccess) {
	o.SecureRemoteAccessDetails = &v
}

// GetSessionExtensionWarnIntervalMin returns the SessionExtensionWarnIntervalMin field value if set, zero value otherwise.
func (o *DSProducerDetails) GetSessionExtensionWarnIntervalMin() int64 {
	if o == nil || o.SessionExtensionWarnIntervalMin == nil {
		var ret int64
		return ret
	}
	return *o.SessionExtensionWarnIntervalMin
}

// GetSessionExtensionWarnIntervalMinOk returns a tuple with the SessionExtensionWarnIntervalMin field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetSessionExtensionWarnIntervalMinOk() (*int64, bool) {
	if o == nil || o.SessionExtensionWarnIntervalMin == nil {
		return nil, false
	}
	return o.SessionExtensionWarnIntervalMin, true
}

// HasSessionExtensionWarnIntervalMin returns a boolean if a field has been set.
func (o *DSProducerDetails) HasSessionExtensionWarnIntervalMin() bool {
	if o != nil && o.SessionExtensionWarnIntervalMin != nil {
		return true
	}

	return false
}

// SetSessionExtensionWarnIntervalMin gets a reference to the given int64 and assigns it to the SessionExtensionWarnIntervalMin field.
func (o *DSProducerDetails) SetSessionExtensionWarnIntervalMin(v int64) {
	o.SessionExtensionWarnIntervalMin = &v
}

// GetSfAccount returns the SfAccount field value if set, zero value otherwise.
func (o *DSProducerDetails) GetSfAccount() string {
	if o == nil || o.SfAccount == nil {
		var ret string
		return ret
	}
	return *o.SfAccount
}

// GetSfAccountOk returns a tuple with the SfAccount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetSfAccountOk() (*string, bool) {
	if o == nil || o.SfAccount == nil {
		return nil, false
	}
	return o.SfAccount, true
}

// HasSfAccount returns a boolean if a field has been set.
func (o *DSProducerDetails) HasSfAccount() bool {
	if o != nil && o.SfAccount != nil {
		return true
	}

	return false
}

// SetSfAccount gets a reference to the given string and assigns it to the SfAccount field.
func (o *DSProducerDetails) SetSfAccount(v string) {
	o.SfAccount = &v
}

// GetSfUserRole returns the SfUserRole field value if set, zero value otherwise.
func (o *DSProducerDetails) GetSfUserRole() string {
	if o == nil || o.SfUserRole == nil {
		var ret string
		return ret
	}
	return *o.SfUserRole
}

// GetSfUserRoleOk returns a tuple with the SfUserRole field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetSfUserRoleOk() (*string, bool) {
	if o == nil || o.SfUserRole == nil {
		return nil, false
	}
	return o.SfUserRole, true
}

// HasSfUserRole returns a boolean if a field has been set.
func (o *DSProducerDetails) HasSfUserRole() bool {
	if o != nil && o.SfUserRole != nil {
		return true
	}

	return false
}

// SetSfUserRole gets a reference to the given string and assigns it to the SfUserRole field.
func (o *DSProducerDetails) SetSfUserRole(v string) {
	o.SfUserRole = &v
}

// GetSfWarehouseName returns the SfWarehouseName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetSfWarehouseName() string {
	if o == nil || o.SfWarehouseName == nil {
		var ret string
		return ret
	}
	return *o.SfWarehouseName
}

// GetSfWarehouseNameOk returns a tuple with the SfWarehouseName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetSfWarehouseNameOk() (*string, bool) {
	if o == nil || o.SfWarehouseName == nil {
		return nil, false
	}
	return o.SfWarehouseName, true
}

// HasSfWarehouseName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasSfWarehouseName() bool {
	if o != nil && o.SfWarehouseName != nil {
		return true
	}

	return false
}

// SetSfWarehouseName gets a reference to the given string and assigns it to the SfWarehouseName field.
func (o *DSProducerDetails) SetSfWarehouseName(v string) {
	o.SfWarehouseName = &v
}

// GetShouldStop returns the ShouldStop field value if set, zero value otherwise.
func (o *DSProducerDetails) GetShouldStop() string {
	if o == nil || o.ShouldStop == nil {
		var ret string
		return ret
	}
	return *o.ShouldStop
}

// GetShouldStopOk returns a tuple with the ShouldStop field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetShouldStopOk() (*string, bool) {
	if o == nil || o.ShouldStop == nil {
		return nil, false
	}
	return o.ShouldStop, true
}

// HasShouldStop returns a boolean if a field has been set.
func (o *DSProducerDetails) HasShouldStop() bool {
	if o != nil && o.ShouldStop != nil {
		return true
	}

	return false
}

// SetShouldStop gets a reference to the given string and assigns it to the ShouldStop field.
func (o *DSProducerDetails) SetShouldStop(v string) {
	o.ShouldStop = &v
}

// GetSigningAlgorithm returns the SigningAlgorithm field value if set, zero value otherwise.
func (o *DSProducerDetails) GetSigningAlgorithm() string {
	if o == nil || o.SigningAlgorithm == nil {
		var ret string
		return ret
	}
	return *o.SigningAlgorithm
}

// GetSigningAlgorithmOk returns a tuple with the SigningAlgorithm field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetSigningAlgorithmOk() (*string, bool) {
	if o == nil || o.SigningAlgorithm == nil {
		return nil, false
	}
	return o.SigningAlgorithm, true
}

// HasSigningAlgorithm returns a boolean if a field has been set.
func (o *DSProducerDetails) HasSigningAlgorithm() bool {
	if o != nil && o.SigningAlgorithm != nil {
		return true
	}

	return false
}

// SetSigningAlgorithm gets a reference to the given string and assigns it to the SigningAlgorithm field.
func (o *DSProducerDetails) SetSigningAlgorithm(v string) {
	o.SigningAlgorithm = &v
}

// GetSslConnectionCertificate returns the SslConnectionCertificate field value if set, zero value otherwise.
func (o *DSProducerDetails) GetSslConnectionCertificate() string {
	if o == nil || o.SslConnectionCertificate == nil {
		var ret string
		return ret
	}
	return *o.SslConnectionCertificate
}

// GetSslConnectionCertificateOk returns a tuple with the SslConnectionCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetSslConnectionCertificateOk() (*string, bool) {
	if o == nil || o.SslConnectionCertificate == nil {
		return nil, false
	}
	return o.SslConnectionCertificate, true
}

// HasSslConnectionCertificate returns a boolean if a field has been set.
func (o *DSProducerDetails) HasSslConnectionCertificate() bool {
	if o != nil && o.SslConnectionCertificate != nil {
		return true
	}

	return false
}

// SetSslConnectionCertificate gets a reference to the given string and assigns it to the SslConnectionCertificate field.
func (o *DSProducerDetails) SetSslConnectionCertificate(v string) {
	o.SslConnectionCertificate = &v
}

// GetSslConnectionMode returns the SslConnectionMode field value if set, zero value otherwise.
func (o *DSProducerDetails) GetSslConnectionMode() bool {
	if o == nil || o.SslConnectionMode == nil {
		var ret bool
		return ret
	}
	return *o.SslConnectionMode
}

// GetSslConnectionModeOk returns a tuple with the SslConnectionMode field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetSslConnectionModeOk() (*bool, bool) {
	if o == nil || o.SslConnectionMode == nil {
		return nil, false
	}
	return o.SslConnectionMode, true
}

// HasSslConnectionMode returns a boolean if a field has been set.
func (o *DSProducerDetails) HasSslConnectionMode() bool {
	if o != nil && o.SslConnectionMode != nil {
		return true
	}

	return false
}

// SetSslConnectionMode gets a reference to the given bool and assigns it to the SslConnectionMode field.
func (o *DSProducerDetails) SetSslConnectionMode(v bool) {
	o.SslConnectionMode = &v
}

// GetSubjectDn returns the SubjectDn field value if set, zero value otherwise.
func (o *DSProducerDetails) GetSubjectDn() string {
	if o == nil || o.SubjectDn == nil {
		var ret string
		return ret
	}
	return *o.SubjectDn
}

// GetSubjectDnOk returns a tuple with the SubjectDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetSubjectDnOk() (*string, bool) {
	if o == nil || o.SubjectDn == nil {
		return nil, false
	}
	return o.SubjectDn, true
}

// HasSubjectDn returns a boolean if a field has been set.
func (o *DSProducerDetails) HasSubjectDn() bool {
	if o != nil && o.SubjectDn != nil {
		return true
	}

	return false
}

// SetSubjectDn gets a reference to the given string and assigns it to the SubjectDn field.
func (o *DSProducerDetails) SetSubjectDn(v string) {
	o.SubjectDn = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DSProducerDetails) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DSProducerDetails) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DSProducerDetails) SetTags(v []string) {
	o.Tags = &v
}

// GetTimeoutSeconds returns the TimeoutSeconds field value if set, zero value otherwise.
func (o *DSProducerDetails) GetTimeoutSeconds() int64 {
	if o == nil || o.TimeoutSeconds == nil {
		var ret int64
		return ret
	}
	return *o.TimeoutSeconds
}

// GetTimeoutSecondsOk returns a tuple with the TimeoutSeconds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetTimeoutSecondsOk() (*int64, bool) {
	if o == nil || o.TimeoutSeconds == nil {
		return nil, false
	}
	return o.TimeoutSeconds, true
}

// HasTimeoutSeconds returns a boolean if a field has been set.
func (o *DSProducerDetails) HasTimeoutSeconds() bool {
	if o != nil && o.TimeoutSeconds != nil {
		return true
	}

	return false
}

// SetTimeoutSeconds gets a reference to the given int64 and assigns it to the TimeoutSeconds field.
func (o *DSProducerDetails) SetTimeoutSeconds(v int64) {
	o.TimeoutSeconds = &v
}

// GetUseGwCloudIdentity returns the UseGwCloudIdentity field value if set, zero value otherwise.
func (o *DSProducerDetails) GetUseGwCloudIdentity() bool {
	if o == nil || o.UseGwCloudIdentity == nil {
		var ret bool
		return ret
	}
	return *o.UseGwCloudIdentity
}

// GetUseGwCloudIdentityOk returns a tuple with the UseGwCloudIdentity field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetUseGwCloudIdentityOk() (*bool, bool) {
	if o == nil || o.UseGwCloudIdentity == nil {
		return nil, false
	}
	return o.UseGwCloudIdentity, true
}

// HasUseGwCloudIdentity returns a boolean if a field has been set.
func (o *DSProducerDetails) HasUseGwCloudIdentity() bool {
	if o != nil && o.UseGwCloudIdentity != nil {
		return true
	}

	return false
}

// SetUseGwCloudIdentity gets a reference to the given bool and assigns it to the UseGwCloudIdentity field.
func (o *DSProducerDetails) SetUseGwCloudIdentity(v bool) {
	o.UseGwCloudIdentity = &v
}

// GetUseGwServiceAccount returns the UseGwServiceAccount field value if set, zero value otherwise.
func (o *DSProducerDetails) GetUseGwServiceAccount() bool {
	if o == nil || o.UseGwServiceAccount == nil {
		var ret bool
		return ret
	}
	return *o.UseGwServiceAccount
}

// GetUseGwServiceAccountOk returns a tuple with the UseGwServiceAccount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetUseGwServiceAccountOk() (*bool, bool) {
	if o == nil || o.UseGwServiceAccount == nil {
		return nil, false
	}
	return o.UseGwServiceAccount, true
}

// HasUseGwServiceAccount returns a boolean if a field has been set.
func (o *DSProducerDetails) HasUseGwServiceAccount() bool {
	if o != nil && o.UseGwServiceAccount != nil {
		return true
	}

	return false
}

// SetUseGwServiceAccount gets a reference to the given bool and assigns it to the UseGwServiceAccount field.
func (o *DSProducerDetails) SetUseGwServiceAccount(v bool) {
	o.UseGwServiceAccount = &v
}

// GetUserName returns the UserName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetUserName() string {
	if o == nil || o.UserName == nil {
		var ret string
		return ret
	}
	return *o.UserName
}

// GetUserNameOk returns a tuple with the UserName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetUserNameOk() (*string, bool) {
	if o == nil || o.UserName == nil {
		return nil, false
	}
	return o.UserName, true
}

// HasUserName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasUserName() bool {
	if o != nil && o.UserName != nil {
		return true
	}

	return false
}

// SetUserName gets a reference to the given string and assigns it to the UserName field.
func (o *DSProducerDetails) SetUserName(v string) {
	o.UserName = &v
}

// GetUserPassword returns the UserPassword field value if set, zero value otherwise.
func (o *DSProducerDetails) GetUserPassword() string {
	if o == nil || o.UserPassword == nil {
		var ret string
		return ret
	}
	return *o.UserPassword
}

// GetUserPasswordOk returns a tuple with the UserPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetUserPasswordOk() (*string, bool) {
	if o == nil || o.UserPassword == nil {
		return nil, false
	}
	return o.UserPassword, true
}

// HasUserPassword returns a boolean if a field has been set.
func (o *DSProducerDetails) HasUserPassword() bool {
	if o != nil && o.UserPassword != nil {
		return true
	}

	return false
}

// SetUserPassword gets a reference to the given string and assigns it to the UserPassword field.
func (o *DSProducerDetails) SetUserPassword(v string) {
	o.UserPassword = &v
}

// GetUserPrincipalName returns the UserPrincipalName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetUserPrincipalName() string {
	if o == nil || o.UserPrincipalName == nil {
		var ret string
		return ret
	}
	return *o.UserPrincipalName
}

// GetUserPrincipalNameOk returns a tuple with the UserPrincipalName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetUserPrincipalNameOk() (*string, bool) {
	if o == nil || o.UserPrincipalName == nil {
		return nil, false
	}
	return o.UserPrincipalName, true
}

// HasUserPrincipalName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasUserPrincipalName() bool {
	if o != nil && o.UserPrincipalName != nil {
		return true
	}

	return false
}

// SetUserPrincipalName gets a reference to the given string and assigns it to the UserPrincipalName field.
func (o *DSProducerDetails) SetUserPrincipalName(v string) {
	o.UserPrincipalName = &v
}

// GetUserTtl returns the UserTtl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetUserTtl() string {
	if o == nil || o.UserTtl == nil {
		var ret string
		return ret
	}
	return *o.UserTtl
}

// GetUserTtlOk returns a tuple with the UserTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetUserTtlOk() (*string, bool) {
	if o == nil || o.UserTtl == nil {
		return nil, false
	}
	return o.UserTtl, true
}

// HasUserTtl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasUserTtl() bool {
	if o != nil && o.UserTtl != nil {
		return true
	}

	return false
}

// SetUserTtl gets a reference to the given string and assigns it to the UserTtl field.
func (o *DSProducerDetails) SetUserTtl(v string) {
	o.UserTtl = &v
}

// GetUsernameLength returns the UsernameLength field value if set, zero value otherwise.
func (o *DSProducerDetails) GetUsernameLength() int64 {
	if o == nil || o.UsernameLength == nil {
		var ret int64
		return ret
	}
	return *o.UsernameLength
}

// GetUsernameLengthOk returns a tuple with the UsernameLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetUsernameLengthOk() (*int64, bool) {
	if o == nil || o.UsernameLength == nil {
		return nil, false
	}
	return o.UsernameLength, true
}

// HasUsernameLength returns a boolean if a field has been set.
func (o *DSProducerDetails) HasUsernameLength() bool {
	if o != nil && o.UsernameLength != nil {
		return true
	}

	return false
}

// SetUsernameLength gets a reference to the given int64 and assigns it to the UsernameLength field.
func (o *DSProducerDetails) SetUsernameLength(v int64) {
	o.UsernameLength = &v
}

// GetUsernamePolicy returns the UsernamePolicy field value if set, zero value otherwise.
func (o *DSProducerDetails) GetUsernamePolicy() string {
	if o == nil || o.UsernamePolicy == nil {
		var ret string
		return ret
	}
	return *o.UsernamePolicy
}

// GetUsernamePolicyOk returns a tuple with the UsernamePolicy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetUsernamePolicyOk() (*string, bool) {
	if o == nil || o.UsernamePolicy == nil {
		return nil, false
	}
	return o.UsernamePolicy, true
}

// HasUsernamePolicy returns a boolean if a field has been set.
func (o *DSProducerDetails) HasUsernamePolicy() bool {
	if o != nil && o.UsernamePolicy != nil {
		return true
	}

	return false
}

// SetUsernamePolicy gets a reference to the given string and assigns it to the UsernamePolicy field.
func (o *DSProducerDetails) SetUsernamePolicy(v string) {
	o.UsernamePolicy = &v
}

// GetVenafiAllowSubdomains returns the VenafiAllowSubdomains field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiAllowSubdomains() bool {
	if o == nil || o.VenafiAllowSubdomains == nil {
		var ret bool
		return ret
	}
	return *o.VenafiAllowSubdomains
}

// GetVenafiAllowSubdomainsOk returns a tuple with the VenafiAllowSubdomains field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiAllowSubdomainsOk() (*bool, bool) {
	if o == nil || o.VenafiAllowSubdomains == nil {
		return nil, false
	}
	return o.VenafiAllowSubdomains, true
}

// HasVenafiAllowSubdomains returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiAllowSubdomains() bool {
	if o != nil && o.VenafiAllowSubdomains != nil {
		return true
	}

	return false
}

// SetVenafiAllowSubdomains gets a reference to the given bool and assigns it to the VenafiAllowSubdomains field.
func (o *DSProducerDetails) SetVenafiAllowSubdomains(v bool) {
	o.VenafiAllowSubdomains = &v
}

// GetVenafiAllowedDomains returns the VenafiAllowedDomains field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiAllowedDomains() []string {
	if o == nil || o.VenafiAllowedDomains == nil {
		var ret []string
		return ret
	}
	return *o.VenafiAllowedDomains
}

// GetVenafiAllowedDomainsOk returns a tuple with the VenafiAllowedDomains field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiAllowedDomainsOk() (*[]string, bool) {
	if o == nil || o.VenafiAllowedDomains == nil {
		return nil, false
	}
	return o.VenafiAllowedDomains, true
}

// HasVenafiAllowedDomains returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiAllowedDomains() bool {
	if o != nil && o.VenafiAllowedDomains != nil {
		return true
	}

	return false
}

// SetVenafiAllowedDomains gets a reference to the given []string and assigns it to the VenafiAllowedDomains field.
func (o *DSProducerDetails) SetVenafiAllowedDomains(v []string) {
	o.VenafiAllowedDomains = &v
}

// GetVenafiApiKey returns the VenafiApiKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiApiKey() string {
	if o == nil || o.VenafiApiKey == nil {
		var ret string
		return ret
	}
	return *o.VenafiApiKey
}

// GetVenafiApiKeyOk returns a tuple with the VenafiApiKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiApiKeyOk() (*string, bool) {
	if o == nil || o.VenafiApiKey == nil {
		return nil, false
	}
	return o.VenafiApiKey, true
}

// HasVenafiApiKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiApiKey() bool {
	if o != nil && o.VenafiApiKey != nil {
		return true
	}

	return false
}

// SetVenafiApiKey gets a reference to the given string and assigns it to the VenafiApiKey field.
func (o *DSProducerDetails) SetVenafiApiKey(v string) {
	o.VenafiApiKey = &v
}

// GetVenafiAutoGeneratedFolder returns the VenafiAutoGeneratedFolder field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiAutoGeneratedFolder() string {
	if o == nil || o.VenafiAutoGeneratedFolder == nil {
		var ret string
		return ret
	}
	return *o.VenafiAutoGeneratedFolder
}

// GetVenafiAutoGeneratedFolderOk returns a tuple with the VenafiAutoGeneratedFolder field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiAutoGeneratedFolderOk() (*string, bool) {
	if o == nil || o.VenafiAutoGeneratedFolder == nil {
		return nil, false
	}
	return o.VenafiAutoGeneratedFolder, true
}

// HasVenafiAutoGeneratedFolder returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiAutoGeneratedFolder() bool {
	if o != nil && o.VenafiAutoGeneratedFolder != nil {
		return true
	}

	return false
}

// SetVenafiAutoGeneratedFolder gets a reference to the given string and assigns it to the VenafiAutoGeneratedFolder field.
func (o *DSProducerDetails) SetVenafiAutoGeneratedFolder(v string) {
	o.VenafiAutoGeneratedFolder = &v
}

// GetVenafiBaseUrl returns the VenafiBaseUrl field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiBaseUrl() string {
	if o == nil || o.VenafiBaseUrl == nil {
		var ret string
		return ret
	}
	return *o.VenafiBaseUrl
}

// GetVenafiBaseUrlOk returns a tuple with the VenafiBaseUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiBaseUrlOk() (*string, bool) {
	if o == nil || o.VenafiBaseUrl == nil {
		return nil, false
	}
	return o.VenafiBaseUrl, true
}

// HasVenafiBaseUrl returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiBaseUrl() bool {
	if o != nil && o.VenafiBaseUrl != nil {
		return true
	}

	return false
}

// SetVenafiBaseUrl gets a reference to the given string and assigns it to the VenafiBaseUrl field.
func (o *DSProducerDetails) SetVenafiBaseUrl(v string) {
	o.VenafiBaseUrl = &v
}

// GetVenafiRootFirstInChain returns the VenafiRootFirstInChain field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiRootFirstInChain() bool {
	if o == nil || o.VenafiRootFirstInChain == nil {
		var ret bool
		return ret
	}
	return *o.VenafiRootFirstInChain
}

// GetVenafiRootFirstInChainOk returns a tuple with the VenafiRootFirstInChain field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiRootFirstInChainOk() (*bool, bool) {
	if o == nil || o.VenafiRootFirstInChain == nil {
		return nil, false
	}
	return o.VenafiRootFirstInChain, true
}

// HasVenafiRootFirstInChain returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiRootFirstInChain() bool {
	if o != nil && o.VenafiRootFirstInChain != nil {
		return true
	}

	return false
}

// SetVenafiRootFirstInChain gets a reference to the given bool and assigns it to the VenafiRootFirstInChain field.
func (o *DSProducerDetails) SetVenafiRootFirstInChain(v bool) {
	o.VenafiRootFirstInChain = &v
}

// GetVenafiSignUsingAkeylessPki returns the VenafiSignUsingAkeylessPki field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiSignUsingAkeylessPki() bool {
	if o == nil || o.VenafiSignUsingAkeylessPki == nil {
		var ret bool
		return ret
	}
	return *o.VenafiSignUsingAkeylessPki
}

// GetVenafiSignUsingAkeylessPkiOk returns a tuple with the VenafiSignUsingAkeylessPki field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiSignUsingAkeylessPkiOk() (*bool, bool) {
	if o == nil || o.VenafiSignUsingAkeylessPki == nil {
		return nil, false
	}
	return o.VenafiSignUsingAkeylessPki, true
}

// HasVenafiSignUsingAkeylessPki returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiSignUsingAkeylessPki() bool {
	if o != nil && o.VenafiSignUsingAkeylessPki != nil {
		return true
	}

	return false
}

// SetVenafiSignUsingAkeylessPki gets a reference to the given bool and assigns it to the VenafiSignUsingAkeylessPki field.
func (o *DSProducerDetails) SetVenafiSignUsingAkeylessPki(v bool) {
	o.VenafiSignUsingAkeylessPki = &v
}

// GetVenafiSignerKeyName returns the VenafiSignerKeyName field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiSignerKeyName() string {
	if o == nil || o.VenafiSignerKeyName == nil {
		var ret string
		return ret
	}
	return *o.VenafiSignerKeyName
}

// GetVenafiSignerKeyNameOk returns a tuple with the VenafiSignerKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiSignerKeyNameOk() (*string, bool) {
	if o == nil || o.VenafiSignerKeyName == nil {
		return nil, false
	}
	return o.VenafiSignerKeyName, true
}

// HasVenafiSignerKeyName returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiSignerKeyName() bool {
	if o != nil && o.VenafiSignerKeyName != nil {
		return true
	}

	return false
}

// SetVenafiSignerKeyName gets a reference to the given string and assigns it to the VenafiSignerKeyName field.
func (o *DSProducerDetails) SetVenafiSignerKeyName(v string) {
	o.VenafiSignerKeyName = &v
}

// GetVenafiStorePrivateKey returns the VenafiStorePrivateKey field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiStorePrivateKey() bool {
	if o == nil || o.VenafiStorePrivateKey == nil {
		var ret bool
		return ret
	}
	return *o.VenafiStorePrivateKey
}

// GetVenafiStorePrivateKeyOk returns a tuple with the VenafiStorePrivateKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiStorePrivateKeyOk() (*bool, bool) {
	if o == nil || o.VenafiStorePrivateKey == nil {
		return nil, false
	}
	return o.VenafiStorePrivateKey, true
}

// HasVenafiStorePrivateKey returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiStorePrivateKey() bool {
	if o != nil && o.VenafiStorePrivateKey != nil {
		return true
	}

	return false
}

// SetVenafiStorePrivateKey gets a reference to the given bool and assigns it to the VenafiStorePrivateKey field.
func (o *DSProducerDetails) SetVenafiStorePrivateKey(v bool) {
	o.VenafiStorePrivateKey = &v
}

// GetVenafiTppAccessToken returns the VenafiTppAccessToken field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiTppAccessToken() string {
	if o == nil || o.VenafiTppAccessToken == nil {
		var ret string
		return ret
	}
	return *o.VenafiTppAccessToken
}

// GetVenafiTppAccessTokenOk returns a tuple with the VenafiTppAccessToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiTppAccessTokenOk() (*string, bool) {
	if o == nil || o.VenafiTppAccessToken == nil {
		return nil, false
	}
	return o.VenafiTppAccessToken, true
}

// HasVenafiTppAccessToken returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiTppAccessToken() bool {
	if o != nil && o.VenafiTppAccessToken != nil {
		return true
	}

	return false
}

// SetVenafiTppAccessToken gets a reference to the given string and assigns it to the VenafiTppAccessToken field.
func (o *DSProducerDetails) SetVenafiTppAccessToken(v string) {
	o.VenafiTppAccessToken = &v
}

// GetVenafiTppClientId returns the VenafiTppClientId field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiTppClientId() string {
	if o == nil || o.VenafiTppClientId == nil {
		var ret string
		return ret
	}
	return *o.VenafiTppClientId
}

// GetVenafiTppClientIdOk returns a tuple with the VenafiTppClientId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiTppClientIdOk() (*string, bool) {
	if o == nil || o.VenafiTppClientId == nil {
		return nil, false
	}
	return o.VenafiTppClientId, true
}

// HasVenafiTppClientId returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiTppClientId() bool {
	if o != nil && o.VenafiTppClientId != nil {
		return true
	}

	return false
}

// SetVenafiTppClientId gets a reference to the given string and assigns it to the VenafiTppClientId field.
func (o *DSProducerDetails) SetVenafiTppClientId(v string) {
	o.VenafiTppClientId = &v
}

// GetVenafiTppPassword returns the VenafiTppPassword field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiTppPassword() string {
	if o == nil || o.VenafiTppPassword == nil {
		var ret string
		return ret
	}
	return *o.VenafiTppPassword
}

// GetVenafiTppPasswordOk returns a tuple with the VenafiTppPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiTppPasswordOk() (*string, bool) {
	if o == nil || o.VenafiTppPassword == nil {
		return nil, false
	}
	return o.VenafiTppPassword, true
}

// HasVenafiTppPassword returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiTppPassword() bool {
	if o != nil && o.VenafiTppPassword != nil {
		return true
	}

	return false
}

// SetVenafiTppPassword gets a reference to the given string and assigns it to the VenafiTppPassword field.
func (o *DSProducerDetails) SetVenafiTppPassword(v string) {
	o.VenafiTppPassword = &v
}

// GetVenafiTppRefreshToken returns the VenafiTppRefreshToken field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiTppRefreshToken() string {
	if o == nil || o.VenafiTppRefreshToken == nil {
		var ret string
		return ret
	}
	return *o.VenafiTppRefreshToken
}

// GetVenafiTppRefreshTokenOk returns a tuple with the VenafiTppRefreshToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiTppRefreshTokenOk() (*string, bool) {
	if o == nil || o.VenafiTppRefreshToken == nil {
		return nil, false
	}
	return o.VenafiTppRefreshToken, true
}

// HasVenafiTppRefreshToken returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiTppRefreshToken() bool {
	if o != nil && o.VenafiTppRefreshToken != nil {
		return true
	}

	return false
}

// SetVenafiTppRefreshToken gets a reference to the given string and assigns it to the VenafiTppRefreshToken field.
func (o *DSProducerDetails) SetVenafiTppRefreshToken(v string) {
	o.VenafiTppRefreshToken = &v
}

// GetVenafiTppUsername returns the VenafiTppUsername field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiTppUsername() string {
	if o == nil || o.VenafiTppUsername == nil {
		var ret string
		return ret
	}
	return *o.VenafiTppUsername
}

// GetVenafiTppUsernameOk returns a tuple with the VenafiTppUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiTppUsernameOk() (*string, bool) {
	if o == nil || o.VenafiTppUsername == nil {
		return nil, false
	}
	return o.VenafiTppUsername, true
}

// HasVenafiTppUsername returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiTppUsername() bool {
	if o != nil && o.VenafiTppUsername != nil {
		return true
	}

	return false
}

// SetVenafiTppUsername gets a reference to the given string and assigns it to the VenafiTppUsername field.
func (o *DSProducerDetails) SetVenafiTppUsername(v string) {
	o.VenafiTppUsername = &v
}

// GetVenafiUseTpp returns the VenafiUseTpp field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiUseTpp() bool {
	if o == nil || o.VenafiUseTpp == nil {
		var ret bool
		return ret
	}
	return *o.VenafiUseTpp
}

// GetVenafiUseTppOk returns a tuple with the VenafiUseTpp field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiUseTppOk() (*bool, bool) {
	if o == nil || o.VenafiUseTpp == nil {
		return nil, false
	}
	return o.VenafiUseTpp, true
}

// HasVenafiUseTpp returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiUseTpp() bool {
	if o != nil && o.VenafiUseTpp != nil {
		return true
	}

	return false
}

// SetVenafiUseTpp gets a reference to the given bool and assigns it to the VenafiUseTpp field.
func (o *DSProducerDetails) SetVenafiUseTpp(v bool) {
	o.VenafiUseTpp = &v
}

// GetVenafiZone returns the VenafiZone field value if set, zero value otherwise.
func (o *DSProducerDetails) GetVenafiZone() string {
	if o == nil || o.VenafiZone == nil {
		var ret string
		return ret
	}
	return *o.VenafiZone
}

// GetVenafiZoneOk returns a tuple with the VenafiZone field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetVenafiZoneOk() (*string, bool) {
	if o == nil || o.VenafiZone == nil {
		return nil, false
	}
	return o.VenafiZone, true
}

// HasVenafiZone returns a boolean if a field has been set.
func (o *DSProducerDetails) HasVenafiZone() bool {
	if o != nil && o.VenafiZone != nil {
		return true
	}

	return false
}

// SetVenafiZone gets a reference to the given string and assigns it to the VenafiZone field.
func (o *DSProducerDetails) SetVenafiZone(v string) {
	o.VenafiZone = &v
}

// GetWarnBeforeUserExpirationMin returns the WarnBeforeUserExpirationMin field value if set, zero value otherwise.
func (o *DSProducerDetails) GetWarnBeforeUserExpirationMin() int64 {
	if o == nil || o.WarnBeforeUserExpirationMin == nil {
		var ret int64
		return ret
	}
	return *o.WarnBeforeUserExpirationMin
}

// GetWarnBeforeUserExpirationMinOk returns a tuple with the WarnBeforeUserExpirationMin field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DSProducerDetails) GetWarnBeforeUserExpirationMinOk() (*int64, bool) {
	if o == nil || o.WarnBeforeUserExpirationMin == nil {
		return nil, false
	}
	return o.WarnBeforeUserExpirationMin, true
}

// HasWarnBeforeUserExpirationMin returns a boolean if a field has been set.
func (o *DSProducerDetails) HasWarnBeforeUserExpirationMin() bool {
	if o != nil && o.WarnBeforeUserExpirationMin != nil {
		return true
	}

	return false
}

// SetWarnBeforeUserExpirationMin gets a reference to the given int64 and assigns it to the WarnBeforeUserExpirationMin field.
func (o *DSProducerDetails) SetWarnBeforeUserExpirationMin(v int64) {
	o.WarnBeforeUserExpirationMin = &v
}

func (o DSProducerDetails) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessTokenManagerId != nil {
		toSerialize["access_token_manager_id"] = o.AccessTokenManagerId
	}
	if o.AclRules != nil {
		toSerialize["acl_rules"] = o.AclRules
	}
	if o.Active != nil {
		toSerialize["active"] = o.Active
	}
	if o.AdminName != nil {
		toSerialize["admin_name"] = o.AdminName
	}
	if o.AdminPwd != nil {
		toSerialize["admin_pwd"] = o.AdminPwd
	}
	if o.AdminRotationIntervalDays != nil {
		toSerialize["admin_rotation_interval_days"] = o.AdminRotationIntervalDays
	}
	if o.AdministrativePort != nil {
		toSerialize["administrative_port"] = o.AdministrativePort
	}
	if o.ArtifactoryAdminApikey != nil {
		toSerialize["artifactory_admin_apikey"] = o.ArtifactoryAdminApikey
	}
	if o.ArtifactoryAdminUsername != nil {
		toSerialize["artifactory_admin_username"] = o.ArtifactoryAdminUsername
	}
	if o.ArtifactoryBaseUrl != nil {
		toSerialize["artifactory_base_url"] = o.ArtifactoryBaseUrl
	}
	if o.ArtifactoryTokenAudience != nil {
		toSerialize["artifactory_token_audience"] = o.ArtifactoryTokenAudience
	}
	if o.ArtifactoryTokenScope != nil {
		toSerialize["artifactory_token_scope"] = o.ArtifactoryTokenScope
	}
	if o.AuthorizationPort != nil {
		toSerialize["authorization_port"] = o.AuthorizationPort
	}
	if o.AwsAccessKeyId != nil {
		toSerialize["aws_access_key_id"] = o.AwsAccessKeyId
	}
	if o.AwsAccessMode != nil {
		toSerialize["aws_access_mode"] = o.AwsAccessMode
	}
	if o.AwsRegion != nil {
		toSerialize["aws_region"] = o.AwsRegion
	}
	if o.AwsRoleArns != nil {
		toSerialize["aws_role_arns"] = o.AwsRoleArns
	}
	if o.AwsSecretAccessKey != nil {
		toSerialize["aws_secret_access_key"] = o.AwsSecretAccessKey
	}
	if o.AwsSessionTags != nil {
		toSerialize["aws_session_tags"] = o.AwsSessionTags
	}
	if o.AwsSessionToken != nil {
		toSerialize["aws_session_token"] = o.AwsSessionToken
	}
	if o.AwsTransitiveTagKeys != nil {
		toSerialize["aws_transitive_tag_keys"] = o.AwsTransitiveTagKeys
	}
	if o.AwsUserConsoleAccess != nil {
		toSerialize["aws_user_console_access"] = o.AwsUserConsoleAccess
	}
	if o.AwsUserGroups != nil {
		toSerialize["aws_user_groups"] = o.AwsUserGroups
	}
	if o.AwsUserPolicies != nil {
		toSerialize["aws_user_policies"] = o.AwsUserPolicies
	}
	if o.AwsUserProgrammaticAccess != nil {
		toSerialize["aws_user_programmatic_access"] = o.AwsUserProgrammaticAccess
	}
	if o.AzureAppObjectId != nil {
		toSerialize["azure_app_object_id"] = o.AzureAppObjectId
	}
	if o.AzureClientId != nil {
		toSerialize["azure_client_id"] = o.AzureClientId
	}
	if o.AzureClientSecret != nil {
		toSerialize["azure_client_secret"] = o.AzureClientSecret
	}
	if o.AzureFixedUserNameSubClaimKey != nil {
		toSerialize["azure_fixed_user_name_sub_claim_key"] = o.AzureFixedUserNameSubClaimKey
	}
	if o.AzureFixedUserOnly != nil {
		toSerialize["azure_fixed_user_only"] = o.AzureFixedUserOnly
	}
	if o.AzureResourceGroupName != nil {
		toSerialize["azure_resource_group_name"] = o.AzureResourceGroupName
	}
	if o.AzureResourceName != nil {
		toSerialize["azure_resource_name"] = o.AzureResourceName
	}
	if o.AzureSubscriptionId != nil {
		toSerialize["azure_subscription_id"] = o.AzureSubscriptionId
	}
	if o.AzureTenantId != nil {
		toSerialize["azure_tenant_id"] = o.AzureTenantId
	}
	if o.AzureUserGroupsObjId != nil {
		toSerialize["azure_user_groups_obj_id"] = o.AzureUserGroupsObjId
	}
	if o.AzureUserPortalAccess != nil {
		toSerialize["azure_user_portal_access"] = o.AzureUserPortalAccess
	}
	if o.AzureUserProgrammaticAccess != nil {
		toSerialize["azure_user_programmatic_access"] = o.AzureUserProgrammaticAccess
	}
	if o.AzureUserRolesTemplateId != nil {
		toSerialize["azure_user_roles_template_id"] = o.AzureUserRolesTemplateId
	}
	if o.AzureUsername != nil {
		toSerialize["azure_username"] = o.AzureUsername
	}
	if o.CassandraCreationStatements != nil {
		toSerialize["cassandra_creation_statements"] = o.CassandraCreationStatements
	}
	if o.ChefOrganizations != nil {
		toSerialize["chef_organizations"] = o.ChefOrganizations
	}
	if o.ChefServerAccessMode != nil {
		toSerialize["chef_server_access_mode"] = o.ChefServerAccessMode
	}
	if o.ChefServerHostName != nil {
		toSerialize["chef_server_host_name"] = o.ChefServerHostName
	}
	if o.ChefServerKey != nil {
		toSerialize["chef_server_key"] = o.ChefServerKey
	}
	if o.ChefServerPort != nil {
		toSerialize["chef_server_port"] = o.ChefServerPort
	}
	if o.ChefServerUrl != nil {
		toSerialize["chef_server_url"] = o.ChefServerUrl
	}
	if o.ChefServerUsername != nil {
		toSerialize["chef_server_username"] = o.ChefServerUsername
	}
	if o.ChefSkipSsl != nil {
		toSerialize["chef_skip_ssl"] = o.ChefSkipSsl
	}
	if o.ClientAuthenticationType != nil {
		toSerialize["client_authentication_type"] = o.ClientAuthenticationType
	}
	if o.CloudServiceProvider != nil {
		toSerialize["cloud_service_provider"] = o.CloudServiceProvider
	}
	if o.ClusterMode != nil {
		toSerialize["cluster_mode"] = o.ClusterMode
	}
	if o.ConnectionType != nil {
		toSerialize["connection_type"] = o.ConnectionType
	}
	if o.CreateSyncUrl != nil {
		toSerialize["create_sync_url"] = o.CreateSyncUrl
	}
	if o.DbClientId != nil {
		toSerialize["db_client_id"] = o.DbClientId
	}
	if o.DbClientSecret != nil {
		toSerialize["db_client_secret"] = o.DbClientSecret
	}
	if o.DbHostName != nil {
		toSerialize["db_host_name"] = o.DbHostName
	}
	if o.DbIsolationLevel != nil {
		toSerialize["db_isolation_level"] = o.DbIsolationLevel
	}
	if o.DbMaxIdleConns != nil {
		toSerialize["db_max_idle_conns"] = o.DbMaxIdleConns
	}
	if o.DbMaxOpenConns != nil {
		toSerialize["db_max_open_conns"] = o.DbMaxOpenConns
	}
	if o.DbName != nil {
		toSerialize["db_name"] = o.DbName
	}
	if o.DbPort != nil {
		toSerialize["db_port"] = o.DbPort
	}
	if o.DbPrivateKey != nil {
		toSerialize["db_private_key"] = o.DbPrivateKey
	}
	if o.DbPrivateKeyPassphrase != nil {
		toSerialize["db_private_key_passphrase"] = o.DbPrivateKeyPassphrase
	}
	if o.DbPwd != nil {
		toSerialize["db_pwd"] = o.DbPwd
	}
	if o.DbServerCertificates != nil {
		toSerialize["db_server_certificates"] = o.DbServerCertificates
	}
	if o.DbServerName != nil {
		toSerialize["db_server_name"] = o.DbServerName
	}
	if o.DbTenantId != nil {
		toSerialize["db_tenant_id"] = o.DbTenantId
	}
	if o.DbUserName != nil {
		toSerialize["db_user_name"] = o.DbUserName
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.DynamicSecretId != nil {
		toSerialize["dynamic_secret_id"] = o.DynamicSecretId
	}
	if o.DynamicSecretKey != nil {
		toSerialize["dynamic_secret_key"] = o.DynamicSecretKey
	}
	if o.DynamicSecretName != nil {
		toSerialize["dynamic_secret_name"] = o.DynamicSecretName
	}
	if o.DynamicSecretType != nil {
		toSerialize["dynamic_secret_type"] = o.DynamicSecretType
	}
	if o.EksAccessKeyId != nil {
		toSerialize["eks_access_key_id"] = o.EksAccessKeyId
	}
	if o.EksAssumeRole != nil {
		toSerialize["eks_assume_role"] = o.EksAssumeRole
	}
	if o.EksClusterCaCertificate != nil {
		toSerialize["eks_cluster_ca_certificate"] = o.EksClusterCaCertificate
	}
	if o.EksClusterEndpoint != nil {
		toSerialize["eks_cluster_endpoint"] = o.EksClusterEndpoint
	}
	if o.EksClusterName != nil {
		toSerialize["eks_cluster_name"] = o.EksClusterName
	}
	if o.EksRegion != nil {
		toSerialize["eks_region"] = o.EksRegion
	}
	if o.EksSecretAccessKey != nil {
		toSerialize["eks_secret_access_key"] = o.EksSecretAccessKey
	}
	if o.EnableAdminRotation != nil {
		toSerialize["enable_admin_rotation"] = o.EnableAdminRotation
	}
	if o.EnforceReplayPrevention != nil {
		toSerialize["enforce_replay_prevention"] = o.EnforceReplayPrevention
	}
	if o.ExternallyProvidedUser != nil {
		toSerialize["externally_provided_user"] = o.ExternallyProvidedUser
	}
	if o.FailureMessage != nil {
		toSerialize["failure_message"] = o.FailureMessage
	}
	if o.FixedUserOnly != nil {
		toSerialize["fixed_user_only"] = o.FixedUserOnly
	}
	if o.GcpKeyAlgo != nil {
		toSerialize["gcp_key_algo"] = o.GcpKeyAlgo
	}
	if o.GcpRoleBindings != nil {
		toSerialize["gcp_role_bindings"] = o.GcpRoleBindings
	}
	if o.GcpServiceAccountEmail != nil {
		toSerialize["gcp_service_account_email"] = o.GcpServiceAccountEmail
	}
	if o.GcpServiceAccountKey != nil {
		toSerialize["gcp_service_account_key"] = o.GcpServiceAccountKey
	}
	if o.GcpServiceAccountKeyBase64 != nil {
		toSerialize["gcp_service_account_key_base64"] = o.GcpServiceAccountKeyBase64
	}
	if o.GcpServiceAccountKeyId != nil {
		toSerialize["gcp_service_account_key_id"] = o.GcpServiceAccountKeyId
	}
	if o.GcpServiceAccountType != nil {
		toSerialize["gcp_service_account_type"] = o.GcpServiceAccountType
	}
	if o.GcpTmpServiceAccountName != nil {
		toSerialize["gcp_tmp_service_account_name"] = o.GcpTmpServiceAccountName
	}
	if o.GcpTokenLifetime != nil {
		toSerialize["gcp_token_lifetime"] = o.GcpTokenLifetime
	}
	if o.GcpTokenScope != nil {
		toSerialize["gcp_token_scope"] = o.GcpTokenScope
	}
	if o.GcpTokenType != nil {
		toSerialize["gcp_token_type"] = o.GcpTokenType
	}
	if o.GithubAppId != nil {
		toSerialize["github_app_id"] = o.GithubAppId
	}
	if o.GithubAppPrivateKey != nil {
		toSerialize["github_app_private_key"] = o.GithubAppPrivateKey
	}
	if o.GithubBaseUrl != nil {
		toSerialize["github_base_url"] = o.GithubBaseUrl
	}
	if o.GithubInstallationId != nil {
		toSerialize["github_installation_id"] = o.GithubInstallationId
	}
	if o.GithubInstallationTokenPermissions != nil {
		toSerialize["github_installation_token_permissions"] = o.GithubInstallationTokenPermissions
	}
	if o.GithubInstallationTokenRepositories != nil {
		toSerialize["github_installation_token_repositories"] = o.GithubInstallationTokenRepositories
	}
	if o.GithubInstallationTokenRepositoriesIds != nil {
		toSerialize["github_installation_token_repositories_ids"] = o.GithubInstallationTokenRepositoriesIds
	}
	if o.GithubOrganizationName != nil {
		toSerialize["github_organization_name"] = o.GithubOrganizationName
	}
	if o.GithubRepositoryPath != nil {
		toSerialize["github_repository_path"] = o.GithubRepositoryPath
	}
	if o.GitlabAccessToken != nil {
		toSerialize["gitlab_access_token"] = o.GitlabAccessToken
	}
	if o.GitlabAccessType != nil {
		toSerialize["gitlab_access_type"] = o.GitlabAccessType
	}
	if o.GitlabCertificate != nil {
		toSerialize["gitlab_certificate"] = o.GitlabCertificate
	}
	if o.GitlabGroupName != nil {
		toSerialize["gitlab_group_name"] = o.GitlabGroupName
	}
	if o.GitlabProjectName != nil {
		toSerialize["gitlab_project_name"] = o.GitlabProjectName
	}
	if o.GitlabRole != nil {
		toSerialize["gitlab_role"] = o.GitlabRole
	}
	if o.GitlabTokenScope != nil {
		toSerialize["gitlab_token_scope"] = o.GitlabTokenScope
	}
	if o.GitlabUrl != nil {
		toSerialize["gitlab_url"] = o.GitlabUrl
	}
	if o.GkeClusterCaCertificate != nil {
		toSerialize["gke_cluster_ca_certificate"] = o.GkeClusterCaCertificate
	}
	if o.GkeClusterEndpoint != nil {
		toSerialize["gke_cluster_endpoint"] = o.GkeClusterEndpoint
	}
	if o.GkeClusterName != nil {
		toSerialize["gke_cluster_name"] = o.GkeClusterName
	}
	if o.GkeServiceAccountKey != nil {
		toSerialize["gke_service_account_key"] = o.GkeServiceAccountKey
	}
	if o.GkeServiceAccountName != nil {
		toSerialize["gke_service_account_name"] = o.GkeServiceAccountName
	}
	if o.GoogleWorkspaceAccessMode != nil {
		toSerialize["google_workspace_access_mode"] = o.GoogleWorkspaceAccessMode
	}
	if o.GoogleWorkspaceAdminName != nil {
		toSerialize["google_workspace_admin_name"] = o.GoogleWorkspaceAdminName
	}
	if o.GoogleWorkspaceGroupName != nil {
		toSerialize["google_workspace_group_name"] = o.GoogleWorkspaceGroupName
	}
	if o.GoogleWorkspaceGroupRole != nil {
		toSerialize["google_workspace_group_role"] = o.GoogleWorkspaceGroupRole
	}
	if o.GoogleWorkspaceRoleName != nil {
		toSerialize["google_workspace_role_name"] = o.GoogleWorkspaceRoleName
	}
	if o.GoogleWorkspaceRoleScope != nil {
		toSerialize["google_workspace_role_scope"] = o.GoogleWorkspaceRoleScope
	}
	if o.GrantTypes != nil {
		toSerialize["grant_types"] = o.GrantTypes
	}
	if o.Groups != nil {
		toSerialize["groups"] = o.Groups
	}
	if o.HanadbCreationStatements != nil {
		toSerialize["hanadb_creation_statements"] = o.HanadbCreationStatements
	}
	if o.HanadbRevocationStatements != nil {
		toSerialize["hanadb_revocation_statements"] = o.HanadbRevocationStatements
	}
	if o.HostName != nil {
		toSerialize["host_name"] = o.HostName
	}
	if o.HostPort != nil {
		toSerialize["host_port"] = o.HostPort
	}
	if o.ImplementationType != nil {
		toSerialize["implementation_type"] = o.ImplementationType
	}
	if o.IsFixedUser != nil {
		toSerialize["is_fixed_user"] = o.IsFixedUser
	}
	if o.Issuer != nil {
		toSerialize["issuer"] = o.Issuer
	}
	if o.ItemTargetsAssoc != nil {
		toSerialize["item_targets_assoc"] = o.ItemTargetsAssoc
	}
	if o.Jwks != nil {
		toSerialize["jwks"] = o.Jwks
	}
	if o.JwksUrl != nil {
		toSerialize["jwks_url"] = o.JwksUrl
	}
	if o.K8sAllowedNamespaces != nil {
		toSerialize["k8s_allowed_namespaces"] = o.K8sAllowedNamespaces
	}
	if o.K8sAuthType != nil {
		toSerialize["k8s_auth_type"] = o.K8sAuthType
	}
	if o.K8sBearerToken != nil {
		toSerialize["k8s_bearer_token"] = o.K8sBearerToken
	}
	if o.K8sClientCertData != nil {
		toSerialize["k8s_client_cert_data"] = o.K8sClientCertData
	}
	if o.K8sClientKeyData != nil {
		toSerialize["k8s_client_key_data"] = o.K8sClientKeyData
	}
	if o.K8sClusterCaCertificate != nil {
		toSerialize["k8s_cluster_ca_certificate"] = o.K8sClusterCaCertificate
	}
	if o.K8sClusterEndpoint != nil {
		toSerialize["k8s_cluster_endpoint"] = o.K8sClusterEndpoint
	}
	if o.K8sClusterName != nil {
		toSerialize["k8s_cluster_name"] = o.K8sClusterName
	}
	if o.K8sDynamicMode != nil {
		toSerialize["k8s_dynamic_mode"] = o.K8sDynamicMode
	}
	if o.K8sMultipleDocYamlTempDefinition != nil {
		toSerialize["k8s_multiple_doc_yaml_temp_definition"] = o.K8sMultipleDocYamlTempDefinition
	}
	if o.K8sNamespace != nil {
		toSerialize["k8s_namespace"] = o.K8sNamespace
	}
	if o.K8sRoleName != nil {
		toSerialize["k8s_role_name"] = o.K8sRoleName
	}
	if o.K8sRoleType != nil {
		toSerialize["k8s_role_type"] = o.K8sRoleType
	}
	if o.K8sServiceAccount != nil {
		toSerialize["k8s_service_account"] = o.K8sServiceAccount
	}
	if o.LastAdminRotation != nil {
		toSerialize["last_admin_rotation"] = o.LastAdminRotation
	}
	if o.LdapAudience != nil {
		toSerialize["ldap_audience"] = o.LdapAudience
	}
	if o.LdapBindDn != nil {
		toSerialize["ldap_bind_dn"] = o.LdapBindDn
	}
	if o.LdapBindPassword != nil {
		toSerialize["ldap_bind_password"] = o.LdapBindPassword
	}
	if o.LdapCertificate != nil {
		toSerialize["ldap_certificate"] = o.LdapCertificate
	}
	if o.LdapGroupDn != nil {
		toSerialize["ldap_group_dn"] = o.LdapGroupDn
	}
	if o.LdapTokenExpiration != nil {
		toSerialize["ldap_token_expiration"] = o.LdapTokenExpiration
	}
	if o.LdapUrl != nil {
		toSerialize["ldap_url"] = o.LdapUrl
	}
	if o.LdapUserAttr != nil {
		toSerialize["ldap_user_attr"] = o.LdapUserAttr
	}
	if o.LdapUserDn != nil {
		toSerialize["ldap_user_dn"] = o.LdapUserDn
	}
	if o.Metadata != nil {
		toSerialize["metadata"] = o.Metadata
	}
	if o.MongodbAtlasApiPrivateKey != nil {
		toSerialize["mongodb_atlas_api_private_key"] = o.MongodbAtlasApiPrivateKey
	}
	if o.MongodbAtlasApiPublicKey != nil {
		toSerialize["mongodb_atlas_api_public_key"] = o.MongodbAtlasApiPublicKey
	}
	if o.MongodbAtlasProjectId != nil {
		toSerialize["mongodb_atlas_project_id"] = o.MongodbAtlasProjectId
	}
	if o.MongodbCustomData != nil {
		toSerialize["mongodb_custom_data"] = o.MongodbCustomData
	}
	if o.MongodbDbName != nil {
		toSerialize["mongodb_db_name"] = o.MongodbDbName
	}
	if o.MongodbDefaultAuthDb != nil {
		toSerialize["mongodb_default_auth_db"] = o.MongodbDefaultAuthDb
	}
	if o.MongodbHostPort != nil {
		toSerialize["mongodb_host_port"] = o.MongodbHostPort
	}
	if o.MongodbIsAtlas != nil {
		toSerialize["mongodb_is_atlas"] = o.MongodbIsAtlas
	}
	if o.MongodbPassword != nil {
		toSerialize["mongodb_password"] = o.MongodbPassword
	}
	if o.MongodbRoles != nil {
		toSerialize["mongodb_roles"] = o.MongodbRoles
	}
	if o.MongodbUriConnection != nil {
		toSerialize["mongodb_uri_connection"] = o.MongodbUriConnection
	}
	if o.MongodbUriOptions != nil {
		toSerialize["mongodb_uri_options"] = o.MongodbUriOptions
	}
	if o.MongodbUsername != nil {
		toSerialize["mongodb_username"] = o.MongodbUsername
	}
	if o.MssqlCreationStatements != nil {
		toSerialize["mssql_creation_statements"] = o.MssqlCreationStatements
	}
	if o.MssqlRevocationStatements != nil {
		toSerialize["mssql_revocation_statements"] = o.MssqlRevocationStatements
	}
	if o.MysqlCreationStatements != nil {
		toSerialize["mysql_creation_statements"] = o.MysqlCreationStatements
	}
	if o.MysqlRevocationStatements != nil {
		toSerialize["mysql_revocation_statements"] = o.MysqlRevocationStatements
	}
	if o.OracleCreationStatements != nil {
		toSerialize["oracle_creation_statements"] = o.OracleCreationStatements
	}
	if o.OracleRevocationStatements != nil {
		toSerialize["oracle_revocation_statements"] = o.OracleRevocationStatements
	}
	if o.Password != nil {
		toSerialize["password"] = o.Password
	}
	if o.PasswordLength != nil {
		toSerialize["password_length"] = o.PasswordLength
	}
	if o.PasswordPolicy != nil {
		toSerialize["password_policy"] = o.PasswordPolicy
	}
	if o.Payload != nil {
		toSerialize["payload"] = o.Payload
	}
	if o.PingUrl != nil {
		toSerialize["ping_url"] = o.PingUrl
	}
	if o.PostgresCreationStatements != nil {
		toSerialize["postgres_creation_statements"] = o.PostgresCreationStatements
	}
	if o.PostgresRevocationStatements != nil {
		toSerialize["postgres_revocation_statements"] = o.PostgresRevocationStatements
	}
	if o.PrivilegedUser != nil {
		toSerialize["privileged_user"] = o.PrivilegedUser
	}
	if o.RabbitmqServerPassword != nil {
		toSerialize["rabbitmq_server_password"] = o.RabbitmqServerPassword
	}
	if o.RabbitmqServerUri != nil {
		toSerialize["rabbitmq_server_uri"] = o.RabbitmqServerUri
	}
	if o.RabbitmqServerUser != nil {
		toSerialize["rabbitmq_server_user"] = o.RabbitmqServerUser
	}
	if o.RabbitmqUserConfPermission != nil {
		toSerialize["rabbitmq_user_conf_permission"] = o.RabbitmqUserConfPermission
	}
	if o.RabbitmqUserReadPermission != nil {
		toSerialize["rabbitmq_user_read_permission"] = o.RabbitmqUserReadPermission
	}
	if o.RabbitmqUserTags != nil {
		toSerialize["rabbitmq_user_tags"] = o.RabbitmqUserTags
	}
	if o.RabbitmqUserVhost != nil {
		toSerialize["rabbitmq_user_vhost"] = o.RabbitmqUserVhost
	}
	if o.RabbitmqUserWritePermission != nil {
		toSerialize["rabbitmq_user_write_permission"] = o.RabbitmqUserWritePermission
	}
	if o.RedirectUris != nil {
		toSerialize["redirect_uris"] = o.RedirectUris
	}
	if o.RedshiftCreationStatements != nil {
		toSerialize["redshift_creation_statements"] = o.RedshiftCreationStatements
	}
	if o.RestrictedScopes != nil {
		toSerialize["restricted_scopes"] = o.RestrictedScopes
	}
	if o.RevokeSyncUrl != nil {
		toSerialize["revoke_sync_url"] = o.RevokeSyncUrl
	}
	if o.RotateSyncUrl != nil {
		toSerialize["rotate_sync_url"] = o.RotateSyncUrl
	}
	if o.Scopes != nil {
		toSerialize["scopes"] = o.Scopes
	}
	if o.SecureRemoteAccessDetails != nil {
		toSerialize["secure_remote_access_details"] = o.SecureRemoteAccessDetails
	}
	if o.SessionExtensionWarnIntervalMin != nil {
		toSerialize["session_extension_warn_interval_min"] = o.SessionExtensionWarnIntervalMin
	}
	if o.SfAccount != nil {
		toSerialize["sf_account"] = o.SfAccount
	}
	if o.SfUserRole != nil {
		toSerialize["sf_user_role"] = o.SfUserRole
	}
	if o.SfWarehouseName != nil {
		toSerialize["sf_warehouse_name"] = o.SfWarehouseName
	}
	if o.ShouldStop != nil {
		toSerialize["should_stop"] = o.ShouldStop
	}
	if o.SigningAlgorithm != nil {
		toSerialize["signing_algorithm"] = o.SigningAlgorithm
	}
	if o.SslConnectionCertificate != nil {
		toSerialize["ssl_connection_certificate"] = o.SslConnectionCertificate
	}
	if o.SslConnectionMode != nil {
		toSerialize["ssl_connection_mode"] = o.SslConnectionMode
	}
	if o.SubjectDn != nil {
		toSerialize["subject_dn"] = o.SubjectDn
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TimeoutSeconds != nil {
		toSerialize["timeout_seconds"] = o.TimeoutSeconds
	}
	if o.UseGwCloudIdentity != nil {
		toSerialize["use_gw_cloud_identity"] = o.UseGwCloudIdentity
	}
	if o.UseGwServiceAccount != nil {
		toSerialize["use_gw_service_account"] = o.UseGwServiceAccount
	}
	if o.UserName != nil {
		toSerialize["user_name"] = o.UserName
	}
	if o.UserPassword != nil {
		toSerialize["user_password"] = o.UserPassword
	}
	if o.UserPrincipalName != nil {
		toSerialize["user_principal_name"] = o.UserPrincipalName
	}
	if o.UserTtl != nil {
		toSerialize["user_ttl"] = o.UserTtl
	}
	if o.UsernameLength != nil {
		toSerialize["username_length"] = o.UsernameLength
	}
	if o.UsernamePolicy != nil {
		toSerialize["username_policy"] = o.UsernamePolicy
	}
	if o.VenafiAllowSubdomains != nil {
		toSerialize["venafi_allow_subdomains"] = o.VenafiAllowSubdomains
	}
	if o.VenafiAllowedDomains != nil {
		toSerialize["venafi_allowed_domains"] = o.VenafiAllowedDomains
	}
	if o.VenafiApiKey != nil {
		toSerialize["venafi_api_key"] = o.VenafiApiKey
	}
	if o.VenafiAutoGeneratedFolder != nil {
		toSerialize["venafi_auto_generated_folder"] = o.VenafiAutoGeneratedFolder
	}
	if o.VenafiBaseUrl != nil {
		toSerialize["venafi_base_url"] = o.VenafiBaseUrl
	}
	if o.VenafiRootFirstInChain != nil {
		toSerialize["venafi_root_first_in_chain"] = o.VenafiRootFirstInChain
	}
	if o.VenafiSignUsingAkeylessPki != nil {
		toSerialize["venafi_sign_using_akeyless_pki"] = o.VenafiSignUsingAkeylessPki
	}
	if o.VenafiSignerKeyName != nil {
		toSerialize["venafi_signer_key_name"] = o.VenafiSignerKeyName
	}
	if o.VenafiStorePrivateKey != nil {
		toSerialize["venafi_store_private_key"] = o.VenafiStorePrivateKey
	}
	if o.VenafiTppAccessToken != nil {
		toSerialize["venafi_tpp_access_token"] = o.VenafiTppAccessToken
	}
	if o.VenafiTppClientId != nil {
		toSerialize["venafi_tpp_client_id"] = o.VenafiTppClientId
	}
	if o.VenafiTppPassword != nil {
		toSerialize["venafi_tpp_password"] = o.VenafiTppPassword
	}
	if o.VenafiTppRefreshToken != nil {
		toSerialize["venafi_tpp_refresh_token"] = o.VenafiTppRefreshToken
	}
	if o.VenafiTppUsername != nil {
		toSerialize["venafi_tpp_username"] = o.VenafiTppUsername
	}
	if o.VenafiUseTpp != nil {
		toSerialize["venafi_use_tpp"] = o.VenafiUseTpp
	}
	if o.VenafiZone != nil {
		toSerialize["venafi_zone"] = o.VenafiZone
	}
	if o.WarnBeforeUserExpirationMin != nil {
		toSerialize["warn_before_user_expiration_min"] = o.WarnBeforeUserExpirationMin
	}
	return json.Marshal(toSerialize)
}

type NullableDSProducerDetails struct {
	value *DSProducerDetails
	isSet bool
}

func (v NullableDSProducerDetails) Get() *DSProducerDetails {
	return v.value
}

func (v *NullableDSProducerDetails) Set(val *DSProducerDetails) {
	v.value = val
	v.isSet = true
}

func (v NullableDSProducerDetails) IsSet() bool {
	return v.isSet
}

func (v *NullableDSProducerDetails) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDSProducerDetails(val *DSProducerDetails) *NullableDSProducerDetails {
	return &NullableDSProducerDetails{value: val, isSet: true}
}

func (v NullableDSProducerDetails) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDSProducerDetails) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


