/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DeleteTargetAssociation deleteTargetAssociation is a command that deletes an association between target and item.
type DeleteTargetAssociation struct {
	// The association id to be deleted
	AssocId *string `json:"assoc-id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Item name
	Name string `json:"name"`
	// The target to associate
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewDeleteTargetAssociation instantiates a new DeleteTargetAssociation object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDeleteTargetAssociation(name string, ) *DeleteTargetAssociation {
	this := DeleteTargetAssociation{}
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewDeleteTargetAssociationWithDefaults instantiates a new DeleteTargetAssociation object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDeleteTargetAssociationWithDefaults() *DeleteTargetAssociation {
	this := DeleteTargetAssociation{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAssocId returns the AssocId field value if set, zero value otherwise.
func (o *DeleteTargetAssociation) GetAssocId() string {
	if o == nil || o.AssocId == nil {
		var ret string
		return ret
	}
	return *o.AssocId
}

// GetAssocIdOk returns a tuple with the AssocId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteTargetAssociation) GetAssocIdOk() (*string, bool) {
	if o == nil || o.AssocId == nil {
		return nil, false
	}
	return o.AssocId, true
}

// HasAssocId returns a boolean if a field has been set.
func (o *DeleteTargetAssociation) HasAssocId() bool {
	if o != nil && o.AssocId != nil {
		return true
	}

	return false
}

// SetAssocId gets a reference to the given string and assigns it to the AssocId field.
func (o *DeleteTargetAssociation) SetAssocId(v string) {
	o.AssocId = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DeleteTargetAssociation) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteTargetAssociation) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DeleteTargetAssociation) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DeleteTargetAssociation) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DeleteTargetAssociation) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DeleteTargetAssociation) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DeleteTargetAssociation) SetName(v string) {
	o.Name = v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DeleteTargetAssociation) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteTargetAssociation) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DeleteTargetAssociation) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DeleteTargetAssociation) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DeleteTargetAssociation) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteTargetAssociation) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DeleteTargetAssociation) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DeleteTargetAssociation) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DeleteTargetAssociation) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteTargetAssociation) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DeleteTargetAssociation) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DeleteTargetAssociation) SetUidToken(v string) {
	o.UidToken = &v
}

func (o DeleteTargetAssociation) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AssocId != nil {
		toSerialize["assoc-id"] = o.AssocId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableDeleteTargetAssociation struct {
	value *DeleteTargetAssociation
	isSet bool
}

func (v NullableDeleteTargetAssociation) Get() *DeleteTargetAssociation {
	return v.value
}

func (v *NullableDeleteTargetAssociation) Set(val *DeleteTargetAssociation) {
	v.value = val
	v.isSet = true
}

func (v NullableDeleteTargetAssociation) IsSet() bool {
	return v.isSet
}

func (v *NullableDeleteTargetAssociation) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDeleteTargetAssociation(val *DeleteTargetAssociation) *NullableDeleteTargetAssociation {
	return &NullableDeleteTargetAssociation{value: val, isSet: true}
}

func (v NullableDeleteTargetAssociation) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDeleteTargetAssociation) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


