/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// DeleteItemOutput struct for DeleteItemOutput
type DeleteItemOutput struct {
	DeletionDate *time.Time `json:"deletion_date,omitempty"`
	ItemId *int64 `json:"item_id,omitempty"`
	ItemName *string `json:"item_name,omitempty"`
	VersionDeleted *int32 `json:"version_deleted,omitempty"`
}

// NewDeleteItemOutput instantiates a new DeleteItemOutput object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDeleteItemOutput() *DeleteItemOutput {
	this := DeleteItemOutput{}
	return &this
}

// NewDeleteItemOutputWithDefaults instantiates a new DeleteItemOutput object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDeleteItemOutputWithDefaults() *DeleteItemOutput {
	this := DeleteItemOutput{}
	return &this
}

// GetDeletionDate returns the DeletionDate field value if set, zero value otherwise.
func (o *DeleteItemOutput) GetDeletionDate() time.Time {
	if o == nil || o.DeletionDate == nil {
		var ret time.Time
		return ret
	}
	return *o.DeletionDate
}

// GetDeletionDateOk returns a tuple with the DeletionDate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItemOutput) GetDeletionDateOk() (*time.Time, bool) {
	if o == nil || o.DeletionDate == nil {
		return nil, false
	}
	return o.DeletionDate, true
}

// HasDeletionDate returns a boolean if a field has been set.
func (o *DeleteItemOutput) HasDeletionDate() bool {
	if o != nil && o.DeletionDate != nil {
		return true
	}

	return false
}

// SetDeletionDate gets a reference to the given time.Time and assigns it to the DeletionDate field.
func (o *DeleteItemOutput) SetDeletionDate(v time.Time) {
	o.DeletionDate = &v
}

// GetItemId returns the ItemId field value if set, zero value otherwise.
func (o *DeleteItemOutput) GetItemId() int64 {
	if o == nil || o.ItemId == nil {
		var ret int64
		return ret
	}
	return *o.ItemId
}

// GetItemIdOk returns a tuple with the ItemId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItemOutput) GetItemIdOk() (*int64, bool) {
	if o == nil || o.ItemId == nil {
		return nil, false
	}
	return o.ItemId, true
}

// HasItemId returns a boolean if a field has been set.
func (o *DeleteItemOutput) HasItemId() bool {
	if o != nil && o.ItemId != nil {
		return true
	}

	return false
}

// SetItemId gets a reference to the given int64 and assigns it to the ItemId field.
func (o *DeleteItemOutput) SetItemId(v int64) {
	o.ItemId = &v
}

// GetItemName returns the ItemName field value if set, zero value otherwise.
func (o *DeleteItemOutput) GetItemName() string {
	if o == nil || o.ItemName == nil {
		var ret string
		return ret
	}
	return *o.ItemName
}

// GetItemNameOk returns a tuple with the ItemName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItemOutput) GetItemNameOk() (*string, bool) {
	if o == nil || o.ItemName == nil {
		return nil, false
	}
	return o.ItemName, true
}

// HasItemName returns a boolean if a field has been set.
func (o *DeleteItemOutput) HasItemName() bool {
	if o != nil && o.ItemName != nil {
		return true
	}

	return false
}

// SetItemName gets a reference to the given string and assigns it to the ItemName field.
func (o *DeleteItemOutput) SetItemName(v string) {
	o.ItemName = &v
}

// GetVersionDeleted returns the VersionDeleted field value if set, zero value otherwise.
func (o *DeleteItemOutput) GetVersionDeleted() int32 {
	if o == nil || o.VersionDeleted == nil {
		var ret int32
		return ret
	}
	return *o.VersionDeleted
}

// GetVersionDeletedOk returns a tuple with the VersionDeleted field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteItemOutput) GetVersionDeletedOk() (*int32, bool) {
	if o == nil || o.VersionDeleted == nil {
		return nil, false
	}
	return o.VersionDeleted, true
}

// HasVersionDeleted returns a boolean if a field has been set.
func (o *DeleteItemOutput) HasVersionDeleted() bool {
	if o != nil && o.VersionDeleted != nil {
		return true
	}

	return false
}

// SetVersionDeleted gets a reference to the given int32 and assigns it to the VersionDeleted field.
func (o *DeleteItemOutput) SetVersionDeleted(v int32) {
	o.VersionDeleted = &v
}

func (o DeleteItemOutput) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DeletionDate != nil {
		toSerialize["deletion_date"] = o.DeletionDate
	}
	if o.ItemId != nil {
		toSerialize["item_id"] = o.ItemId
	}
	if o.ItemName != nil {
		toSerialize["item_name"] = o.ItemName
	}
	if o.VersionDeleted != nil {
		toSerialize["version_deleted"] = o.VersionDeleted
	}
	return json.Marshal(toSerialize)
}

type NullableDeleteItemOutput struct {
	value *DeleteItemOutput
	isSet bool
}

func (v NullableDeleteItemOutput) Get() *DeleteItemOutput {
	return v.value
}

func (v *NullableDeleteItemOutput) Set(val *DeleteItemOutput) {
	v.value = val
	v.isSet = true
}

func (v NullableDeleteItemOutput) IsSet() bool {
	return v.isSet
}

func (v *NullableDeleteItemOutput) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDeleteItemOutput(val *DeleteItemOutput) *NullableDeleteItemOutput {
	return &NullableDeleteItemOutput{value: val, isSet: true}
}

func (v NullableDeleteItemOutput) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDeleteItemOutput) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


