/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateLdapTarget createldapTarget is a command that creates a new target. [Deprecated: Use target-create-ldap command]
type CreateLdapTarget struct {
	// Bind DN
	BindDn string `json:"bind-dn"`
	// Bind DN Password
	BindDnPassword string `json:"bind-dn-password"`
	// Deprecated - use description
	Comment *string `json:"comment,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// CA Certificate File Content
	LdapCaCert *string `json:"ldap-ca-cert,omitempty"`
	// LDAP Server URL
	LdapUrl string `json:"ldap-url"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Set Ldap server type, Options:[OpenLDAP, ActiveDirectory]. Default is OpenLDAP
	ServerType *string `json:"server-type,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// Token expiration
	TokenExpiration *string `json:"token-expiration,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewCreateLdapTarget instantiates a new CreateLdapTarget object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateLdapTarget(bindDn string, bindDnPassword string, ldapUrl string, name string, ) *CreateLdapTarget {
	this := CreateLdapTarget{}
	this.BindDn = bindDn
	this.BindDnPassword = bindDnPassword
	var json bool = false
	this.Json = &json
	this.LdapUrl = ldapUrl
	this.Name = name
	var serverType string = "OpenLDAP"
	this.ServerType = &serverType
	return &this
}

// NewCreateLdapTargetWithDefaults instantiates a new CreateLdapTarget object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateLdapTargetWithDefaults() *CreateLdapTarget {
	this := CreateLdapTarget{}
	var json bool = false
	this.Json = &json
	var serverType string = "OpenLDAP"
	this.ServerType = &serverType
	return &this
}

// GetBindDn returns the BindDn field value
func (o *CreateLdapTarget) GetBindDn() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.BindDn
}

// GetBindDnOk returns a tuple with the BindDn field value
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetBindDnOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.BindDn, true
}

// SetBindDn sets field value
func (o *CreateLdapTarget) SetBindDn(v string) {
	o.BindDn = v
}

// GetBindDnPassword returns the BindDnPassword field value
func (o *CreateLdapTarget) GetBindDnPassword() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.BindDnPassword
}

// GetBindDnPasswordOk returns a tuple with the BindDnPassword field value
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetBindDnPasswordOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.BindDnPassword, true
}

// SetBindDnPassword sets field value
func (o *CreateLdapTarget) SetBindDnPassword(v string) {
	o.BindDnPassword = v
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetComment() string {
	if o == nil || o.Comment == nil {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetCommentOk() (*string, bool) {
	if o == nil || o.Comment == nil {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasComment() bool {
	if o != nil && o.Comment != nil {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *CreateLdapTarget) SetComment(v string) {
	o.Comment = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateLdapTarget) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateLdapTarget) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *CreateLdapTarget) SetKey(v string) {
	o.Key = &v
}

// GetLdapCaCert returns the LdapCaCert field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetLdapCaCert() string {
	if o == nil || o.LdapCaCert == nil {
		var ret string
		return ret
	}
	return *o.LdapCaCert
}

// GetLdapCaCertOk returns a tuple with the LdapCaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetLdapCaCertOk() (*string, bool) {
	if o == nil || o.LdapCaCert == nil {
		return nil, false
	}
	return o.LdapCaCert, true
}

// HasLdapCaCert returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasLdapCaCert() bool {
	if o != nil && o.LdapCaCert != nil {
		return true
	}

	return false
}

// SetLdapCaCert gets a reference to the given string and assigns it to the LdapCaCert field.
func (o *CreateLdapTarget) SetLdapCaCert(v string) {
	o.LdapCaCert = &v
}

// GetLdapUrl returns the LdapUrl field value
func (o *CreateLdapTarget) GetLdapUrl() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.LdapUrl
}

// GetLdapUrlOk returns a tuple with the LdapUrl field value
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetLdapUrlOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.LdapUrl, true
}

// SetLdapUrl sets field value
func (o *CreateLdapTarget) SetLdapUrl(v string) {
	o.LdapUrl = v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *CreateLdapTarget) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *CreateLdapTarget) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateLdapTarget) SetName(v string) {
	o.Name = v
}

// GetServerType returns the ServerType field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetServerType() string {
	if o == nil || o.ServerType == nil {
		var ret string
		return ret
	}
	return *o.ServerType
}

// GetServerTypeOk returns a tuple with the ServerType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetServerTypeOk() (*string, bool) {
	if o == nil || o.ServerType == nil {
		return nil, false
	}
	return o.ServerType, true
}

// HasServerType returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasServerType() bool {
	if o != nil && o.ServerType != nil {
		return true
	}

	return false
}

// SetServerType gets a reference to the given string and assigns it to the ServerType field.
func (o *CreateLdapTarget) SetServerType(v string) {
	o.ServerType = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateLdapTarget) SetToken(v string) {
	o.Token = &v
}

// GetTokenExpiration returns the TokenExpiration field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetTokenExpiration() string {
	if o == nil || o.TokenExpiration == nil {
		var ret string
		return ret
	}
	return *o.TokenExpiration
}

// GetTokenExpirationOk returns a tuple with the TokenExpiration field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetTokenExpirationOk() (*string, bool) {
	if o == nil || o.TokenExpiration == nil {
		return nil, false
	}
	return o.TokenExpiration, true
}

// HasTokenExpiration returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasTokenExpiration() bool {
	if o != nil && o.TokenExpiration != nil {
		return true
	}

	return false
}

// SetTokenExpiration gets a reference to the given string and assigns it to the TokenExpiration field.
func (o *CreateLdapTarget) SetTokenExpiration(v string) {
	o.TokenExpiration = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateLdapTarget) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateLdapTarget) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateLdapTarget) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateLdapTarget) SetUidToken(v string) {
	o.UidToken = &v
}

func (o CreateLdapTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["bind-dn"] = o.BindDn
	}
	if true {
		toSerialize["bind-dn-password"] = o.BindDnPassword
	}
	if o.Comment != nil {
		toSerialize["comment"] = o.Comment
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.LdapCaCert != nil {
		toSerialize["ldap-ca-cert"] = o.LdapCaCert
	}
	if true {
		toSerialize["ldap-url"] = o.LdapUrl
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ServerType != nil {
		toSerialize["server-type"] = o.ServerType
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.TokenExpiration != nil {
		toSerialize["token-expiration"] = o.TokenExpiration
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableCreateLdapTarget struct {
	value *CreateLdapTarget
	isSet bool
}

func (v NullableCreateLdapTarget) Get() *CreateLdapTarget {
	return v.value
}

func (v *NullableCreateLdapTarget) Set(val *CreateLdapTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateLdapTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateLdapTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateLdapTarget(val *CreateLdapTarget) *NullableCreateLdapTarget {
	return &NullableCreateLdapTarget{value: val, isSet: true}
}

func (v NullableCreateLdapTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateLdapTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


