/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.PrimitivesKt;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005<=>?@B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000bH\u0002J@\u0010\r\u001a\u00020\b*\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\b2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013H\u0002J$\u0010\u001d\u001a\u0004\u0018\u00010\b*\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u0004\u0018\u00010\u000bH\u0002J0\u0010 \u001a\u00020!*\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\bH\u0002J,\u0010%\u001a\u0004\u0018\u00010&*\u00020\u00142\u0006\u0010\u000f\u001a\u00020\t2\u0014\b\u0002\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020)0(H\u0002JD\u0010*\u001a\u00020!*\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u000f\u001a\u00020\t2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001400*\u0006\u0012\u0002\b\u00030,H\u0002J\u001a\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u00010,*\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u001a\u00102\u001a\u0004\u0018\u00010\u0019*\u0006\u0012\u0002\b\u00030,2\u0006\u00103\u001a\u000204H\u0002J\u0016\u00105\u001a\u0004\u0018\u00010\u001b*\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0016\u00105\u001a\u0004\u0018\u00010\u001b*\u0002062\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00107\u001a\u00020\u0011*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0018\u0010:\u001a\u00020\u0011*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00109\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker;", "", "<init>", "()V", "javaClassClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlinClassClassId", "isCompatible", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$Compatibility;", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "a", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "b", "getCompatibility", "", "ctx", "isConcreteType", "", "upperBounds", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "lowerBounds", "compatibilityUpperBound", "checkedTypeParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "computeLeafClassesOrInterfaces", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$FirClassWithSuperClasses;", "upperBoundClasses", "areClassesOrInterfacesCompatible", "classesOrInterfaces", "collectLowerBounds", "collectTypeArgumentMapping", "", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$BoundTypeArguments;", "coneType", "toTypeArgumentMapping", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$TypeArgumentMapping;", "envMapping", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$BoundTypeArgument;", "collect", "typeParameterOwner", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "parameter", "boundTypeArgument", "getSuperTypes", "", "getClassLikeElement", "getTypeParameter", "index", "", "toFirClassWithSuperClasses", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "prohibitComparisonOfIncompatibleEnums", "getProhibitComparisonOfIncompatibleEnums", "(Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;)Z", "prohibitComparisonOfIncompatibleClasses", "getProhibitComparisonOfIncompatibleClasses", "Compatibility", "TypeArgumentMapping", "BoundTypeArgument", "BoundTypeArguments", "FirClassWithSuperClasses", "checkers"})
@SourceDebugExtension(value={"SMAP\nConeTypeCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeCompatibilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,465:1\n1#2:466\n1#2:492\n1#2:550\n1734#3,3:467\n1734#3,3:470\n1368#3:473\n1454#3,5:474\n1734#3,3:479\n1611#3,9:482\n1863#3:491\n1864#3:493\n1620#3:494\n1755#3,3:495\n1734#3,2:498\n1734#3,3:500\n1736#3:503\n1293#3,4:504\n774#3:515\n865#3,2:516\n1755#3,3:518\n295#3,2:521\n1368#3:523\n1454#3,5:524\n1368#3:529\n1454#3,5:530\n1611#3,9:539\n1863#3:548\n1864#3:551\n1620#3:552\n503#4,7:508\n13474#5,3:535\n26#6:538\n26#6:549\n*S KotlinDebug\n*F\n+ 1 ConeTypeCompatibilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker\n*L\n126#1:492\n364#1:550\n89#1:467,3\n93#1:470,3\n100#1:473\n100#1:474,5\n107#1:479,3\n126#1:482,9\n126#1:491\n126#1:493\n126#1:494\n138#1:495,3\n144#1:498,2\n147#1:500,3\n144#1:503\n189#1:504,4\n218#1:515\n218#1:516,2\n221#1:518,3\n227#1:521,2\n250#1:523\n250#1:524,5\n252#1:529\n252#1:530,5\n364#1:539,9\n364#1:548\n364#1:551\n364#1:552\n205#1:508,7\n300#1:535,3\n363#1:538\n364#1:549\n*E\n"})
public final class ConeTypeCompatibilityChecker {
    @NotNull
    public static final ConeTypeCompatibilityChecker INSTANCE = new ConeTypeCompatibilityChecker();
    @NotNull
    private static final ClassId javaClassClassId = ClassId.Companion.fromString$default(ClassId.Companion, "java/lang/Class", false, 2, null);
    @NotNull
    private static final ClassId kotlinClassClassId = ClassId.Companion.fromString$default(ClassId.Companion, "kotlin/reflect/KClass", false, 2, null);

    private ConeTypeCompatibilityChecker() {
    }

    @NotNull
    public final Compatibility isCompatible(@NotNull ConeInferenceContext $this$isCompatible, @NotNull ConeKotlinType a, @NotNull ConeKotlinType b) {
        Compatibility compatibility;
        Intrinsics.checkNotNullParameter((Object)$this$isCompatible, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (ConeBuiltinTypeUtilsKt.isNothing(a) || ConeBuiltinTypeUtilsKt.isNothing(b)) {
            return Compatibility.COMPATIBLE;
        }
        if (a instanceof ConeIntersectionType) {
            Iterator iterator2 = ((Iterable)((ConeIntersectionType)a).getIntersectedTypes()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Object it = (ConeKotlinType)iterator2.next();
            boolean bl = false;
            it = INSTANCE.isCompatible($this$isCompatible, (ConeKotlinType)it, b);
            while (iterator2.hasNext()) {
                Object it2 = (ConeKotlinType)iterator2.next();
                $i$a$-minOf-ConeTypeCompatibilityChecker$isCompatible$1 = false;
                if (it.compareTo(it2 = (Comparable)INSTANCE.isCompatible($this$isCompatible, (ConeKotlinType)it2, b)) <= 0) continue;
                it = it2;
            }
            return (Compatibility)it;
        }
        if (b instanceof ConeIntersectionType) {
            Iterator iterator3 = ((Iterable)((ConeIntersectionType)b).getIntersectedTypes()).iterator();
            if (!iterator3.hasNext()) {
                throw new NoSuchElementException();
            }
            ConeKotlinType it = (ConeKotlinType)iterator3.next();
            boolean bl = false;
            Comparable comparable = INSTANCE.isCompatible($this$isCompatible, a, it);
            while (iterator3.hasNext()) {
                ConeKotlinType it3 = (ConeKotlinType)iterator3.next();
                $i$a$-minOf-ConeTypeCompatibilityChecker$isCompatible$2 = false;
                Comparable comparable2 = INSTANCE.isCompatible($this$isCompatible, a, it3);
                if (comparable.compareTo(comparable2) <= 0) continue;
                comparable = comparable2;
            }
            return (Compatibility)comparable;
        }
        Object[] objectArray = new ConeKotlinType[]{a, b};
        ConeKotlinType intersectionType = org.jetbrains.kotlin.fir.types.TypeUtilsKt.intersectTypesOrNull($this$isCompatible, CollectionsKt.listOf((Object[])objectArray));
        if (intersectionType instanceof ConeIntersectionType) {
            compatibility = this.getCompatibility(((ConeIntersectionType)intersectionType).getIntersectedTypes(), $this$isCompatible);
        } else {
            ConeKotlinType coneKotlinType = intersectionType;
            compatibility = (coneKotlinType != null ? ConeBuiltinTypeUtilsKt.isNothing(coneKotlinType) : false) ? Compatibility.HARD_INCOMPATIBLE : Compatibility.COMPATIBLE;
        }
        return compatibility;
    }

    /*
     * WARNING - void declaration
     */
    private final Compatibility getCompatibility(Collection<? extends ConeKotlinType> $this$getCompatibility, ConeInferenceContext ctx) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        boolean bl;
        Iterable $this$all$iv;
        Object element$iv2;
        block9: {
            boolean bl2;
            block8: {
                Iterable $this$all$iv2 = $this$getCompatibility;
                boolean $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        ConeKotlinType it = (ConeKotlinType)element$iv2;
                        boolean bl3 = false;
                        ConeInferenceContext $this$getCompatibility_u24lambda_u243_u24lambda_u242 = ctx;
                        boolean bl4 = false;
                        if ($this$getCompatibility_u24lambda_u243_u24lambda_u242.isNullableType(it)) continue;
                        bl2 = false;
                        break block8;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return Compatibility.COMPATIBLE;
            }
            $this$all$iv = $this$getCompatibility;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv3 : $this$all$iv) {
                    ConeKotlinType it = (ConeKotlinType)element$iv3;
                    boolean bl5 = false;
                    if (INSTANCE.isConcreteType(it)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        Compatibility compatibilityUpperBound = bl ? Compatibility.HARD_INCOMPATIBLE : Compatibility.SOFT_INCOMPATIBLE;
        $this$all$iv = $this$getCompatibility;
        ConeInferenceContext coneInferenceContext = ctx;
        ConeTypeCompatibilityChecker coneTypeCompatibilityChecker = this;
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ConeKotlinType it = (ConeKotlinType)element$iv$iv;
            boolean bl6 = false;
            Iterable list$iv$iv = TypeUtilsKt.collectUpperBounds(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return ConeTypeCompatibilityChecker.getCompatibility$default(coneTypeCompatibilityChecker, coneInferenceContext, CollectionsKt.toSet((Iterable)list), SetsKt.emptySet(), compatibilityUpperBound, null, 8, null);
    }

    private final boolean isConcreteType(ConeKotlinType $this$isConcreteType) {
        boolean bl;
        block9: {
            ConeKotlinType coneKotlinType = $this$isConcreteType;
            if (coneKotlinType instanceof ConeClassLikeType) {
                bl = true;
            } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                bl = this.isConcreteType(((ConeDefinitelyNotNullType)$this$isConcreteType).getOriginal());
            } else if (coneKotlinType instanceof ConeIntersectionType) {
                Iterable $this$all$iv = ((ConeIntersectionType)$this$isConcreteType).getIntersectedTypes();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl2 = false;
                        if (INSTANCE.isConcreteType(it)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final Compatibility getCompatibility(ConeInferenceContext $this$getCompatibility, Set<? extends ConeClassLikeType> upperBounds, Set<? extends ConeClassLikeType> lowerBounds, Compatibility compatibilityUpperBound, Set<FirTypeParameterSymbol> checkedTypeParameters) {
        Map $i$f$all22;
        boolean bl;
        block21: {
            boolean bl2;
            Set upperBoundClasses;
            block19: {
                Iterator $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = upperBounds;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean bl3 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirClassWithSuperClasses it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl32 = false;
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl4 = false;
                    if (INSTANCE.toFirClassWithSuperClasses(it, $this$getCompatibility) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                upperBoundClasses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (lowerBounds.isEmpty() && (upperBounds.size() < 2 || this.areClassesOrInterfacesCompatible($this$getCompatibility, upperBoundClasses, compatibilityUpperBound) == Compatibility.COMPATIBLE)) {
                    return Compatibility.COMPATIBLE;
                }
                Iterable $this$any$iv = upperBounds;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeClassLikeType it = (ConeClassLikeType)element$iv;
                        boolean bl6 = false;
                        if (!(Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(it), (Object)javaClassClassId) || Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(it), (Object)kotlinClassClassId))) continue;
                        bl2 = true;
                        break block19;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return Compatibility.COMPATIBLE;
            }
            Set<FirClassWithSuperClasses> leafClassesOrInterfaces = this.computeLeafClassesOrInterfaces(upperBoundClasses);
            Compatibility $i$f$any = this.areClassesOrInterfacesCompatible($this$getCompatibility, (Collection<FirClassWithSuperClasses>)leafClassesOrInterfaces, compatibilityUpperBound);
            if ($i$f$any != null) {
                Compatibility it = $i$f$any;
                boolean bl7 = false;
                return it;
            }
            Iterable $this$all$iv = lowerBounds;
            boolean $i$f$all22 = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl4;
                    block20: {
                        ConeClassLikeType lowerBoundType = (ConeClassLikeType)element$iv;
                        boolean bl5 = false;
                        Object object = INSTANCE.toFirClassWithSuperClasses(lowerBoundType, $this$getCompatibility);
                        if (object == null || (object = ((FirClassWithSuperClasses)object).getThisAndAllSuperClasses()) == null) {
                            object = SetsKt.emptySet();
                        }
                        Object classesSatisfyingLowerBounds = object;
                        Iterable $this$all$iv2 = leafClassesOrInterfaces;
                        boolean $i$f$all3 = false;
                        if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                            bl4 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv2) {
                                FirClassWithSuperClasses it = (FirClassWithSuperClasses)element$iv2;
                                boolean bl10 = false;
                                if (classesSatisfyingLowerBounds.contains(it)) continue;
                                bl4 = false;
                                break block20;
                            }
                            bl4 = true;
                        }
                    }
                    if (bl4) continue;
                    bl = false;
                    break block21;
                }
                bl = true;
            }
        }
        if (!bl) {
            return compatibilityUpperBound;
        }
        if (upperBounds.size() < 2) {
            return Compatibility.COMPATIBLE;
        }
        Map $this$getCompatibility_u24lambda_u2412 = $i$f$all22 = (Map)new LinkedHashMap();
        boolean bl11 = false;
        for (ConeClassLikeType coneClassLikeType : upperBounds) {
            INSTANCE.collectTypeArgumentMapping($this$getCompatibility_u24lambda_u2412, coneClassLikeType, $this$getCompatibility, compatibilityUpperBound);
        }
        Map typeArgumentMapping = $i$f$all22;
        Compatibility result2 = Compatibility.COMPATIBLE;
        Sequence typeArgsCompatibility = SequencesKt.map((Sequence)MapsKt.asSequence((Map)typeArgumentMapping), arg_0 -> ConeTypeCompatibilityChecker.getCompatibility$lambda$13(checkedTypeParameters, $this$getCompatibility, arg_0));
        for (Compatibility compatibility : typeArgsCompatibility) {
            if (compatibility == compatibilityUpperBound) {
                return compatibility;
            }
            if (compatibility.compareTo((Enum)result2) <= 0) continue;
            result2 = compatibility;
        }
        return result2;
    }

    static /* synthetic */ Compatibility getCompatibility$default(ConeTypeCompatibilityChecker coneTypeCompatibilityChecker, ConeInferenceContext coneInferenceContext, Set set, Set set2, Compatibility compatibility, Set set3, int n, Object object) {
        if ((n & 8) != 0) {
            set3 = new LinkedHashSet();
        }
        return coneTypeCompatibilityChecker.getCompatibility(coneInferenceContext, set, set2, compatibility, set3);
    }

    private final Set<FirClassWithSuperClasses> computeLeafClassesOrInterfaces(Set<FirClassWithSuperClasses> upperBoundClasses) {
        Map isLeaf = new LinkedHashMap();
        Iterable $this$associateWithTo$iv = upperBoundClasses;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            FirClassWithSuperClasses firClassWithSuperClasses = (FirClassWithSuperClasses)element$iv;
            Object t = element$iv;
            Map map = isLeaf;
            boolean bl = false;
            Boolean bl2 = true;
            map.put(t, bl2);
        }
        ArrayDeque queue = new ArrayDeque((Collection)upperBoundClasses);
        while (!((Collection)queue).isEmpty()) {
            for (FirClassWithSuperClasses superClass : ((FirClassWithSuperClasses)queue.removeFirst()).getSuperClasses()) {
                Object element$iv;
                element$iv = (Boolean)isLeaf.get(superClass);
                if (Intrinsics.areEqual(element$iv, (Object)true)) {
                    isLeaf.put(superClass, false);
                    continue;
                }
                if (Intrinsics.areEqual(element$iv, (Object)false)) continue;
                isLeaf.put(superClass, false);
                queue.addLast((Object)superClass);
            }
        }
        Map $this$filterValues$iv = isLeaf;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            boolean it = (Boolean)entry.getValue();
            boolean bl = false;
            if (!it) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        return ((Map)result$iv).keySet();
    }

    private final Compatibility areClassesOrInterfacesCompatible(ConeInferenceContext $this$areClassesOrInterfacesCompatible, Collection<FirClassWithSuperClasses> classesOrInterfaces, Compatibility compatibilityUpperBound) {
        Object v1;
        List classes;
        block9: {
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv = classesOrInterfaces;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                FirClassWithSuperClasses it = (FirClassWithSuperClasses)element$iv$iv;
                boolean bl = false;
                if (!(!it.isInterface())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            classes = (List)destination$iv$iv;
            if (classes.size() >= 2) {
                boolean bl;
                block8: {
                    Iterable $this$any$iv = classes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirClassWithSuperClasses it = (FirClassWithSuperClasses)element$iv;
                            boolean bl2 = false;
                            if (!it.getHasPredefinedEqualityContract($this$areClassesOrInterfacesCompatible)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                return bl ? compatibilityUpperBound : Compatibility.SOFT_INCOMPATIBLE;
            }
            Iterable $this$firstOrNull$iv = classes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirClassWithSuperClasses it = (FirClassWithSuperClasses)element$iv;
                boolean bl = false;
                if (!it.isFinal()) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        FirClassWithSuperClasses firClassWithSuperClasses = v1;
        if (firClassWithSuperClasses == null) {
            return null;
        }
        FirClassWithSuperClasses finalClass = firClassWithSuperClasses;
        if (classesOrInterfaces.size() > classes.size()) {
            return finalClass.getHasPredefinedEqualityContract($this$areClassesOrInterfacesCompatible) ? compatibilityUpperBound : Compatibility.SOFT_INCOMPATIBLE;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Set<ConeClassLikeType> collectLowerBounds(ConeKotlinType $this$collectLowerBounds) {
        Set set;
        if ($this$collectLowerBounds == null) {
            return SetsKt.emptySet();
        }
        ConeKotlinType coneKotlinType = $this$collectLowerBounds;
        if (coneKotlinType instanceof ConeErrorType) {
            set = SetsKt.emptySet();
            return set;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            ConeLookupTagBasedType coneLookupTagBasedType = (ConeLookupTagBasedType)$this$collectLowerBounds;
            if (coneLookupTagBasedType instanceof ConeClassLikeType) {
                set = SetsKt.setOf((Object)$this$collectLowerBounds);
                return set;
            } else {
                if (!(coneLookupTagBasedType instanceof ConeTypeParameterType)) throw new IllegalStateException(("missing branch for " + $this$collectLowerBounds.getClass().getName()).toString());
                set = SetsKt.emptySet();
            }
            return set;
        } else if (coneKotlinType instanceof ConeTypeVariableType) {
            set = SetsKt.emptySet();
            return set;
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            set = this.collectLowerBounds(((ConeDefinitelyNotNullType)$this$collectLowerBounds).getOriginal());
            return set;
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((ConeIntersectionType)$this$collectLowerBounds).getIntersectedTypes();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.collectLowerBounds(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            return set;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            set = this.collectLowerBounds(((ConeFlexibleType)$this$collectLowerBounds).getLowerBound());
            return set;
        } else if (coneKotlinType instanceof ConeCapturedType) {
            Set set2;
            List<ConeKotlinType> list = ((ConeCapturedType)$this$collectLowerBounds).getConstructor().getSupertypes();
            if (list != null) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = list;
                boolean $i$f$flatMap = false;
                Iterable $i$f$flatMapTo = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ConeKotlinType it = (ConeKotlinType)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = INSTANCE.collectLowerBounds(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            } else {
                set2 = set = null;
            }
            if (set2 != null) return set;
            set = SetsKt.emptySet();
            return set;
        } else if (coneKotlinType instanceof ConeIntegerConstantOperatorType) {
            set = SetsKt.setOf((Object)ConeIntegerLiteralType.getApproximatedType$default((ConeIntegerLiteralType)$this$collectLowerBounds, null, 1, null));
            return set;
        } else {
            if (!(coneKotlinType instanceof ConeStubType) && !(coneKotlinType instanceof ConeIntegerLiteralConstantType)) throw new NoWhenBranchMatchedException();
            throw new IllegalStateException(($this$collectLowerBounds + " should not reach here").toString());
        }
    }

    private final void collectTypeArgumentMapping(Map<FirTypeParameterSymbol, BoundTypeArguments> $this$collectTypeArgumentMapping, ConeClassLikeType coneType, ConeInferenceContext ctx, Compatibility compatibilityUpperBound) {
        ArrayDeque queue = new ArrayDeque();
        TypeArgumentMapping typeArgumentMapping = ConeTypeCompatibilityChecker.toTypeArgumentMapping$default(this, coneType, ctx, null, 2, null);
        if (typeArgumentMapping == null) {
            return;
        }
        queue.addLast((Object)typeArgumentMapping);
        while (!((Collection)queue).isEmpty()) {
            TypeArgumentMapping typeArgumentMapping2 = (TypeArgumentMapping)queue.removeFirst();
            FirClassLikeSymbol<?> typeParameterOwner = typeArgumentMapping2.component1();
            Map<FirTypeParameterSymbol, BoundTypeArgument> mapping = typeArgumentMapping2.component2();
            List<ConeClassLikeType> superTypes = this.getSuperTypes(typeParameterOwner);
            for (ConeClassLikeType coneClassLikeType : superTypes) {
                TypeArgumentMapping typeArgumentMapping3 = this.toTypeArgumentMapping(coneClassLikeType, ctx, mapping);
                if (typeArgumentMapping3 == null) continue;
                queue.addLast((Object)typeArgumentMapping3);
            }
            for (Map.Entry entry : mapping.entrySet()) {
                FirTypeParameterSymbol firTypeParameterRef = (FirTypeParameterSymbol)entry.getKey();
                BoundTypeArgument boundTypeArgument = (BoundTypeArgument)entry.getValue();
                this.collect($this$collectTypeArgumentMapping, ctx, typeParameterOwner, firTypeParameterRef, boundTypeArgument, compatibilityUpperBound);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TypeArgumentMapping toTypeArgumentMapping(ConeClassLikeType $this$toTypeArgumentMapping, ConeInferenceContext ctx, Map<FirTypeParameterSymbol, BoundTypeArgument> envMapping) {
        Map map;
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getClassLikeElement($this$toTypeArgumentMapping, ctx);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> typeParameterOwner = firClassLikeSymbol;
        Map $this$toTypeArgumentMapping_u24lambda_u2422 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        ConeTypeProjection[] $this$forEachIndexed$iv = $this$toTypeArgumentMapping.getTypeArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (ConeTypeProjection item$iv : $this$forEachIndexed$iv) {
            FirTypeParameterSymbol envTypeParameter;
            BoundTypeArgument envTypeArgument;
            FirTypeParameterSymbol typeParameter;
            BoundTypeArgument boundTypeArgument;
            void coneTypeProjection;
            void var19_18;
            int n = index$iv++;
            ConeTypeProjection coneTypeProjection2 = item$iv;
            int index = n;
            boolean bl2 = false;
            if (INSTANCE.getTypeParameter(typeParameterOwner, index) == null || Intrinsics.areEqual((Object)(var19_18 = coneTypeProjection), (Object)ConeStarProjection.INSTANCE)) continue;
            if (var19_18 instanceof ConeKotlinTypeProjectionIn) {
                boundTypeArgument = new BoundTypeArgument(((ConeKotlinTypeProjectionIn)coneTypeProjection).getType(), Variance.IN_VARIANCE);
            } else if (var19_18 instanceof ConeKotlinTypeProjectionOut) {
                boundTypeArgument = new BoundTypeArgument(((ConeKotlinTypeProjectionOut)coneTypeProjection).getType(), Variance.OUT_VARIANCE);
            } else if (var19_18 instanceof ConeKotlinTypeConflictingProjection) {
                boundTypeArgument = new BoundTypeArgument(((ConeKotlinTypeConflictingProjection)coneTypeProjection).getType(), Variance.INVARIANT);
            } else if (var19_18 instanceof ConeKotlinType) {
                switch (WhenMappings.$EnumSwitchMapping$0[typeParameter.getVariance().ordinal()]) {
                    case 1: {
                        boundTypeArgument = new BoundTypeArgument(((ConeKotlinType)coneTypeProjection).getType(), Variance.IN_VARIANCE);
                        break;
                    }
                    case 2: {
                        boundTypeArgument = new BoundTypeArgument(((ConeKotlinType)coneTypeProjection).getType(), Variance.OUT_VARIANCE);
                        break;
                    }
                    default: {
                        boundTypeArgument = new BoundTypeArgument(((ConeKotlinType)coneTypeProjection).getType(), Variance.INVARIANT);
                        break;
                    }
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            BoundTypeArgument boundTypeArgument2 = boundTypeArgument;
            ConeKotlinType coneKotlinType = boundTypeArgument2.getType();
            if (coneKotlinType instanceof ConeTypeParameterType && (envTypeArgument = envMapping.get(envTypeParameter = ((ConeTypeParameterType)coneKotlinType).getLookupTag().getTypeParameterSymbol())) != null) {
                boundTypeArgument2 = envTypeArgument;
            }
            $this$toTypeArgumentMapping_u24lambda_u2422.put(typeParameter, boundTypeArgument2);
        }
        Map mapping = MapsKt.build((Map)map);
        return new TypeArgumentMapping(typeParameterOwner, mapping);
    }

    static /* synthetic */ TypeArgumentMapping toTypeArgumentMapping$default(ConeTypeCompatibilityChecker coneTypeCompatibilityChecker, ConeClassLikeType coneClassLikeType, ConeInferenceContext coneInferenceContext, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return coneTypeCompatibilityChecker.toTypeArgumentMapping(coneClassLikeType, coneInferenceContext, map);
    }

    private final void collect(Map<FirTypeParameterSymbol, BoundTypeArguments> $this$collect, ConeInferenceContext ctx, FirClassLikeSymbol<?> typeParameterOwner, FirTypeParameterSymbol parameter, BoundTypeArgument boundTypeArgument, Compatibility compatibilityUpperBound) {
        BoundTypeArguments it = $this$collect.computeIfAbsent(parameter, arg_0 -> ConeTypeCompatibilityChecker.collect$lambda$24(arg_0 -> ConeTypeCompatibilityChecker.collect$lambda$23(ctx, typeParameterOwner, compatibilityUpperBound, arg_0), arg_0));
        boolean bl = false;
        ConeKotlinType type2 = boundTypeArgument.getType();
        if (boundTypeArgument.getVariance().getAllowsInPosition()) {
            CollectionsKt.addAll((Collection)it.getLower(), (Iterable)INSTANCE.collectLowerBounds(type2));
        }
        if (boundTypeArgument.getVariance().getAllowsOutPosition()) {
            CollectionsKt.addAll((Collection)it.getUpper(), (Iterable)TypeUtilsKt.collectUpperBounds(type2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConeClassLikeType> getSuperTypes(FirClassLikeSymbol<?> $this$getSuperTypes) {
        List list;
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$getSuperTypes;
        if (firClassLikeSymbol instanceof FirTypeAliasSymbol) {
            FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAliasSymbol)$this$getSuperTypes).getResolvedExpandedTypeRef();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            list = CollectionsKt.listOfNotNull((Object)((ConeClassLikeType)coneKotlinType));
        } else if (firClassLikeSymbol instanceof FirClassSymbol) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ((FirClassSymbol)$this$getSuperTypes).getResolvedSuperTypeRefs();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConeClassLikeType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                boolean bl2 = false;
                FirTypeRef $this$coneTypeSafe$iv = it;
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final FirClassLikeSymbol<?> getClassLikeElement(ConeClassLikeType $this$getClassLikeElement, ConeInferenceContext ctx) {
        return LookupTagUtilsKt.getSymbolByLookupTag(ctx.getSymbolProvider(), $this$getClassLikeElement.getLookupTag());
    }

    private final FirTypeParameterSymbol getTypeParameter(FirClassLikeSymbol<?> $this$getTypeParameter, int index) {
        FirTypeParameterSymbol firTypeParameterSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$getTypeParameter;
        if (firClassLikeSymbol instanceof FirTypeAliasSymbol) {
            firTypeParameterSymbol = ((FirTypeAliasSymbol)$this$getTypeParameter).getTypeParameterSymbols().get(index);
        } else if (firClassLikeSymbol instanceof FirClassSymbol) {
            firTypeParameterSymbol = ((FirClassSymbol)$this$getTypeParameter).getTypeParameterSymbols().get(index);
        } else {
            return null;
        }
        return firTypeParameterSymbol;
    }

    private final FirClassWithSuperClasses toFirClassWithSuperClasses(ConeClassLikeType $this$toFirClassWithSuperClasses, ConeInferenceContext ctx) {
        return this.toFirClassWithSuperClasses($this$toFirClassWithSuperClasses.getLookupTag(), ctx);
    }

    private final FirClassWithSuperClasses toFirClassWithSuperClasses(ConeClassLikeLookupTag $this$toFirClassWithSuperClasses, ConeInferenceContext ctx) {
        FirClassWithSuperClasses firClassWithSuperClasses;
        FirClassLikeSymbol<?> klass = LookupTagUtilsKt.getSymbolByLookupTag(ctx.getSymbolProvider(), $this$toFirClassWithSuperClasses);
        if (klass instanceof FirTypeAliasSymbol) {
            FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(klass, ctx.getSession());
            if (firRegularClassSymbol != null) {
                FirRegularClassSymbol it = firRegularClassSymbol;
                boolean bl = false;
                firClassWithSuperClasses = new FirClassWithSuperClasses(it, ctx);
            } else {
                firClassWithSuperClasses = null;
            }
        } else {
            firClassWithSuperClasses = klass instanceof FirClassSymbol ? new FirClassWithSuperClasses((FirClassSymbol)klass, ctx) : null;
        }
        return firClassWithSuperClasses;
    }

    private final boolean getProhibitComparisonOfIncompatibleEnums(ConeInferenceContext $this$prohibitComparisonOfIncompatibleEnums) {
        return FirLanguageSettingsComponentKt.getLanguageVersionSettings($this$prohibitComparisonOfIncompatibleEnums.getSession()).supportsFeature(LanguageFeature.ProhibitComparisonOfIncompatibleEnums);
    }

    private final boolean getProhibitComparisonOfIncompatibleClasses(ConeInferenceContext $this$prohibitComparisonOfIncompatibleClasses) {
        return FirLanguageSettingsComponentKt.getLanguageVersionSettings($this$prohibitComparisonOfIncompatibleClasses.getSession()).supportsFeature(LanguageFeature.ProhibitComparisonOfIncompatibleClasses);
    }

    private static final Compatibility getCompatibility$lambda$13(Set $checkedTypeParameters, ConeInferenceContext $this_getCompatibility, Map.Entry entry) {
        Compatibility compatibility;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        FirTypeParameterSymbol paramRef = (FirTypeParameterSymbol)entry.getKey();
        BoundTypeArguments boundTypeArguments = (BoundTypeArguments)entry.getValue();
        Set<ConeClassLikeType> upper = boundTypeArguments.component1();
        Set<ConeClassLikeType> lower2 = boundTypeArguments.component2();
        Compatibility compatibility2 = boundTypeArguments.component3();
        if ($checkedTypeParameters.contains(paramRef)) {
            compatibility = Compatibility.COMPATIBLE;
        } else {
            $checkedTypeParameters.add(paramRef);
            compatibility = INSTANCE.getCompatibility($this_getCompatibility, upper, lower2, compatibility2, $checkedTypeParameters);
        }
        return compatibility;
    }

    private static final BoundTypeArguments collect$lambda$23(ConeInferenceContext $ctx, FirClassLikeSymbol $typeParameterOwner, Compatibility $compatibilityUpperBound, FirTypeParameterSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Compatibility compatibilityUpperBoundForTypeArg = INSTANCE.getProhibitComparisonOfIncompatibleEnums($ctx) && Intrinsics.areEqual((Object)$typeParameterOwner.getClassId(), (Object)StandardClassIds.INSTANCE.getEnum()) || INSTANCE.getProhibitComparisonOfIncompatibleClasses($ctx) && Intrinsics.areEqual((Object)$typeParameterOwner.getClassId(), (Object)StandardClassIds.INSTANCE.getKClass()) ? $compatibilityUpperBound : Compatibility.SOFT_INCOMPATIBLE;
        return new BoundTypeArguments(new LinkedHashSet(), new LinkedHashSet(), compatibilityUpperBoundForTypeArg);
    }

    private static final BoundTypeArguments collect$lambda$24(Function1 $tmp0, Object p0) {
        return (BoundTypeArguments)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$BoundTypeArgument;", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/types/Variance;)V", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getVariance", "()Lorg/jetbrains/kotlin/types/Variance;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    private static final class BoundTypeArgument {
        @NotNull
        private final ConeKotlinType type;
        @NotNull
        private final Variance variance;

        public BoundTypeArgument(@NotNull ConeKotlinType type2, @NotNull Variance variance) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"variance");
            this.type = type2;
            this.variance = variance;
        }

        @NotNull
        public final ConeKotlinType getType() {
            return this.type;
        }

        @NotNull
        public final Variance getVariance() {
            return this.variance;
        }

        @NotNull
        public final ConeKotlinType component1() {
            return this.type;
        }

        @NotNull
        public final Variance component2() {
            return this.variance;
        }

        @NotNull
        public final BoundTypeArgument copy(@NotNull ConeKotlinType type2, @NotNull Variance variance) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"variance");
            return new BoundTypeArgument(type2, variance);
        }

        public static /* synthetic */ BoundTypeArgument copy$default(BoundTypeArgument boundTypeArgument, ConeKotlinType coneKotlinType, Variance variance, int n, Object object) {
            if ((n & 1) != 0) {
                coneKotlinType = boundTypeArgument.type;
            }
            if ((n & 2) != 0) {
                variance = boundTypeArgument.variance;
            }
            return boundTypeArgument.copy(coneKotlinType, variance);
        }

        @NotNull
        public String toString() {
            return "BoundTypeArgument(type=" + this.type + ", variance=" + (Object)((Object)this.variance) + ')';
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.variance.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BoundTypeArgument)) {
                return false;
            }
            BoundTypeArgument boundTypeArgument = (BoundTypeArgument)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)boundTypeArgument.type)) {
                return false;
            }
            return this.variance == boundTypeArgument.variance;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$BoundTypeArguments;", "", "upper", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "lower", "compatibilityUpperBound", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$Compatibility;", "<init>", "(Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$Compatibility;)V", "getUpper", "()Ljava/util/Set;", "getLower", "getCompatibilityUpperBound", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$Compatibility;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    private static final class BoundTypeArguments {
        @NotNull
        private final Set<ConeClassLikeType> upper;
        @NotNull
        private final Set<ConeClassLikeType> lower;
        @NotNull
        private final Compatibility compatibilityUpperBound;

        public BoundTypeArguments(@NotNull Set<ConeClassLikeType> upper, @NotNull Set<ConeClassLikeType> lower2, @NotNull Compatibility compatibilityUpperBound) {
            Intrinsics.checkNotNullParameter(upper, (String)"upper");
            Intrinsics.checkNotNullParameter(lower2, (String)"lower");
            Intrinsics.checkNotNullParameter((Object)compatibilityUpperBound, (String)"compatibilityUpperBound");
            this.upper = upper;
            this.lower = lower2;
            this.compatibilityUpperBound = compatibilityUpperBound;
        }

        @NotNull
        public final Set<ConeClassLikeType> getUpper() {
            return this.upper;
        }

        @NotNull
        public final Set<ConeClassLikeType> getLower() {
            return this.lower;
        }

        @NotNull
        public final Compatibility getCompatibilityUpperBound() {
            return this.compatibilityUpperBound;
        }

        @NotNull
        public final Set<ConeClassLikeType> component1() {
            return this.upper;
        }

        @NotNull
        public final Set<ConeClassLikeType> component2() {
            return this.lower;
        }

        @NotNull
        public final Compatibility component3() {
            return this.compatibilityUpperBound;
        }

        @NotNull
        public final BoundTypeArguments copy(@NotNull Set<ConeClassLikeType> upper, @NotNull Set<ConeClassLikeType> lower2, @NotNull Compatibility compatibilityUpperBound) {
            Intrinsics.checkNotNullParameter(upper, (String)"upper");
            Intrinsics.checkNotNullParameter(lower2, (String)"lower");
            Intrinsics.checkNotNullParameter((Object)compatibilityUpperBound, (String)"compatibilityUpperBound");
            return new BoundTypeArguments(upper, lower2, compatibilityUpperBound);
        }

        public static /* synthetic */ BoundTypeArguments copy$default(BoundTypeArguments boundTypeArguments, Set set, Set set2, Compatibility compatibility, int n, Object object) {
            if ((n & 1) != 0) {
                set = boundTypeArguments.upper;
            }
            if ((n & 2) != 0) {
                set2 = boundTypeArguments.lower;
            }
            if ((n & 4) != 0) {
                compatibility = boundTypeArguments.compatibilityUpperBound;
            }
            return boundTypeArguments.copy(set, set2, compatibility);
        }

        @NotNull
        public String toString() {
            return "BoundTypeArguments(upper=" + this.upper + ", lower=" + this.lower + ", compatibilityUpperBound=" + this.compatibilityUpperBound + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.upper).hashCode();
            result2 = result2 * 31 + ((Object)this.lower).hashCode();
            result2 = result2 * 31 + this.compatibilityUpperBound.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BoundTypeArguments)) {
                return false;
            }
            BoundTypeArguments boundTypeArguments = (BoundTypeArguments)other;
            if (!Intrinsics.areEqual(this.upper, boundTypeArguments.upper)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.lower, boundTypeArguments.lower)) {
                return false;
            }
            return this.compatibilityUpperBound == boundTypeArguments.compatibilityUpperBound;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$Compatibility;", "", "", "<init>", "(Ljava/lang/String;I)V", "COMPATIBLE", "SOFT_INCOMPATIBLE", "HARD_INCOMPATIBLE", "checkers"})
    public static final class Compatibility
    extends Enum<Compatibility>
    implements Comparable<Compatibility> {
        public static final /* enum */ Compatibility COMPATIBLE = new Compatibility();
        public static final /* enum */ Compatibility SOFT_INCOMPATIBLE = new Compatibility();
        public static final /* enum */ Compatibility HARD_INCOMPATIBLE = new Compatibility();
        private static final /* synthetic */ Compatibility[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Compatibility[] values() {
            return (Compatibility[])$VALUES.clone();
        }

        public static Compatibility valueOf(String value2) {
            return Enum.valueOf(Compatibility.class, value2);
        }

        @NotNull
        public static EnumEntries<Compatibility> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = compatibilityArray = new Compatibility[]{Compatibility.COMPATIBLE, Compatibility.SOFT_INCOMPATIBLE, Compatibility.HARD_INCOMPATIBLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005J\r\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J!\u0010\u001d\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u001c\u0010\u0018\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$FirClassWithSuperClasses;", "", "firClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "ctx", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;)V", "getFirClass", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getCtx", "()Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "isInterface", "", "()Z", "superClasses", "", "getSuperClasses", "()Ljava/util/Set;", "superClasses$delegate", "Lkotlin/Lazy;", "thisAndAllSuperClasses", "getThisAndAllSuperClasses", "thisAndAllSuperClasses$delegate", "isFinal", "getHasPredefinedEqualityContract", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "checkers"})
    @SourceDebugExtension(value={"SMAP\nConeTypeCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeCompatibilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$FirClassWithSuperClasses\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,465:1\n72#2:466\n75#2:468\n57#2:470\n51#2:471\n40#2:472\n34#3:467\n37#3:469\n1611#4,9:473\n1863#4:482\n1864#4:484\n1620#4:485\n855#4,2:486\n1#5:483\n*S KotlinDebug\n*F\n+ 1 ConeTypeCompatibilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$FirClassWithSuperClasses\n*L\n409#1:466\n442#1:468\n446#1:470\n446#1:471\n453#1:472\n409#1:467\n442#1:469\n412#1:473,9\n412#1:482\n412#1:484\n412#1:485\n423#1:486,2\n412#1:483\n*E\n"})
    private static final class FirClassWithSuperClasses {
        @NotNull
        private final FirClassSymbol<?> firClass;
        @NotNull
        private final ConeInferenceContext ctx;
        @NotNull
        private final Lazy superClasses$delegate;
        @NotNull
        private final Lazy thisAndAllSuperClasses$delegate;

        public FirClassWithSuperClasses(@NotNull FirClassSymbol<?> firClass, @NotNull ConeInferenceContext ctx) {
            Intrinsics.checkNotNullParameter(firClass, (String)"firClass");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.firClass = firClass;
            this.ctx = ctx;
            this.superClasses$delegate = LazyKt.lazy(() -> FirClassWithSuperClasses.superClasses_delegate$lambda$1(this));
            this.thisAndAllSuperClasses$delegate = LazyKt.lazy(() -> FirClassWithSuperClasses.thisAndAllSuperClasses_delegate$lambda$4(this));
        }

        @NotNull
        public final FirClassSymbol<?> getFirClass() {
            return this.firClass;
        }

        @NotNull
        public final ConeInferenceContext getCtx() {
            return this.ctx;
        }

        public final boolean isInterface() {
            FirClassSymbol<?> $this$isInterface$iv = this.firClass;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            return $this$isInterface$iv$iv == ClassKind.INTERFACE;
        }

        @NotNull
        public final Set<FirClassWithSuperClasses> getSuperClasses() {
            Lazy lazy = this.superClasses$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final Set<FirClassWithSuperClasses> getThisAndAllSuperClasses() {
            Lazy lazy = this.thisAndAllSuperClasses$delegate;
            return (Set)lazy.getValue();
        }

        public final boolean isFinal() {
            return this.isFinal(this.firClass);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean getHasPredefinedEqualityContract(@NotNull ConeInferenceContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (INSTANCE.getProhibitComparisonOfIncompatibleEnums(ctx)) {
                FirClassSymbol<?> $this$isEnumClass$iv = this.firClass;
                boolean $i$f$isEnumClass = false;
                ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                boolean $i$f$isEnumClass2 = false;
                if ($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS) {
                    return true;
                }
                boolean bl = false;
                if (bl) return true;
                if (Intrinsics.areEqual((Object)this.firClass.getClassId(), (Object)StandardClassIds.INSTANCE.getEnum())) return true;
            }
            if (PrimitivesKt.isPrimitiveType(this.firClass)) return true;
            if (INSTANCE.getProhibitComparisonOfIncompatibleClasses(ctx)) {
                if (Intrinsics.areEqual((Object)this.firClass.getClassId(), (Object)StandardClassIds.INSTANCE.getKClass())) return true;
            }
            if (Intrinsics.areEqual((Object)this.firClass.getClassId(), (Object)StandardClassIds.INSTANCE.getString())) return true;
            if (Intrinsics.areEqual((Object)this.firClass.getClassId(), (Object)StandardClassIds.INSTANCE.getUnit())) return true;
            if (!(this.firClass instanceof FirRegularClassSymbol)) return false;
            FirClassLikeSymbol $this$isData$iv = this.firClass;
            boolean $i$f$isData = false;
            if ($this$isData$iv.getRawStatus().isData()) return true;
            FirClassLikeSymbol $this$isInline$iv = this.firClass;
            boolean $i$f$isInline = false;
            if (!$this$isInline$iv.getRawStatus().isInline()) return false;
            return true;
        }

        private final boolean isFinal(FirClassSymbol<?> $this$isFinal) {
            boolean bl;
            FirClassSymbol<?> firClassSymbol = $this$isFinal;
            if (firClassSymbol instanceof FirAnonymousObjectSymbol) {
                bl = true;
            } else if (firClassSymbol instanceof FirRegularClassSymbol) {
                FirClassLikeSymbol $this$modality$iv = $this$isFinal;
                boolean $i$f$getModality = false;
                bl = $this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL;
            } else {
                throw new IllegalStateException(("unknown type of FirClass " + $this$isFinal).toString());
            }
            return bl;
        }

        @NotNull
        public final FirClassSymbol<?> component1() {
            return this.firClass;
        }

        @NotNull
        public final ConeInferenceContext component2() {
            return this.ctx;
        }

        @NotNull
        public final FirClassWithSuperClasses copy(@NotNull FirClassSymbol<?> firClass, @NotNull ConeInferenceContext ctx) {
            Intrinsics.checkNotNullParameter(firClass, (String)"firClass");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return new FirClassWithSuperClasses(firClass, ctx);
        }

        public static /* synthetic */ FirClassWithSuperClasses copy$default(FirClassWithSuperClasses firClassWithSuperClasses, FirClassSymbol firClassSymbol, ConeInferenceContext coneInferenceContext, int n, Object object) {
            if ((n & 1) != 0) {
                firClassSymbol = firClassWithSuperClasses.firClass;
            }
            if ((n & 2) != 0) {
                coneInferenceContext = firClassWithSuperClasses.ctx;
            }
            return firClassWithSuperClasses.copy(firClassSymbol, coneInferenceContext);
        }

        @NotNull
        public String toString() {
            return "FirClassWithSuperClasses(firClass=" + this.firClass + ", ctx=" + this.ctx + ')';
        }

        public int hashCode() {
            int result2 = this.firClass.hashCode();
            result2 = result2 * 31 + this.ctx.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FirClassWithSuperClasses)) {
                return false;
            }
            FirClassWithSuperClasses firClassWithSuperClasses = (FirClassWithSuperClasses)other;
            if (!Intrinsics.areEqual(this.firClass, firClassWithSuperClasses.firClass)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ctx, (Object)firClassWithSuperClasses.ctx);
        }

        /*
         * WARNING - void declaration
         */
        private static final Set superClasses_delegate$lambda$1(FirClassWithSuperClasses this$0) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this$0.firClass.getResolvedSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirClassWithSuperClasses it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ConeKotlinType it = (ConeKotlinType)element$iv$iv;
                boolean bl2 = false;
                Object object = it instanceof ConeClassLikeType ? (ConeClassLikeType)it : null;
                if ((object != null && (object = ((ConeClassLikeType)object).getLookupTag()) != null ? INSTANCE.toFirClassWithSuperClasses((ConeClassLikeLookupTag)object, this$0.ctx) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        private static final Set thisAndAllSuperClasses_delegate$lambda$4(FirClassWithSuperClasses this$0) {
            Set set;
            ArrayDeque queue = new ArrayDeque();
            queue.addLast((Object)this$0);
            Set $this$thisAndAllSuperClasses_delegate_u24lambda_u244_u24lambda_u243 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            $this$thisAndAllSuperClasses_delegate_u24lambda_u244_u24lambda_u243.add(this$0);
            while (!((Collection)queue).isEmpty()) {
                FirClassWithSuperClasses current = (FirClassWithSuperClasses)queue.removeFirst();
                Set<FirClassWithSuperClasses> superTypes = current.getSuperClasses();
                Iterable $this$filterNotTo$iv = superTypes;
                boolean $i$f$filterNotTo = false;
                for (Object element$iv : $this$filterNotTo$iv) {
                    FirClassWithSuperClasses it = (FirClassWithSuperClasses)element$iv;
                    boolean bl2 = false;
                    if ($this$thisAndAllSuperClasses_delegate_u24lambda_u244_u24lambda_u243.contains(it)) continue;
                    ((Collection)queue).add(element$iv);
                }
                Collection cfr_ignored_0 = (Collection)queue;
                $this$thisAndAllSuperClasses_delegate_u24lambda_u244_u24lambda_u243.addAll((Collection)superTypes);
            }
            return SetsKt.build((Set)set);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J-\u0010\u0010\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$TypeArgumentMapping;", "", "typeParameterOwner", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "mapping", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ConeTypeCompatibilityChecker$BoundTypeArgument;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Ljava/util/Map;)V", "getTypeParameterOwner", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getMapping", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers"})
    private static final class TypeArgumentMapping {
        @NotNull
        private final FirClassLikeSymbol<?> typeParameterOwner;
        @NotNull
        private final Map<FirTypeParameterSymbol, BoundTypeArgument> mapping;

        public TypeArgumentMapping(@NotNull FirClassLikeSymbol<?> typeParameterOwner, @NotNull Map<FirTypeParameterSymbol, BoundTypeArgument> mapping) {
            Intrinsics.checkNotNullParameter(typeParameterOwner, (String)"typeParameterOwner");
            Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
            this.typeParameterOwner = typeParameterOwner;
            this.mapping = mapping;
        }

        @NotNull
        public final FirClassLikeSymbol<?> getTypeParameterOwner() {
            return this.typeParameterOwner;
        }

        @NotNull
        public final Map<FirTypeParameterSymbol, BoundTypeArgument> getMapping() {
            return this.mapping;
        }

        @NotNull
        public final FirClassLikeSymbol<?> component1() {
            return this.typeParameterOwner;
        }

        @NotNull
        public final Map<FirTypeParameterSymbol, BoundTypeArgument> component2() {
            return this.mapping;
        }

        @NotNull
        public final TypeArgumentMapping copy(@NotNull FirClassLikeSymbol<?> typeParameterOwner, @NotNull Map<FirTypeParameterSymbol, BoundTypeArgument> mapping) {
            Intrinsics.checkNotNullParameter(typeParameterOwner, (String)"typeParameterOwner");
            Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
            return new TypeArgumentMapping(typeParameterOwner, mapping);
        }

        public static /* synthetic */ TypeArgumentMapping copy$default(TypeArgumentMapping typeArgumentMapping, FirClassLikeSymbol firClassLikeSymbol, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                firClassLikeSymbol = typeArgumentMapping.typeParameterOwner;
            }
            if ((n & 2) != 0) {
                map = typeArgumentMapping.mapping;
            }
            return typeArgumentMapping.copy(firClassLikeSymbol, map);
        }

        @NotNull
        public String toString() {
            return "TypeArgumentMapping(typeParameterOwner=" + this.typeParameterOwner + ", mapping=" + this.mapping + ')';
        }

        public int hashCode() {
            int result2 = this.typeParameterOwner.hashCode();
            result2 = result2 * 31 + ((Object)this.mapping).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeArgumentMapping)) {
                return false;
            }
            TypeArgumentMapping typeArgumentMapping = (TypeArgumentMapping)other;
            if (!Intrinsics.areEqual(this.typeParameterOwner, typeArgumentMapping.typeParameterOwner)) {
                return false;
            }
            return Intrinsics.areEqual(this.mapping, typeArgumentMapping.mapping);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

