/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectTopLevelDeclarations;
import org.jetbrains.kotlin.backend.common.actualizer.IrExtraActualDeclarationExtractor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J&\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\rH\u0002J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\tH\u0002J\"\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020\r2\b\b\u0002\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector;", "", "expectTopLevelDeclarations", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectTopLevelDeclarations;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectTopLevelDeclarations;)V", "actualClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "actualTypeAliasesWithoutExpansion", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeAliasSymbol;", "actualTopLevels", "Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbolsToFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitedActualClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "currentFile", "collect", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "collectExtraActualDeclarations", "extraActualDeclarationExtractor", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExtraActualDeclarationExtractor;", "collectExtraActualClasses", "expectClass", "collectExtraActualCallables", "expectTopLevelCallables", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "callableId", "recordMappingsForNestedClassesActualizedViaTypealias", "typealiasClassId", "actualClassSymbol", "recordActualCallable", "callableDeclaration", "writeActualSymbolToFile", "", "Companion", "ir.actualization"})
@SourceDebugExtension(value={"SMAP\nExpectActualCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,422:1\n1611#2,9:423\n1863#2:432\n1864#2:434\n1620#2:435\n1#3:433\n381#4,7:436\n678#5:443\n708#5,4:444\n*S KotlinDebug\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector\n*L\n215#1:423,9\n215#1:432\n215#1:434\n215#1:435\n215#1:433\n279#1:436,7\n259#1:443\n259#1:444,4\n*E\n"})
final class ActualDeclarationsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExpectTopLevelDeclarations expectTopLevelDeclarations;
    @NotNull
    private final Map<ClassId, IrClassSymbol> actualClasses;
    @NotNull
    private final Map<ClassId, IrTypeAliasSymbol> actualTypeAliasesWithoutExpansion;
    @NotNull
    private final Map<CallableId, List<IrSymbol>> actualTopLevels;
    @NotNull
    private final Map<IrSymbol, IrFile> actualSymbolsToFile;
    @NotNull
    private final Set<IrClass> visitedActualClasses;
    @Nullable
    private IrFile currentFile;

    public ActualDeclarationsCollector(@NotNull ExpectTopLevelDeclarations expectTopLevelDeclarations) {
        Intrinsics.checkNotNullParameter((Object)expectTopLevelDeclarations, (String)"expectTopLevelDeclarations");
        this.expectTopLevelDeclarations = expectTopLevelDeclarations;
        this.actualClasses = new LinkedHashMap();
        this.actualTypeAliasesWithoutExpansion = new LinkedHashMap();
        this.actualTopLevels = new LinkedHashMap();
        this.actualSymbolsToFile = new LinkedHashMap();
        this.visitedActualClasses = new LinkedHashSet();
    }

    private final void collect(IrElement element) {
        IrElement irElement = element;
        if (irElement instanceof IrModuleFragment) {
            for (IrFile file2 : ((IrModuleFragment)element).getFiles()) {
                this.collect(file2);
            }
        } else if (irElement instanceof IrFile) {
            this.currentFile = (IrFile)element;
            for (IrDeclaration declaration : ((IrFile)element).getDeclarations()) {
                this.collect(declaration);
            }
        } else if (irElement instanceof IrTypeAlias) {
            if (!((IrTypeAlias)element).isActual()) {
                return;
            }
            ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail((IrTypeAlias)element);
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(((IrTypeAlias)element).getExpandedType());
            Intrinsics.checkNotNull((Object)irClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
            IrClassSymbol expandedTypeSymbol = (IrClassSymbol)irClassifierSymbol;
            this.actualClasses.put(classId, expandedTypeSymbol);
            this.actualTypeAliasesWithoutExpansion.put(classId, ((IrTypeAlias)element).getSymbol());
            this.actualSymbolsToFile.put(expandedTypeSymbol, this.currentFile);
            this.actualSymbolsToFile.put(((IrTypeAlias)element).getSymbol(), this.currentFile);
            this.collect((IrElement)expandedTypeSymbol.getOwner());
            this.recordMappingsForNestedClassesActualizedViaTypealias(classId, expandedTypeSymbol);
        } else if (irElement instanceof IrClass) {
            if (((IrClass)element).isExpect() || !this.visitedActualClasses.add((IrClass)element)) {
                return;
            }
            this.actualClasses.put(AdditionalIrUtilsKt.getClassIdOrFail((IrClass)element), ((IrClass)element).getSymbol());
            this.actualSymbolsToFile.put(((IrClass)element).getSymbol(), this.currentFile);
            for (IrDeclaration declaration : ((IrClass)element).getDeclarations()) {
                this.collect(declaration);
            }
        } else if (irElement instanceof IrDeclarationContainer) {
            for (IrDeclaration declaration : ((IrDeclarationContainer)element).getDeclarations()) {
                this.collect(declaration);
            }
        } else if (irElement instanceof IrEnumEntry) {
            ActualDeclarationsCollector.recordActualCallable$default(this, (IrDeclarationWithName)element, AdditionalIrUtilsKt.getCallableId((IrEnumEntry)element), false, 4, null);
        } else if (irElement instanceof IrProperty) {
            if (((IrProperty)element).isExpect()) {
                return;
            }
            ActualDeclarationsCollector.recordActualCallable$default(this, (IrDeclarationWithName)element, AdditionalIrUtilsKt.getCallableId((IrProperty)element), false, 4, null);
        } else if (irElement instanceof IrFunction) {
            if (((IrFunction)element).isExpect()) {
                return;
            }
            ActualDeclarationsCollector.recordActualCallable$default(this, (IrDeclarationWithName)element, AdditionalIrUtilsKt.getCallableId((IrFunction)element), false, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectExtraActualDeclarations(IrExtraActualDeclarationExtractor extraActualDeclarationExtractor) {
        for (IrClassSymbol entry : this.expectTopLevelDeclarations.getClasses().values()) {
            this.collectExtraActualClasses(extraActualDeclarationExtractor, (IrClass)entry.getOwner());
        }
        for (Map.Entry entry : this.expectTopLevelDeclarations.getCallables().entrySet()) {
            void $this$mapNotNullTo$iv$iv;
            CallableId callableId = (CallableId)entry.getKey();
            List callableSymbols = (List)entry.getValue();
            Iterable $this$mapNotNull$iv = callableSymbols;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrSymbol it = (IrSymbol)element$iv$iv;
                boolean bl2 = false;
                IrSymbolOwner owner = it.getOwner();
                if ((owner instanceof IrProperty ? (IrElement)owner : (owner instanceof IrFunction ? (IrElement)owner : null)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List expectTopLevelCallables = (List)destination$iv$iv;
            this.collectExtraActualCallables(extraActualDeclarationExtractor, expectTopLevelCallables, callableId);
        }
    }

    private final void collectExtraActualClasses(IrExtraActualDeclarationExtractor extraActualDeclarationExtractor, IrClass expectClass) {
        IrClassSymbol irClassSymbol = extraActualDeclarationExtractor.extract(expectClass);
        if (irClassSymbol == null) {
            return;
        }
        IrClassSymbol actualClassSymbol = irClassSymbol;
        ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail(expectClass);
        if (this.actualClasses.containsKey(classId)) {
            return;
        }
        this.actualClasses.put(classId, actualClassSymbol);
        for (IrDeclaration declaration : expectClass.getDeclarations()) {
            if (!(declaration instanceof IrClass)) continue;
            this.collectExtraActualClasses(extraActualDeclarationExtractor, (IrClass)declaration);
        }
    }

    private final void collectExtraActualCallables(IrExtraActualDeclarationExtractor extraActualDeclarationExtractor, List<? extends IrDeclarationWithName> expectTopLevelCallables, CallableId callableId) {
        for (IrSymbol actualCallableSymbol : extraActualDeclarationExtractor.extract(expectTopLevelCallables, callableId)) {
            IrSymbolOwner irSymbolOwner = actualCallableSymbol.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            this.recordActualCallable((IrDeclarationWithName)irSymbolOwner, callableId, false);
        }
    }

    private final void recordMappingsForNestedClassesActualizedViaTypealias(ClassId typealiasClassId, IrClassSymbol actualClassSymbol) {
        IrClassSymbol irClassSymbol = this.expectTopLevelDeclarations.getClasses().get(typealiasClassId);
        if (irClassSymbol == null) {
            return;
        }
        IrClassSymbol expectClassSymbol = irClassSymbol;
        ActualDeclarationsCollector.recordMappingsForNestedClassesActualizedViaTypealias$recordRecursively(this, (IrClass)expectClassSymbol.getOwner(), (IrClass)actualClassSymbol.getOwner());
    }

    /*
     * WARNING - void declaration
     */
    private final void recordActualCallable(IrDeclarationWithName callableDeclaration, CallableId callableId, boolean writeActualSymbolToFile) {
        if (callableId.getClassId() == null) {
            Object object;
            void $this$getOrPut$iv;
            Map<CallableId, List<IrSymbol>> map = this.actualTopLevels;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(callableId);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(callableId, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(callableDeclaration.getSymbol());
            if (writeActualSymbolToFile) {
                this.actualSymbolsToFile.put(callableDeclaration.getSymbol(), this.currentFile);
            }
        }
    }

    static /* synthetic */ void recordActualCallable$default(ActualDeclarationsCollector actualDeclarationsCollector, IrDeclarationWithName irDeclarationWithName, CallableId callableId, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        actualDeclarationsCollector.recordActualCallable(irDeclarationWithName, callableId, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final void recordMappingsForNestedClassesActualizedViaTypealias$recordRecursively(ActualDeclarationsCollector this$0, IrClass expectClass, IrClass actualClass) {
        void $this$associateByTo$iv$iv;
        Sequence<IrClass> $this$associateBy$iv = IrUtilsKt.getNestedClasses(actualClass);
        boolean $i$f$associateBy = false;
        Sequence<IrClass> sequence2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            IrClass irClass = (IrClass)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map actualNestedClassesByName = destination$iv$iv;
        for (IrClass expectNestedClass : IrUtilsKt.getNestedClasses(expectClass)) {
            IrClass actualNestedClass;
            if ((IrClass)actualNestedClassesByName.get(expectNestedClass.getName()) == null) continue;
            this$0.actualClasses.put(AdditionalIrUtilsKt.getClassIdOrFail(expectNestedClass), actualNestedClass.getSymbol());
            ActualDeclarationsCollector.recordMappingsForNestedClassesActualizedViaTypealias$recordRecursively(this$0, expectNestedClass, actualNestedClass);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ActualDeclarationsCollector$Companion;", "", "<init>", "()V", "collectActuals", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "fragments", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "expectTopLevelDeclarations", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectTopLevelDeclarations;", "extraActualDeclarationExtractor", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExtraActualDeclarationExtractor;", "ir.actualization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassActualizationInfo collectActuals(@NotNull List<? extends IrModuleFragment> fragments, @NotNull ExpectTopLevelDeclarations expectTopLevelDeclarations, @Nullable IrExtraActualDeclarationExtractor extraActualDeclarationExtractor) {
            Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
            Intrinsics.checkNotNullParameter((Object)expectTopLevelDeclarations, (String)"expectTopLevelDeclarations");
            ActualDeclarationsCollector collector2 = new ActualDeclarationsCollector(expectTopLevelDeclarations);
            for (IrModuleFragment irModuleFragment : fragments) {
                collector2.collect(irModuleFragment);
            }
            if (extraActualDeclarationExtractor != null) {
                collector2.collectExtraActualDeclarations(extraActualDeclarationExtractor);
            }
            return new ClassActualizationInfo(collector2.actualClasses, collector2.actualTypeAliasesWithoutExpansion, collector2.actualTopLevels, collector2.actualSymbolsToFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

