/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.AbstractConfigurationMetadata;
import org.gradle.internal.component.external.model.ForcedDependencyMetadataWrapper;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;

public class DefaultConfigurationMetadata
extends AbstractConfigurationMetadata {
    private final VariantMetadataRules componentMetadataRules;
    private List<? extends ModuleDependencyMetadata> calculatedDependencies;
    private ImmutableList<? extends ModuleComponentArtifactMetadata> calculatedArtifacts;
    private ImmutableAttributes computedAttributes;
    private ImmutableCapabilities computedCapabilities;
    private final DependencyFilter dependencyFilter;
    private ImmutableList<ModuleDependencyMetadata> filteredConfigDependencies;

    public DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, VariantMetadataRules componentMetadataRules, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes componentLevelAttributes, boolean externalVariant) {
        super(componentId, name, transitive, visible, artifacts, hierarchy, excludes, componentLevelAttributes, (ImmutableList<ModuleDependencyMetadata>)((ImmutableList)null), ImmutableCapabilities.EMPTY, externalVariant);
        this.componentMetadataRules = componentMetadataRules;
        this.dependencyFilter = DependencyFilter.ALL;
    }

    private DefaultConfigurationMetadata(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> hierarchy, ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts, VariantMetadataRules componentMetadataRules, ImmutableList<ExcludeMetadata> excludes, ImmutableAttributes attributes, Factory<List<ModuleDependencyMetadata>> configDependenciesFactory, DependencyFilter dependencyFilter, ImmutableCapabilities capabilities, boolean externalVariant) {
        super(componentId, name, transitive, visible, artifacts, hierarchy, excludes, attributes, configDependenciesFactory, capabilities, externalVariant);
        this.componentMetadataRules = componentMetadataRules;
        this.dependencyFilter = dependencyFilter;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        if (this.computedAttributes == null) {
            this.computedAttributes = this.componentMetadataRules.applyVariantAttributeRules(this, (AttributeContainerInternal)super.getAttributes());
        }
        return this.computedAttributes;
    }

    @Override
    ImmutableList<ModuleDependencyMetadata> getConfigDependencies() {
        if (this.filteredConfigDependencies != null) {
            return this.filteredConfigDependencies;
        }
        ImmutableList<ModuleDependencyMetadata> filtered = super.getConfigDependencies();
        switch (this.dependencyFilter) {
            case CONSTRAINTS_ONLY: 
            case FORCED_CONSTRAINTS_ONLY: {
                filtered = this.withConstraints(true, filtered);
                break;
            }
            case DEPENDENCIES_ONLY: 
            case FORCED_DEPENDENCIES_ONLY: {
                filtered = this.withConstraints(false, filtered);
            }
        }
        switch (this.dependencyFilter) {
            case FORCED_CONSTRAINTS_ONLY: 
            case FORCED_DEPENDENCIES_ONLY: 
            case FORCED_ALL: {
                filtered = this.force(filtered);
            }
        }
        this.filteredConfigDependencies = filtered;
        return this.filteredConfigDependencies;
    }

    private ImmutableList<? extends ModuleComponentArtifactMetadata> getOriginalArtifacts() {
        return super.getArtifacts();
    }

    @Override
    public ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifacts() {
        if (this.calculatedArtifacts == null) {
            this.calculatedArtifacts = this.componentMetadataRules.applyVariantFilesMetadataRulesToArtifacts(this, this.getOriginalArtifacts(), this.getComponentId());
        }
        return this.calculatedArtifacts;
    }

    @Override
    public List<? extends ModuleDependencyMetadata> getDependencies() {
        if (this.calculatedDependencies == null) {
            this.calculatedDependencies = this.componentMetadataRules.applyDependencyMetadataRules(this, this.getConfigDependencies());
        }
        return this.calculatedDependencies;
    }

    @Override
    public ImmutableCapabilities getCapabilities() {
        if (this.computedCapabilities == null) {
            this.computedCapabilities = this.componentMetadataRules.applyCapabilitiesRules(this, super.getCapabilities());
        }
        return this.computedCapabilities;
    }

    private ImmutableCapabilities getRawCapabilities() {
        return super.getCapabilities();
    }

    private Factory<List<ModuleDependencyMetadata>> lazyConfigDependencies() {
        return new Factory<List<ModuleDependencyMetadata>>(){

            @Nullable
            public List<ModuleDependencyMetadata> create() {
                return DefaultConfigurationMetadata.super.getConfigDependencies();
            }
        };
    }

    private ImmutableList<ModuleDependencyMetadata> force(ImmutableList<ModuleDependencyMetadata> configDependencies) {
        ImmutableList.Builder dependencies = new ImmutableList.Builder();
        for (ModuleDependencyMetadata configDependency : configDependencies) {
            if (configDependency instanceof ForcingDependencyMetadata) {
                dependencies.add((Object)((ModuleDependencyMetadata)((Object)((ForcingDependencyMetadata)((Object)configDependency)).forced())));
                continue;
            }
            dependencies.add((Object)new ForcedDependencyMetadataWrapper(configDependency));
        }
        return dependencies.build();
    }

    private ImmutableList<ModuleDependencyMetadata> withConstraints(boolean constraint, ImmutableList<ModuleDependencyMetadata> configDependencies) {
        if (configDependencies.isEmpty()) {
            return ImmutableList.of();
        }
        int count = 0;
        ImmutableList.Builder filtered = null;
        for (ModuleDependencyMetadata configDependency : configDependencies) {
            if (configDependency.isConstraint() != constraint) continue;
            if (filtered == null) {
                filtered = new ImmutableList.Builder();
            }
            filtered.add((Object)configDependency);
            ++count;
        }
        if (count == configDependencies.size()) {
            return configDependencies;
        }
        return filtered == null ? ImmutableList.of() : filtered.build();
    }

    public Builder mutate() {
        return new Builder();
    }

    private static enum DependencyFilter {
        ALL,
        CONSTRAINTS_ONLY,
        DEPENDENCIES_ONLY,
        FORCED_ALL,
        FORCED_CONSTRAINTS_ONLY,
        FORCED_DEPENDENCIES_ONLY;


        DependencyFilter forcing() {
            switch (this) {
                case ALL: {
                    return FORCED_ALL;
                }
                case CONSTRAINTS_ONLY: {
                    return FORCED_CONSTRAINTS_ONLY;
                }
                case DEPENDENCIES_ONLY: {
                    return FORCED_DEPENDENCIES_ONLY;
                }
            }
            return this;
        }

        DependencyFilter dependenciesOnly() {
            switch (this) {
                case ALL: {
                    return DEPENDENCIES_ONLY;
                }
                case FORCED_ALL: {
                    return FORCED_DEPENDENCIES_ONLY;
                }
                case DEPENDENCIES_ONLY: {
                    return this;
                }
            }
            throw new IllegalStateException("Cannot set dependencies only when constraints only has already been called");
        }

        DependencyFilter constraintsOnly() {
            switch (this) {
                case ALL: {
                    return CONSTRAINTS_ONLY;
                }
                case FORCED_ALL: {
                    return FORCED_CONSTRAINTS_ONLY;
                }
                case CONSTRAINTS_ONLY: {
                    return this;
                }
            }
            throw new IllegalStateException("Cannot set constraints only when dependencies only has already been called");
        }
    }

    public class Builder {
        private String name;
        private DependencyFilter dependencyFilter;
        private ImmutableCapabilities capabilities;
        private ImmutableAttributes attributes;
        private ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts;

        public Builder() {
            this.name = DefaultConfigurationMetadata.this.getName();
            this.dependencyFilter = DependencyFilter.ALL;
        }

        Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withArtifacts(ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        Builder withAttributes(ImmutableAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder withoutConstraints() {
            this.dependencyFilter = this.dependencyFilter.dependenciesOnly();
            return this;
        }

        Builder withForcedDependencies() {
            this.dependencyFilter = this.dependencyFilter.forcing();
            return this;
        }

        Builder withConstraintsOnly() {
            this.dependencyFilter = this.dependencyFilter.constraintsOnly();
            this.artifacts = ImmutableList.of();
            return this;
        }

        Builder withCapabilities(ImmutableCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public DefaultConfigurationMetadata build() {
            return new DefaultConfigurationMetadata(DefaultConfigurationMetadata.this.getComponentId(), this.name, DefaultConfigurationMetadata.this.isTransitive(), DefaultConfigurationMetadata.this.isVisible(), DefaultConfigurationMetadata.this.getHierarchy(), this.artifacts == null ? DefaultConfigurationMetadata.this.getOriginalArtifacts() : this.artifacts, DefaultConfigurationMetadata.this.componentMetadataRules, DefaultConfigurationMetadata.this.getExcludes(), this.attributes == null ? DefaultConfigurationMetadata.super.getAttributes() : this.attributes, DefaultConfigurationMetadata.this.lazyConfigDependencies(), this.dependencyFilter, this.capabilities == null ? DefaultConfigurationMetadata.this.getRawCapabilities() : this.capabilities, DefaultConfigurationMetadata.this.isExternalVariant());
        }
    }
}

