/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryValueIndexingExpression
extends SQLQueryValueExpression {
    private static final Log log = Log.getLog(SQLQueryValueIndexingExpression.class);
    @NotNull
    private final SQLQueryValueExpression owner;
    @NotNull
    private final boolean[] slicingDepthSpec;

    public SQLQueryValueIndexingExpression(@NotNull Interval region, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueExpression owner, @NotNull boolean[] slicingDepthSpec) {
        super(region, syntaxNode, owner);
        this.owner = owner;
        this.slicingDepthSpec = slicingDepthSpec;
    }

    @Override
    protected void propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.owner.propagateContext(context, statistics);
        this.resolveTypeImpl(statistics);
    }

    @Override
    protected void resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.owner.resolveRowSources(context, statistics);
    }

    @Override
    protected SQLQueryExprType resolveValueTypeImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.resolveTypeImpl(statistics);
        return this.type;
    }

    private void resolveTypeImpl(@NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryExprType type = this.owner.getValueType();
        try {
            type = type.findIndexedItemType(statistics.getMonitor(), this.slicingDepthSpec.length, this.slicingDepthSpec);
        }
        catch (DBException e) {
            log.debug((Object)e);
            type = null;
        }
        this.type = type != null ? type : SQLQueryExprType.UNKNOWN;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueIndexingExpr(this, arg);
    }
}

