/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public abstract class SQLQuerySymbolOrigin {
    public abstract boolean isChained();

    public abstract void apply(Visitor var1);

    public static class ColumnNameFromContext
    extends DataContextSymbolOrigin {
        public ColumnNameFromContext(SQLQueryDataContext dataContext) {
            super(dataContext);
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitColumnNameFromContext(this);
        }
    }

    public static class ColumnNameFromRowsData
    extends RowsDataRef {
        public ColumnNameFromRowsData(@NotNull SQLQueryRowsDataContext dataContext) {
            super(dataContext);
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitColumnNameFromRowsData(this);
        }
    }

    public static class ColumnRefFromReferencedContext
    extends SQLQuerySymbolOrigin {
        private final SourceResolutionResult referencedSource;

        public ColumnRefFromReferencedContext(SourceResolutionResult referencedSource) {
            this.referencedSource = referencedSource;
        }

        @Override
        public boolean isChained() {
            return true;
        }

        public SourceResolutionResult getRowsSource() {
            return this.referencedSource;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitColumnRefFromReferencedContext(this);
        }
    }

    public static class DataContextSymbolOrigin
    extends SQLQuerySymbolOrigin {
        private final SQLQueryDataContext dataContext;

        public DataContextSymbolOrigin(SQLQueryDataContext dataContext) {
            this.dataContext = dataContext;
        }

        @Override
        public boolean isChained() {
            return false;
        }

        public SQLQueryDataContext getDataContext() {
            return this.dataContext;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitDataContextSymbol(this);
        }
    }

    public static class DbObjectFromContext
    extends DataContextSymbolOrigin {
        @NotNull
        private final Set<DBSObjectType> objectTypes;
        private final boolean includingRowsets;

        public DbObjectFromContext(@NotNull SQLQueryDataContext dataContext, @NotNull DBSObjectType objectType) {
            this(dataContext, Set.of(objectType), false);
        }

        public DbObjectFromContext(@NotNull SQLQueryDataContext dataContext, @NotNull Set<DBSObjectType> objectTypes, boolean includingRowsets) {
            super(dataContext);
            this.objectTypes = objectTypes;
            this.includingRowsets = includingRowsets;
        }

        @NotNull
        public Set<DBSObjectType> getObjectTypes() {
            return this.objectTypes;
        }

        public boolean isIncludingRowsets() {
            return this.includingRowsets;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitDbObjectFromContext(this);
        }
    }

    public static class DbObjectFromDbObject
    extends SQLQuerySymbolOrigin {
        @NotNull
        private final DBSObject object;
        @NotNull
        private final Set<DBSObjectType> objectTypes;

        public DbObjectFromDbObject(@NotNull DBSObject object, @NotNull DBSObjectType memberType) {
            this(object, Set.of(memberType));
        }

        public DbObjectFromDbObject(@NotNull DBSObject object, @NotNull Set<DBSObjectType> objectTypes) {
            this.object = object;
            this.objectTypes = objectTypes;
        }

        @NotNull
        public DBSObject getObject() {
            return this.object;
        }

        @NotNull
        public Set<DBSObjectType> getMemberTypes() {
            return this.objectTypes;
        }

        @Override
        public boolean isChained() {
            return true;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitDbObjectFromDbObject(this);
        }
    }

    public static class ExpandableRowsTupleRef
    extends RowsDataRef {
        @NotNull
        private final STMTreeNode placeholder;
        @Nullable
        private final SourceResolutionResult referencedSource;

        public ExpandableRowsTupleRef(@NotNull STMTreeNode placeholder, @NotNull SQLQueryRowsDataContext dataContext, @Nullable SourceResolutionResult referencedSource) {
            super(dataContext);
            this.placeholder = placeholder;
            this.referencedSource = referencedSource;
        }

        @Override
        public boolean isChained() {
            return true;
        }

        @NotNull
        public STMTreeNode getPlaceholder() {
            return this.placeholder;
        }

        @Nullable
        public SourceResolutionResult getReferencedSource() {
            return this.referencedSource;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitExpandableRowsTupleRef(this);
        }
    }

    public static class ExpandableTupleRef
    extends DataContextSymbolOrigin {
        @NotNull
        private final STMTreeNode placeholder;
        @Nullable
        private final SourceResolutionResult referencedSource;

        public ExpandableTupleRef(@NotNull STMTreeNode placeholder, @NotNull SQLQueryDataContext dataContext, @Nullable SourceResolutionResult referencedSource) {
            super(dataContext);
            this.placeholder = placeholder;
            this.referencedSource = referencedSource;
        }

        @Override
        public boolean isChained() {
            return true;
        }

        @NotNull
        public STMTreeNode getPlaceholder() {
            return this.placeholder;
        }

        @Nullable
        public SourceResolutionResult getRowsSource() {
            return this.referencedSource;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitExpandableTupleRef(this);
        }
    }

    public static class MemberOfType
    extends SQLQuerySymbolOrigin {
        @NotNull
        private final SQLQueryExprType type;

        public MemberOfType(@NotNull SQLQueryExprType type) {
            this.type = type;
        }

        @NotNull
        public final SQLQueryExprType getType() {
            return this.type;
        }

        @Override
        public boolean isChained() {
            return true;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitMemberOfType(this);
        }
    }

    public static class RowsDataRef
    extends SQLQuerySymbolOrigin {
        @NotNull
        private final SQLQueryRowsDataContext rowsDataContext;

        public RowsDataRef(@NotNull SQLQueryRowsDataContext rowsDataContext) {
            this.rowsDataContext = rowsDataContext;
        }

        @Override
        public boolean isChained() {
            return false;
        }

        @NotNull
        public SQLQueryRowsDataContext getRowsDataContext() {
            return this.rowsDataContext;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitRowsDataRef(this);
        }
    }

    public static class RowsSourceRef
    extends SQLQuerySymbolOrigin {
        @NotNull
        private final SQLQueryRowsSourceContext rowsSourceContext;

        public RowsSourceRef(@NotNull SQLQueryRowsSourceContext rowsSourceContext) {
            this.rowsSourceContext = rowsSourceContext;
        }

        @Override
        public boolean isChained() {
            return false;
        }

        @NotNull
        public SQLQueryRowsSourceContext getRowsSourceContext() {
            return this.rowsSourceContext;
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitRowsSourceRef(this);
        }
    }

    public static class RowsetRefFromContext
    extends DataContextSymbolOrigin {
        public RowsetRefFromContext(SQLQueryDataContext dataContext) {
            super(dataContext);
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitRowsetRefFromContext(this);
        }
    }

    public static class ValueRefFromContext
    extends DataContextSymbolOrigin {
        public ValueRefFromContext(SQLQueryDataContext dataContext) {
            super(dataContext);
        }

        @Override
        public void apply(Visitor visitor) {
            visitor.visitValueRefFromContext(this);
        }
    }

    public static interface Visitor {
        public void visitDbObjectFromDbObject(DbObjectFromDbObject var1);

        public void visitDbObjectFromContext(DbObjectFromContext var1);

        public void visitRowsetRefFromContext(RowsetRefFromContext var1);

        public void visitValueRefFromContext(ValueRefFromContext var1);

        public void visitColumnRefFromReferencedContext(ColumnRefFromReferencedContext var1);

        public void visitColumnNameFromContext(ColumnNameFromContext var1);

        public void visitMemberOfType(MemberOfType var1);

        public void visitDataContextSymbol(DataContextSymbolOrigin var1);

        public void visitExpandableTupleRef(ExpandableTupleRef var1);

        public void visitRowsSourceRef(RowsSourceRef var1);

        public void visitRowsDataRef(RowsDataRef var1);

        public void visitExpandableRowsTupleRef(ExpandableRowsTupleRef var1);

        public void visitColumnNameFromRowsData(ColumnNameFromRowsData var1);
    }
}

